/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus2.core.container.netty;

import com.linkedin.databus2.core.container.ChunkedWritableByteChannel;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.log4j.Logger;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelConfig;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.socket.nio.NioSocketChannelConfig;
import org.jboss.netty.handler.codec.http.DefaultHttpChunk;
import org.jboss.netty.handler.codec.http.DefaultHttpChunkTrailer;
import org.jboss.netty.handler.codec.http.HttpChunk;
import org.jboss.netty.handler.codec.http.HttpChunkTrailer;
import org.jboss.netty.handler.codec.http.HttpResponse;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;

public class ChunkedBodyWritableByteChannel
implements ChunkedWritableByteChannel {
    public static final String MODULE = ChunkedBodyWritableByteChannel.class.getName();
    public static final Logger LOG = Logger.getLogger((String)MODULE);
    public static final String RESPONSE_CODE_FOOTER_NAME = "x-databus-response-code";
    private final Channel _channel;
    private HttpResponse _response;
    private HttpResponseStatus _responseCode;
    private boolean _open = true;
    private HttpChunk _chunkReuse = null;
    private HttpChunkTrailer _trailer = null;

    public ChunkedBodyWritableByteChannel(Channel channel, HttpResponse response) {
        this._channel = channel;
        this._responseCode = response.getStatus();
        this._response = response;
        ChannelConfig channelConfig = this._channel.getConfig();
        if (channelConfig instanceof NioSocketChannelConfig) {
            NioSocketChannelConfig nioSocketConfig = (NioSocketChannelConfig)channelConfig;
            nioSocketConfig.setWriteBufferLowWaterMark(16384);
            nioSocketConfig.setWriteBufferHighWaterMark(65536);
        }
    }

    @Override
    public int write(ByteBuffer buffer) throws IOException {
        ByteOrder bufferOrder;
        ByteBuffer realBuffer;
        if (null != this._response) {
            this._response.setHeader("Transfer-Encoding", (Object)"chunked");
            this._response.setChunked(true);
            this.writeToChannel(this._response);
            this._response = null;
        }
        ByteBuffer byteBuffer = realBuffer = (bufferOrder = buffer.order()) == ByteOrder.BIG_ENDIAN ? buffer : buffer.slice().order(ByteOrder.BIG_ENDIAN);
        if (null == this._chunkReuse) {
            this._chunkReuse = new DefaultHttpChunk(ChannelBuffers.wrappedBuffer((ByteBuffer)realBuffer));
        } else {
            this._chunkReuse.setContent(ChannelBuffers.wrappedBuffer((ByteBuffer)realBuffer));
        }
        int bytesWritten = realBuffer.remaining();
        this.writeToChannel(this._chunkReuse);
        realBuffer.position(realBuffer.limit());
        if (bufferOrder == ByteOrder.LITTLE_ENDIAN) {
            buffer.position(realBuffer.position());
        }
        return bytesWritten;
    }

    @Override
    public void close() throws IOException {
        if (this._open) {
            this._open = false;
            if (null != this._response) {
                this._response.setHeader("Content-Length", (Object)this._response.getContent().readableBytes());
                this.writeToChannel(this._response, 10);
                this._response = null;
            } else if (null != this._trailer) {
                this.writeToChannel(this._trailer, 1);
                this._trailer = null;
            } else {
                this.writeToChannel(HttpChunk.LAST_CHUNK, 1);
            }
        }
    }

    @Override
    public void addMetadata(String name, Object value) {
        if (null != this._response) {
            this._response.addHeader(name, value);
        } else {
            if (null == this._trailer) {
                this._trailer = new DefaultHttpChunkTrailer();
            }
            this._trailer.addHeader(name, value);
        }
    }

    @Override
    public void setMetadata(String name, Object value) {
        if (null != this._response) {
            this._response.setHeader(name, value);
        } else {
            if (null == this._trailer) {
                this._trailer = new DefaultHttpChunkTrailer();
            }
            this._trailer.setHeader(name, value);
        }
    }

    @Override
    public void removeMetadata(String name) {
        if (null != this._response) {
            this._response.removeHeader(name);
        } else if (null != this._trailer) {
            this._trailer.removeHeader(name);
        }
    }

    private void writeToChannel(Object o, int flushSize) throws IOException {
        ChannelConfig channelConfig;
        ChannelFuture channelFuture = this._channel.write(o);
        if (flushSize > 0 && !this._channel.isWritable() && (channelConfig = this._channel.getConfig()) instanceof NioSocketChannelConfig) {
            NioSocketChannelConfig nioSocketConfig = (NioSocketChannelConfig)channelConfig;
            nioSocketConfig.setWriteBufferLowWaterMark(flushSize);
            nioSocketConfig.setWriteBufferHighWaterMark(flushSize);
        }
        this.awaitChannelFuture(channelFuture);
        if (!channelFuture.isSuccess()) {
            throw new IOException(channelFuture.getCause());
        }
    }

    private void writeToChannel(Object o) throws IOException {
        this.writeToChannel(o, 0);
    }

    private void awaitChannelFuture(ChannelFuture channelFuture) {
        boolean done = channelFuture.isDone();
        while (!done) {
            try {
                channelFuture.await();
                done = channelFuture.isDone();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    @Override
    public boolean isOpen() {
        return this._open;
    }

    @Override
    public HttpResponseStatus getResponseCode() {
        return this._responseCode;
    }

    @Override
    public void setResponseCode(HttpResponseStatus responseCode) {
        this._responseCode = responseCode;
        if (null != this._response) {
            this._response.setStatus(responseCode);
        } else {
            this.setMetadata(RESPONSE_CODE_FOOTER_NAME, Integer.toString(responseCode.getCode()));
        }
    }

    @Override
    public Channel getRawChannel() {
        return this._channel;
    }
}

