/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus2.core.container.monitoring.mbean;

import com.linkedin.databus.core.Checkpoint;
import com.linkedin.databus.core.util.ConfigApplier;
import com.linkedin.databus.core.util.ConfigBuilder;
import com.linkedin.databus.core.util.InvalidConfigException;
import com.linkedin.databus.core.util.JmxUtil;
import com.linkedin.databus.core.util.ReadWriteSyncedObject;
import com.linkedin.databus2.core.container.monitoring.mbean.DbusHttpTotalStats;
import com.linkedin.databus2.core.container.monitoring.mbean.HttpStatisticsCollectorMBean;
import com.linkedin.databus2.core.container.request.RegisterResponseEntry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.log4j.Logger;

public class HttpStatisticsCollector
extends ReadWriteSyncedObject
implements HttpStatisticsCollectorMBean {
    public static final String MODULE = HttpStatisticsCollector.class.getName();
    public static final Logger LOG = Logger.getLogger((String)MODULE);
    private static final String NO_PEER = "NONE";
    private final DbusHttpTotalStats _totalStats;
    private final HashMap<Integer, DbusHttpTotalStats> _perSourceStats;
    private final HashMap<String, DbusHttpTotalStats> _perClientStats;
    private final MBeanServer _mbeanServer;
    private final ObjectName _collectorObjName;
    private final int _id;
    private final String _name;
    private final String _perSourceNamePrefix;
    private final String _perPeerPrefix;
    private final String _curPeer;
    private final AtomicBoolean _enabled;

    public HttpStatisticsCollector(int id, String name, boolean enabled, boolean threadSafe, MBeanServer mbeanServer) {
        this(id, name, enabled, threadSafe, NO_PEER, mbeanServer);
    }

    private HttpStatisticsCollector(int relayId, String name, boolean enabled, boolean threadSafe, String peer, MBeanServer mbeanServer) {
        super(threadSafe);
        this._mbeanServer = mbeanServer;
        this._curPeer = peer;
        this._enabled = new AtomicBoolean(enabled);
        this._id = relayId;
        this._name = name;
        this._perSourceNamePrefix = this._name + ".source.";
        this._perPeerPrefix = this._name + ".peer.";
        this._totalStats = new DbusHttpTotalStats(this._id, this._name + ".total", enabled, threadSafe, null);
        this._perSourceStats = new HashMap(100);
        this._perClientStats = new HashMap(1000);
        ObjectName jmxName = null;
        try {
            Hashtable<String, String> mbeanProps = new Hashtable<String, String>(5);
            mbeanProps.put("name", this._name);
            mbeanProps.put("type", HttpStatisticsCollector.class.getSimpleName());
            mbeanProps.put("relay", Integer.toString(relayId));
            jmxName = new ObjectName("com.linkedin.databus2", mbeanProps);
        }
        catch (Exception e) {
            LOG.error((Object)"Error creating JMX object name", (Throwable)e);
        }
        this._collectorObjName = jmxName;
        this.registerAsMBeans();
    }

    protected void registerAsMBeans() {
        if (null != this._mbeanServer && null != this._collectorObjName) {
            try {
                if (this._mbeanServer.isRegistered(this._collectorObjName)) {
                    LOG.warn((Object)("unregistering stale mbean: " + this._collectorObjName));
                    this._mbeanServer.unregisterMBean(this._collectorObjName);
                }
                this._mbeanServer.registerMBean(this, this._collectorObjName);
                this._totalStats.registerAsMbean(this._mbeanServer);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("MBean registered " + this._collectorObjName));
                }
            }
            catch (Exception e) {
                LOG.error((Object)"JMX registration failed", (Throwable)e);
            }
        }
    }

    public void unregisterMBeans() {
        if (null != this._mbeanServer && null != this._collectorObjName) {
            try {
                JmxUtil.unregisterMBeanSafely((MBeanServer)this._mbeanServer, (ObjectName)this._collectorObjName, (Logger)LOG);
                this._totalStats.unregisterMbean(this._mbeanServer);
                for (String clientName : this._perClientStats.keySet()) {
                    this._perClientStats.get(clientName).unregisterMbean(this._mbeanServer);
                }
                for (Integer srcId : this._perSourceStats.keySet()) {
                    this._perSourceStats.get(srcId).unregisterMbean(this._mbeanServer);
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("MBean unregistered " + this._collectorObjName));
                }
            }
            catch (Exception e) {
                LOG.error((Object)"JMX deregistration failed", (Throwable)e);
            }
        }
    }

    public HttpStatisticsCollector createForClientConnection(String client) {
        return new HttpStatisticsCollector(this._id, this._name, true, false, client, null);
    }

    @Override
    public DbusHttpTotalStats getTotalStats() {
        return this._totalStats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Integer> getSources() {
        Lock readLock = this.acquireReadLock();
        try {
            ArrayList<Integer> result;
            ArrayList<Integer> arrayList = result = new ArrayList<Integer>(this._perSourceStats.keySet());
            return arrayList;
        }
        finally {
            this.releaseLock(readLock);
        }
    }

    @Override
    public DbusHttpTotalStats getSourceStats(int srcId) {
        DbusHttpTotalStats result = this.getOrAddPerSourceCollector(srcId, null);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getPeers() {
        Lock readLock = this.acquireReadLock();
        try {
            ArrayList<String> result;
            ArrayList<String> arrayList = result = new ArrayList<String>(this._perClientStats.keySet());
            return arrayList;
        }
        finally {
            this.releaseLock(readLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DbusHttpTotalStats getPeerStats(String peer) {
        Lock readLock = this.acquireReadLock();
        try {
            DbusHttpTotalStats result;
            DbusHttpTotalStats dbusHttpTotalStats = result = this._perClientStats.get(peer);
            return dbusHttpTotalStats;
        }
        finally {
            this.releaseLock(readLock);
        }
    }

    @Override
    public void registerRegisterCall(List<RegisterResponseEntry> sources) {
        if (!this._enabled.get()) {
            return;
        }
        this._totalStats.registerRegisterCall(this._curPeer);
        for (RegisterResponseEntry respEntry : sources) {
            DbusHttpTotalStats perSourceCollector = this.getOrAddPerSourceCollector((int)respEntry.getId(), null);
            perSourceCollector.registerRegisterCall(this._curPeer);
        }
        if (NO_PEER != this._curPeer) {
            DbusHttpTotalStats clientStats = this.getOrAddPerPeerCollector(this._curPeer, null);
            clientStats.registerRegisterCall(this._curPeer);
        }
    }

    @Override
    public void registerSourcesCall() {
        if (!this._enabled.get()) {
            return;
        }
        this._totalStats.registerSourcesCall(this._curPeer);
        if (NO_PEER != this._curPeer) {
            DbusHttpTotalStats clientStats = this.getOrAddPerPeerCollector(this._curPeer, null);
            clientStats.registerSourcesCall(this._curPeer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerStreamResponse(long streamCallDuration) {
        if (!this._enabled.get()) {
            return;
        }
        Lock writeLock = this.acquireWriteLock();
        try {
            this._totalStats.registerStreamResponse(streamCallDuration);
            if (NO_PEER != this._curPeer) {
                DbusHttpTotalStats clientStats = this.getOrAddPerPeerCollector(this._curPeer, writeLock);
                clientStats.registerStreamResponse(streamCallDuration);
            }
        }
        finally {
            this.releaseLock(writeLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerStreamRequest(Checkpoint cp, Collection<Integer> sourceIds) {
        if (!this._enabled.get()) {
            return;
        }
        this._totalStats.registerStreamRequest(this._curPeer, cp);
        Lock writeLock = this.acquireWriteLock();
        try {
            for (Integer srcId : sourceIds) {
                DbusHttpTotalStats curBean = this.getOrAddPerSourceCollector(srcId, writeLock);
                curBean.registerStreamRequest(this._curPeer, cp);
            }
            if (NO_PEER != this._curPeer) {
                DbusHttpTotalStats clientStats = this.getOrAddPerPeerCollector(this._curPeer, writeLock);
                clientStats.registerStreamRequest(this._curPeer, cp);
            }
        }
        finally {
            this.releaseLock(writeLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void merge(HttpStatisticsCollector other) {
        this._totalStats.mergeStats(other._totalStats);
        Lock otherReadLock = other.acquireReadLock();
        Lock writeLock = this.acquireWriteLock(otherReadLock);
        try {
            DbusHttpTotalStats bean;
            for (Integer id : other._perSourceStats.keySet()) {
                bean = other._perSourceStats.get(id);
                this.mergePerSource(id, bean, writeLock);
            }
            for (String peerName : other._perClientStats.keySet()) {
                bean = other._perClientStats.get(peerName);
                this.mergePerPeer(peerName, bean, writeLock);
            }
        }
        finally {
            this.releaseLock(writeLock);
            this.releaseLock(otherReadLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() {
        this._totalStats.reset();
        Lock readLock = this.acquireReadLock();
        try {
            for (Integer sourceId : this._perSourceStats.keySet()) {
                DbusHttpTotalStats sourceStats = this._perSourceStats.get(sourceId);
                sourceStats.reset();
            }
            for (String peer : this._perClientStats.keySet()) {
                this._perClientStats.get(peer).reset();
            }
        }
        finally {
            this.releaseLock(readLock);
        }
    }

    @Override
    public boolean isEnabled() {
        return this._enabled.get();
    }

    @Override
    public void setEnabled(boolean enabled) {
        this._enabled.set(enabled);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DbusHttpTotalStats getOrAddPerSourceCollector(Integer srcId, Lock writeLock) {
        Lock myWriteLock = null;
        if (null == writeLock) {
            myWriteLock = this.acquireWriteLock();
        }
        try {
            DbusHttpTotalStats data = this._perSourceStats.get(srcId);
            if (null == data) {
                data = new DbusHttpTotalStats(this._id, this._perSourceNamePrefix + srcId, true, this.isThreadSafe(), null);
                this._perSourceStats.put(srcId, data);
                if (null != this._mbeanServer) {
                    data.registerAsMbean(this._mbeanServer);
                }
            }
            DbusHttpTotalStats dbusHttpTotalStats = data;
            return dbusHttpTotalStats;
        }
        finally {
            this.releaseLock(myWriteLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DbusHttpTotalStats getOrAddPerPeerCollector(String client, Lock writeLock) {
        Lock myWriteLock = null;
        if (null == writeLock) {
            myWriteLock = this.acquireWriteLock();
        }
        try {
            DbusHttpTotalStats clientStats = this._perClientStats.get(client);
            if (null == clientStats) {
                clientStats = new DbusHttpTotalStats(this._id, this._perPeerPrefix + client, true, this.isThreadSafe(), null);
                this._perClientStats.put(client, clientStats);
                if (null != this._mbeanServer) {
                    clientStats.registerAsMbean(this._mbeanServer);
                }
            }
            DbusHttpTotalStats dbusHttpTotalStats = clientStats;
            return dbusHttpTotalStats;
        }
        finally {
            this.releaseLock(myWriteLock);
        }
    }

    private void mergePerSource(Integer srcId, DbusHttpTotalStats other, Lock writeLock) {
        DbusHttpTotalStats curBean = this.getOrAddPerSourceCollector(srcId, writeLock);
        curBean.mergeStats(other);
    }

    private void mergePerPeer(String peer, DbusHttpTotalStats other, Lock writeLock) {
        DbusHttpTotalStats curBean = this.getOrAddPerPeerCollector(peer, writeLock);
        curBean.mergeStats(other);
    }

    @Override
    public String getName() {
        return this._name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerInvalidStreamRequest() {
        if (!this._enabled.get()) {
            return;
        }
        this._totalStats.registerInvalidStreamRequest(this._curPeer);
        Lock writeLock = this.acquireWriteLock();
        try {
            if (NO_PEER != this._curPeer) {
                DbusHttpTotalStats clientStats = this.getOrAddPerPeerCollector(this._curPeer, writeLock);
                clientStats.registerInvalidStreamRequest(this._curPeer);
            }
        }
        finally {
            this.releaseLock(writeLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerScnNotFoundStreamResponse() {
        if (!this._enabled.get()) {
            return;
        }
        this._totalStats.registerScnNotFoundStreamResponse(this._curPeer);
        Lock writeLock = this.acquireWriteLock();
        try {
            if (NO_PEER != this._curPeer) {
                DbusHttpTotalStats clientStats = this.getOrAddPerPeerCollector(this._curPeer, writeLock);
                clientStats.registerScnNotFoundStreamResponse(this._curPeer);
            }
        }
        finally {
            this.releaseLock(writeLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerInvalidSourceRequest() {
        if (!this._enabled.get()) {
            return;
        }
        this._totalStats.registerInvalidSourceRequest(this._curPeer);
        Lock writeLock = this.acquireWriteLock();
        try {
            if (NO_PEER != this._curPeer) {
                DbusHttpTotalStats clientStats = this.getOrAddPerPeerCollector(this._curPeer, writeLock);
                clientStats.registerInvalidSourceRequest(this._curPeer);
            }
        }
        finally {
            this.releaseLock(writeLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerInvalidRegisterCall() {
        if (!this._enabled.get()) {
            return;
        }
        this._totalStats.registerInvalidRegisterCall(this._curPeer);
        Lock writeLock = this.acquireWriteLock();
        try {
            if (NO_PEER != this._curPeer) {
                DbusHttpTotalStats clientStats = this.getOrAddPerPeerCollector(this._curPeer, writeLock);
                clientStats.registerInvalidRegisterCall(this._curPeer);
            }
        }
        finally {
            this.releaseLock(writeLock);
        }
    }

    @Override
    public void registerMastershipStatus(int i) {
        this._totalStats.registerMastershipStatus(i);
    }

    public static class Config
    implements ConfigBuilder<StaticConfig> {
        private final RuntimeConfigBuilder _runtime = new RuntimeConfigBuilder();
        private HttpStatisticsCollector _existingStatsCollector = null;

        public RuntimeConfigBuilder getRuntime() {
            return this._runtime;
        }

        public HttpStatisticsCollector getExisting() {
            return this._existingStatsCollector;
        }

        public void setExisting(HttpStatisticsCollector existingStatsCollector) {
            this._existingStatsCollector = existingStatsCollector;
        }

        public StaticConfig build() throws InvalidConfigException {
            return new StaticConfig(this._runtime, this._existingStatsCollector);
        }
    }

    public static class StaticConfig {
        private final RuntimeConfigBuilder _runtime;
        private final HttpStatisticsCollector _existingStatsCollector;

        public StaticConfig(RuntimeConfigBuilder runtime, HttpStatisticsCollector existingStatsCollector) {
            this._runtime = runtime;
            this._existingStatsCollector = existingStatsCollector;
        }

        public RuntimeConfigBuilder getRuntime() {
            return this._runtime;
        }

        public HttpStatisticsCollector getExistingStatsCollector() {
            return this._existingStatsCollector;
        }
    }

    public static class RuntimeConfigBuilder
    implements ConfigBuilder<RuntimeConfig> {
        private boolean _enabled = true;
        private HttpStatisticsCollector _managedInstance = null;

        public boolean isEnabled() {
            return this._enabled;
        }

        public void setEnabled(boolean enabled) {
            this._enabled = enabled;
        }

        public RuntimeConfig build() throws InvalidConfigException {
            if (null != this._managedInstance) {
                HttpStatisticsCollector httpStatisticsCollector = this._managedInstance;
                httpStatisticsCollector.getClass();
                return httpStatisticsCollector.new RuntimeConfig(this._enabled);
            }
            throw new InvalidConfigException("No ContainerStatisticsCollector instance assigned");
        }

        public HttpStatisticsCollector getManagedInstance() {
            return this._managedInstance;
        }

        public void setManagedInstance(HttpStatisticsCollector managedInstance) {
            this._managedInstance = managedInstance;
        }
    }

    public class RuntimeConfig
    implements ConfigApplier<RuntimeConfig> {
        private final boolean _enabled;

        public RuntimeConfig(boolean enabled) {
            this._enabled = enabled;
        }

        public boolean isEnabled() {
            return this._enabled;
        }

        public void applyNewConfig(RuntimeConfig oldConfig) {
            HttpStatisticsCollector.this.setEnabled(this.isEnabled());
        }

        public boolean equals(Object other) {
            if (null == other || !(other instanceof RuntimeConfig)) {
                return false;
            }
            return this.equalsConfig((RuntimeConfig)other);
        }

        public boolean equalsConfig(RuntimeConfig otherConfig) {
            if (null == otherConfig) {
                return false;
            }
            return this.isEnabled() == otherConfig.isEnabled();
        }

        public int hashCode() {
            return this._enabled ? 0 : 1;
        }
    }
}

