/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus2.core.container.monitoring.mbean;

import com.linkedin.databus.core.Checkpoint;
import com.linkedin.databus.core.monitoring.mbean.AbstractMonitoringMBean;
import com.linkedin.databus.core.monitoring.mbean.DatabusMonitoringMBean;
import com.linkedin.databus2.core.container.monitoring.events.DbusHttpTotalStatsEvent;
import com.linkedin.databus2.core.container.monitoring.mbean.DbusHttpTotalStatsMBean;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.concurrent.locks.Lock;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.avro.io.JsonEncoder;
import org.apache.avro.specific.SpecificDatumWriter;
import org.apache.log4j.Logger;

public class DbusHttpTotalStats
extends AbstractMonitoringMBean<DbusHttpTotalStatsEvent>
implements DbusHttpTotalStatsMBean {
    public static final String MODULE = DbusHttpTotalStats.class.getName();
    public static final Logger LOG = Logger.getLogger((String)MODULE);
    private final HashSet<Object> _peers;
    private final String _dimension;

    public DbusHttpTotalStats(int ownerId, String dimesion, boolean enabled, boolean threadSafe, DbusHttpTotalStatsEvent initData) {
        super(enabled, threadSafe, (Object)initData);
        ((DbusHttpTotalStatsEvent)((Object)this._event)).ownerId = ownerId;
        ((DbusHttpTotalStatsEvent)((Object)this._event)).dimension = dimesion;
        this._peers = new HashSet(1000);
        this._dimension = dimesion;
        this.reset();
    }

    public DbusHttpTotalStats clone(boolean threadSafe) {
        return new DbusHttpTotalStats(((DbusHttpTotalStatsEvent)((Object)this._event)).ownerId, this._dimension, this._enabled.get(), threadSafe, (DbusHttpTotalStatsEvent)((Object)this.getStatistics(null)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getNumPeers() {
        Lock readLock = this.acquireReadLock();
        int result = 0;
        try {
            result = ((DbusHttpTotalStatsEvent)((Object)this._event)).numPeers;
        }
        finally {
            this.releaseLock(readLock);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getNumRegisterCalls() {
        Lock readLock = this.acquireReadLock();
        int result = 0;
        try {
            result = ((DbusHttpTotalStatsEvent)((Object)this._event)).numRegisterCalls;
        }
        finally {
            this.releaseLock(readLock);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getNumSourcesCalls() {
        Lock readLock = this.acquireReadLock();
        int result = 0;
        try {
            result = ((DbusHttpTotalStatsEvent)((Object)this._event)).numSourcesCalls;
        }
        finally {
            this.releaseLock(readLock);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getNumStreamCalls() {
        Lock readLock = this.acquireReadLock();
        long result = 0L;
        try {
            result = ((DbusHttpTotalStatsEvent)((Object)this._event)).numStreamCalls;
        }
        finally {
            this.releaseLock(readLock);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getTimeSinceLastResetMs() {
        Lock readLock = this.acquireReadLock();
        long result = 0L;
        try {
            result = System.currentTimeMillis() - ((DbusHttpTotalStatsEvent)((Object)this._event)).timestampLastResetMs;
        }
        finally {
            this.releaseLock(readLock);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getTimestampLastResetMs() {
        Lock readLock = this.acquireReadLock();
        long result = 0L;
        try {
            result = ((DbusHttpTotalStatsEvent)((Object)this._event)).timestampLastResetMs;
        }
        finally {
            this.releaseLock(readLock);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getMaxStreamWinScn() {
        Lock readLock = this.acquireReadLock();
        try {
            long l = ((DbusHttpTotalStatsEvent)((Object)this._event)).maxStreamWinScn;
            return l;
        }
        finally {
            this.releaseLock(readLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getMinStreamWinScn() {
        Lock readLock = this.acquireReadLock();
        try {
            long l = ((DbusHttpTotalStatsEvent)((Object)this._event)).minStreamWinScn;
            return l;
        }
        finally {
            this.releaseLock(readLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getLatencyStreamCalls() {
        Lock readLock = this.acquireReadLock();
        try {
            long numCalls = ((DbusHttpTotalStatsEvent)((Object)this._event)).numStreamCalls;
            double d = 0L == numCalls ? 0.0 : 1.0 * (double)((DbusHttpTotalStatsEvent)((Object)this._event)).timeStreamCallsMs / (double)numCalls;
            return d;
        }
        finally {
            this.releaseLock(readLock);
        }
    }

    private void registerPeer(String peer) {
        this._peers.add(peer);
        ((DbusHttpTotalStatsEvent)((Object)this._event)).numPeers = this._peers.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerRegisterCall(String peer) {
        if (!this._enabled.get()) {
            return;
        }
        Lock writeLock = this.acquireWriteLock();
        try {
            ++((DbusHttpTotalStatsEvent)((Object)this._event)).numRegisterCalls;
            this.registerPeer(peer);
        }
        finally {
            this.releaseLock(writeLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerSourcesCall(String peer) {
        if (!this._enabled.get()) {
            return;
        }
        Lock writeLock = this.acquireWriteLock();
        try {
            ++((DbusHttpTotalStatsEvent)((Object)this._event)).numSourcesCalls;
            this.registerPeer(peer);
        }
        finally {
            this.releaseLock(writeLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerStreamResponse(long totalTime) {
        if (!this._enabled.get()) {
            return;
        }
        Lock writeLock = this.acquireWriteLock();
        try {
            ++((DbusHttpTotalStatsEvent)((Object)this._event)).numStreamCalls;
            ((DbusHttpTotalStatsEvent)((Object)this._event)).timeStreamCallsMs += totalTime;
        }
        finally {
            this.releaseLock(writeLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerStreamRequest(String peer, Checkpoint cp) {
        long winScn = cp.getWindowScn();
        Lock writeLock = this.acquireWriteLock();
        try {
            ((DbusHttpTotalStatsEvent)((Object)this._event)).maxStreamWinScn = this.maxValue(((DbusHttpTotalStatsEvent)((Object)this._event)).maxStreamWinScn, winScn);
            ((DbusHttpTotalStatsEvent)((Object)this._event)).minStreamWinScn = this.minValue(((DbusHttpTotalStatsEvent)((Object)this._event)).minStreamWinScn, winScn);
            this.registerPeer(peer);
        }
        finally {
            this.releaseLock(writeLock);
        }
    }

    protected void resetData() {
        ((DbusHttpTotalStatsEvent)((Object)this._event)).timestampLastResetMs = System.currentTimeMillis();
        ((DbusHttpTotalStatsEvent)((Object)this._event)).timeSinceLastResetMs = 0L;
        ((DbusHttpTotalStatsEvent)((Object)this._event)).numPeers = 0;
        ((DbusHttpTotalStatsEvent)((Object)this._event)).numRegisterCalls = 0;
        ((DbusHttpTotalStatsEvent)((Object)this._event)).numSourcesCalls = 0;
        ((DbusHttpTotalStatsEvent)((Object)this._event)).numStreamCalls = 0L;
        ((DbusHttpTotalStatsEvent)((Object)this._event)).timeStreamCallsMs = 0L;
        ((DbusHttpTotalStatsEvent)((Object)this._event)).maxStreamWinScn = -1L;
        ((DbusHttpTotalStatsEvent)((Object)this._event)).minStreamWinScn = -1L;
        ((DbusHttpTotalStatsEvent)((Object)this._event)).numErrInvalidParamsRegisterCalls = 0;
        ((DbusHttpTotalStatsEvent)((Object)this._event)).numErrRegisterCalls = 0;
        ((DbusHttpTotalStatsEvent)((Object)this._event)).numErrInvalidParamsStreamCalls = 0L;
        ((DbusHttpTotalStatsEvent)((Object)this._event)).numErrScnNotFoundStreamCalls = 0L;
        ((DbusHttpTotalStatsEvent)((Object)this._event)).numErrSourcesCalls = 0;
        ((DbusHttpTotalStatsEvent)((Object)this._event)).numErrStreamCalls = 0L;
        ((DbusHttpTotalStatsEvent)((Object)this._event)).numErrInvalidParamsRegisterCalls = 0;
        ((DbusHttpTotalStatsEvent)((Object)this._event)).numErrInvalidParamsSourcesCalls = 0;
        ((DbusHttpTotalStatsEvent)((Object)this._event)).mastershipStatus = 0;
        this._peers.clear();
    }

    public JsonEncoder createJsonEncoder(OutputStream out) throws IOException {
        return new JsonEncoder(((DbusHttpTotalStatsEvent)((Object)this._event)).getSchema(), out);
    }

    protected void cloneData(DbusHttpTotalStatsEvent event) {
        event.ownerId = ((DbusHttpTotalStatsEvent)((Object)this._event)).ownerId;
        event.dimension = ((DbusHttpTotalStatsEvent)((Object)this._event)).dimension;
        event.timestampLastResetMs = ((DbusHttpTotalStatsEvent)((Object)this._event)).timestampLastResetMs;
        event.timeSinceLastResetMs = System.currentTimeMillis() - ((DbusHttpTotalStatsEvent)((Object)this._event)).timestampLastResetMs;
        event.numPeers = ((DbusHttpTotalStatsEvent)((Object)this._event)).numPeers;
        event.numRegisterCalls = ((DbusHttpTotalStatsEvent)((Object)this._event)).numRegisterCalls;
        event.numSourcesCalls = ((DbusHttpTotalStatsEvent)((Object)this._event)).numSourcesCalls;
        event.numStreamCalls = ((DbusHttpTotalStatsEvent)((Object)this._event)).numStreamCalls;
        event.timeStreamCallsMs = ((DbusHttpTotalStatsEvent)((Object)this._event)).timeStreamCallsMs;
        event.maxStreamWinScn = ((DbusHttpTotalStatsEvent)((Object)this._event)).maxStreamWinScn;
        event.minStreamWinScn = ((DbusHttpTotalStatsEvent)((Object)this._event)).minStreamWinScn;
        event.numErrInvalidParamsRegisterCalls = ((DbusHttpTotalStatsEvent)((Object)this._event)).numErrInvalidParamsRegisterCalls;
        event.numErrRegisterCalls = ((DbusHttpTotalStatsEvent)((Object)this._event)).numErrRegisterCalls;
        event.numErrInvalidParamsStreamCalls = ((DbusHttpTotalStatsEvent)((Object)this._event)).numErrInvalidParamsStreamCalls;
        event.numErrScnNotFoundStreamCalls = ((DbusHttpTotalStatsEvent)((Object)this._event)).numErrScnNotFoundStreamCalls;
        event.numErrSourcesCalls = ((DbusHttpTotalStatsEvent)((Object)this._event)).numErrSourcesCalls;
        event.numErrStreamCalls = ((DbusHttpTotalStatsEvent)((Object)this._event)).numErrStreamCalls;
        event.numErrInvalidParamsRegisterCalls = ((DbusHttpTotalStatsEvent)((Object)this._event)).numErrInvalidParamsRegisterCalls;
        event.numErrInvalidParamsSourcesCalls = ((DbusHttpTotalStatsEvent)((Object)this._event)).numErrInvalidParamsSourcesCalls;
        event.mastershipStatus = ((DbusHttpTotalStatsEvent)((Object)this._event)).mastershipStatus;
    }

    protected DbusHttpTotalStatsEvent newDataEvent() {
        return new DbusHttpTotalStatsEvent();
    }

    protected SpecificDatumWriter<DbusHttpTotalStatsEvent> getAvroWriter() {
        return new SpecificDatumWriter(DbusHttpTotalStatsEvent.class);
    }

    public void mergeStats(DatabusMonitoringMBean<DbusHttpTotalStatsEvent> other) {
        super.mergeStats(other);
        if (other instanceof DbusHttpTotalStats) {
            this.mergeClients((DbusHttpTotalStats)other);
        }
    }

    protected void doMergeStats(Object eventData) {
        if (!(eventData instanceof DbusHttpTotalStatsEvent)) {
            LOG.warn((Object)("Attempt to merge unknown event class" + eventData.getClass().getName()));
            return;
        }
        DbusHttpTotalStatsEvent e = (DbusHttpTotalStatsEvent)((Object)eventData);
        if (((DbusHttpTotalStatsEvent)((Object)this._event)).ownerId > 0 && e.ownerId != ((DbusHttpTotalStatsEvent)((Object)this._event)).ownerId) {
            LOG.warn((Object)("Attempt to data for a different relay " + e.ownerId));
            return;
        }
        ((DbusHttpTotalStatsEvent)((Object)this._event)).numPeers += e.numPeers;
        ((DbusHttpTotalStatsEvent)((Object)this._event)).numRegisterCalls += e.numRegisterCalls;
        ((DbusHttpTotalStatsEvent)((Object)this._event)).numSourcesCalls += e.numSourcesCalls;
        ((DbusHttpTotalStatsEvent)((Object)this._event)).numStreamCalls += e.numStreamCalls;
        ((DbusHttpTotalStatsEvent)((Object)this._event)).timeStreamCallsMs += e.timeStreamCallsMs;
        ((DbusHttpTotalStatsEvent)((Object)this._event)).maxStreamWinScn = this.maxValue(((DbusHttpTotalStatsEvent)((Object)this._event)).maxStreamWinScn, e.maxStreamWinScn);
        ((DbusHttpTotalStatsEvent)((Object)this._event)).minStreamWinScn = this.minValue(((DbusHttpTotalStatsEvent)((Object)this._event)).minStreamWinScn, e.minStreamWinScn);
        ((DbusHttpTotalStatsEvent)((Object)this._event)).numErrInvalidParamsRegisterCalls += e.numErrInvalidParamsRegisterCalls;
        ((DbusHttpTotalStatsEvent)((Object)this._event)).numErrRegisterCalls += e.numErrRegisterCalls;
        ((DbusHttpTotalStatsEvent)((Object)this._event)).numErrInvalidParamsStreamCalls += e.numErrInvalidParamsStreamCalls;
        ((DbusHttpTotalStatsEvent)((Object)this._event)).numErrScnNotFoundStreamCalls += e.numErrScnNotFoundStreamCalls;
        ((DbusHttpTotalStatsEvent)((Object)this._event)).numErrSourcesCalls += e.numErrSourcesCalls;
        ((DbusHttpTotalStatsEvent)((Object)this._event)).numErrStreamCalls += e.numErrStreamCalls;
        ((DbusHttpTotalStatsEvent)((Object)this._event)).numErrInvalidParamsRegisterCalls += e.numErrInvalidParamsRegisterCalls;
        ((DbusHttpTotalStatsEvent)((Object)this._event)).numErrInvalidParamsSourcesCalls += e.numErrInvalidParamsSourcesCalls;
        ((DbusHttpTotalStatsEvent)((Object)this._event)).mastershipStatus = Math.max(e.mastershipStatus, ((DbusHttpTotalStatsEvent)((Object)this._event)).mastershipStatus);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mergeClients(DbusHttpTotalStats other) {
        Lock otherReadLock = other.acquireReadLock();
        Lock writeLock = this.acquireWriteLock(otherReadLock);
        try {
            this._peers.addAll(other._peers);
            ((DbusHttpTotalStatsEvent)((Object)this._event)).numPeers = this._peers.size();
        }
        finally {
            this.releaseLock(writeLock);
            this.releaseLock(otherReadLock);
        }
    }

    public ObjectName generateObjectName() throws MalformedObjectNameException {
        Hashtable mbeanProps = this.generateBaseMBeanProps();
        mbeanProps.put("ownerId", Integer.toString(((DbusHttpTotalStatsEvent)((Object)this._event)).ownerId));
        mbeanProps.put("dimension", this._dimension);
        return new ObjectName("com.linkedin.databus2", mbeanProps);
    }

    @Override
    public String getDimension() {
        return this._dimension;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerInvalidStreamRequest(String peer) {
        Lock writeLock = this.acquireWriteLock();
        try {
            this.registerPeer(peer);
            ++((DbusHttpTotalStatsEvent)((Object)this._event)).numErrStreamCalls;
            ++((DbusHttpTotalStatsEvent)((Object)this._event)).numErrInvalidParamsStreamCalls;
        }
        finally {
            this.releaseLock(writeLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerScnNotFoundStreamResponse(String peer) {
        Lock writeLock = this.acquireWriteLock();
        try {
            this.registerPeer(peer);
            ++((DbusHttpTotalStatsEvent)((Object)this._event)).numErrStreamCalls;
            ++((DbusHttpTotalStatsEvent)((Object)this._event)).numErrScnNotFoundStreamCalls;
        }
        finally {
            this.releaseLock(writeLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerInvalidSourceRequest(String peer) {
        Lock writeLock = this.acquireWriteLock();
        try {
            this.registerPeer(peer);
            ++((DbusHttpTotalStatsEvent)((Object)this._event)).numErrInvalidParamsSourcesCalls;
            ++((DbusHttpTotalStatsEvent)((Object)this._event)).numErrSourcesCalls;
        }
        finally {
            this.releaseLock(writeLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerInvalidRegisterCall(String peer) {
        Lock writeLock = this.acquireWriteLock();
        try {
            this.registerPeer(peer);
            ++((DbusHttpTotalStatsEvent)((Object)this._event)).numErrStreamCalls;
            ++((DbusHttpTotalStatsEvent)((Object)this._event)).numErrInvalidParamsRegisterCalls;
        }
        finally {
            this.releaseLock(writeLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getNumScnNotFoundStream() {
        Lock readLock = this.acquireReadLock();
        long result = 0L;
        try {
            result = ((DbusHttpTotalStatsEvent)((Object)this._event)).numErrScnNotFoundStreamCalls;
        }
        finally {
            this.releaseLock(readLock);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getNumErrStream() {
        Lock readLock = this.acquireReadLock();
        long result = 0L;
        try {
            result = ((DbusHttpTotalStatsEvent)((Object)this._event)).numErrStreamCalls;
        }
        finally {
            this.releaseLock(readLock);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getNumErrStreamReq() {
        Lock readLock = this.acquireReadLock();
        long result = 0L;
        try {
            result = ((DbusHttpTotalStatsEvent)((Object)this._event)).numErrInvalidParamsStreamCalls;
        }
        finally {
            this.releaseLock(readLock);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getNumErrRegister() {
        Lock readLock = this.acquireReadLock();
        long result = 0L;
        try {
            result = ((DbusHttpTotalStatsEvent)((Object)this._event)).numErrRegisterCalls;
        }
        finally {
            this.releaseLock(readLock);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getNumErrRegisterReq() {
        Lock readLock = this.acquireReadLock();
        long result = 0L;
        try {
            result = ((DbusHttpTotalStatsEvent)((Object)this._event)).numErrInvalidParamsRegisterCalls;
        }
        finally {
            this.releaseLock(readLock);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getNumErrSources() {
        Lock readLock = this.acquireReadLock();
        long result = 0L;
        try {
            result = ((DbusHttpTotalStatsEvent)((Object)this._event)).numErrSourcesCalls;
        }
        finally {
            this.releaseLock(readLock);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getNumErrSourcesReq() {
        Lock readLock = this.acquireReadLock();
        long result = 0L;
        try {
            result = ((DbusHttpTotalStatsEvent)((Object)this._event)).numErrInvalidParamsSourcesCalls;
        }
        finally {
            this.releaseLock(readLock);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMastershipStatus() {
        Lock readLock = this.acquireReadLock();
        int result = 0;
        try {
            result = ((DbusHttpTotalStatsEvent)((Object)this._event)).mastershipStatus;
        }
        finally {
            this.releaseLock(readLock);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerMastershipStatus(int i) {
        Lock writeLock = this.acquireWriteLock();
        try {
            ((DbusHttpTotalStatsEvent)((Object)this._event)).mastershipStatus = i;
        }
        finally {
            this.releaseLock(writeLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getHttpErrorRate() {
        Lock readLock = this.acquireReadLock();
        try {
            long totalCalls = ((DbusHttpTotalStatsEvent)((Object)this._event)).numStreamCalls + (long)((DbusHttpTotalStatsEvent)((Object)this._event)).numRegisterCalls + (long)((DbusHttpTotalStatsEvent)((Object)this._event)).numSourcesCalls;
            long totalErrors = ((DbusHttpTotalStatsEvent)((Object)this._event)).numErrStreamCalls + (long)((DbusHttpTotalStatsEvent)((Object)this._event)).numErrSourcesCalls + (long)((DbusHttpTotalStatsEvent)((Object)this._event)).numErrRegisterCalls;
            double d = 0L == totalCalls ? 0.0 : 1.0 * (double)totalErrors / (double)totalCalls;
            return d;
        }
        finally {
            this.releaseLock(readLock);
        }
    }
}

