/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus2.core.container.monitoring.mbean;

import com.linkedin.databus.core.util.JmxUtil;
import com.linkedin.databus2.core.container.monitoring.mbean.DatabusComponentAdminMBean;
import com.linkedin.databus2.core.container.netty.ServerContainer;
import java.util.Hashtable;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.log4j.Logger;

public class DatabusComponentAdmin
implements DatabusComponentAdminMBean {
    public static final String MODULE = DatabusComponentAdmin.class.getName();
    public static final Logger LOG = Logger.getLogger((String)MODULE);
    public static final String JMX_DOMAIN = "com.linkedin.databus2";
    private final String _componentName;
    private final ServerContainer _serverContainer;
    private final MBeanServer _mbeanServer;
    private final ObjectName _mbeanObjectName;

    public DatabusComponentAdmin(ServerContainer serverContainer, MBeanServer mbeanServer, String componentName) {
        this._serverContainer = serverContainer;
        this._mbeanServer = mbeanServer;
        this._componentName = componentName;
        this._mbeanObjectName = this.createMBeanObjectName();
    }

    @Override
    public String getStatus() {
        return this._serverContainer.getStatus().toString();
    }

    @Override
    public int getStatusCode() {
        return this._serverContainer.getStatus().getCode();
    }

    @Override
    public String getStatusMessage() {
        return this._serverContainer.getStatusMessage();
    }

    @Override
    public long getContainerId() {
        return this._serverContainer.getContainerStaticConfig().getId();
    }

    @Override
    public long getHttpPort() {
        return this._serverContainer.getContainerStaticConfig().getHttpPort();
    }

    @Override
    public String getComponentName() {
        return this._componentName;
    }

    @Override
    public void pause() {
        this._serverContainer.pause();
    }

    @Override
    public void resume() {
        this._serverContainer.resume();
    }

    @Override
    public void shutdown() {
        this._serverContainer.awaitShutdown();
    }

    private ObjectName createMBeanObjectName() {
        ObjectName jmxName = null;
        try {
            Hashtable<String, String> mbeanProps = new Hashtable<String, String>(5);
            mbeanProps.put("name", this._componentName);
            mbeanProps.put("type", DatabusComponentAdmin.class.getSimpleName());
            mbeanProps.put("ownerId", Long.toString(this.getContainerId()));
            jmxName = new ObjectName(JMX_DOMAIN, mbeanProps);
        }
        catch (Exception e) {
            LOG.error((Object)"Error creating JMX object name", (Throwable)e);
        }
        return jmxName;
    }

    public void registerAsMBean() {
        if (null != this._mbeanServer) {
            try {
                this._mbeanServer.registerMBean(this, this._mbeanObjectName);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("MBean registered " + this._mbeanObjectName));
                }
            }
            catch (Exception e) {
                LOG.error((Object)"JMX registration failed", (Throwable)e);
            }
        }
    }

    public void unregisterAsMBeans() {
        if (null != this._mbeanServer) {
            try {
                JmxUtil.unregisterMBeanSafely((MBeanServer)this._mbeanServer, (ObjectName)this._mbeanObjectName, (Logger)LOG);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("MBean unregistered " + this._mbeanObjectName));
                }
            }
            catch (Exception e) {
                LOG.error((Object)"JMX deregistration failed", (Throwable)e);
            }
        }
    }
}

