/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus2.core.container.monitoring.mbean;

import com.linkedin.databus.core.monitoring.mbean.AbstractMonitoringMBean;
import com.linkedin.databus.core.monitoring.mbean.DatabusMonitoringMBean;
import com.linkedin.databus2.core.container.monitoring.events.ContainerTrafficTotalStatsEvent;
import com.linkedin.databus2.core.container.monitoring.mbean.ContainerTrafficTotalStatsMBean;
import java.io.IOException;
import java.io.OutputStream;
import java.net.ConnectException;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.concurrent.locks.Lock;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.avro.io.JsonEncoder;
import org.apache.avro.specific.SpecificDatumWriter;
import org.apache.log4j.Logger;
import org.jboss.netty.handler.timeout.TimeoutException;

public class ContainerTrafficTotalStats
extends AbstractMonitoringMBean<ContainerTrafficTotalStatsEvent>
implements ContainerTrafficTotalStatsMBean {
    public static final String MODULE = ContainerTrafficTotalStats.class.getName();
    public static final Logger LOG = Logger.getLogger((String)MODULE);
    private final HashSet<Object> _clients = new HashSet(1000);
    private final String _dimension;
    private long _lastConnOpenTimestamp;
    private long _lastConnOpenMergeTimestamp;

    public ContainerTrafficTotalStats(int containerId, String dimension, boolean enabled, boolean threadSafe, ContainerTrafficTotalStatsEvent initData) {
        super(enabled, threadSafe, (Object)initData);
        this._dimension = dimension;
        ((ContainerTrafficTotalStatsEvent)((Object)this._event)).containerId = containerId;
        ((ContainerTrafficTotalStatsEvent)((Object)this._event)).dimension = dimension;
        this.reset();
    }

    public ContainerTrafficTotalStats clone(boolean threadSafe) {
        return new ContainerTrafficTotalStats(((ContainerTrafficTotalStatsEvent)((Object)this._event)).containerId, this._dimension, this._enabled.get(), threadSafe, (ContainerTrafficTotalStatsEvent)((Object)this.getStatistics(null)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getNumBytes() {
        Lock readLock = this.acquireReadLock();
        long result = 0L;
        try {
            result = ((ContainerTrafficTotalStatsEvent)((Object)this._event)).numBytes;
        }
        finally {
            this.releaseLock(readLock);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getNumClients() {
        Lock readLock = this.acquireReadLock();
        int result = 0;
        try {
            result = ((ContainerTrafficTotalStatsEvent)((Object)this._event)).numClients;
        }
        finally {
            this.releaseLock(readLock);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getNumClosedConns() {
        Lock readLock = this.acquireReadLock();
        long result = 0L;
        try {
            result = ((ContainerTrafficTotalStatsEvent)((Object)this._event)).numClosedConns;
        }
        finally {
            this.releaseLock(readLock);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getNumOpenConns() {
        Lock readLock = this.acquireReadLock();
        long result = 0L;
        try {
            result = ((ContainerTrafficTotalStatsEvent)((Object)this._event)).numOpenConns - ((ContainerTrafficTotalStatsEvent)((Object)this._event)).numClosedConns;
        }
        finally {
            this.releaseLock(readLock);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getTimeSinceLastResetMs() {
        Lock readLock = this.acquireReadLock();
        try {
            long l = System.currentTimeMillis() - ((ContainerTrafficTotalStatsEvent)((Object)this._event)).timestampLastResetMs;
            return l;
        }
        finally {
            this.releaseLock(readLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getTimestampLastResetMs() {
        Lock readLock = this.acquireReadLock();
        try {
            long l = ((ContainerTrafficTotalStatsEvent)((Object)this._event)).timestampLastResetMs;
            return l;
        }
        finally {
            this.releaseLock(readLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getTimeClosedConnLifeMs() {
        Lock readLock = this.acquireReadLock();
        try {
            long l = ((ContainerTrafficTotalStatsEvent)((Object)this._event)).timeClosedConnLifeMs;
            return l;
        }
        finally {
            this.releaseLock(readLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getTimeOpenConnLifeMs() {
        Lock writeLock = this.acquireWriteLock();
        try {
            long now = 0L == this._lastConnOpenTimestamp ? 0L : System.currentTimeMillis();
            long currentOpenTime = 0L == this._lastConnOpenTimestamp ? 0L : now - this._lastConnOpenMergeTimestamp;
            ((ContainerTrafficTotalStatsEvent)((Object)this._event)).timeOpenConnLifeMs += currentOpenTime;
            this._lastConnOpenMergeTimestamp = now;
            long l = ((ContainerTrafficTotalStatsEvent)((Object)this._event)).timeOpenConnLifeMs - ((ContainerTrafficTotalStatsEvent)((Object)this._event)).timeClosedConnLifeMs;
            return l;
        }
        finally {
            this.releaseLock(writeLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getErrorTotalCount() {
        Lock readLock = this.acquireReadLock();
        try {
            long l = ((ContainerTrafficTotalStatsEvent)((Object)this._event)).errorTotalCount;
            return l;
        }
        finally {
            this.releaseLock(readLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getErrorConnectCount() {
        Lock readLock = this.acquireReadLock();
        try {
            long l = ((ContainerTrafficTotalStatsEvent)((Object)this._event)).errorConnectCount;
            return l;
        }
        finally {
            this.releaseLock(readLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getErrorTimeoutCount() {
        Lock readLock = this.acquireReadLock();
        try {
            long l = ((ContainerTrafficTotalStatsEvent)((Object)this._event)).errorTimeoutCount;
            return l;
        }
        finally {
            this.releaseLock(readLock);
        }
    }

    @Override
    public long getOpenConnsRate() {
        return this.getNumOpenConns();
    }

    @Override
    public long getClosedConnsRate() {
        return this.getNumClosedConns();
    }

    @Override
    public int getClientsRate() {
        return this.getNumClients();
    }

    @Override
    public long getLatencyOpenConn() {
        long openConns = this.getOpenConnsRate();
        return 0L == openConns ? 0L : this.getTimeOpenConnLifeMs() / openConns;
    }

    @Override
    public long getLatencyClosedConn() {
        long closedConns = this.getClosedConnsRate();
        return 0L == closedConns ? 0L : this.getTimeClosedConnLifeMs() / closedConns;
    }

    public String getDimension() {
        return this._dimension;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerConnectionClose() {
        if (!this._enabled.get()) {
            return;
        }
        Lock writeLock = this.acquireWriteLock();
        try {
            long now = this.isThreadSafe() ? 0L : System.currentTimeMillis();
            long connLifespanMs = this.isThreadSafe() ? 0L : now - this._lastConnOpenTimestamp;
            long unmergedConnLifespanMs = this.isThreadSafe() ? 0L : now - this._lastConnOpenMergeTimestamp;
            ++((ContainerTrafficTotalStatsEvent)((Object)this._event)).numClosedConns;
            ((ContainerTrafficTotalStatsEvent)((Object)this._event)).timeOpenConnLifeMs += connLifespanMs;
            ((ContainerTrafficTotalStatsEvent)((Object)this._event)).timeClosedConnLifeMs += unmergedConnLifespanMs;
            this._lastConnOpenTimestamp = 0L;
            this._lastConnOpenMergeTimestamp = 0L;
        }
        finally {
            this.releaseLock(writeLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerConnectionOpen(String client) {
        if (!this._enabled.get()) {
            return;
        }
        Lock writeLock = this.acquireWriteLock();
        try {
            this._lastConnOpenMergeTimestamp = this._lastConnOpenTimestamp = this.isThreadSafe() ? 0L : System.currentTimeMillis();
            ++((ContainerTrafficTotalStatsEvent)((Object)this._event)).numOpenConns;
            this._clients.add(client);
            ((ContainerTrafficTotalStatsEvent)((Object)this._event)).numClients = this._clients.size();
        }
        finally {
            this.releaseLock(writeLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerConnectionError(Throwable error) {
        if (!this._enabled.get()) {
            return;
        }
        Lock writeLock = this.acquireWriteLock();
        try {
            ++((ContainerTrafficTotalStatsEvent)((Object)this._event)).errorTotalCount;
            if (error instanceof TimeoutException) {
                ++((ContainerTrafficTotalStatsEvent)((Object)this._event)).errorTimeoutCount;
            } else if (error instanceof ConnectException) {
                ++((ContainerTrafficTotalStatsEvent)((Object)this._event)).errorConnectCount;
            }
        }
        finally {
            this.releaseLock(writeLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addResponseSize(int bytesSent) {
        if (!this._enabled.get()) {
            return;
        }
        Lock writeLock = this.acquireWriteLock();
        try {
            ((ContainerTrafficTotalStatsEvent)((Object)this._event)).numBytes += (long)bytesSent;
        }
        finally {
            this.releaseLock(writeLock);
        }
    }

    protected void resetData() {
        ((ContainerTrafficTotalStatsEvent)((Object)this._event)).timestampLastResetMs = System.currentTimeMillis();
        ((ContainerTrafficTotalStatsEvent)((Object)this._event)).timeSinceLastResetMs = 0L;
        ((ContainerTrafficTotalStatsEvent)((Object)this._event)).numBytes = 0L;
        ((ContainerTrafficTotalStatsEvent)((Object)this._event)).numClients = 0;
        ((ContainerTrafficTotalStatsEvent)((Object)this._event)).numClosedConns = 0L;
        ((ContainerTrafficTotalStatsEvent)((Object)this._event)).numOpenConns = 0L;
        ((ContainerTrafficTotalStatsEvent)((Object)this._event)).timeClosedConnLifeMs = 0L;
        ((ContainerTrafficTotalStatsEvent)((Object)this._event)).timeOpenConnLifeMs = 0L;
        this._clients.clear();
        this._lastConnOpenTimestamp = 0L;
        this._lastConnOpenMergeTimestamp = 0L;
        ((ContainerTrafficTotalStatsEvent)((Object)this._event)).errorConnectCount = 0L;
        ((ContainerTrafficTotalStatsEvent)((Object)this._event)).errorTimeoutCount = 0L;
        ((ContainerTrafficTotalStatsEvent)((Object)this._event)).errorTotalCount = 0L;
    }

    public JsonEncoder createJsonEncoder(OutputStream out) throws IOException {
        return new JsonEncoder(((ContainerTrafficTotalStatsEvent)((Object)this._event)).getSchema(), out);
    }

    protected void cloneData(ContainerTrafficTotalStatsEvent event) {
        event.containerId = ((ContainerTrafficTotalStatsEvent)((Object)this._event)).containerId;
        event.dimension = ((ContainerTrafficTotalStatsEvent)((Object)this._event)).dimension;
        event.timestampLastResetMs = ((ContainerTrafficTotalStatsEvent)((Object)this._event)).timestampLastResetMs;
        event.timeSinceLastResetMs = System.currentTimeMillis() - ((ContainerTrafficTotalStatsEvent)((Object)this._event)).timestampLastResetMs;
        event.numBytes = ((ContainerTrafficTotalStatsEvent)((Object)this._event)).numBytes;
        event.numClients = ((ContainerTrafficTotalStatsEvent)((Object)this._event)).numClients;
        event.numClosedConns = ((ContainerTrafficTotalStatsEvent)((Object)this._event)).numClosedConns;
        event.numOpenConns = ((ContainerTrafficTotalStatsEvent)((Object)this._event)).numOpenConns;
        event.timeClosedConnLifeMs = ((ContainerTrafficTotalStatsEvent)((Object)this._event)).timeClosedConnLifeMs;
        event.timeOpenConnLifeMs = ((ContainerTrafficTotalStatsEvent)((Object)this._event)).timeOpenConnLifeMs;
        event.errorConnectCount = ((ContainerTrafficTotalStatsEvent)((Object)this._event)).errorConnectCount;
        event.errorTimeoutCount = ((ContainerTrafficTotalStatsEvent)((Object)this._event)).errorTimeoutCount;
        event.errorTotalCount = ((ContainerTrafficTotalStatsEvent)((Object)this._event)).errorTotalCount;
    }

    protected ContainerTrafficTotalStatsEvent newDataEvent() {
        return new ContainerTrafficTotalStatsEvent();
    }

    protected SpecificDatumWriter<ContainerTrafficTotalStatsEvent> getAvroWriter() {
        return new SpecificDatumWriter(ContainerTrafficTotalStatsEvent.class);
    }

    public void mergeStats(DatabusMonitoringMBean<ContainerTrafficTotalStatsEvent> other) {
        super.mergeStats(other);
        if (other instanceof ContainerTrafficTotalStats) {
            ContainerTrafficTotalStats o = (ContainerTrafficTotalStats)other;
            o.getLatencyOpenConn();
            this.mergeClients(o);
        }
    }

    protected void doMergeStats(Object eventData) {
        if (!(eventData instanceof ContainerTrafficTotalStatsEvent)) {
            LOG.warn((Object)("Attempt to merge unknown event class: " + eventData.getClass().getName()));
            return;
        }
        ContainerTrafficTotalStatsEvent e = (ContainerTrafficTotalStatsEvent)((Object)eventData);
        if (((ContainerTrafficTotalStatsEvent)((Object)this._event)).containerId > 0 && e.containerId != ((ContainerTrafficTotalStatsEvent)((Object)this._event)).containerId) {
            LOG.warn((Object)("Attempt to data for a different relay " + e.containerId));
            return;
        }
        ((ContainerTrafficTotalStatsEvent)((Object)this._event)).numBytes += e.numBytes;
        ((ContainerTrafficTotalStatsEvent)((Object)this._event)).numClosedConns += e.numClosedConns;
        ((ContainerTrafficTotalStatsEvent)((Object)this._event)).numOpenConns += e.numOpenConns;
        ((ContainerTrafficTotalStatsEvent)((Object)this._event)).timeClosedConnLifeMs += e.timeClosedConnLifeMs;
        ((ContainerTrafficTotalStatsEvent)((Object)this._event)).timeOpenConnLifeMs += e.timeOpenConnLifeMs;
        ((ContainerTrafficTotalStatsEvent)((Object)this._event)).errorConnectCount += e.errorConnectCount;
        ((ContainerTrafficTotalStatsEvent)((Object)this._event)).errorTotalCount += e.errorTotalCount;
        ((ContainerTrafficTotalStatsEvent)((Object)this._event)).errorTimeoutCount += e.errorTimeoutCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mergeClients(ContainerTrafficTotalStats other) {
        Lock otherReadLock = other.acquireReadLock();
        Lock writeLock = this.acquireReadLock(otherReadLock);
        try {
            this._clients.addAll(other._clients);
            ((ContainerTrafficTotalStatsEvent)((Object)this._event)).numClients = this._clients.size();
        }
        finally {
            this.releaseLock(writeLock);
            this.releaseLock(otherReadLock);
        }
    }

    public ObjectName generateObjectName() throws MalformedObjectNameException {
        Hashtable mbeanProps = this.generateBaseMBeanProps();
        mbeanProps.put("containerId", Integer.toString(((ContainerTrafficTotalStatsEvent)((Object)this._event)).containerId));
        mbeanProps.put("dimension", this.getDimension());
        return new ObjectName("com.linkedin.databus2", mbeanProps);
    }
}

