/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus2.core.container.monitoring.mbean;

import com.linkedin.databus.core.monitoring.mbean.AbstractMonitoringMBean;
import com.linkedin.databus2.core.container.monitoring.events.ContainerStatsEvent;
import com.linkedin.databus2.core.container.monitoring.mbean.ContainerStatsMBean;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.locks.Lock;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.avro.io.JsonEncoder;
import org.apache.avro.specific.SpecificDatumWriter;

public class ContainerStats
extends AbstractMonitoringMBean<ContainerStatsEvent>
implements ContainerStatsMBean {
    private final ThreadPoolExecutor _ioThreadPool;
    private final ThreadPoolExecutor _workerThreadPool;

    public ContainerStats(int containerId, boolean enabled, boolean threadSafe, ContainerStatsEvent initData, ThreadPoolExecutor ioThreadPool, ThreadPoolExecutor workerThreadPool) {
        super(enabled, threadSafe, (Object)initData);
        ((ContainerStatsEvent)((Object)this._event)).containerId = containerId;
        this._ioThreadPool = ioThreadPool;
        this._workerThreadPool = workerThreadPool;
        this.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getErrorCount() {
        Lock readLock = this.acquireReadLock();
        try {
            long l = ((ContainerStatsEvent)((Object)this._event)).errorCount;
            return l;
        }
        finally {
            this.releaseLock(readLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getErrorUncaughtCount() {
        Lock readLock = this.acquireReadLock();
        try {
            long l = ((ContainerStatsEvent)((Object)this._event)).errorUncaughtCount;
            return l;
        }
        finally {
            this.releaseLock(readLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getErrorRequestProcessingCount() {
        Lock readLock = this.acquireReadLock();
        try {
            long l = ((ContainerStatsEvent)((Object)this._event)).errorRequestProcessingCount;
            return l;
        }
        finally {
            this.releaseLock(readLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getTimestampLastResetMs() {
        Lock readLock = this.acquireReadLock();
        try {
            long l = ((ContainerStatsEvent)((Object)this._event)).timestampLastResetMs;
            return l;
        }
        finally {
            this.releaseLock(readLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getTimeSinceLastResetMs() {
        Lock readLock = this.acquireReadLock();
        try {
            long l = System.currentTimeMillis() - ((ContainerStatsEvent)((Object)this._event)).timestampLastResetMs;
            return l;
        }
        finally {
            this.releaseLock(readLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getIoThreadMax() {
        Lock readLock = this.acquireReadLock();
        try {
            int n = ((ContainerStatsEvent)((Object)this._event)).ioThreadMax;
            return n;
        }
        finally {
            this.releaseLock(readLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getIoThreadRate() {
        Lock writeLock = this.acquireWriteLock();
        try {
            ((ContainerStatsEvent)((Object)this._event)).ioThreadRate = null != this._ioThreadPool ? this._ioThreadPool.getActiveCount() : -1;
            ((ContainerStatsEvent)((Object)this._event)).ioThreadMax = Math.max(((ContainerStatsEvent)((Object)this._event)).ioThreadRate, ((ContainerStatsEvent)((Object)this._event)).ioThreadMax);
            int n = ((ContainerStatsEvent)((Object)this._event)).ioThreadRate;
            return n;
        }
        finally {
            this.releaseLock(writeLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getIoTaskCount() {
        Lock writeLock = this.acquireWriteLock();
        try {
            if (null != this._ioThreadPool) {
                long taskCount = this._ioThreadPool.getTaskCount();
                long taskDelta = taskCount - ((ContainerStatsEvent)((Object)this._event)).ioTaskCount;
                if (((ContainerStatsEvent)((Object)this._event)).ioTaskCount > 0L) {
                    ((ContainerStatsEvent)((Object)this._event)).ioTaskMax = (int)Math.max(taskDelta, (long)((ContainerStatsEvent)((Object)this._event)).ioTaskMax);
                }
                ((ContainerStatsEvent)((Object)this._event)).ioTaskCount = taskCount;
            }
            long l = ((ContainerStatsEvent)((Object)this._event)).ioTaskCount;
            return l;
        }
        finally {
            this.releaseLock(writeLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getIoTaskMax() {
        Lock readLock = this.acquireReadLock();
        try {
            int n = ((ContainerStatsEvent)((Object)this._event)).ioTaskMax;
            return n;
        }
        finally {
            this.releaseLock(readLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getIoTaskQueueSize() {
        Lock writeLock = this.acquireWriteLock();
        try {
            if (null != this._ioThreadPool) {
                ((ContainerStatsEvent)((Object)this._event)).ioTaskQueueSize = this._ioThreadPool.getQueue().size();
            }
            int n = ((ContainerStatsEvent)((Object)this._event)).ioTaskQueueSize;
            return n;
        }
        finally {
            this.releaseLock(writeLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getWorkerThreadMax() {
        Lock readLock = this.acquireReadLock();
        try {
            int n = ((ContainerStatsEvent)((Object)this._event)).workerThreadMax;
            return n;
        }
        finally {
            this.releaseLock(readLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getWorkerThreadRate() {
        Lock writeLock = this.acquireWriteLock();
        try {
            ((ContainerStatsEvent)((Object)this._event)).workerThreadRate = this._workerThreadPool.getActiveCount();
            ((ContainerStatsEvent)((Object)this._event)).workerThreadMax = Math.max(((ContainerStatsEvent)((Object)this._event)).workerThreadRate, ((ContainerStatsEvent)((Object)this._event)).workerThreadMax);
            int n = ((ContainerStatsEvent)((Object)this._event)).workerThreadRate;
            return n;
        }
        finally {
            this.releaseLock(writeLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getWorkerTaskCount() {
        Lock writeLock = this.acquireWriteLock();
        try {
            long taskCount = this._workerThreadPool.getTaskCount();
            long taskDelta = taskCount - ((ContainerStatsEvent)((Object)this._event)).workerTaskCount;
            if (((ContainerStatsEvent)((Object)this._event)).workerTaskCount > 0L) {
                ((ContainerStatsEvent)((Object)this._event)).workerTaskMax = (int)Math.max(taskDelta, (long)((ContainerStatsEvent)((Object)this._event)).workerTaskMax);
            }
            long l = ((ContainerStatsEvent)((Object)this._event)).workerTaskCount = taskCount;
            return l;
        }
        finally {
            this.releaseLock(writeLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getWorkerTaskMax() {
        Lock readLock = this.acquireReadLock();
        try {
            int n = ((ContainerStatsEvent)((Object)this._event)).workerTaskMax;
            return n;
        }
        finally {
            this.releaseLock(readLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getWorkerTaskQueueSize() {
        Lock writeLock = this.acquireWriteLock();
        try {
            int n = ((ContainerStatsEvent)((Object)this._event)).workerTaskQueueSize = this._workerThreadPool.getQueue().size();
            return n;
        }
        finally {
            this.releaseLock(writeLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerError(Throwable error) {
        Lock writeLock = this.acquireWriteLock();
        try {
            ++((ContainerStatsEvent)((Object)this._event)).errorCount;
            if (error.getClass().getSimpleName().equals("RequestProcessingException")) {
                ++((ContainerStatsEvent)((Object)this._event)).errorRequestProcessingCount;
            } else {
                ++((ContainerStatsEvent)((Object)this._event)).errorUncaughtCount;
            }
        }
        finally {
            this.releaseLock(writeLock);
        }
    }

    public JsonEncoder createJsonEncoder(OutputStream out) throws IOException {
        return new JsonEncoder(((ContainerStatsEvent)((Object)this._event)).getSchema(), out);
    }

    public ObjectName generateObjectName() throws MalformedObjectNameException {
        Hashtable mbeanProps = this.generateBaseMBeanProps();
        mbeanProps.put("containerId", Integer.toString(((ContainerStatsEvent)((Object)this._event)).containerId));
        return new ObjectName("com.linkedin.databus2", mbeanProps);
    }

    protected void resetData() {
        ((ContainerStatsEvent)((Object)this._event)).timestampLastResetMs = System.currentTimeMillis();
        ((ContainerStatsEvent)((Object)this._event)).ioThreadRate = 0;
        ((ContainerStatsEvent)((Object)this._event)).ioThreadMax = 0;
        ((ContainerStatsEvent)((Object)this._event)).ioTaskCount = 0L;
        ((ContainerStatsEvent)((Object)this._event)).ioTaskMax = 0;
        ((ContainerStatsEvent)((Object)this._event)).ioTaskQueueSize = 0;
        ((ContainerStatsEvent)((Object)this._event)).workerThreadRate = 0;
        ((ContainerStatsEvent)((Object)this._event)).workerThreadMax = 0;
        ((ContainerStatsEvent)((Object)this._event)).workerTaskCount = 0L;
        ((ContainerStatsEvent)((Object)this._event)).workerTaskMax = 0;
        ((ContainerStatsEvent)((Object)this._event)).workerTaskQueueSize = 0;
        ((ContainerStatsEvent)((Object)this._event)).errorCount = 0L;
        ((ContainerStatsEvent)((Object)this._event)).errorRequestProcessingCount = 0L;
        ((ContainerStatsEvent)((Object)this._event)).errorUncaughtCount = 0L;
    }

    protected void cloneData(ContainerStatsEvent event) {
        event.containerId = ((ContainerStatsEvent)((Object)this._event)).containerId;
        event.timestampLastResetMs = ((ContainerStatsEvent)((Object)this._event)).timestampLastResetMs;
        event.ioThreadRate = ((ContainerStatsEvent)((Object)this._event)).ioThreadRate;
        event.ioThreadMax = ((ContainerStatsEvent)((Object)this._event)).ioThreadMax;
        event.ioTaskCount = ((ContainerStatsEvent)((Object)this._event)).ioTaskCount;
        event.ioTaskMax = ((ContainerStatsEvent)((Object)this._event)).ioTaskMax;
        event.ioTaskQueueSize = ((ContainerStatsEvent)((Object)this._event)).ioTaskQueueSize;
        event.workerThreadRate = ((ContainerStatsEvent)((Object)this._event)).workerThreadRate;
        event.workerThreadMax = ((ContainerStatsEvent)((Object)this._event)).workerThreadMax;
        event.workerTaskCount = ((ContainerStatsEvent)((Object)this._event)).workerTaskCount;
        event.workerTaskMax = ((ContainerStatsEvent)((Object)this._event)).workerTaskMax;
        event.workerTaskQueueSize = ((ContainerStatsEvent)((Object)this._event)).workerTaskQueueSize;
        event.errorCount = ((ContainerStatsEvent)((Object)this._event)).errorCount;
        event.errorRequestProcessingCount = ((ContainerStatsEvent)((Object)this._event)).errorRequestProcessingCount;
        event.errorUncaughtCount = ((ContainerStatsEvent)((Object)this._event)).errorUncaughtCount;
    }

    protected ContainerStatsEvent newDataEvent() {
        return new ContainerStatsEvent();
    }

    protected SpecificDatumWriter<ContainerStatsEvent> getAvroWriter() {
        return new SpecificDatumWriter(ContainerStatsEvent.class);
    }

    protected void doMergeStats(Object eventData) {
        if (!(eventData instanceof ContainerStatsEvent)) {
            LOG.warn((Object)("Attempt to merge unknown event class: " + eventData.getClass().getName()));
            return;
        }
        ContainerStatsEvent e = (ContainerStatsEvent)((Object)eventData);
        if (((ContainerStatsEvent)((Object)this._event)).containerId > 0 && e.containerId != ((ContainerStatsEvent)((Object)this._event)).containerId) {
            LOG.warn((Object)("Attempt to data for a different relay " + e.containerId));
            return;
        }
        ((ContainerStatsEvent)((Object)this._event)).ioThreadRate = e.ioThreadRate;
        ((ContainerStatsEvent)((Object)this._event)).ioThreadMax = Math.max(e.ioThreadMax, ((ContainerStatsEvent)((Object)this._event)).ioThreadMax);
        ((ContainerStatsEvent)((Object)this._event)).ioTaskCount += e.ioTaskCount;
        ((ContainerStatsEvent)((Object)this._event)).ioTaskMax = Math.max(e.ioTaskMax, ((ContainerStatsEvent)((Object)this._event)).ioTaskMax);
        ((ContainerStatsEvent)((Object)this._event)).ioTaskQueueSize = e.ioTaskQueueSize;
        ((ContainerStatsEvent)((Object)this._event)).workerThreadRate = e.workerThreadRate;
        ((ContainerStatsEvent)((Object)this._event)).workerThreadMax = Math.max(e.workerThreadMax, ((ContainerStatsEvent)((Object)this._event)).workerThreadMax);
        ((ContainerStatsEvent)((Object)this._event)).workerTaskCount += e.workerTaskCount;
        ((ContainerStatsEvent)((Object)this._event)).workerTaskMax = Math.max(e.workerTaskMax, ((ContainerStatsEvent)((Object)this._event)).workerTaskMax);
        ((ContainerStatsEvent)((Object)this._event)).workerTaskQueueSize = e.workerTaskQueueSize;
        ((ContainerStatsEvent)((Object)this._event)).errorCount += e.errorCount;
        ((ContainerStatsEvent)((Object)this._event)).errorRequestProcessingCount += e.errorRequestProcessingCount;
        ((ContainerStatsEvent)((Object)this._event)).errorUncaughtCount += e.errorUncaughtCount;
    }
}

