/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus2.core.container.monitoring.mbean;

import com.linkedin.databus.core.monitoring.mbean.DatabusMonitoringMBean;
import com.linkedin.databus.core.util.ConfigApplier;
import com.linkedin.databus.core.util.ConfigBuilder;
import com.linkedin.databus.core.util.InvalidConfigException;
import com.linkedin.databus.core.util.JmxUtil;
import com.linkedin.databus.core.util.ReadWriteSyncedObject;
import com.linkedin.databus2.core.container.monitoring.mbean.ContainerStatisticsCollectorMBean;
import com.linkedin.databus2.core.container.monitoring.mbean.ContainerStats;
import com.linkedin.databus2.core.container.monitoring.mbean.ContainerTrafficTotalStats;
import com.linkedin.databus2.core.container.monitoring.mbean.ContainerTrafficTotalStatsMBean;
import com.linkedin.databus2.core.container.netty.ServerContainer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.log4j.Logger;

public class ContainerStatisticsCollector
extends ReadWriteSyncedObject
implements ContainerStatisticsCollectorMBean {
    public static final String MODULE = ContainerStatisticsCollector.class.getName();
    public static final Logger LOG = Logger.getLogger((String)MODULE);
    public static final String NO_PEER = "none";
    private final ContainerTrafficTotalStats _outboundTrafficTotalStatsMBean;
    private final ContainerTrafficTotalStats _inboundTrafficTotalStatsMBean;
    private final HashMap<String, ContainerTrafficTotalStats> _outboundTrafficPerClientStats;
    private final MBeanServer _mbeanServer;
    private final ServerContainer _serverContainer;
    private final ContainerStats _containerStats;
    private final int _containerId;
    private final String _curClient;
    private final String _name;
    private final String _perPeerNamePrefix;
    private final ObjectName _collectorObjName;
    private final AtomicBoolean _enabled;

    public ContainerStatisticsCollector(ServerContainer serverContainer, String name, boolean enabled, boolean threadSafe, MBeanServer mbeanServer) {
        this(serverContainer, name, enabled, threadSafe, NO_PEER, mbeanServer);
    }

    private ContainerStatisticsCollector(ServerContainer serverContainer, String name, boolean enabled, boolean threadSafe, String client, MBeanServer mbeanServer) {
        super(threadSafe);
        this._serverContainer = serverContainer;
        this._mbeanServer = mbeanServer;
        this._curClient = client;
        this._name = name;
        this._perPeerNamePrefix = this._name + ".peer.";
        this._enabled = new AtomicBoolean(enabled);
        this._containerId = serverContainer.getContainerStaticConfig().getId();
        this._outboundTrafficTotalStatsMBean = new ContainerTrafficTotalStats(this._containerId, "outbound", enabled, threadSafe, null);
        this._inboundTrafficTotalStatsMBean = new ContainerTrafficTotalStats(this._containerId, "inbound", enabled, threadSafe, null);
        ExecutorService ioService = serverContainer.getIoExecutorService();
        this._containerStats = new ContainerStats(this._containerId, enabled, threadSafe, null, ioService instanceof ThreadPoolExecutor ? (ThreadPoolExecutor)ioService : null, serverContainer.getDefaultExecutorService());
        this._outboundTrafficPerClientStats = new HashMap(1000);
        Hashtable<String, String> mbeanProps = new Hashtable<String, String>(5);
        mbeanProps.put("type", ContainerStatisticsCollector.class.getSimpleName());
        mbeanProps.put("name", this._name);
        mbeanProps.put("container", Integer.toString(this._containerId));
        ObjectName jmxName = null;
        try {
            jmxName = new ObjectName("com.linkedin.databus2", mbeanProps);
        }
        catch (Exception e) {
            LOG.error((Object)"Error creating JMX object name", (Throwable)e);
        }
        this._collectorObjName = jmxName;
        this.registerAsMBeans();
    }

    protected void registerAsMBeans() {
        if (null != this._mbeanServer && null != this._collectorObjName) {
            try {
                if (this._mbeanServer.isRegistered(this._collectorObjName)) {
                    LOG.warn((Object)("unregistering stale mbean: " + this._collectorObjName));
                    this._mbeanServer.unregisterMBean(this._collectorObjName);
                }
                this._mbeanServer.registerMBean(this, this._collectorObjName);
                this._outboundTrafficTotalStatsMBean.registerAsMbean(this._mbeanServer);
                this._inboundTrafficTotalStatsMBean.registerAsMbean(this._mbeanServer);
                this._containerStats.registerAsMbean(this._mbeanServer);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("MBean registered " + this._collectorObjName));
                }
            }
            catch (Exception e) {
                LOG.error((Object)"JMX registration failed", (Throwable)e);
            }
        }
    }

    public void unregisterMBeans() {
        if (null != this._mbeanServer && null != this._collectorObjName) {
            try {
                JmxUtil.unregisterMBeanSafely((MBeanServer)this._mbeanServer, (ObjectName)this._collectorObjName, (Logger)LOG);
                this._outboundTrafficTotalStatsMBean.unregisterMbean(this._mbeanServer);
                this._inboundTrafficTotalStatsMBean.unregisterMbean(this._mbeanServer);
                this._containerStats.unregisterMbean(this._mbeanServer);
                for (String clientName : this._outboundTrafficPerClientStats.keySet()) {
                    this._outboundTrafficPerClientStats.get(clientName).unregisterMbean(this._mbeanServer);
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("MBean unregistered " + this._collectorObjName));
                }
            }
            catch (Exception e) {
                LOG.error((Object)"JMX deregistration failed", (Throwable)e);
            }
        }
    }

    public ContainerStatisticsCollector createForClientConnection(String client) {
        return new ContainerStatisticsCollector(this._serverContainer, client, true, false, client, null);
    }

    @Override
    public ContainerTrafficTotalStatsMBean getOutboundTrafficTotalStats() {
        return this._outboundTrafficTotalStatsMBean;
    }

    @Override
    public ContainerTrafficTotalStatsMBean getInboundTrafficTotalStats() {
        return this._inboundTrafficTotalStatsMBean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getOutboundClients() {
        Lock readLock = this.acquireReadLock();
        try {
            ArrayList<String> result;
            ArrayList<String> arrayList = result = new ArrayList<String>(this._outboundTrafficPerClientStats.keySet());
            return arrayList;
        }
        finally {
            this.releaseLock(readLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ContainerTrafficTotalStats getOutboundClientStats(String client) {
        Lock readLock = this.acquireReadLock();
        try {
            ContainerTrafficTotalStats result;
            ContainerTrafficTotalStats containerTrafficTotalStats = result = this._outboundTrafficPerClientStats.get(client);
            return containerTrafficTotalStats;
        }
        finally {
            this.releaseLock(readLock);
        }
    }

    public ContainerStats getContainerStats() {
        return this._containerStats;
    }

    public void registerOutboundConnectionClose() {
        if (!this._enabled.get()) {
            return;
        }
        this._outboundTrafficTotalStatsMBean.registerConnectionClose();
        if (NO_PEER != this._curClient) {
            ContainerTrafficTotalStats clientStats = this.getOrAddPerClientOutboundCollector(this._curClient, null);
            clientStats.registerConnectionClose();
        }
    }

    public void registerInboundConnectionClose() {
        if (!this._enabled.get()) {
            return;
        }
        this._inboundTrafficTotalStatsMBean.registerConnectionClose();
    }

    public void registerInboundConnectionError(Throwable error) {
        if (!this._enabled.get()) {
            return;
        }
        this._inboundTrafficTotalStatsMBean.registerConnectionError(error);
    }

    public void registerOutboundConnectionError(Throwable error) {
        if (!this._enabled.get()) {
            return;
        }
        this._outboundTrafficTotalStatsMBean.registerConnectionError(error);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerOutboundConnectionOpen() {
        if (!this._enabled.get()) {
            return;
        }
        this._outboundTrafficTotalStatsMBean.registerConnectionOpen(this._curClient);
        Lock writeLock = this.acquireWriteLock();
        try {
            if (NO_PEER != this._curClient) {
                ContainerTrafficTotalStats clientStats = this.getOrAddPerClientOutboundCollector(this._curClient, writeLock);
                clientStats.registerConnectionOpen(this._curClient);
            }
        }
        finally {
            this.releaseLock(writeLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerInboundConnectionOpen() {
        if (!this._enabled.get()) {
            return;
        }
        this._inboundTrafficTotalStatsMBean.registerConnectionOpen(this._curClient);
        Lock writeLock = this.acquireWriteLock();
        this.releaseLock(writeLock);
    }

    public void registerContainerError(Throwable error) {
        if (!this._enabled.get()) {
            return;
        }
        this._containerStats.registerError(error);
    }

    public void registerInboundNetworkError(Throwable error) {
        if (!this._enabled.get()) {
            return;
        }
        this._inboundTrafficTotalStatsMBean.registerConnectionError(error);
    }

    public void registerOutboundNetworkError(Throwable error) {
        if (!this._enabled.get()) {
            return;
        }
        this._outboundTrafficTotalStatsMBean.registerConnectionError(error);
    }

    public void addOutboundResponseSize(int bytesSent) {
        if (!this._enabled.get()) {
            return;
        }
        this._outboundTrafficTotalStatsMBean.addResponseSize(bytesSent);
        if (NO_PEER != this._curClient) {
            ContainerTrafficTotalStats clientStats = this.getOrAddPerClientOutboundCollector(this._curClient, null);
            clientStats.addResponseSize(bytesSent);
        }
    }

    public void addInboundResponseSize(int bytesSent) {
        if (!this._enabled.get()) {
            return;
        }
        this._inboundTrafficTotalStatsMBean.addResponseSize(bytesSent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void merge(ContainerStatisticsCollector other) {
        this._outboundTrafficTotalStatsMBean.mergeStats(other._outboundTrafficTotalStatsMBean);
        this._inboundTrafficTotalStatsMBean.mergeStats(other._inboundTrafficTotalStatsMBean);
        this._containerStats.mergeStats((DatabusMonitoringMBean)other._containerStats);
        Lock otherReadLock = other.acquireReadLock();
        Lock writeLock = this.acquireWriteLock(otherReadLock);
        try {
            for (String clientName : other._outboundTrafficPerClientStats.keySet()) {
                ContainerTrafficTotalStats bean = other._outboundTrafficPerClientStats.get(clientName);
                this.mergeOutboundTrafficPerClient(clientName, bean, writeLock);
            }
        }
        finally {
            this.releaseLock(writeLock);
            this.releaseLock(otherReadLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() {
        this._outboundTrafficTotalStatsMBean.reset();
        this._inboundTrafficTotalStatsMBean.reset();
        this._containerStats.reset();
        Lock readLock = this.acquireReadLock();
        try {
            for (String client : this._outboundTrafficPerClientStats.keySet()) {
                this._outboundTrafficPerClientStats.get(client).reset();
            }
        }
        finally {
            this.releaseLock(readLock);
        }
    }

    @Override
    public boolean isEnabled() {
        return this._enabled.get();
    }

    @Override
    public void setEnabled(boolean enabled) {
        this._enabled.set(enabled);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ContainerTrafficTotalStats getOrAddPerClientOutboundCollector(String client, Lock writeLock) {
        Lock myWriteLock = null;
        if (null == writeLock) {
            myWriteLock = this.acquireWriteLock();
        }
        try {
            ContainerTrafficTotalStats clientStats = this._outboundTrafficPerClientStats.get(client);
            if (null == clientStats) {
                clientStats = new ContainerTrafficTotalStats(this._containerId, this._perPeerNamePrefix + client, true, this.isThreadSafe(), null);
                this._outboundTrafficPerClientStats.put(client, clientStats);
                if (null != this._mbeanServer) {
                    clientStats.registerAsMbean(this._mbeanServer);
                }
            }
            ContainerTrafficTotalStats containerTrafficTotalStats = clientStats;
            return containerTrafficTotalStats;
        }
        finally {
            this.releaseLock(myWriteLock);
        }
    }

    private void mergeOutboundTrafficPerClient(String client, ContainerTrafficTotalStats other, Lock writeLock) {
        ContainerTrafficTotalStats curBean = this.getOrAddPerClientOutboundCollector(client, writeLock);
        curBean.mergeStats(other);
    }

    public static class Config
    implements ConfigBuilder<StaticConfig> {
        private final RuntimeConfigBuilder _runtime = new RuntimeConfigBuilder();

        public RuntimeConfigBuilder getRuntime() {
            return this._runtime;
        }

        public StaticConfig build() throws InvalidConfigException {
            return new StaticConfig(this._runtime);
        }
    }

    public static class StaticConfig {
        private final RuntimeConfigBuilder _runtime;

        public StaticConfig(RuntimeConfigBuilder runtime) {
            this._runtime = runtime;
        }

        public RuntimeConfigBuilder getRuntime() {
            return this._runtime;
        }
    }

    public static class RuntimeConfigBuilder
    implements ConfigBuilder<RuntimeConfig> {
        private boolean _enabled = true;
        private ContainerStatisticsCollector _managedInstance = null;

        public boolean isEnabled() {
            return this._enabled;
        }

        public void setEnabled(boolean enabled) {
            this._enabled = enabled;
        }

        public RuntimeConfig build() throws InvalidConfigException {
            if (null != this._managedInstance) {
                ContainerStatisticsCollector containerStatisticsCollector = this._managedInstance;
                containerStatisticsCollector.getClass();
                return containerStatisticsCollector.new RuntimeConfig(this._enabled);
            }
            throw new InvalidConfigException("No ContainerStatisticsCollector instance assigned");
        }

        public ContainerStatisticsCollector getManagedInstance() {
            return this._managedInstance;
        }

        public void setManagedInstance(ContainerStatisticsCollector managedInstance) {
            this._managedInstance = managedInstance;
        }
    }

    public class RuntimeConfig
    implements ConfigApplier<RuntimeConfig> {
        private final boolean _enabled;

        public RuntimeConfig(boolean enabled) {
            this._enabled = enabled;
        }

        public boolean isEnabled() {
            return this._enabled;
        }

        public void applyNewConfig(RuntimeConfig oldConfig) {
            ContainerStatisticsCollector.this.setEnabled(this.isEnabled());
        }

        public boolean equals(Object other) {
            if (null == other || !(other instanceof RuntimeConfig)) {
                return false;
            }
            return this.equalsConfig((RuntimeConfig)other);
        }

        public boolean equalsConfig(RuntimeConfig otherConfig) {
            if (null == otherConfig) {
                return false;
            }
            return this.isEnabled() == otherConfig.isEnabled();
        }

        public int hashCode() {
            return this._enabled ? -1 : 0;
        }
    }
}

