/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus2.core.container;

import com.linkedin.databus.core.util.ConfigBuilder;
import com.linkedin.databus.core.util.InvalidConfigException;
import com.linkedin.databus2.core.container.JmxStaticConfig;
import org.apache.log4j.Logger;

public class JmxStaticConfigBuilder
implements ConfigBuilder<JmxStaticConfig> {
    public static final String MODULE = JmxStaticConfigBuilder.class.getName();
    public static final Logger LOG = Logger.getLogger((String)MODULE);
    public static final int DEFAULT_JMX_SERVICE_PORT = 9999;
    public static final String DEFAULT_JMX_SERVICE_HOST = "localhost";
    public static final int DEFAULT_RMI_REGISTRY_PORT = 1099;
    public static final String DEFAULT_RMI_REGISTRY_HOST = "localhost";
    private int _jmxServicePort = 9999;
    private String _jmxServiceHost = "localhost";
    private int _rmiRegistryPort = 1099;
    private String _rmiRegistryHost = "localhost";
    private boolean _rmiEnabled = true;

    public int getJmxServicePort() {
        return this._jmxServicePort;
    }

    public void setJmxServicePort(int jmxServicePort) {
        this._jmxServicePort = jmxServicePort;
    }

    public String getJmxServiceHost() {
        return this._jmxServiceHost;
    }

    public void setJmxServiceHost(String jmxServiceHost) {
        this._jmxServiceHost = jmxServiceHost;
    }

    public int getRmiRegistryPort() {
        return this._rmiRegistryPort;
    }

    public void setRmiRegistryPort(int rmiRegistryPort) {
        this._rmiRegistryPort = rmiRegistryPort;
    }

    public String getRmiRegistryHost() {
        return this._rmiRegistryHost;
    }

    public void setRmiRegistryHost(String rmiRegistryHost) {
        this._rmiRegistryHost = rmiRegistryHost;
    }

    public JmxStaticConfig build() throws InvalidConfigException {
        LOG.info((Object)("Using JMX service: " + this._jmxServiceHost + ":" + this._jmxServicePort));
        LOG.info((Object)("Using RMI registry: rmi://" + this._rmiRegistryHost + ":" + this._rmiRegistryPort));
        return new JmxStaticConfig(this._jmxServicePort, this._jmxServiceHost, this._rmiRegistryPort, this._rmiRegistryHost, this._rmiEnabled);
    }

    public boolean isRmiEnabled() {
        return this._rmiEnabled;
    }

    public void setRmiEnabled(boolean rmiEnabled) {
        this._rmiEnabled = rmiEnabled;
    }
}

