/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus2.core.container;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.ClosedChannelException;
import java.util.Formatter;
import org.apache.log4j.Logger;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelHandler;
import org.jboss.netty.channel.WriteCompletionEvent;
import org.jboss.netty.handler.codec.http.HttpChunk;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.codec.http.HttpResponse;
import org.jboss.netty.handler.timeout.ReadTimeoutException;
import org.jboss.netty.handler.timeout.WriteTimeoutException;

public class HttpRequestLoggingHandler
extends SimpleChannelHandler {
    public static final String MODULE = HttpRequestLoggingHandler.class.getName();
    public static final String INBOUND_MODULE = MODULE + ".in";
    public static final String OUTBOUND_MODULE = MODULE + ".out";
    public static final Logger LOG = Logger.getLogger((String)MODULE);
    public static final Logger INBOUND_LOG = Logger.getLogger((String)INBOUND_MODULE);
    public static final Logger OUTBOUND_LOG = Logger.getLogger((String)OUTBOUND_MODULE);
    public static final String INBOUND_DIR = ">";
    public static final String OUTBOUND_DIR = "<";
    public static final int READ_TIMEOUT_CODE = 997;
    public static final int WRITE_TIMEOUT_CODE = 998;
    public static final int DISCONNECTED_CODE = 996;
    private static final String LOG_LINE_FORMAT = "%s %s %s %s %d %03d/%3s %7.2f %7.2f %d";
    private static final String CONNECT_LINE_FORMAT = "%s %s %s %s %d %d %14.2f %14.2f %d";
    private static final int MAX_SKIPPED_LOG_LINES = 500;
    private String _peerIp = "N/A";
    private String _peerId = "N/A";
    private long _connRequestNano = -1L;
    private long _connStartNano = -1L;
    private long _reqStartNano = -1L;
    private long _respStartNano = -1L;
    private long _respFinishNano = -1L;
    private long _reqBytes = 0L;
    private long _respBytes = 0L;
    private long _connBytes = 0L;
    private String _channelStatusCode = "AOK";
    private State _state = State.WAIT;
    private volatile HttpRequest _request;
    private HttpResponse _response;
    private String _lastLogLine = "";
    private int _lastLogLineRepeat = 0;

    public void channelConnected(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        SocketAddress remoteAddress = ctx.getChannel().getRemoteAddress();
        if (remoteAddress instanceof InetSocketAddress) {
            InetSocketAddress inetAddress = (InetSocketAddress)remoteAddress;
            this._peerIp = inetAddress.getAddress().getHostAddress();
        } else {
            this._peerIp = remoteAddress.toString();
        }
        this._peerId = this._peerIp;
        this._connStartNano = System.nanoTime();
        this._connBytes = 0L;
        this.logConnectionStart();
        super.channelConnected(ctx, e);
    }

    public void channelDisconnected(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        if (null != this._request) {
            switch (this._state) {
                case INBOUND_REQUEST: 
                case INBOUND_RESPONSE: 
                case INBOUND_RESPONSE_END: {
                    this.endHttpResponse(false);
                    break;
                }
                case OUTBOUND_REQUEST: 
                case OUTBOUND_RESPONSE: 
                case OUTBOUND_RESPONSE_END: {
                    this.endHttpResponse(true);
                    break;
                }
            }
        }
        this.logConnectionEnd();
        super.channelDisconnected(ctx, e);
    }

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        if (e.getMessage() instanceof HttpRequest) {
            HttpRequest req = (HttpRequest)e.getMessage();
            this.startHttpRequest(false, req);
        } else if (e.getMessage() instanceof HttpResponse) {
            HttpResponse resp = (HttpResponse)e.getMessage();
            this.startHttpResponse(true, resp);
        } else if (e.getMessage() instanceof HttpChunk) {
            HttpChunk chunk = (HttpChunk)e.getMessage();
            this.processHttpChunk(true, chunk);
            if (State.OUTBOUND_RESPONSE_END == this._state) {
                this.endHttpResponse(true);
            }
        }
        super.messageReceived(ctx, e);
    }

    public void writeComplete(ChannelHandlerContext ctx, WriteCompletionEvent e) throws Exception {
        if (State.INBOUND_RESPONSE_END == this._state) {
            this.endHttpResponse(false);
        }
        super.writeComplete(ctx, e);
    }

    public void writeRequested(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        if (e.getMessage() instanceof HttpRequest) {
            HttpRequest req = (HttpRequest)e.getMessage();
            this.startHttpRequest(true, req);
        } else if (e.getMessage() instanceof HttpResponse) {
            HttpResponse resp = (HttpResponse)e.getMessage();
            this.startHttpResponse(false, resp);
        } else if (e.getMessage() instanceof HttpChunk) {
            HttpChunk chunk = (HttpChunk)e.getMessage();
            this.processHttpChunk(false, chunk);
        }
        super.writeRequested(ctx, e);
    }

    private void startHttpRequest(boolean outbound, HttpRequest req) {
        this._reqStartNano = System.nanoTime();
        this._respBytes = 0L;
        this._reqBytes = 0L;
        this._request = req;
        this._response = null;
        this._channelStatusCode = null;
        this._state = outbound ? State.OUTBOUND_REQUEST : State.INBOUND_REQUEST;
        String hostHdr = null;
        String svcHdr = null;
        if (outbound) {
            if (req.containsHeader("x-dbus-server-host") || req.containsHeader("x-dbus-server-service")) {
                hostHdr = req.getHeader("x-dbus-server-host");
                svcHdr = req.getHeader("x-dbus-server-service");
            }
        } else if (req.containsHeader("x-dbus-client-host") || req.containsHeader("x-dbus-client-service")) {
            hostHdr = req.getHeader("x-dbus-client-host");
            svcHdr = req.getHeader("x-dbus-client-service");
        }
        if (null != hostHdr || null != svcHdr) {
            this.updateTrackingInfo(hostHdr, svcHdr);
        }
    }

    private void startHttpResponse(boolean outbound, HttpResponse resp) {
        this._respStartNano = System.nanoTime();
        if (!resp.isChunked()) {
            this._respBytes = resp.getContent().readableBytes();
            this._connBytes += this._respBytes;
        }
        this._response = resp;
        this._state = outbound ? (resp.isChunked() ? State.OUTBOUND_RESPONSE : State.OUTBOUND_RESPONSE_END) : (resp.isChunked() ? State.INBOUND_RESPONSE : State.INBOUND_RESPONSE_END);
        String hostHdr = null;
        String svcHdr = null;
        if (outbound) {
            if (resp.containsHeader("x-dbus-server-host") || resp.containsHeader("x-dbus-server-service")) {
                hostHdr = resp.getHeader("x-dbus-server-host");
                svcHdr = resp.getHeader("x-dbus-server-service");
            }
        } else if (resp.containsHeader("x-dbus-client-host") || resp.containsHeader("x-dbus-client-service")) {
            hostHdr = resp.getHeader("x-dbus-client-host");
            svcHdr = resp.getHeader("x-dbus-client-service");
        }
        if (null != hostHdr || null != svcHdr) {
            this.updateTrackingInfo(hostHdr, svcHdr);
        }
        if (State.WAIT == this._state || State.INBOUND_RESPONSE_END == this._state || State.OUTBOUND_RESPONSE_END == this._state) {
            this.endHttpResponse(outbound);
        }
    }

    private void processHttpChunk(boolean outbound, HttpChunk chunk) {
        switch (this._state) {
            case INBOUND_REQUEST: 
            case OUTBOUND_REQUEST: {
                this._reqBytes += (long)chunk.getContent().readableBytes();
                break;
            }
            case INBOUND_RESPONSE: 
            case OUTBOUND_RESPONSE: {
                this._respBytes += (long)chunk.getContent().readableBytes();
                this._connBytes += (long)chunk.getContent().readableBytes();
                if (!chunk.isLast()) break;
                if (State.INBOUND_RESPONSE == this._state) {
                    this._state = State.INBOUND_RESPONSE_END;
                    break;
                }
                if (State.OUTBOUND_RESPONSE != this._state) break;
                this._state = State.OUTBOUND_RESPONSE_END;
                break;
            }
        }
    }

    private void endHttpResponse(boolean outbound) {
        HttpRequest req = this._request;
        String method = null != req ? req.getMethod().getName() : "ERR";
        String uri = null != req ? req.getUri() : "ERR";
        int respCode = null != this._response ? this._response.getStatus().getCode() : 0;
        this._respFinishNano = System.nanoTime();
        StringBuilder logLineBuilder = new StringBuilder(10000);
        Formatter logFormatter = new Formatter(logLineBuilder);
        logFormatter.format(LOG_LINE_FORMAT, outbound ? OUTBOUND_DIR : INBOUND_DIR, this._peerId, method, uri, this._reqBytes, respCode, null != this._channelStatusCode ? this._channelStatusCode : "AOK", (double)(this._respStartNano - this._reqStartNano) * 1.0 / 1000000.0, (double)(this._respFinishNano - this._reqStartNano) * 1.0 / 1000000.0, this._respBytes);
        this.log(outbound, logFormatter);
        this._state = State.WAIT;
        this._request = null;
    }

    private void logConnectionStart() {
        StringBuilder logLineBuilder = new StringBuilder(10000);
        boolean outbound = this._connRequestNano > -1L;
        Formatter logFormatter = new Formatter(logLineBuilder);
        logFormatter.format(CONNECT_LINE_FORMAT, outbound ? OUTBOUND_DIR : INBOUND_DIR, this._peerId, "CONNECT", "/START", 0, 200, 0.0, outbound ? (double)(System.nanoTime() - this._connRequestNano) * 1.0 / 1000000.0 : 0.0, 0);
        this.log(outbound, logFormatter);
    }

    private void logConnectionEnd() {
        StringBuilder logLineBuilder = new StringBuilder(10000);
        boolean outbound = this._connRequestNano > -1L;
        Formatter logFormatter = new Formatter(logLineBuilder);
        logFormatter.format(CONNECT_LINE_FORMAT, outbound ? OUTBOUND_DIR : INBOUND_DIR, this._peerId, "CONNECT", "/END", 0, 200, 0.0, outbound ? (double)(System.nanoTime() - this._connStartNano) * 1.0 / 1000000.0 : 0.0, this._connBytes);
        this.log(outbound, logFormatter);
    }

    public void connectRequested(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        this._connRequestNano = System.nanoTime();
        super.connectRequested(ctx, e);
    }

    private void log(boolean outbound, Formatter logLine) {
        logLine.flush();
        String newLogLine = logLine.toString();
        boolean skipLog = true;
        int saveLastLogLineRepeat = this._lastLogLineRepeat;
        if (this._lastLogLine.equals(newLogLine) && this._lastLogLineRepeat < 500) {
            ++this._lastLogLineRepeat;
        } else {
            skipLog = false;
            this._lastLogLine = newLogLine;
            this._lastLogLineRepeat = 0;
        }
        if (!skipLog) {
            if (outbound) {
                if (0 != saveLastLogLineRepeat) {
                    OUTBOUND_LOG.debug((Object)("last line repeated: " + saveLastLogLineRepeat));
                }
                OUTBOUND_LOG.debug((Object)newLogLine);
            } else {
                if (0 != saveLastLogLineRepeat) {
                    INBOUND_LOG.debug((Object)("last line repeated: " + saveLastLogLineRepeat));
                }
                INBOUND_LOG.debug((Object)newLogLine);
            }
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
        if (null == this._channelStatusCode) {
            this._channelStatusCode = e.getCause() instanceof ReadTimeoutException ? "RTE" : (e.getCause() instanceof WriteTimeoutException ? "WTE" : (e.getCause() instanceof ClosedChannelException ? "CCE" : "UKE"));
        }
        super.exceptionCaught(ctx, e);
    }

    private void updateTrackingInfo(String hostHdr, String svcHdr) {
        this._peerId = (null == hostHdr ? this._peerIp : hostHdr) + (null == svcHdr ? "" : "[" + svcHdr + "]");
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("updateTrackingInfo: host=" + hostHdr + ",service=" + svcHdr + ",id=" + this._peerId));
        }
    }

    private static enum State {
        WAIT,
        INBOUND_REQUEST,
        OUTBOUND_REQUEST,
        INBOUND_RESPONSE,
        OUTBOUND_RESPONSE,
        INBOUND_RESPONSE_END,
        OUTBOUND_RESPONSE_END;

    }
}

