/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus2.core.container;

import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.LifeCycleAwareChannelHandler;
import org.jboss.netty.handler.timeout.WriteTimeoutException;
import org.jboss.netty.handler.timeout.WriteTimeoutHandler;
import org.jboss.netty.util.HashedWheelTimer;
import org.jboss.netty.util.Timer;

public class ExtendedWriteTimeoutHandler
extends WriteTimeoutHandler
implements LifeCycleAwareChannelHandler {
    public static final String MODULE = ExtendedWriteTimeoutHandler.class.getName();
    public static final Logger LOG = Logger.getLogger((String)MODULE);
    private final String _name;
    private final boolean _closeOnTimeout;
    private final boolean _ownTimer;

    public ExtendedWriteTimeoutHandler(String name, Timer timer, long timeoutMs, boolean closeOnTimeout) {
        super((Timer)(null != timer ? timer : new HashedWheelTimer(timeoutMs, TimeUnit.MILLISECONDS, 10)), timeoutMs, TimeUnit.MILLISECONDS);
        this._name = name;
        this._closeOnTimeout = closeOnTimeout;
        this._ownTimer = null == timer;
    }

    public void destroy() {
        if (this._ownTimer) {
            LOG.info((Object)"releasing external resources");
            super.releaseExternalResources();
        }
    }

    public void beforeAdd(ChannelHandlerContext arg0) throws Exception {
    }

    public void afterAdd(ChannelHandlerContext arg0) throws Exception {
    }

    public void beforeRemove(ChannelHandlerContext arg0) throws Exception {
        this.destroy();
    }

    public void afterRemove(ChannelHandlerContext arg0) throws Exception {
    }

    public void releaseExternalResources() {
        this.destroy();
    }

    protected void writeTimedOut(ChannelHandlerContext ctx) {
        Channels.fireExceptionCaught((ChannelHandlerContext)ctx, (Throwable)new WriteTimeoutException(this._name));
        if (this._closeOnTimeout) {
            ctx.getChannel().close();
        }
    }
}

