/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus2.core.container;

import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.LifeCycleAwareChannelHandler;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.jboss.netty.handler.timeout.ReadTimeoutException;
import org.jboss.netty.util.ExternalResourceReleasable;
import org.jboss.netty.util.HashedWheelTimer;
import org.jboss.netty.util.Timeout;
import org.jboss.netty.util.Timer;
import org.jboss.netty.util.TimerTask;

public class ExtendedReadTimeoutHandler
extends SimpleChannelUpstreamHandler
implements LifeCycleAwareChannelHandler,
ExternalResourceReleasable {
    public static final String MODULE = ExtendedReadTimeoutHandler.class.getName();
    public static final Logger LOG = Logger.getLogger((String)MODULE);
    private final String _name;
    private final boolean _closeOnTimeout;
    private final Timer _timer;
    private final long _timeoutMs;
    private final boolean _ownTimer;
    private volatile long _lastReadTs;
    private volatile Timeout _timeout;
    private volatile ReadTimeoutTask _timeoutTask;

    public ExtendedReadTimeoutHandler(String name, Timer timer, long timeoutMs, boolean closeOnTimeout) {
        this._name = name;
        this._closeOnTimeout = closeOnTimeout;
        this._timeoutMs = timeoutMs;
        this._lastReadTs = -1L;
        if (null != timer) {
            this._timer = timer;
            this._ownTimer = false;
        } else {
            this._timer = new HashedWheelTimer(timeoutMs, TimeUnit.MILLISECONDS, 10);
            this._ownTimer = true;
        }
    }

    public synchronized void start(ChannelHandlerContext ctx) {
        this.updateLastReadTime();
        this._timeoutTask = new ReadTimeoutTask(ctx);
        this.createTimeout(this._timeoutTask, this._timeoutMs);
    }

    public synchronized void stop() {
        this._lastReadTs = -1L;
        if (null != this._timeout) {
            this._timeout.cancel();
        }
        this._timeoutTask = null;
        this._timeout = null;
    }

    public void destroy() {
        this.stop();
        if (this._ownTimer) {
            LOG.info((Object)"stopping timeout timer");
            this._timer.stop();
        }
    }

    public synchronized boolean isStarted() {
        return null != this._timeoutTask;
    }

    public void beforeAdd(ChannelHandlerContext arg0) throws Exception {
    }

    public void afterAdd(ChannelHandlerContext arg0) throws Exception {
    }

    public void beforeRemove(ChannelHandlerContext arg0) throws Exception {
        this.destroy();
    }

    public void afterRemove(ChannelHandlerContext arg0) throws Exception {
    }

    public void releaseExternalResources() {
        this.destroy();
    }

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        if (!this.isStarted()) {
            this.start(ctx);
        } else {
            this.updateLastReadTime();
        }
        super.messageReceived(ctx, e);
    }

    private void updateLastReadTime() {
        this._lastReadTs = System.currentTimeMillis();
    }

    private void createTimeout(ReadTimeoutTask task, long timeoutMs) {
        if (timeoutMs > 0L && task != null) {
            this._timeout = this._timer.newTimeout((TimerTask)task, timeoutMs, TimeUnit.MILLISECONDS);
        }
    }

    private void readTimedOut(ChannelHandlerContext ctx) {
        Channels.fireExceptionCaught((ChannelHandlerContext)ctx, (Throwable)new ReadTimeoutException(this._name));
        if (this._closeOnTimeout) {
            ctx.getChannel().close();
        }
    }

    private final class ReadTimeoutTask
    implements TimerTask {
        private final ChannelHandlerContext _ctx;

        ReadTimeoutTask(ChannelHandlerContext ctx) {
            this._ctx = ctx;
        }

        public void run(Timeout timeout) throws Exception {
            if (timeout.isCancelled() || !this._ctx.getChannel().isOpen() || -1L == ExtendedReadTimeoutHandler.this._lastReadTs) {
                return;
            }
            long now = System.currentTimeMillis();
            long nextTimeout = ExtendedReadTimeoutHandler.this._timeoutMs - (now - ExtendedReadTimeoutHandler.this._lastReadTs);
            if (nextTimeout <= 0L) {
                try {
                    ExtendedReadTimeoutHandler.this.readTimedOut(this._ctx);
                }
                catch (Throwable t) {
                    Channels.fireExceptionCaught((ChannelHandlerContext)this._ctx, (Throwable)t);
                }
            } else {
                ExtendedReadTimeoutHandler.this.createTimeout(this, nextTimeout);
            }
        }
    }
}

