/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus2.core.container;

import com.linkedin.databus2.core.container.ExtendedReadTimeoutHandler;
import com.linkedin.databus2.core.container.request.BinaryProtocol;
import com.linkedin.databus2.core.container.request.CommandsRegistry;
import com.linkedin.databus2.core.container.request.SimpleBinaryDatabusRequestDecoder;
import com.linkedin.databus2.core.container.request.SimpleBinaryDatabusResponseEncoder;
import java.nio.ByteOrder;
import java.util.List;
import java.util.Vector;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.DynamicChannelBuffer;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;

public class DummyPipelineFactory {
    public static final String RESPONSE_AGGREGATOR_NAME = "response aggregator";
    public static final String COMMAND_CAPTURE_NAME = "command capture";
    private static final int READ_TIMEOUT_MS = 500;

    public static class SimpleResponseBytesAggregatorHandler
    extends SimpleChannelUpstreamHandler {
        private final ChannelBuffer _buffer;

        public SimpleResponseBytesAggregatorHandler(ByteOrder byteOrder) {
            this._buffer = new DynamicChannelBuffer(byteOrder, 1000);
        }

        public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
            if (e.getMessage() instanceof ChannelBuffer) {
                ChannelBuffer buf = (ChannelBuffer)e.getMessage();
                this._buffer.writeBytes(buf);
            }
            super.messageReceived(ctx, e);
        }

        public ChannelBuffer getBuffer() {
            return this._buffer;
        }

        public void clear() {
            this._buffer.clear();
        }
    }

    public static class SimpleObjectCaptureHandler
    extends SimpleChannelUpstreamHandler {
        private final List<Object> _messages = new Vector<Object>();

        public void clear() {
            this._messages.clear();
        }

        public List<Object> getMessages() {
            return this._messages;
        }

        public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
            this._messages.add(e.getMessage());
            super.messageReceived(ctx, e);
        }
    }

    public static class DummyClientPipelineFactory
    implements ChannelPipelineFactory {
        public ChannelPipeline getPipeline() throws Exception {
            ChannelPipeline pipeline = Channels.pipeline();
            pipeline.addLast(DummyPipelineFactory.RESPONSE_AGGREGATOR_NAME, (ChannelHandler)new SimpleResponseBytesAggregatorHandler(BinaryProtocol.BYTE_ORDER));
            return pipeline;
        }
    }

    public static class DummyServerPipelineFactory
    implements ChannelPipelineFactory {
        private final CommandsRegistry _cmdsRegistry;
        private final ByteOrder _byteOrder;

        public DummyServerPipelineFactory(CommandsRegistry cmdsRegistry, ByteOrder byteOrder) {
            this._cmdsRegistry = cmdsRegistry;
            this._byteOrder = byteOrder;
        }

        public ChannelPipeline getPipeline() throws Exception {
            ChannelPipeline pipeline = Channels.pipeline();
            ExtendedReadTimeoutHandler readTimeoutHandler = new ExtendedReadTimeoutHandler("server container 1", null, 500L, true);
            pipeline.addLast("read timeout", (ChannelHandler)readTimeoutHandler);
            pipeline.addLast("request decoder", (ChannelHandler)new SimpleBinaryDatabusRequestDecoder(this._cmdsRegistry, readTimeoutHandler, this._byteOrder));
            pipeline.addLast(DummyPipelineFactory.COMMAND_CAPTURE_NAME, (ChannelHandler)new SimpleObjectCaptureHandler());
            pipeline.addLast("request execute hander", (ChannelHandler)new SimpleObjectCaptureHandler());
            pipeline.addLast("response encoder", (ChannelHandler)new SimpleBinaryDatabusResponseEncoder());
            return pipeline;
        }
    }
}

