/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.cluster;

import com.linkedin.databus.cluster.DatabusClusterNotifier;
import org.apache.helix.NotificationContext;
import org.apache.helix.model.Message;
import org.apache.helix.participant.statemachine.StateModel;
import org.apache.helix.participant.statemachine.StateModelInfo;
import org.apache.helix.participant.statemachine.Transition;
import org.apache.log4j.Logger;

@StateModelInfo(initialState="OFFLINE", states={"ONLINE", "ERROR"})
public class DatabusClusterNotifierStateModel
extends StateModel {
    private static final Logger LOG = Logger.getLogger(DatabusClusterNotifierStateModel.class);
    private final DatabusClusterNotifier _notifier;
    private final String _partition;

    public DatabusClusterNotifierStateModel(String partition, DatabusClusterNotifier notifier) {
        this._notifier = notifier;
        String[] ps = partition.split("_");
        this._partition = ps.length >= 2 ? ps[ps.length - 1] : "-1";
    }

    @Transition(to="ONLINE", from="OFFLINE")
    public void onBecomeOnlineFromOffline(Message message, NotificationContext context) {
        LOG.debug((Object)("Gained partition " + this._partition));
        if (this._notifier != null) {
            this._notifier.onGainedPartitionOwnership(Integer.parseInt(this._partition));
        }
    }

    @Transition(to="OFFLINE", from="ONLINE")
    public void onBecomeOfflineFromOnline(Message message, NotificationContext context) {
        LOG.debug((Object)("Lost partition " + this._partition));
        if (this._notifier != null) {
            this._notifier.onLostPartitionOwnership(Integer.parseInt(this._partition));
        }
    }

    @Transition(to="DROPPED", from="OFFLINE")
    public void onBecomeDroppedFromOffline(Message message, NotificationContext context) {
        LOG.debug((Object)("Dropped partition " + this._partition));
        if (this._notifier != null) {
            this._notifier.onLostPartitionOwnership(Integer.parseInt(this._partition));
        }
    }

    @Transition(to="OFFLINE", from="ERROR")
    public void onBecomeOfflineFromError(Message message, NotificationContext context) {
        LOG.debug((Object)("Offline from error for partition " + this._partition));
        if (this._notifier != null) {
            this._notifier.onError(Integer.parseInt(this._partition));
        }
    }

    public void reset() {
        LOG.debug((Object)("Partition " + this._partition + " reset"));
        if (this._notifier != null) {
            this._notifier.onReset(Integer.parseInt(this._partition));
        }
    }
}

