/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.client.registration;

import com.linkedin.databus.client.registration.ClusterRegistrationStaticConfig;
import com.linkedin.databus.core.util.ConfigBuilder;
import com.linkedin.databus.core.util.InvalidConfigException;
import org.apache.log4j.Logger;

public class ClusterRegistrationConfig
implements ConfigBuilder<ClusterRegistrationStaticConfig> {
    private static final String DEFAULT_CLUSTER_NAME = "";
    private static final String DEFAULT_ZK_ADDR = "";
    private static final long DEFAULT_NUM_PARTITIONS = 1L;
    private static final long DEFAULT_QUORUM = 1L;
    private static final int DEFAULT_NUM_WRITES_SKIPPED = 0;
    private static final long DEFAULT_CHECKPOINT_INTERVAL_MS = 300000L;
    public static final long MIN_CHECKPOINT_INTERVAL_MS = 300000L;
    public static final int DEFAULT_CONNECTION_TIMEOUT_MSEC = 60000;
    public static final int DEFAULT_SESSION_TIMEOUT_MSEC = 30000;
    protected static final Logger LOG = Logger.getLogger(ClusterRegistrationConfig.class);
    private String _clusterName = "";
    private String _zkAddr = "";
    private long _numPartitions = 1L;
    private long _quorum = 1L;
    private int _maxCkptWritesSkipped = 0;
    private long _checkpointIntervalMs = 300000L;
    private int _zkSessionTimeoutMs = 30000;
    private int _zkConnectionTimeoutMs = 60000;

    public String getClusterName() {
        return this._clusterName;
    }

    public void setClusterName(String clusterName) {
        this._clusterName = clusterName;
    }

    public String getZkAddr() {
        return this._zkAddr;
    }

    public void setZkAddr(String zkAddr) {
        this._zkAddr = zkAddr;
    }

    public long getNumPartitions() {
        return this._numPartitions;
    }

    public void setNumPartitions(long numPartitions) {
        this._numPartitions = numPartitions;
    }

    public long getQuorum() {
        return this._quorum;
    }

    public void setQuorum(long quorum) {
        this._quorum = quorum;
    }

    public int getMaxCkptWritesSkipped() {
        return this._maxCkptWritesSkipped;
    }

    public void setMaxCkptWritesSkipped(int maxCkptWritesSkipped) {
        this._maxCkptWritesSkipped = maxCkptWritesSkipped;
    }

    public long getCheckpointIntervalMs() {
        return this._checkpointIntervalMs;
    }

    public void setCheckpointIntervalMs(long checkpointIntervalMs) {
        if (checkpointIntervalMs >= 300000L) {
            this._checkpointIntervalMs = checkpointIntervalMs;
        } else {
            LOG.warn((Object)"checkpointIntervalMs cannot be set to lower than300000. Setting to 300000");
            this._checkpointIntervalMs = 300000L;
        }
    }

    public String toString() {
        return "ClusterRegistrationConfig [clusterName=" + this._clusterName + ", zkAddr=" + this._zkAddr + ", numPartitions=" + this._numPartitions + ", quorum=" + this._quorum + ", maxCkptWritesSkipped=" + this._maxCkptWritesSkipped + ", checkpointIntervalMs=" + this._checkpointIntervalMs + "]";
    }

    public ClusterRegistrationStaticConfig build() throws InvalidConfigException {
        return new ClusterRegistrationStaticConfig(this._clusterName, this._zkAddr, this._numPartitions, this._quorum, this._maxCkptWritesSkipped, this._checkpointIntervalMs, this._zkSessionTimeoutMs, this._zkConnectionTimeoutMs);
    }

    public int getZkSessionTimeoutMs() {
        return this._zkSessionTimeoutMs;
    }

    public void setZkSessionTimeoutMs(int zkSessionTimeoutMs) {
        this._zkSessionTimeoutMs = zkSessionTimeoutMs;
    }

    public int getZkConnectionTimeoutMs() {
        return this._zkConnectionTimeoutMs;
    }

    public void setZkConnectionTimeoutMs(int zkConnectionTimeoutMs) {
        this._zkConnectionTimeoutMs = zkConnectionTimeoutMs;
    }
}

