/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.client.netty;

import com.linkedin.databus.core.Checkpoint;
import com.linkedin.databus.core.DbusEventBuffer;
import com.linkedin.databus.core.DbusEventV1Factory;
import com.linkedin.databus.core.OffsetNotFoundException;
import com.linkedin.databus.core.ScnNotFoundException;
import com.linkedin.databus.core.StreamEventsArgs;
import com.linkedin.databus.core.monitoring.mbean.DbusEventsStatisticsCollector;
import com.linkedin.databus2.core.container.request.RegisterResponseEntry;
import com.linkedin.databus2.test.container.SimpleObjectCaptureHandler;
import com.linkedin.databus2.test.container.SimpleTestServerConnection;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.SocketAddress;
import java.nio.ByteOrder;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import junit.framework.Assert;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBufferOutputStream;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.handler.codec.http.HttpChunk;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.codec.http.HttpResponse;

public class NettyTestUtils {
    public static void sendServerResponses(SimpleTestServerConnection srv, SocketAddress clientAddr, HttpResponse sourcesResp, HttpChunk body, long timeout) {
        srv.sendServerResponse(clientAddr, (Object)sourcesResp, timeout);
        srv.sendServerResponse(clientAddr, (Object)body, timeout);
        srv.sendServerResponse(clientAddr, (Object)HttpChunk.LAST_CHUNK, timeout);
    }

    public static void sendServerResponses(SimpleTestServerConnection srv, SocketAddress clientAddr, HttpResponse sourcesResp, HttpChunk body) {
        NettyTestUtils.sendServerResponses(srv, clientAddr, sourcesResp, body, 1000L);
    }

    public static String generateRegisterResponse(RegisterResponseEntry ... entries) throws JsonGenerationException, JsonMappingException, IOException {
        ObjectMapper mapper = new ObjectMapper();
        StringWriter w = new StringWriter();
        mapper.writeValue((Writer)w, (Object)entries);
        w.close();
        return w.toString();
    }

    public static String generateRegisterResponseV4(HashMap<String, List<Object>> entries) throws JsonGenerationException, JsonMappingException, IOException {
        ObjectMapper mapper = new ObjectMapper();
        StringWriter w = new StringWriter();
        mapper.writeValue((Writer)w, entries);
        w.close();
        return w.toString();
    }

    public static ChannelBuffer streamToChannelBuffer(DbusEventBuffer buf, Checkpoint cp, int maxSize, DbusEventsStatisticsCollector stats) throws ScnNotFoundException, OffsetNotFoundException, IOException {
        ChannelBuffer tmpBuf = ChannelBuffers.buffer((ByteOrder)new DbusEventV1Factory().getByteOrder(), (int)maxSize);
        ChannelBufferOutputStream tmpOS = new ChannelBufferOutputStream(tmpBuf);
        WritableByteChannel tmpChannel = Channels.newChannel((OutputStream)tmpOS);
        StreamEventsArgs args = new StreamEventsArgs(maxSize).setStatsCollector(stats);
        buf.streamEvents(cp, tmpChannel, args);
        tmpChannel.close();
        return tmpBuf;
    }

    public static Matcher waitForHttpRequest(SimpleObjectCaptureHandler objCapture, String regex, long timeout) {
        Pattern pattern = Pattern.compile(regex);
        Assert.assertTrue((boolean)objCapture.waitForMessage(timeout, 0));
        Object msgObj = objCapture.getMessages().get(0);
        Assert.assertTrue((boolean)(msgObj instanceof HttpRequest));
        HttpRequest msgReq = (HttpRequest)msgObj;
        Matcher result = pattern.matcher(msgReq.getUri());
        Assert.assertTrue((boolean)result.matches());
        return result;
    }
}

