/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.client.request;

import com.linkedin.databus.client.DatabusHttpClientImpl;
import com.linkedin.databus.client.pub.DatabusRegistration;
import com.linkedin.databus.client.pub.DatabusV3Registration;
import com.linkedin.databus.client.pub.DbusPartitionInfo;
import com.linkedin.databus.client.pub.RegistrationId;
import com.linkedin.databus.client.pub.mbean.UnifiedClientStats;
import com.linkedin.databus.client.registration.DatabusMultiPartitionRegistration;
import com.linkedin.databus.core.monitoring.mbean.DatabusMonitoringMBean;
import com.linkedin.databus.core.monitoring.mbean.DbusEventsStatisticsCollector;
import com.linkedin.databus.core.monitoring.mbean.DbusEventsTotalStats;
import com.linkedin.databus.core.monitoring.mbean.StatsCollectors;
import com.linkedin.databus2.core.container.monitoring.mbean.DbusHttpTotalStats;
import com.linkedin.databus2.core.container.request.AbstractStatsRequestProcessor;
import com.linkedin.databus2.core.container.request.DatabusRequest;
import com.linkedin.databus2.core.container.request.InvalidRequestParamValueException;
import com.linkedin.databus2.core.container.request.RequestProcessingException;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.apache.log4j.Logger;
import org.jboss.netty.handler.codec.http.HttpMethod;

public class ClientStatsRequestProcessor
extends AbstractStatsRequestProcessor {
    public static final String MODULE = ClientStatsRequestProcessor.class.getName();
    public static final Logger LOG = Logger.getLogger((String)MODULE);
    public static final String COMMAND_NAME = "clientStats";
    private static final String OUTBOUND_EVENTS_TOTAL_KEY = "outbound/events/total";
    private static final String OUTBOUND_EVENTS_SOURCES_KEY = "outbound/events/sources";
    private static final String OUTBOUND_EVENTS_SOURCE_PREFIX = "outbound/events/source/";
    private static final String OUTBOUND_EVENTS_CLIENTS_KEY = "outbound/events/clients";
    private static final String OUTBOUND_EVENTS_CLIENT_PREFIX = "outbound/events/client/";
    private static final String INBOUND_HTTP_TOTAL_KEY = "inbound/http/total";
    private static final String INBOUND_HTTP_SOURCES_KEY = "inbound/http/sources";
    private static final String INBOUND_HTTP_SOURCE_PREFIX = "inbound/http/source/";
    private static final String INBOUND_HTTP_RELAYS_KEY = "inbound/http/relays";
    private static final String INBOUND_HTTP_RELAYS_PREFIX = "inbound/http/relay/";
    private static final String INBOUND_EVENTS_TOTAL_KEY = "inbound/events/total";
    private static final String BOOTSTRAP_EVENTS_TOTAL_KEY = "bootstrap/events/total";
    private static final String INBOUND_EVENTS_SOURCES_KEY = "inbound/events/sources";
    private static final String INBOUND_EVENTS_REG_KEY_PREFIX = "inbound/events/registration/";
    private static final String BOOTSTRAP_EVENTS_REG_KEY_PREFIX = "bootstrap/events/registration/";
    private static final String INBOUND_CALLBACKS_REG_KEY_PREFIX = "inbound/callbacks/registration/";
    private static final String BOOTSTRAP_CALLBACKS_REG_KEY_PREFIX = "bootstrap/callbacks/registration/";
    private static final String UNIFIED_REG_KEY_PREFIX = "unified/registration/";
    private static final String UNIFIED_TOTAL_KEY = "unified/total";
    private final DatabusHttpClientImpl _client;

    public ClientStatsRequestProcessor(ExecutorService executorService, DatabusHttpClientImpl client) {
        super(COMMAND_NAME, executorService);
        this._client = client;
    }

    public boolean doProcess(String category, DatabusRequest request) throws IOException, RequestProcessingException {
        boolean success = true;
        if (category.equals(OUTBOUND_EVENTS_TOTAL_KEY)) {
            this.processEventsTotalStats(this._client.getOutboundEventStatisticsCollector(), request);
        } else if (category.equals(OUTBOUND_EVENTS_SOURCES_KEY)) {
            this.processEventsSourcesList(this._client.getOutboundEventStatisticsCollector(), request);
        } else if (category.startsWith(OUTBOUND_EVENTS_SOURCE_PREFIX)) {
            this.processEventsSourceStats(this._client.getOutboundEventStatisticsCollector(), OUTBOUND_EVENTS_SOURCE_PREFIX, request);
        } else if (category.equals(OUTBOUND_EVENTS_CLIENTS_KEY)) {
            this.processEventsPeersList(this._client.getOutboundEventStatisticsCollector(), request);
        } else if (category.startsWith(OUTBOUND_EVENTS_CLIENT_PREFIX)) {
            this.processEventsPeerStats(this._client.getOutboundEventStatisticsCollector(), OUTBOUND_EVENTS_CLIENT_PREFIX, request);
        } else if (category.equals(INBOUND_HTTP_TOTAL_KEY)) {
            this.processOutboundHttpTotalStats(request);
        } else if (category.equals(INBOUND_HTTP_SOURCES_KEY)) {
            this.processOutboundHttpSourcesList(request);
        } else if (category.startsWith(INBOUND_HTTP_SOURCE_PREFIX)) {
            this.processOutboundHttpSourceStats(request);
        } else if (category.equals(INBOUND_HTTP_RELAYS_KEY)) {
            this.processOutboundHttpClientsList(request);
        } else if (category.startsWith(INBOUND_HTTP_RELAYS_PREFIX)) {
            this.processOutboundHttpClientStats(request);
        } else if (category.equals(INBOUND_EVENTS_TOTAL_KEY)) {
            this.processEventsTotalStats(this._client.getInboundEventStatisticsCollector(), request);
        } else if (category.equals(BOOTSTRAP_EVENTS_TOTAL_KEY)) {
            this.processEventsTotalStats(this._client.getBootstrapEventsStatsCollector(), request);
        } else if (category.equals(INBOUND_EVENTS_SOURCES_KEY)) {
            this.processEventsSourcesList(this._client.getInboundEventStatisticsCollector(), request);
        } else if (category.startsWith(INBOUND_EVENTS_REG_KEY_PREFIX)) {
            if (((Object)((Object)this._client)).getClass().getSimpleName().equalsIgnoreCase("DatabusHttpClientImpl")) {
                this.processInboundEventsRegistration(request);
            } else {
                this.processInboundEventsRegistrationV3(request);
            }
        } else if (category.startsWith(BOOTSTRAP_EVENTS_REG_KEY_PREFIX)) {
            if (((Object)((Object)this._client)).getClass().getSimpleName().equalsIgnoreCase("DatabusHttpClientImpl")) {
                this.processBootstrapEventsRegistration(request);
            } else {
                this.processBootstrapEventsRegistrationV3(request);
            }
        } else if (category.startsWith(INBOUND_CALLBACKS_REG_KEY_PREFIX)) {
            if (((Object)((Object)this._client)).getClass().getSimpleName().equalsIgnoreCase("DatabusHttpClientImpl")) {
                this.processInboundCallbacksRegistration(request);
            } else {
                this.processInboundCallbacksRegistrationV3(request);
            }
        } else if (category.startsWith(BOOTSTRAP_CALLBACKS_REG_KEY_PREFIX)) {
            if (((Object)((Object)this._client)).getClass().getSimpleName().equalsIgnoreCase("DatabusHttpClientImpl")) {
                this.processBootstrapCallbacksRegistration(request);
            } else {
                this.processBootstrapCallbacksRegistrationV3(request);
            }
        } else if (category.startsWith(UNIFIED_REG_KEY_PREFIX)) {
            if (((Object)((Object)this._client)).getClass().getSimpleName().equalsIgnoreCase("DatabusHttpClientImpl")) {
                this.processUnifiedRegistration(request);
            } else {
                this.processUnifiedRegistrationV3(request);
            }
        } else if (category.equals(UNIFIED_TOTAL_KEY)) {
            this.processUnifiedTotalStats(this._client.getUnifiedClientStatsCollectors(), request);
        } else {
            success = false;
        }
        return success;
    }

    private void processUnifiedTotalStats(StatsCollectors<UnifiedClientStats> statsCollectors, DatabusRequest request) throws IOException {
        if (null == statsCollectors) {
            return;
        }
        UnifiedClientStats unifiedTotalStats = (UnifiedClientStats)statsCollectors.getStatsCollector();
        if (null == unifiedTotalStats) {
            return;
        }
        this.writeJsonObjectToResponse(unifiedTotalStats, request);
        if (request.getRequestType() == HttpMethod.PUT || request.getRequestType() == HttpMethod.POST) {
            this.enableOrResetStatsMBean((DatabusMonitoringMBean)unifiedTotalStats, request);
        }
    }

    private void processEventsTotalStats(DbusEventsStatisticsCollector statsCollector, DatabusRequest request) throws IOException {
        if (null == statsCollector) {
            return;
        }
        DbusEventsTotalStats totalStatsMBean = statsCollector.getTotalStats();
        if (null == totalStatsMBean) {
            return;
        }
        this.writeJsonObjectToResponse(totalStatsMBean, request);
        if (request.getRequestType() == HttpMethod.PUT || request.getRequestType() == HttpMethod.POST) {
            this.enableOrResetStatsMBean((DatabusMonitoringMBean)totalStatsMBean, request);
        }
    }

    private void processEventsSourcesList(DbusEventsStatisticsCollector statsCollector, DatabusRequest request) throws IOException {
        if (null == statsCollector) {
            return;
        }
        List sourcesList = statsCollector.getSources();
        this.writeJsonObjectToResponse(sourcesList, request);
    }

    private void processEventsSourceStats(DbusEventsStatisticsCollector statsCollector, String prefix, DatabusRequest request) throws IOException, RequestProcessingException {
        if (null == statsCollector) {
            return;
        }
        String category = request.getParams().getProperty("reqpath");
        String sourceIdStr = category.substring(prefix.length());
        int sourceId = -1;
        try {
            sourceId = Integer.valueOf(sourceIdStr);
        }
        catch (NumberFormatException nfe) {
            throw new InvalidRequestParamValueException(request.getName(), prefix, sourceIdStr);
        }
        DbusEventsTotalStats sourceStats = statsCollector.getSourceStats(sourceId);
        if (null == sourceStats) {
            throw new InvalidRequestParamValueException(request.getName(), prefix, sourceIdStr);
        }
        this.writeJsonObjectToResponse(sourceStats, request);
        if (request.getRequestType() == HttpMethod.PUT || request.getRequestType() == HttpMethod.POST) {
            this.enableOrResetStatsMBean((DatabusMonitoringMBean)sourceStats, request);
        }
    }

    private void processEventsPeersList(DbusEventsStatisticsCollector statsCollector, DatabusRequest request) throws IOException {
        if (null == statsCollector) {
            return;
        }
        List clientsList = statsCollector.getPeers();
        this.writeJsonObjectToResponse(clientsList, request);
    }

    private void processEventsPeerStats(DbusEventsStatisticsCollector statsCollector, String prefix, DatabusRequest request) throws IOException, RequestProcessingException {
        if (null == statsCollector) {
            return;
        }
        String category = request.getParams().getProperty("reqpath");
        String client = category.substring(prefix.length());
        DbusEventsTotalStats clientStats = statsCollector.getPeerStats(client);
        if (null == clientStats) {
            throw new InvalidRequestParamValueException(request.getName(), prefix, client);
        }
        this.writeJsonObjectToResponse(clientStats, request);
        if (request.getRequestType() == HttpMethod.PUT || request.getRequestType() == HttpMethod.POST) {
            this.enableOrResetStatsMBean((DatabusMonitoringMBean)clientStats, request);
        }
    }

    private void processOutboundHttpTotalStats(DatabusRequest request) throws IOException {
        DbusHttpTotalStats totalStats = this._client.getHttpStatsCollector().getTotalStats();
        if (null == totalStats) {
            return;
        }
        this.writeJsonObjectToResponse(totalStats, request);
        if (request.getRequestType() == HttpMethod.PUT || request.getRequestType() == HttpMethod.POST) {
            this.enableOrResetStatsMBean((DatabusMonitoringMBean)totalStats, request);
        }
    }

    private void processOutboundHttpSourcesList(DatabusRequest request) throws IOException {
        List sourcesList = this._client.getHttpStatsCollector().getSources();
        this.writeJsonObjectToResponse(sourcesList, request);
    }

    private void processOutboundHttpClientsList(DatabusRequest request) throws IOException {
        List clientsList = this._client.getHttpStatsCollector().getPeers();
        this.writeJsonObjectToResponse(clientsList, request);
    }

    private void processOutboundHttpSourceStats(DatabusRequest request) throws IOException, RequestProcessingException {
        String category = request.getParams().getProperty("reqpath");
        String sourceIdStr = category.substring(INBOUND_HTTP_SOURCE_PREFIX.length());
        int sourceId = -1;
        try {
            sourceId = Integer.valueOf(sourceIdStr);
        }
        catch (NumberFormatException nfe) {
            throw new InvalidRequestParamValueException(request.getName(), INBOUND_HTTP_SOURCE_PREFIX, sourceIdStr);
        }
        DbusHttpTotalStats sourceStats = this._client.getHttpStatsCollector().getSourceStats(sourceId);
        if (null == sourceStats) {
            throw new InvalidRequestParamValueException(request.getName(), INBOUND_HTTP_SOURCE_PREFIX, sourceIdStr);
        }
        this.writeJsonObjectToResponse(sourceStats, request);
        if (request.getRequestType() == HttpMethod.PUT || request.getRequestType() == HttpMethod.POST) {
            this.enableOrResetStatsMBean((DatabusMonitoringMBean)sourceStats, request);
        }
    }

    private void processOutboundHttpClientStats(DatabusRequest request) throws IOException, RequestProcessingException {
        String category = request.getParams().getProperty("reqpath");
        String client = category.substring(INBOUND_HTTP_RELAYS_PREFIX.length());
        DbusHttpTotalStats clientStats = this._client.getHttpStatsCollector().getPeerStats(client);
        if (null == clientStats) {
            throw new InvalidRequestParamValueException(request.getName(), INBOUND_HTTP_RELAYS_PREFIX, client);
        }
        this.writeJsonObjectToResponse(clientStats, request);
        if (request.getRequestType() == HttpMethod.PUT || request.getRequestType() == HttpMethod.POST) {
            this.enableOrResetStatsMBean((DatabusMonitoringMBean)clientStats, request);
        }
    }

    private void processInboundEventsRegistration(DatabusRequest request) throws IOException, RequestProcessingException {
        DatabusRegistration reg = this.findRegistration(request, INBOUND_EVENTS_REG_KEY_PREFIX);
        this.writeJsonObjectToResponse(reg.getRelayEventStats().getTotalStats(), request);
    }

    private void processBootstrapEventsRegistration(DatabusRequest request) throws IOException, RequestProcessingException {
        DatabusRegistration reg = this.findRegistration(request, BOOTSTRAP_EVENTS_REG_KEY_PREFIX);
        this.writeJsonObjectToResponse(reg.getBootstrapEventStats().getTotalStats(), request);
    }

    private void processInboundCallbacksRegistration(DatabusRequest request) throws IOException, RequestProcessingException {
        DatabusRegistration reg = this.findRegistration(request, INBOUND_CALLBACKS_REG_KEY_PREFIX);
        this.writeJsonObjectToResponse(reg.getRelayCallbackStats(), request);
    }

    private void processBootstrapCallbacksRegistration(DatabusRequest request) throws IOException, RequestProcessingException {
        DatabusRegistration reg = this.findRegistration(request, BOOTSTRAP_CALLBACKS_REG_KEY_PREFIX);
        this.writeJsonObjectToResponse(reg.getBootstrapCallbackStats(), request);
    }

    private void processUnifiedRegistration(DatabusRequest request) throws IOException, RequestProcessingException {
        DatabusRegistration reg = this.findRegistration(request, UNIFIED_REG_KEY_PREFIX);
        this.writeJsonObjectToResponse(reg.getUnifiedClientStats(), request);
    }

    private DatabusRegistration findRegistration(DatabusRequest request, String prefix) throws RequestProcessingException {
        String category = request.getParams().getProperty("reqpath");
        String registrationIdStr = category.substring(prefix.length());
        RegistrationId regId = new RegistrationId(registrationIdStr);
        Collection<DatabusRegistration> regs = this._client.getAllRegistrations();
        for (DatabusRegistration r : regs) {
            if (regId.equals((Object)r.getRegistrationId())) {
                return r;
            }
            if (!(r instanceof DatabusMultiPartitionRegistration)) continue;
            Map<DbusPartitionInfo, DatabusRegistration> childRegs = ((DatabusMultiPartitionRegistration)r).getPartitionRegs();
            for (Map.Entry<DbusPartitionInfo, DatabusRegistration> e : childRegs.entrySet()) {
                if (!regId.equals((Object)e.getValue().getRegistrationId())) continue;
                return e.getValue();
            }
        }
        throw new RequestProcessingException("Unable to find registration (" + regId + ") ");
    }

    private void processInboundEventsRegistrationV3(DatabusRequest request) throws IOException, RequestProcessingException {
        DatabusV3Registration reg = this.findV3Registration(request, INBOUND_EVENTS_REG_KEY_PREFIX);
        this.writeJsonObjectToResponse(reg.getRelayEventStats().getTotalStats(), request);
    }

    private void processBootstrapEventsRegistrationV3(DatabusRequest request) throws IOException, RequestProcessingException {
        DatabusV3Registration reg = this.findV3Registration(request, BOOTSTRAP_EVENTS_REG_KEY_PREFIX);
        this.writeJsonObjectToResponse(reg.getBootstrapEventStats().getTotalStats(), request);
    }

    private void processInboundCallbacksRegistrationV3(DatabusRequest request) throws IOException, RequestProcessingException {
        DatabusV3Registration reg = this.findV3Registration(request, INBOUND_CALLBACKS_REG_KEY_PREFIX);
        this.writeJsonObjectToResponse(reg.getRelayCallbackStats(), request);
    }

    private void processBootstrapCallbacksRegistrationV3(DatabusRequest request) throws IOException, RequestProcessingException {
        DatabusV3Registration reg = this.findV3Registration(request, BOOTSTRAP_CALLBACKS_REG_KEY_PREFIX);
        this.writeJsonObjectToResponse(reg.getBootstrapCallbackStats(), request);
    }

    private void processUnifiedRegistrationV3(DatabusRequest request) throws IOException, RequestProcessingException {
        DatabusV3Registration reg = this.findV3Registration(request, UNIFIED_REG_KEY_PREFIX);
        this.writeJsonObjectToResponse(reg.getUnifiedClientStats(), request);
    }

    private DatabusV3Registration findV3Registration(DatabusRequest request, String prefix) throws InvalidRequestParamValueException {
        String category = request.getParams().getProperty("reqpath");
        String registrationIdStr = category.substring(prefix.length());
        DatabusV3Registration reg = this._client.getRegistration(new RegistrationId(registrationIdStr));
        if (null == reg) {
            LOG.warn((Object)("Invalid registrationId: " + registrationIdStr));
            throw new InvalidRequestParamValueException(request.getName(), prefix, "No data available for this RegistrationId yet");
        }
        return reg;
    }
}

