/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.client.request;

import com.linkedin.databus.client.DatabusHttpClientImpl;
import com.linkedin.databus.client.DatabusSourcesConnection;
import com.linkedin.databus.client.DbusPartitionInfoImpl;
import com.linkedin.databus.client.monitoring.RegistrationStatsInfo;
import com.linkedin.databus.client.pub.DatabusRegistration;
import com.linkedin.databus.client.pub.DatabusV3MultiPartitionRegistration;
import com.linkedin.databus.client.pub.DatabusV3Registration;
import com.linkedin.databus.client.pub.DbusClusterInfo;
import com.linkedin.databus.client.pub.DbusPartitionInfo;
import com.linkedin.databus.client.pub.RegistrationId;
import com.linkedin.databus.client.pub.RegistrationState;
import com.linkedin.databus.client.registration.DatabusMultiPartitionRegistration;
import com.linkedin.databus.client.registration.DatabusV2ClusterRegistrationImpl;
import com.linkedin.databus.core.DatabusComponentStatus;
import com.linkedin.databus.core.data_model.DatabusSubscription;
import com.linkedin.databus.core.data_model.PhysicalPartition;
import com.linkedin.databus2.core.container.request.AbstractStatsRequestProcessor;
import com.linkedin.databus2.core.container.request.DatabusRequest;
import com.linkedin.databus2.core.container.request.InvalidRequestParamValueException;
import com.linkedin.databus2.core.container.request.RequestProcessingException;
import com.linkedin.databus2.core.filter.DbusKeyCompositeFilterConfig;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ExecutorService;
import org.apache.log4j.Logger;

public class ClientStateRequestProcessor
extends AbstractStatsRequestProcessor {
    public static final String MODULE = ClientStateRequestProcessor.class.getName();
    public static final Logger LOG = Logger.getLogger((String)MODULE);
    public static final String COMMAND_NAME = "clientState";
    private final DatabusHttpClientImpl _client;
    private static final String REGISTRATIONS_KEY = "registrations";
    private static final String REGISTRATION_KEY_PREFIX = "registration/";
    private static final String CLIENT_CLUSTERS_KEY = "clientClusters";
    private static final String CLIENT_CLUSTER_KEY = "clientPartitions/";
    private static final String CLIENT_CLUSTER_PARTITION_REG_KEY = "clientPartition/";
    private static final String MP_REGISTRATIONS_KEY = "mpRegistrations";
    private static final String PAUSE_ALL_REGISTRATIONS = "registrations/pause";
    private static final String PAUSE_REGISTRATION = "registration/pause";
    private static final String RESUME_ALL_REGISTRATIONS = "registrations/resume";
    private static final String RESUME_REGISTRATION = "registration/resume";

    public ClientStateRequestProcessor(ExecutorService executorService, DatabusHttpClientImpl client) {
        super(COMMAND_NAME, executorService);
        this._client = client;
    }

    protected boolean doProcess(String category, DatabusRequest request) throws IOException, RequestProcessingException {
        boolean success = true;
        if (category.equals(REGISTRATIONS_KEY)) {
            this.processRegistrations(request);
        } else if (category.startsWith(PAUSE_REGISTRATION)) {
            this.pauseResumeRegistration(request, true);
        } else if (category.startsWith(RESUME_REGISTRATION)) {
            this.pauseResumeRegistration(request, false);
        } else if (category.startsWith(REGISTRATION_KEY_PREFIX)) {
            this.processRegistrationInfo(request);
        } else if (category.startsWith(CLIENT_CLUSTERS_KEY)) {
            this.processClusters(request);
        } else if (category.startsWith(CLIENT_CLUSTER_KEY)) {
            this.processCluster(request);
        } else if (category.startsWith(CLIENT_CLUSTER_PARTITION_REG_KEY)) {
            this.processPartition(request);
        } else if (category.equals(MP_REGISTRATIONS_KEY)) {
            this.processMPRegistrations(request);
        } else if (category.equals(PAUSE_ALL_REGISTRATIONS)) {
            this.pauseAllRegistrations(request);
        } else if (category.equals(RESUME_ALL_REGISTRATIONS)) {
            this.resumeAllRegistrations(request);
        } else {
            success = false;
        }
        return success;
    }

    private void processMPRegistrations(DatabusRequest request) throws IOException, RequestProcessingException {
        Map<RegistrationId, DatabusV3Registration> registrationIdMap = this._client.getRegistrationIdMap();
        if (null == registrationIdMap) {
            throw new InvalidRequestParamValueException(request.getName(), REGISTRATIONS_KEY, "Present only for Databus V3 clients");
        }
        TreeMap ridList = new TreeMap();
        for (Map.Entry<RegistrationId, DatabusV3Registration> entry : registrationIdMap.entrySet()) {
            DatabusV3Registration reg = entry.getValue();
            if (!(reg instanceof DatabusV3MultiPartitionRegistration)) continue;
            Collection dvrList = ((DatabusV3MultiPartitionRegistration)reg).getPartionRegs().values();
            ArrayList<String> mpRegList = new ArrayList<String>();
            for (DatabusV3Registration dvr : dvrList) {
                mpRegList.add(dvr.getRegistrationId().getId());
            }
            ridList.put(entry.getKey().getId(), mpRegList);
        }
        this.writeJsonObjectToResponse(ridList, request);
    }

    private void processRegistrationInfo(DatabusRequest request) throws IOException, RequestProcessingException {
        boolean found = true;
        RegistrationStatsInfo regStatsInfo = null;
        try {
            DatabusRegistration r = this.findV2Registration(request, REGISTRATION_KEY_PREFIX);
            this.writeJsonObjectToResponse(r, request);
        }
        catch (RequestProcessingException ex) {
            found = false;
        }
        if (!found) {
            DatabusV3Registration reg = this.findV3Registration(request, REGISTRATION_KEY_PREFIX);
            DatabusSourcesConnection sourcesConn = this._client.getDatabusSourcesConnection(reg.getRegistrationId().getId());
            regStatsInfo = new RegistrationStatsInfo(reg, sourcesConn);
            this.writeJsonObjectToResponse(regStatsInfo, request);
        }
    }

    private void processRegistrations(DatabusRequest request) throws IOException {
        Map<RegistrationId, DatabusV3Registration> registrationIdMap;
        TreeMap<String, Collection<DatabusSubscription>> regIds = new TreeMap<String, Collection<DatabusSubscription>>();
        Collection<RegInfo> regs = this.getAllTopLevelV2Registrations();
        if (null != regs) {
            for (RegInfo r : regs) {
                regIds.put(r.getRegId().getId(), r.getSubs());
            }
        }
        if (null != (registrationIdMap = this._client.getRegistrationIdMap())) {
            for (Map.Entry<RegistrationId, DatabusV3Registration> entry : registrationIdMap.entrySet()) {
                DatabusV3Registration reg = entry.getValue();
                List dsl = reg.getSubscriptions();
                regIds.put(entry.getKey().getId(), dsl);
            }
        }
        this.writeJsonObjectToResponse(regIds, request);
    }

    private void processClusters(DatabusRequest request) throws IOException {
        Map<RegistrationId, DbusClusterInfo> clusters = this._client.getAllClientClusters();
        this.writeJsonObjectToResponse(clusters.values(), request);
    }

    private void processCluster(DatabusRequest request) throws IOException, RequestProcessingException {
        String category = request.getParams().getProperty("reqpath");
        String clusterName = category.substring(CLIENT_CLUSTER_KEY.length());
        ArrayList<PartitionInfo> clusters = new ArrayList<PartitionInfo>();
        RequestProcessingException rEx = null;
        Collection<PartitionInfo> v2Clusters = null;
        boolean found = true;
        try {
            v2Clusters = this.getV2ClusterPartitions(clusterName);
            clusters.addAll(v2Clusters);
        }
        catch (RequestProcessingException ex) {
            found = false;
            rEx = ex;
        }
        if (!found) {
            Collection<PartitionInfo> v3Clusters = null;
            try {
                v3Clusters = this.getV3ClusterPartitions(clusterName);
                clusters.addAll(v3Clusters);
                found = true;
            }
            catch (RequestProcessingException ex) {
                found = false;
                rEx = ex;
            }
        }
        if (!found) {
            throw rEx;
        }
        this.writeJsonObjectToResponse(clusters, request);
    }

    private void processPartition(DatabusRequest request) throws IOException, RequestProcessingException {
        String category = request.getParams().getProperty("reqpath");
        String clusterPartitionName = category.substring(CLIENT_CLUSTER_PARTITION_REG_KEY.length());
        String[] toks = clusterPartitionName.split("[:/]");
        if (toks.length != 2) {
            throw new RequestProcessingException("Cluster and partition info are expected to be in pattern = <cluster>[/:]<partition> but was " + clusterPartitionName);
        }
        RegInfo reg = null;
        boolean found = true;
        try {
            reg = this.getV2PartitionRegistration(toks[0], new Long(toks[1]));
        }
        catch (RequestProcessingException ex) {
            found = false;
        }
        if (!found) {
            reg = this.getV3PartitionRegistration(toks[0], new Long(toks[1]));
        }
        this.writeJsonObjectToResponse(reg, request);
    }

    private DatabusV2ClusterRegistrationImpl getV2ClusterRegistration(String clusterName) throws RequestProcessingException {
        Collection<DatabusMultiPartitionRegistration> regs = this._client.getAllClientClusterRegistrations();
        for (DatabusMultiPartitionRegistration reg : regs) {
            DatabusV2ClusterRegistrationImpl r;
            if (!(reg instanceof DatabusV2ClusterRegistrationImpl) || !clusterName.equals((r = (DatabusV2ClusterRegistrationImpl)reg).getClusterInfo().getName())) continue;
            return r;
        }
        throw new RequestProcessingException("No Registration found for cluster (" + clusterName + ") !!");
    }

    private DatabusV3MultiPartitionRegistration getV3ClusterRegistration(String clusterName) throws RequestProcessingException {
        Map<RegistrationId, DbusClusterInfo> clusterMap = this._client.getAllClientClusters();
        for (Map.Entry<RegistrationId, DbusClusterInfo> e : clusterMap.entrySet()) {
            if (!clusterName.equalsIgnoreCase(e.getValue().getName())) continue;
            DatabusV3Registration reg = this._client.getRegistration(e.getKey());
            if (!(reg instanceof DatabusV3MultiPartitionRegistration)) break;
            return (DatabusV3MultiPartitionRegistration)reg;
        }
        throw new RequestProcessingException("No Registration found for cluster (" + clusterName + ") !!");
    }

    private void pauseResumeRegistration(DatabusRequest request, boolean doPause) throws IOException, RequestProcessingException {
        DatabusRegistration r = null;
        DatabusV3Registration r2 = null;
        boolean found = true;
        boolean isRunning = false;
        boolean isPaused = false;
        boolean isSuspended = false;
        RegistrationId regId = null;
        RequestProcessingException rEx = null;
        RegStatePair regStatePair = null;
        try {
            r = this.findV2Registration(request, PAUSE_REGISTRATION);
            isRunning = r.getState().isRunning();
            isPaused = r.getState() == DatabusRegistration.RegistrationState.PAUSED;
            isSuspended = r.getState() == DatabusRegistration.RegistrationState.SUSPENDED_ON_ERROR;
            regId = r.getRegistrationId();
        }
        catch (RequestProcessingException ex) {
            found = false;
            rEx = ex;
        }
        if (!found) {
            try {
                r2 = this.findV3Registration(request, PAUSE_REGISTRATION);
                found = true;
                isRunning = r2.getState().isRunning();
                isPaused = r2.getState() == RegistrationState.PAUSED;
                isSuspended = r2.getState() == RegistrationState.SUSPENDED_ON_ERROR;
                regId = r.getRegistrationId();
            }
            catch (RequestProcessingException ex) {
                found = false;
                rEx = ex;
            }
        }
        if (!found) {
            throw rEx;
        }
        LOG.info((Object)("REST call to pause registration : " + regId));
        if (isRunning) {
            if (doPause) {
                if (!isPaused) {
                    if (null != r) {
                        r.pause();
                        regStatePair = new RegStatePair(r.getState(), r.getRegistrationId());
                    } else {
                        r2.pause();
                        regStatePair = new RegStatePair(r2.getState().name(), r2.getRegistrationId());
                    }
                }
            } else if (isPaused || isSuspended) {
                if (null != r) {
                    r.resume();
                    regStatePair = new RegStatePair(r.getState(), r.getRegistrationId());
                } else {
                    r2.resume();
                    regStatePair = new RegStatePair(r2.getState().name(), r2.getRegistrationId());
                }
            }
        }
        this.writeJsonObjectToResponse(regStatePair, request);
    }

    private void pauseAllRegistrations(DatabusRequest request) throws IOException {
        LOG.info((Object)"REST call to pause all registrations");
        Collection<DatabusRegistration> regs = this._client.getAllRegistrations();
        if (null != regs) {
            for (DatabusRegistration r : regs) {
                if (!r.getState().isRunning() || r.getState() == DatabusRegistration.RegistrationState.PAUSED) continue;
                r.pause();
            }
        }
        Map<RegistrationId, DatabusV3Registration> regMap = this._client.getRegistrationIdMap();
        Collection<RegInfo> topLevelRegs = this.getAllTopLevelV3Registrations();
        if (null != regMap && null != topLevelRegs) {
            for (RegInfo reg : topLevelRegs) {
                DatabusV3Registration r = regMap.get(reg.getRegId());
                if (!r.getState().isRunning() || r.getState() == RegistrationState.PAUSED) continue;
                r.pause();
            }
        }
        this.writeJsonObjectToResponse(this.getAllTopLevelRegStates(), request);
    }

    private void resumeAllRegistrations(DatabusRequest request) throws IOException {
        LOG.info((Object)"REST call to resume all registrations");
        Collection<DatabusRegistration> regs = this._client.getAllRegistrations();
        if (null != regs) {
            for (DatabusRegistration r : regs) {
                if (!r.getState().isRunning() || r.getState() != DatabusRegistration.RegistrationState.PAUSED && r.getState() != DatabusRegistration.RegistrationState.SUSPENDED_ON_ERROR) continue;
                r.resume();
            }
        }
        Map<RegistrationId, DatabusV3Registration> regMap = this._client.getRegistrationIdMap();
        Collection<RegInfo> topLevelRegs = this.getAllTopLevelV3Registrations();
        if (null != regMap && null != topLevelRegs) {
            for (RegInfo reg : topLevelRegs) {
                DatabusV3Registration r = regMap.get(reg.getRegId());
                if (!r.getState().isRunning() || r.getState() != RegistrationState.PAUSED && r.getState() != RegistrationState.SUSPENDED_ON_ERROR) continue;
                r.resume();
            }
        }
        this.writeJsonObjectToResponse(this.getAllTopLevelRegStates(), request);
    }

    private Collection<RegStatePair> getAllTopLevelRegStates() {
        ArrayList<RegStatePair> regList = new ArrayList<RegStatePair>();
        Collection<RegInfo> regs = this.getAllTopLevelRegistrations();
        for (RegInfo reg : regs) {
            regList.add(new RegStatePair(reg.getState(), reg.getRegId()));
        }
        return regList;
    }

    private Collection<RegInfo> getAllTopLevelRegistrations() {
        ArrayList<RegInfo> regList = new ArrayList<RegInfo>();
        regList.addAll(this.getAllTopLevelV2Registrations());
        regList.addAll(this.getAllTopLevelV3Registrations());
        return regList;
    }

    private Collection<RegInfo> getAllTopLevelV3Registrations() {
        HashMap<RegistrationId, RegInfo> regListMap = new HashMap<RegistrationId, RegInfo>();
        Map<RegistrationId, DatabusV3Registration> regMap = this._client.getRegistrationIdMap();
        for (Map.Entry<RegistrationId, DatabusV3Registration> e : regMap.entrySet()) {
            RegInfo regInfo = null;
            DatabusV3Registration r = e.getValue();
            if (null != r.getParentRegistration()) continue;
            HashMap<DbusPartitionInfo, RegInfo> childR = null;
            if (r instanceof DatabusV3MultiPartitionRegistration) {
                Map childRegs = ((DatabusV3MultiPartitionRegistration)r).getPartionRegs();
                childR = new HashMap<DbusPartitionInfo, RegInfo>();
                for (Map.Entry e2 : childRegs.entrySet()) {
                    childR.put(new DbusPartitionInfoImpl(((PhysicalPartition)e2.getKey()).getId().intValue()), new RegInfo(e.getValue().getState().name(), e.getValue().getRegistrationId(), e.getValue().getStatus(), null, e.getValue().getSubscriptions()));
                }
            }
            regInfo = new RegInfo(r.getState().name(), r.getRegistrationId(), r.getStatus(), null, r.getSubscriptions(), true, childR);
            regListMap.put(e.getKey(), regInfo);
        }
        return regListMap.values();
    }

    private Collection<RegInfo> getAllTopLevelV2Registrations() {
        ArrayList<RegInfo> regList = new ArrayList<RegInfo>();
        Collection<DatabusRegistration> regs = this._client.getAllRegistrations();
        for (DatabusRegistration r : regs) {
            RegInfo regInfo = null;
            if (r instanceof DatabusMultiPartitionRegistration) {
                Map<DbusPartitionInfo, DatabusRegistration> childRegs = ((DatabusMultiPartitionRegistration)r).getPartitionRegs();
                HashMap<DbusPartitionInfo, RegInfo> childR = new HashMap<DbusPartitionInfo, RegInfo>();
                for (Map.Entry<DbusPartitionInfo, DatabusRegistration> e : childRegs.entrySet()) {
                    childR.put(e.getKey(), new RegInfo(e.getValue().getState().name(), e.getValue().getRegistrationId(), e.getValue().getStatus(), e.getValue().getFilterConfig(), e.getValue().getSubscriptions()));
                }
                regInfo = new RegInfo(r.getState().name(), r.getRegistrationId(), r.getStatus(), r.getFilterConfig(), r.getSubscriptions(), true, childR);
            } else {
                regInfo = new RegInfo(r.getState().name(), r.getRegistrationId(), r.getStatus(), r.getFilterConfig(), r.getSubscriptions());
            }
            regList.add(regInfo);
        }
        return regList;
    }

    private Collection<PartitionInfo> getV2ClusterPartitions(String cluster) throws RequestProcessingException {
        DatabusV2ClusterRegistrationImpl reg = this.getV2ClusterRegistration(cluster);
        ArrayList<PartitionInfo> partitions = new ArrayList<PartitionInfo>();
        Map<DbusPartitionInfo, DatabusRegistration> regMap = reg.getPartitionRegs();
        for (Map.Entry<DbusPartitionInfo, DatabusRegistration> e : regMap.entrySet()) {
            PartitionInfo p = new PartitionInfo(e.getKey().getPartitionId(), e.getValue().getRegistrationId());
            partitions.add(p);
        }
        return partitions;
    }

    private Collection<PartitionInfo> getV3ClusterPartitions(String cluster) throws RequestProcessingException {
        DatabusV3MultiPartitionRegistration reg = this.getV3ClusterRegistration(cluster);
        ArrayList<PartitionInfo> partitions = new ArrayList<PartitionInfo>();
        Map regMap = reg.getPartionRegs();
        for (Map.Entry e : regMap.entrySet()) {
            PartitionInfo p = new PartitionInfo(((PhysicalPartition)e.getKey()).getId().intValue(), ((DatabusV3Registration)e.getValue()).getRegistrationId());
            partitions.add(p);
        }
        return partitions;
    }

    private RegInfo getV2PartitionRegistration(String cluster, long partition) throws RequestProcessingException {
        DatabusV2ClusterRegistrationImpl reg = this.getV2ClusterRegistration(cluster);
        DbusPartitionInfoImpl p = new DbusPartitionInfoImpl(partition);
        DatabusRegistration r = reg.getPartitionRegs().get(p);
        if (null == r) {
            throw new RequestProcessingException("Partition(" + partition + ") for cluster (" + cluster + ") not found !!");
        }
        return new RegInfo(r.getState().name(), r.getRegistrationId(), r.getStatus(), r.getFilterConfig(), r.getSubscriptions());
    }

    private RegInfo getV3PartitionRegistration(String cluster, long partition) throws RequestProcessingException {
        DatabusV3MultiPartitionRegistration reg = this.getV3ClusterRegistration(cluster);
        for (Map.Entry e : reg.getPartionRegs().entrySet()) {
            if (partition != (long)((PhysicalPartition)e.getKey()).getId().intValue()) continue;
            DatabusV3Registration r = (DatabusV3Registration)e.getValue();
            return new RegInfo(r.getState().name(), r.getRegistrationId(), r.getStatus(), null, r.getSubscriptions());
        }
        throw new RequestProcessingException("Partition(" + partition + ") for cluster (" + cluster + ") not found !!");
    }

    private DatabusRegistration findV2Registration(DatabusRequest request, String prefix) throws RequestProcessingException {
        String category = request.getParams().getProperty("reqpath");
        String registrationIdStr = category.substring(prefix.length());
        RegistrationId regId = new RegistrationId(registrationIdStr);
        Collection<DatabusRegistration> regs = this._client.getAllRegistrations();
        if (null != regs) {
            for (DatabusRegistration r : regs) {
                if (regId.equals((Object)r.getRegistrationId())) {
                    return r;
                }
                if (!(r instanceof DatabusMultiPartitionRegistration)) continue;
                Map<DbusPartitionInfo, DatabusRegistration> childRegs = ((DatabusMultiPartitionRegistration)r).getPartitionRegs();
                for (Map.Entry<DbusPartitionInfo, DatabusRegistration> e : childRegs.entrySet()) {
                    if (!regId.equals((Object)e.getValue().getRegistrationId())) continue;
                    return e.getValue();
                }
            }
        }
        throw new RequestProcessingException("Unable to find registration (" + regId + ") ");
    }

    private DatabusV3Registration findV3Registration(RegistrationId regId, DatabusRequest request) throws RequestProcessingException {
        Map<RegistrationId, DatabusV3Registration> regIdMap = this._client.getRegistrationIdMap();
        if (null == regIdMap) {
            throw new InvalidRequestParamValueException(request.getName(), REGISTRATION_KEY_PREFIX, "No registrations available !! ");
        }
        for (DatabusV3Registration r : regIdMap.values()) {
            if (!regId.equals((Object)r.getRegistrationId())) continue;
            return r;
        }
        throw new InvalidRequestParamValueException(request.getName(), REGISTRATION_KEY_PREFIX, "Registration with id " + regId + " not present !!");
    }

    private DatabusV3Registration findV3Registration(DatabusRequest request, String prefix) throws RequestProcessingException {
        String category = request.getParams().getProperty("reqpath");
        String regIdStr = category.substring(prefix.length());
        RegistrationId regId = new RegistrationId(regIdStr);
        return this.findV3Registration(regId, request);
    }

    private static class RegInfo {
        private final String state;
        private final RegistrationId regId;
        private final String status;
        private final DbusKeyCompositeFilterConfig filter;
        private final Collection<DatabusSubscription> subs;
        private final boolean isMultiPartition;
        private final Map<DbusPartitionInfo, RegInfo> childRegistrations;

        public String getState() {
            return this.state;
        }

        public RegistrationId getRegId() {
            return this.regId;
        }

        public String getStatus() {
            return this.status;
        }

        public DbusKeyCompositeFilterConfig getFilter() {
            return this.filter;
        }

        public Collection<DatabusSubscription> getSubs() {
            return this.subs;
        }

        public boolean isMultiPartition() {
            return this.isMultiPartition;
        }

        public Map<DbusPartitionInfo, RegInfo> getChildRegistrations() {
            return this.childRegistrations;
        }

        public RegInfo(String state, RegistrationId regId, DatabusComponentStatus status, DbusKeyCompositeFilterConfig filter, Collection<DatabusSubscription> subs) {
            this(state, regId, status, filter, subs, false, null);
        }

        public RegInfo(String state, RegistrationId regId, DatabusComponentStatus status, DbusKeyCompositeFilterConfig filter, Collection<DatabusSubscription> subs, boolean isMultiPartition, Map<DbusPartitionInfo, RegInfo> childRegistrations) {
            this.state = state;
            this.regId = regId;
            this.status = status.toString();
            this.filter = filter;
            this.subs = subs;
            this.isMultiPartition = isMultiPartition;
            this.childRegistrations = childRegistrations;
        }
    }

    private static class RegStatePair {
        private final String _state;
        private final RegistrationId _regId;

        public String getState() {
            return this._state;
        }

        public RegistrationId getRegId() {
            return this._regId;
        }

        public RegStatePair(DatabusRegistration.RegistrationState state, RegistrationId regId) {
            this._regId = regId;
            this._state = state.name();
        }

        public RegStatePair(String state, RegistrationId regId) {
            this._regId = regId;
            this._state = state;
        }
    }

    private static class PartitionInfo {
        private final long partition;
        private final RegistrationId regId;

        public long getPartition() {
            return this.partition;
        }

        public RegistrationId getRegId() {
            return this.regId;
        }

        public PartitionInfo(long partition, RegistrationId regId) {
            this.partition = partition;
            this.regId = regId;
        }
    }
}

