/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.client.registration;

import com.linkedin.databus.client.pub.RegistrationId;
import com.linkedin.databus.core.data_model.DatabusSubscription;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.codec.binary.Hex;
import org.apache.log4j.Logger;

public class RegistrationIdGenerator {
    public static final Logger LOG = Logger.getLogger(RegistrationIdGenerator.class);
    private static Set<String> _registrationIdDatabase = new HashSet<String>();

    public static RegistrationId generateNewId(String prefix, Collection<DatabusSubscription> subsSources) {
        StringBuilder subscription = new StringBuilder();
        for (DatabusSubscription ds : subsSources) {
            if (ds == null) continue;
            subscription.append(ds.generateSubscriptionString());
        }
        String id = RegistrationIdGenerator.generateUniqueString(prefix, subscription.toString());
        RegistrationId rid = new RegistrationId(id);
        return rid;
    }

    public static RegistrationId generateNewId(String id) {
        String r = RegistrationIdGenerator.generateUniqueString(id);
        RegistrationId rid = new RegistrationId(r);
        return rid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isIdValid(RegistrationId rid) {
        String id = rid.getId();
        Class<RegistrationIdGenerator> clazz = RegistrationIdGenerator.class;
        synchronized (RegistrationIdGenerator.class) {
            if (_registrationIdDatabase.contains(id)) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return false;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void insertId(RegistrationId rid) {
        String id = rid.getId();
        Class<RegistrationIdGenerator> clazz = RegistrationIdGenerator.class;
        synchronized (RegistrationIdGenerator.class) {
            _registrationIdDatabase.add(id);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    private static String generateUniqueString(String prefix, String subscription) {
        String delimiter = "_";
        String baseId = prefix + "_" + RegistrationIdGenerator.generateByteHash(subscription);
        return RegistrationIdGenerator.generateUniqueString(baseId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String generateUniqueString(String id) {
        String delimiter = "_";
        String baseId = id;
        boolean success = false;
        boolean debugEnabled = LOG.isDebugEnabled();
        Class<RegistrationIdGenerator> clazz = RegistrationIdGenerator.class;
        synchronized (RegistrationIdGenerator.class) {
            int count = _registrationIdDatabase.size();
            while (!success) {
                if (_registrationIdDatabase.contains(id)) {
                    if (debugEnabled) {
                        LOG.debug((Object)("The generated id " + id + " already exists. Retrying ..."));
                    }
                    id = baseId + "_" + count;
                    ++count;
                    continue;
                }
                if (debugEnabled) {
                    LOG.debug((Object)("Obtained a new ID " + id));
                }
                _registrationIdDatabase.add(id);
                success = true;
            }
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return id;
        }
    }

    private static String generateByteHash(String id) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            messageDigest.reset();
            messageDigest.update(id.getBytes(Charset.forName("UTF8")));
            byte[] resultsByte = messageDigest.digest();
            String hash = new String(Hex.encodeHex((byte[])resultsByte));
            int length = 8;
            if (hash.length() > 8) {
                hash = hash.substring(0, 8);
            }
            return hash;
        }
        catch (NoSuchAlgorithmException nse) {
            LOG.error((Object)"Unexpected error : Got NoSuchAlgorithm exception for MD5");
            return "";
        }
    }
}

