/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.client.netty;

import com.linkedin.databus.client.ChunkedBodyReadableByteChannel;
import com.linkedin.databus.client.DatabusSourcesConnection;
import com.linkedin.databus.core.DbusErrorEvent;
import com.linkedin.databus.core.DbusEventBuffer;
import com.linkedin.databus.core.DbusEventFactory;
import com.linkedin.databus.core.DbusEventInternalReadable;
import com.linkedin.databus.core.DbusPrettyLogUtils;
import com.linkedin.databus.core.InvalidEventException;
import com.linkedin.databus.core.PullerRetriesExhaustedException;
import com.linkedin.databus.core.ScnNotFoundException;
import com.linkedin.databus2.core.container.request.BootstrapDBException;
import com.linkedin.databus2.core.container.request.BootstrapDatabaseTooOldException;
import com.linkedin.databus2.core.container.request.BootstrapDatabaseTooYoungException;
import java.io.ByteArrayInputStream;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.sql.SQLException;
import org.apache.log4j.Logger;

public class RemoteExceptionHandler {
    public static final String MODULE = RemoteExceptionHandler.class.getName();
    public static final Logger LOG = Logger.getLogger((String)MODULE);
    private final DatabusSourcesConnection _sourcesConn;
    private final DbusEventBuffer _dbusEventBuffer;
    private final DbusEventFactory _eventFactory;

    public RemoteExceptionHandler(DatabusSourcesConnection sourcesConn, DbusEventBuffer dataEventsBuffer, DbusEventFactory eventFactory) {
        this._sourcesConn = sourcesConn;
        this._dbusEventBuffer = dataEventsBuffer;
        this._eventFactory = eventFactory;
    }

    public int getPendingEventSize(ChunkedBodyReadableByteChannel readChannel) {
        String result = readChannel.getMetadata("x-dbus-pending-event-size");
        if (result == null) {
            return 0;
        }
        try {
            return Integer.parseInt(result);
        }
        catch (NumberFormatException e) {
            LOG.error((Object)("Could not parse pending event size:" + result));
            return 0;
        }
    }

    public static String getExceptionName(ChunkedBodyReadableByteChannel readChannel) {
        String result = readChannel.getMetadata("x-dbus-error-cause");
        if (result == null) {
            result = readChannel.getMetadata("x-dbus-error");
        }
        return result;
    }

    public static String getExceptionMessage(ChunkedBodyReadableByteChannel readChannel) {
        String exceptionName = RemoteExceptionHandler.getExceptionName(readChannel);
        if (null == exceptionName) {
            return null;
        }
        StringBuilder result = new StringBuilder(exceptionName.length() + 100);
        result.append("Remote exception");
        String reqId = readChannel.getMetadata("x-dbus-req-id");
        if (null != reqId) {
            result.append(" for request id");
        }
        result.append(":");
        result.append(exceptionName);
        return result.toString();
    }

    public Throwable getException(ChunkedBodyReadableByteChannel readChannel) {
        Object remoteException = null;
        String err = RemoteExceptionHandler.getExceptionName(readChannel);
        if (null != err) {
            if (err.equalsIgnoreCase(ScnNotFoundException.class.getName())) {
                remoteException = new ScnNotFoundException();
            } else if (err.equalsIgnoreCase(BootstrapDatabaseTooOldException.class.getName())) {
                remoteException = new BootstrapDatabaseTooOldException();
            } else if (err.equalsIgnoreCase(PullerRetriesExhaustedException.class.getName())) {
                remoteException = new PullerRetriesExhaustedException();
            } else if (err.equalsIgnoreCase(BootstrapDatabaseTooYoungException.class.getName())) {
                remoteException = new BootstrapDatabaseTooYoungException();
            } else if (err.equalsIgnoreCase(BootstrapDBException.class.getName())) {
                remoteException = new BootstrapDBException();
            } else if (err.equalsIgnoreCase(SQLException.class.getName())) {
                remoteException = new SQLException();
            } else {
                LOG.error((Object)("Unexpected remote error received: " + err));
            }
            LOG.info((Object)("Remote exception received: " + remoteException));
        }
        return remoteException;
    }

    public void handleException(Throwable remoteException) throws InvalidEventException, InterruptedException {
        if (remoteException instanceof BootstrapDatabaseTooOldException || remoteException instanceof PullerRetriesExhaustedException) {
            this.suspendConnectionOnError(remoteException);
        } else {
            LOG.error((Object)("Unexpected exception received: " + remoteException));
        }
    }

    private void suspendConnectionOnError(Throwable exception) throws InvalidEventException, InterruptedException {
        this._sourcesConn.getConnectionStatus().suspendOnError(exception);
        DbusEventInternalReadable errorEvent = null;
        if (exception instanceof BootstrapDatabaseTooOldException) {
            errorEvent = this._eventFactory.createErrorEvent(new DbusErrorEvent(exception, -5));
        } else if (exception instanceof PullerRetriesExhaustedException) {
            errorEvent = this._eventFactory.createErrorEvent(new DbusErrorEvent(exception, -6));
        } else {
            throw new InvalidEventException("Got an unrecognizable exception ");
        }
        byte[] errorEventBytes = new byte[errorEvent.getRawBytes().limit()];
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("error event size: " + errorEventBytes.length));
            LOG.debug((Object)("error event:" + errorEvent.toString()));
        }
        errorEvent.getRawBytes().get(errorEventBytes);
        ByteArrayInputStream errIs = new ByteArrayInputStream(errorEventBytes);
        ReadableByteChannel errRbc = Channels.newChannel(errIs);
        boolean success = false;
        int retryCounter = 0;
        while (!success && retryCounter < 10) {
            String errMsg = "Sending an internal system event to dispatcher. Retry count = " + retryCounter;
            DbusPrettyLogUtils.logExceptionAtInfo((String)errMsg, (Throwable)exception, (Logger)LOG);
            success = this._dbusEventBuffer.readEvents(errRbc) > 0;
            if (success) continue;
            LOG.warn((Object)("Unable to send an internal system event to dispatcher. Will retry later " + retryCounter));
            ++retryCounter;
            Thread.sleep(1000L);
        }
    }
}

