/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.client.netty;

import com.linkedin.databus.client.DatabusBootstrapConnection;
import com.linkedin.databus.client.DatabusBootstrapConnectionFactory;
import com.linkedin.databus.client.DatabusRelayConnection;
import com.linkedin.databus.client.DatabusRelayConnectionFactory;
import com.linkedin.databus.client.netty.NettyHttpDatabusBootstrapConnection;
import com.linkedin.databus.client.netty.NettyHttpDatabusRelayConnection;
import com.linkedin.databus.client.netty.RemoteExceptionHandler;
import com.linkedin.databus.client.pub.ServerInfo;
import com.linkedin.databus.core.async.ActorMessageQueue;
import com.linkedin.databus2.core.container.monitoring.mbean.ContainerStatisticsCollector;
import java.io.IOException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.group.ChannelGroup;
import org.jboss.netty.channel.socket.nio.NioClientSocketChannelFactory;
import org.jboss.netty.util.Timer;

public class NettyHttpConnectionFactory
implements DatabusRelayConnectionFactory,
DatabusBootstrapConnectionFactory {
    private final ExecutorService _bossThreadPool;
    private final ExecutorService _ioThreadPool;
    private final ContainerStatisticsCollector _containerStatsCollector;
    private final Timer _timeoutTimer;
    private final ChannelFactory _channelFactory;
    private final long _writeTimeoutMs;
    private final long _readTimeoutMs;
    private final long _bstReadTimeoutMs;
    private final int _protocolVersion;
    private final ChannelGroup _channelGroup;
    private final int _maxEventVersion;

    public NettyHttpConnectionFactory(ExecutorService bossThreadPool, ExecutorService ioThreadPool, ContainerStatisticsCollector containerStatsCollector, Timer timeoutTimer, long writeTimeoutMs, long readTimeoutMs, long bstReadTimeoutMs, int protocolVersion, int maxEventVersion, ChannelGroup channelGroup) {
        this._bossThreadPool = bossThreadPool;
        this._ioThreadPool = ioThreadPool;
        this._containerStatsCollector = containerStatsCollector;
        this._timeoutTimer = timeoutTimer;
        this._writeTimeoutMs = writeTimeoutMs;
        this._readTimeoutMs = readTimeoutMs;
        this._bstReadTimeoutMs = bstReadTimeoutMs;
        this._protocolVersion = protocolVersion;
        this._channelFactory = new NioClientSocketChannelFactory((Executor)this._bossThreadPool, (Executor)this._ioThreadPool);
        this._channelGroup = channelGroup;
        this._maxEventVersion = maxEventVersion;
    }

    @Override
    public DatabusRelayConnection createRelayConnection(ServerInfo relay, ActorMessageQueue callback, RemoteExceptionHandler remoteExceptionHandler) throws IOException {
        return new NettyHttpDatabusRelayConnection(relay, callback, this._channelFactory, this._containerStatsCollector, remoteExceptionHandler, this._timeoutTimer, this._writeTimeoutMs, this._readTimeoutMs, this._protocolVersion, this._maxEventVersion, this._channelGroup);
    }

    @Override
    public DatabusBootstrapConnection createConnection(ServerInfo relay, ActorMessageQueue callback, RemoteExceptionHandler remoteExceptionHandler) throws IOException {
        return new NettyHttpDatabusBootstrapConnection(relay, callback, this._channelFactory, this._containerStatsCollector, remoteExceptionHandler, this._timeoutTimer, this._writeTimeoutMs, this._bstReadTimeoutMs, this._protocolVersion, this._channelGroup);
    }

    ChannelFactory getChannelFactory() {
        return this._channelFactory;
    }
}

