/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.client.netty;

import com.linkedin.databus.client.netty.GenericHttpResponseHandler;
import com.linkedin.databus2.core.container.ExtendedReadTimeoutHandler;
import com.linkedin.databus2.core.container.ExtendedWriteTimeoutHandler;
import com.linkedin.databus2.core.container.HttpRequestLoggingHandler;
import com.linkedin.databus2.core.container.monitoring.mbean.ContainerStatisticsCollector;
import com.linkedin.databus2.core.container.netty.ConnectionChannelRegistrationHandler;
import com.linkedin.databus2.core.container.netty.InboundContainerStatisticsCollectingHandler;
import org.apache.log4j.Logger;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.group.ChannelGroup;
import org.jboss.netty.handler.codec.http.HttpClientCodec;
import org.jboss.netty.handler.codec.http.HttpContentDecompressor;
import org.jboss.netty.handler.logging.LoggingHandler;
import org.jboss.netty.logging.InternalLogLevel;
import org.jboss.netty.util.Timer;

public class GenericHttpClientPipelineFactory
implements ChannelPipelineFactory {
    public static final String MODULE = GenericHttpClientPipelineFactory.class.getName();
    public static final Logger LOG = Logger.getLogger((String)MODULE);
    public static final String READ_TIMEOUT_HANDLER_NAME = "client request read timeout handler";
    private final GenericHttpResponseHandler _handler;
    private final ContainerStatisticsCollector _containerStatsCollector;
    private final Timer _timeoutTimer;
    private final long _writeTimeoutMs;
    private final long _readTimeoutMs;
    private final ChannelGroup _channelGroup;

    public GenericHttpClientPipelineFactory(GenericHttpResponseHandler handler, ContainerStatisticsCollector containerStatsCollector, Timer timeoutTimer, long writeTimeoutMs, long readTimeoutMs, ChannelGroup channelGroup) {
        this._handler = handler;
        this._containerStatsCollector = containerStatsCollector;
        this._timeoutTimer = timeoutTimer;
        this._writeTimeoutMs = writeTimeoutMs;
        this._readTimeoutMs = readTimeoutMs;
        this._channelGroup = channelGroup;
    }

    public ChannelPipeline getPipeline() throws Exception {
        ChannelPipeline pipeline = Channels.pipeline();
        if (this._channelGroup != null) {
            pipeline.addLast("auto group register ", (ChannelHandler)new ConnectionChannelRegistrationHandler(this._channelGroup));
        }
        if (Logger.getRootLogger().isTraceEnabled()) {
            LOG.debug((Object)"Adding Netty tracing");
            pipeline.addLast("netty client traffic", (ChannelHandler)new LoggingHandler("netty client traffic", InternalLogLevel.DEBUG, true));
        }
        if (null != this._containerStatsCollector) {
            pipeline.addLast("inbound statistics collector", (ChannelHandler)new InboundContainerStatisticsCollectingHandler(this._containerStatsCollector));
        }
        ExtendedReadTimeoutHandler readTimeoutHandler = new ExtendedReadTimeoutHandler("client call ", this._timeoutTimer, this._readTimeoutMs, true);
        pipeline.addLast(READ_TIMEOUT_HANDLER_NAME, (ChannelHandler)readTimeoutHandler);
        pipeline.addLast("codec", (ChannelHandler)new HttpClientCodec());
        pipeline.addLast("http logger", (ChannelHandler)new HttpRequestLoggingHandler());
        pipeline.addLast("inflater", (ChannelHandler)new HttpContentDecompressor());
        pipeline.addLast("handler", (ChannelHandler)this._handler);
        pipeline.addLast("client request write timeout handler", (ChannelHandler)new ExtendedWriteTimeoutHandler("netty client traffic", this._timeoutTimer, this._writeTimeoutMs, true));
        return pipeline;
    }
}

