/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.client.netty;

import com.linkedin.databus.client.ChunkedBodyReadableByteChannel;
import com.linkedin.databus.client.DatabusServerConnection;
import com.linkedin.databus.client.netty.AbstractHttpResponseProcessorDecorator;
import com.linkedin.databus.client.netty.GenericHttpClientPipelineFactory;
import com.linkedin.databus.client.netty.GenericHttpResponseHandler;
import com.linkedin.databus.client.netty.HttpResponseProcessor;
import com.linkedin.databus.client.pub.ServerInfo;
import com.linkedin.databus.core.DbusConstants;
import com.linkedin.databus.core.DbusPrettyLogUtils;
import com.linkedin.databus.core.util.DbusHttpUtils;
import com.linkedin.databus2.core.DatabusException;
import com.linkedin.databus2.core.container.ExtendedReadTimeoutHandler;
import com.linkedin.databus2.core.container.monitoring.mbean.ContainerStatisticsCollector;
import java.net.SocketAddress;
import java.nio.channels.ClosedChannelException;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.log4j.Logger;
import org.jboss.netty.bootstrap.ClientBootstrap;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.group.ChannelGroup;
import org.jboss.netty.handler.codec.http.DefaultHttpRequest;
import org.jboss.netty.handler.codec.http.HttpChunkTrailer;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.codec.http.HttpResponse;
import org.jboss.netty.handler.codec.http.HttpVersion;
import org.jboss.netty.handler.timeout.WriteTimeoutException;
import org.jboss.netty.util.Timer;

public class AbstractNettyHttpConnection
implements DatabusServerConnection {
    private final Lock _mutex = new ReentrantLock();
    private final Condition _connectionClosed = this._mutex.newCondition();
    private final GenericHttpClientPipelineFactory _pipelineFactory;
    protected final ClientBootstrap _bootstrap;
    protected final ServerInfo _server;
    private final Logger _log;
    private final int _protocolVersion;
    protected volatile Channel _channel;
    private int _connectRetriesLeft;
    private State _state;
    private final GenericHttpResponseHandler _handler;
    String _hostHdr;
    String _svcHdr;

    public AbstractNettyHttpConnection(ServerInfo server, ClientBootstrap bootstrap, ContainerStatisticsCollector containerStatsCollector, Timer timeoutTimer, long writeTimeoutMs, long readTimeoutMs, ChannelGroup channelGroup, int protocolVersion, Logger log) {
        this._log = null != log ? log : Logger.getLogger(AbstractNettyHttpConnection.class);
        this._server = server;
        this._bootstrap = bootstrap;
        this._protocolVersion = protocolVersion;
        this._bootstrap.setOption("connectTimeoutMillis", (Object)100L);
        this._handler = new GenericHttpResponseHandler(GenericHttpResponseHandler.KeepAliveType.KEEP_ALIVE, null);
        this._pipelineFactory = new GenericHttpClientPipelineFactory(this._handler, containerStatsCollector, timeoutTimer, writeTimeoutMs, readTimeoutMs, channelGroup);
        this._bootstrap.setPipelineFactory((ChannelPipelineFactory)this._pipelineFactory);
        this._channel = null;
        this._state = State.INIT;
    }

    @Override
    public int getProtocolVersion() {
        return this._protocolVersion;
    }

    @Override
    public void close() {
        this._log.info((Object)("closing connection to: " + this._server.getAddress()));
        State newState = this.switchToClosing();
        if (State.CLOSING != newState && State.CLOSED != newState) {
            return;
        }
        if (null == this._channel || !this._channel.isConnected()) {
            this.switchToClosed();
        } else {
            this._channel.close();
            this.awaitForCloseUninterruptibly();
        }
    }

    @Override
    public String getRemoteHost() {
        String host = this.getHostHdr();
        return null != host ? host : "UNKNOWN";
    }

    @Override
    public String getRemoteService() {
        String service = this.getSvcHdr();
        return null != service ? service : "UNKNOWN";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void awaitForCloseUninterruptibly() {
        this._mutex.lock();
        try {
            while (!this.isClosed()) {
                this._connectionClosed.awaitUninterruptibly();
            }
        }
        finally {
            this._mutex.unlock();
        }
    }

    public Logger getLog() {
        return this._log;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInit() {
        this._mutex.lock();
        try {
            boolean bl = State.INIT == this._state;
            return bl;
        }
        finally {
            this._mutex.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isClosingOrClosed() {
        this._mutex.lock();
        try {
            boolean bl = State.CLOSING == this._state || State.CLOSED == this._state;
            return bl;
        }
        finally {
            this._mutex.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isClosed() {
        this._mutex.lock();
        try {
            boolean bl = State.CLOSED == this._state;
            return bl;
        }
        finally {
            this._mutex.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isClosing() {
        this._mutex.lock();
        try {
            boolean bl = State.CLOSING == this._state;
            return bl;
        }
        finally {
            this._mutex.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConnectingOrConnected() {
        this._mutex.lock();
        try {
            boolean bl = State.CONNECTING == this._state || State.CONNECTED == this._state;
            return bl;
        }
        finally {
            this._mutex.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConnecting() {
        this._mutex.lock();
        try {
            boolean bl = State.CONNECTING == this._state;
            return bl;
        }
        finally {
            this._mutex.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConnected() {
        this._mutex.lock();
        try {
            boolean bl = State.CONNECTED == this._state;
            return bl;
        }
        finally {
            this._mutex.unlock();
        }
    }

    private void unexpectedTransition(State fromState, State toState) {
        this._log.error((Object)("unexpected netty connection transition from " + (Object)((Object)fromState) + " to " + (Object)((Object)toState)));
        this._state = State.ERROR;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private State switchToClosing() {
        this._mutex.lock();
        try {
            switch (this._state) {
                case CLOSING: 
                case CLOSED: {
                    break;
                }
                default: {
                    this._state = State.CLOSING;
                }
            }
            State state = this._state;
            return state;
        }
        finally {
            this._mutex.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private State switchToClosed() {
        this._mutex.lock();
        try {
            switch (this._state) {
                case CLOSING: 
                case CLOSED: {
                    this._state = State.CLOSED;
                    break;
                }
                default: {
                    this.unexpectedTransition(this._state, State.CLOSED);
                }
            }
            State state = this._state;
            return state;
        }
        finally {
            this._mutex.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private State switchToConnecting() {
        this._mutex.lock();
        try {
            switch (this._state) {
                case CLOSED: 
                case INIT: {
                    this._state = State.CONNECTING;
                    break;
                }
                default: {
                    this.unexpectedTransition(this._state, State.CONNECTING);
                }
            }
            State state = this._state;
            return state;
        }
        finally {
            this._mutex.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private State switchToConnected() {
        this._mutex.lock();
        try {
            switch (this._state) {
                case CONNECTING: {
                    this._state = State.CONNECTED;
                    break;
                }
                case CLOSING: 
                case CLOSED: {
                    break;
                }
                default: {
                    this.unexpectedTransition(this._state, State.CONNECTED);
                }
            }
            State state = this._state;
            return state;
        }
        finally {
            this._mutex.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private State switchToInit() {
        this._mutex.lock();
        try {
            switch (this._state) {
                case CONNECTING: {
                    this._state = State.INIT;
                    break;
                }
                default: {
                    this.unexpectedTransition(this._state, State.INIT);
                }
            }
            State state = this._state;
            return state;
        }
        finally {
            this._mutex.unlock();
        }
    }

    protected boolean hasConnection() {
        return null != this._channel && State.INIT != this._state && State.CLOSED != this._state;
    }

    State getNetworkState() {
        return this._state;
    }

    protected void connectWithListener(ConnectResultListener listener) {
        if (State.CONNECTING != this.switchToConnecting()) {
            listener.onConnectFailure(new RuntimeException("unable to connect"));
        } else {
            this._connectRetriesLeft = 3;
            this.connectRetry(listener);
        }
    }

    private void connectRetry(ConnectResultListener listener) {
        this._log.info((Object)("connecting: " + this._server.toSimpleString()));
        if (this.isClosingOrClosed()) {
            listener.onConnectFailure(new ClosedChannelException());
            return;
        }
        if (!this.isConnecting()) {
            listener.onConnectFailure(new RuntimeException("unable to connect"));
        } else {
            this._handler.reset();
            this._handler.setConnectionListener(new AbstractNettyConnectListener(listener));
            this._bootstrap.connect((SocketAddress)this._server.getAddress());
        }
    }

    protected void sendRequest(HttpRequest request, SendRequestResultListener listener, HttpResponseProcessor responseProcessor) {
        if (this.isClosingOrClosed()) {
            listener.onSendRequestFailure(request, new ClosedChannelException());
        } else if (!this.isConnected()) {
            listener.onSendRequestFailure(request, new RuntimeException("unable to send request"));
        } else {
            try {
                this.setResponseProcessor(responseProcessor, listener);
            }
            catch (DatabusException e) {
                listener.onSendRequestFailure(request, e.getCause());
                this._channel.close();
                return;
            }
            if (this._channel.isConnected()) {
                this._channel.write((Object)request);
            } else {
                this._log.error((Object)("disconnect on request: " + request.getUri()));
                listener.onSendRequestFailure(request, new ClosedChannelException());
            }
        }
    }

    protected HttpRequest createEmptyRequest(String uriString) {
        DefaultHttpRequest request = new DefaultHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, uriString);
        request.setHeader("Host", (Object)this._server.getAddress().toString());
        request.setHeader("Connection", (Object)"keep-alive");
        request.setHeader("Accept-Encoding", (Object)"gzip");
        String hostHdr = DbusHttpUtils.getLocalHostName();
        String svcHdr = DbusConstants.getServiceIdentifier();
        if (!hostHdr.isEmpty()) {
            request.setHeader("x-dbus-client-host", (Object)hostHdr);
        }
        if (!svcHdr.isEmpty()) {
            request.setHeader("x-dbus-client-service", (Object)svcHdr);
        }
        return request;
    }

    protected void setConnectListener(ConnectResultListener l) {
        this._handler.setConnectionListener(l);
    }

    protected void setResponseProcessor(HttpResponseProcessor responseProcessor, SendRequestResultListener l) throws DatabusException {
        this._handler.setResponseProcessor(responseProcessor);
        this._handler.setRequestListener(l);
        assert (this._channel != null);
        assert (this._channel.getPipeline().get("handler") != null);
    }

    protected GenericHttpResponseHandler getHandler() {
        return this._handler;
    }

    protected boolean shouldIgnoreWriteTimeoutException(Throwable cause) {
        boolean requestSent;
        boolean bl = requestSent = null != this.getHandler() ? this.getHandler()._messageState.hasSentRequest() : false;
        if (requestSent && cause instanceof WriteTimeoutException) {
            this._log.error((Object)("Got RequestFailure because of WriteTimeoutException. requestSent = " + requestSent));
            return true;
        }
        this._log.error((Object)("The request has not been sent due to " + cause + " requestSent = " + requestSent));
        return false;
    }

    protected void addConnectionTracking(HttpResponse response) throws Exception {
        boolean debugEnabled = this._log.isDebugEnabled();
        this._hostHdr = response.getHeader("x-dbus-server-host");
        this._svcHdr = response.getHeader("x-dbus-server-service");
        if (debugEnabled) {
            if (null != this._hostHdr) {
                this._log.debug((Object)("Received response for databus server host: " + this._hostHdr));
            }
            if (null != this._svcHdr) {
                this._log.debug((Object)("Received response for databus server host: " + this._svcHdr));
            }
        }
    }

    protected String getHostHdr() {
        return this._hostHdr;
    }

    protected String getSvcHdr() {
        return this._svcHdr;
    }

    @Override
    public int getMaxEventVersion() {
        return 0;
    }

    static class BaseHttpResponseProcessor
    extends AbstractHttpResponseProcessorDecorator<ChunkedBodyReadableByteChannel> {
        private final ExtendedReadTimeoutHandler _readTimeOutHandler;
        private final AbstractNettyHttpConnection _parent;
        protected String _serverErrorClass;
        protected String _serverErrorMessage;

        public BaseHttpResponseProcessor(AbstractNettyHttpConnection parent, ExtendedReadTimeoutHandler readTimeOutHandler) {
            super(null);
            this._readTimeOutHandler = readTimeOutHandler;
            this._parent = parent;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void finishResponse() throws Exception {
            try {
                super.finishResponse();
            }
            finally {
                this.stopReadTimeoutTimer();
            }
        }

        protected void stopReadTimeoutTimer() {
            if (null != this._readTimeOutHandler) {
                this._readTimeOutHandler.stop();
            }
        }

        @Override
        public void startResponse(HttpResponse response) throws Exception {
            this._serverErrorClass = response.getHeader("x-dbus-error-cause");
            this._serverErrorMessage = response.getHeader("x-dbus-error-cause-message");
            if (null == this._serverErrorClass) {
                this._serverErrorClass = response.getHeader("x-dbus-error");
                this._serverErrorMessage = response.getHeader("x-dbus-error-message");
            }
            if (null != this._serverErrorClass && null != this._parent) {
                this._parent.getLog().error((Object)("server error detected class=" + this._serverErrorClass + " message=" + this._serverErrorMessage));
            }
            super.startResponse(response);
            if (null != this._parent) {
                this._parent.addConnectionTracking(response);
            }
        }

        protected AbstractNettyHttpConnection getParent() {
            return this._parent;
        }

        @Override
        public void addTrailer(HttpChunkTrailer trailer) throws Exception {
            if (null == this._serverErrorClass) {
                this._serverErrorClass = trailer.getHeader("x-dbus-error-cause");
                this._serverErrorMessage = trailer.getHeader("x-dbus-error-cause-message");
                if (null == this._serverErrorClass) {
                    this._serverErrorClass = trailer.getHeader("x-dbus-error");
                    this._serverErrorMessage = trailer.getHeader("x-dbus-error-message");
                }
                if (null != this._serverErrorClass && null != this._parent) {
                    this._parent.getLog().error((Object)("server error detected class=" + this._serverErrorClass + " message=" + this._serverErrorMessage));
                }
            }
            super.addTrailer(trailer);
        }
    }

    public static interface SendRequestResultListener {
        public void onSendRequestSuccess(HttpRequest var1);

        public void onSendRequestFailure(HttpRequest var1, Throwable var2);
    }

    public static interface ConnectResultListener {
        public void onConnectSuccess(Channel var1);

        public void onConnectFailure(Throwable var1);
    }

    public static interface ChannelCloseListener {
        public void onChannelClose();
    }

    private class NettyChannelCloseListener
    implements ChannelCloseListener {
        private NettyChannelCloseListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onChannelClose() {
            AbstractNettyHttpConnection.this._mutex.lock();
            try {
                AbstractNettyHttpConnection.this.switchToClosing();
                AbstractNettyHttpConnection.this.switchToClosed();
                AbstractNettyHttpConnection.this._connectionClosed.signalAll();
                AbstractNettyHttpConnection.this._log.info((Object)("connection closed: " + AbstractNettyHttpConnection.this._server.getAddress()));
            }
            finally {
                AbstractNettyHttpConnection.this._mutex.unlock();
            }
        }
    }

    private class AbstractNettyConnectListener
    implements ConnectResultListener {
        private final ConnectResultListener _listener;

        public AbstractNettyConnectListener(ConnectResultListener listener) {
            this._listener = listener;
        }

        @Override
        public void onConnectSuccess(Channel channel) {
            if (State.CONNECTED != AbstractNettyHttpConnection.this.switchToConnected()) {
                this._listener.onConnectFailure(new RuntimeException("unable to connect"));
            } else {
                AbstractNettyHttpConnection.this._log.info((Object)("connected: " + AbstractNettyHttpConnection.this._server.toSimpleString()));
                AbstractNettyHttpConnection.this._handler.setCloseListener(new NettyChannelCloseListener());
                AbstractNettyHttpConnection.this._channel = channel;
                this._listener.onConnectSuccess(channel);
            }
        }

        @Override
        public void onConnectFailure(Throwable cause) {
            DbusPrettyLogUtils.logExceptionAtError((String)"Connect cancelled/failed", (Throwable)cause, (Logger)AbstractNettyHttpConnection.this._log);
            AbstractNettyHttpConnection.this.switchToInit();
            this._listener.onConnectFailure(cause);
        }
    }

    static enum State {
        INIT,
        CONNECTING,
        CONNECTED,
        CLOSING,
        CLOSED,
        ERROR;

    }
}

