/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.client.netty;

import com.linkedin.databus.client.netty.HttpResponseProcessor;
import org.apache.log4j.Logger;
import org.jboss.netty.handler.codec.http.HttpChunk;
import org.jboss.netty.handler.codec.http.HttpChunkTrailer;
import org.jboss.netty.handler.codec.http.HttpResponse;

public abstract class AbstractHttpResponseProcessorDecorator<T extends HttpResponseProcessor>
implements HttpResponseProcessor {
    public static final String MODULE = AbstractHttpResponseProcessorDecorator.class.getName();
    public static final Logger LOG = Logger.getLogger((String)MODULE);
    protected T _decorated;
    protected volatile boolean _errorHandled = false;
    protected volatile ResponseStatus _responseStatus;

    public AbstractHttpResponseProcessorDecorator(T decorated) {
        this._decorated = decorated;
        this._responseStatus = ResponseStatus.WAITING_FOR_FIRST_CHUNK;
    }

    @Override
    public void addChunk(HttpChunk chunk) throws Exception {
        if (null != this._decorated) {
            this._decorated.addChunk(chunk);
        } else {
            LOG.error((Object)"addChunk ignored; no decorated object");
        }
    }

    @Override
    public void addTrailer(HttpChunkTrailer trailer) throws Exception {
        if (null != this._decorated) {
            this._decorated.addTrailer(trailer);
        } else {
            LOG.error((Object)"addTrailer ignored; no decorated object");
        }
    }

    @Override
    public void finishResponse() throws Exception {
        this._responseStatus = ResponseStatus.CHUNKS_FINISHED;
        if (null != this._decorated) {
            this._decorated.finishResponse();
        } else {
            LOG.error((Object)"finishResponse ignored; no decorated object");
        }
    }

    @Override
    public void startResponse(HttpResponse response) throws Exception {
        this._responseStatus = ResponseStatus.CHUNKS_SEEN;
        if (null != this._decorated) {
            this._decorated.startResponse(response);
        } else {
            LOG.error((Object)"startResponse ignored; no decorated object");
        }
    }

    @Override
    public final void channelException(Throwable cause) {
        if (this._errorHandled) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("skipping exception as it is already handled by the client: " + cause.getMessage()), cause);
            }
            return;
        }
        this.handleChannelException(cause);
        this._errorHandled = true;
        this._responseStatus = ResponseStatus.CHUNKS_EXCEPTION;
    }

    public void handleChannelException(Throwable cause) {
        if (null != this._decorated) {
            this._decorated.channelException(cause);
        } else if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("channel exception but no decorated object:" + cause.getMessage()), cause);
        }
    }

    public static enum ResponseStatus {
        WAITING_FOR_FIRST_CHUNK,
        CHUNKS_SEEN,
        CHUNKS_FINISHED,
        CHUNKS_EXCEPTION;


        public boolean isActivelyProcessing() {
            return this.equals((Object)WAITING_FOR_FIRST_CHUNK) || this.equals((Object)CHUNKS_SEEN);
        }
    }
}

