/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.client.monitoring;

import com.linkedin.databus.client.BootstrapPullThread;
import com.linkedin.databus.client.ConnectionState;
import com.linkedin.databus.client.DatabusSourcesConnection;
import com.linkedin.databus.client.DispatcherState;
import com.linkedin.databus.client.GenericDispatcher;
import com.linkedin.databus.client.RelayPullThread;
import com.linkedin.databus.client.pub.DatabusCombinedConsumer;
import com.linkedin.databus.client.pub.DatabusRegistration;
import com.linkedin.databus.client.pub.DatabusV3MultiPartitionRegistration;
import com.linkedin.databus.client.pub.DatabusV3Registration;
import com.linkedin.databus.client.pub.DbusPartitionInfo;
import com.linkedin.databus.client.pub.RegistrationId;
import com.linkedin.databus.client.pub.SCN;
import com.linkedin.databus.client.pub.ServerInfo;
import com.linkedin.databus.client.registration.DatabusMultiPartitionRegistration;
import com.linkedin.databus.core.DatabusComponentStatus;
import com.linkedin.databus.core.data_model.DatabusSubscription;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class RegistrationStatsInfo {
    private RegistrationId regId;
    private RegistrationId parentRegId;
    private Collection<DatabusSubscription> subscriptions;
    private ServerInfo currentRelay;
    private ServerInfo currentBootstrapServer;
    private Set<ServerInfo> candidateRelays;
    private Set<ServerInfo> candidateBootstrapServers;
    private DispatcherState.StateId relayDispatcherConnectionState;
    private DispatcherState.StateId bootstrapDispatcherConnectionState;
    private ConnectionState.StateId relayPullerConnectionState;
    private ConnectionState.StateId bootstrapPullerConnectionState;
    private DatabusComponentStatus.Status relayDispatcherComponentStatus;
    private DatabusComponentStatus.Status bootstrapDispatcherComponentStatus;
    private DatabusComponentStatus.Status relayPullerComponentStatus;
    private DatabusComponentStatus.Status bootstrapPullerComponentStatus;
    private boolean _multiPartition = false;
    private List<RegistrationId> _childrenRegistrations = Collections.emptyList();
    private SCN _highWatermark;

    public RegistrationStatsInfo() {
    }

    public RegistrationStatsInfo(DatabusRegistration reg, DatabusSourcesConnection sourcesConn) {
        this.setRegId(reg.getRegistrationId());
        this.setParentRegId(null != reg.getParent() ? reg.getParent().getRegistrationId() : null);
        this.setSubscriptions(reg.getSubscriptions());
        if (reg instanceof DatabusMultiPartitionRegistration) {
            DatabusMultiPartitionRegistration mpReg = (DatabusMultiPartitionRegistration)reg;
            this.setMultiPartition(true);
            ArrayList<RegistrationId> childrenRegs = new ArrayList<RegistrationId>(mpReg.getPartitions().size());
            for (Map.Entry<DbusPartitionInfo, DatabusRegistration> child : mpReg.getPartitionRegs().entrySet()) {
                childrenRegs.add(child.getValue().getRegistrationId());
            }
            this.setChildrenRegistrations(childrenRegs);
        }
        this.initSourcesConn(sourcesConn);
    }

    public RegistrationStatsInfo(DatabusV3Registration reg, DatabusSourcesConnection sourcesConn) {
        this.setRegId(reg.getId());
        this.setParentRegId(null != reg.getParentRegistration() ? reg.getParentRegistration().getId() : null);
        this.setSubscriptions(reg.getSubscriptions());
        if (reg instanceof DatabusV3MultiPartitionRegistration) {
            DatabusV3MultiPartitionRegistration mpReg = (DatabusV3MultiPartitionRegistration)reg;
            this.setMultiPartition(true);
            ArrayList<RegistrationId> childrenRegs = new ArrayList<RegistrationId>(mpReg.getPartionRegs().size());
            for (Map.Entry child : mpReg.getPartionRegs().entrySet()) {
                childrenRegs.add(((DatabusV3Registration)child.getValue()).getId());
            }
            this.setChildrenRegistrations(childrenRegs);
        }
        this.initSourcesConn(sourcesConn);
    }

    private void initSourcesConn(DatabusSourcesConnection sourcesConn) {
        if (null != sourcesConn) {
            RelayPullThread rp = sourcesConn.getRelayPullThread();
            BootstrapPullThread bp = sourcesConn.getBootstrapPullThread();
            GenericDispatcher<DatabusCombinedConsumer> rd = sourcesConn.getRelayDispatcher();
            GenericDispatcher<DatabusCombinedConsumer> bd = sourcesConn.getBootstrapDispatcher();
            if (null != rp) {
                this.setRelayPullerConnectionState(rp.getConnectionState().getStateId());
                if (null != rp.getComponentStatus()) {
                    this.setRelayPullerComponentStatus(rp.getComponentStatus().getStatus());
                }
                this.setCurrentRelay(rp.getCurentServer());
                this.setCandidateRelays(rp.getServers());
            }
            if (null != bp) {
                this.setBootstrapPullerConnectionState(bp.getConnectionState().getStateId());
                if (null != bp.getComponentStatus()) {
                    this.setBootstrapPullerComponentStatus(bp.getComponentStatus().getStatus());
                }
                this.setCurrentBootstrapServer(bp.getCurentServer());
                this.setCandidateBootstrapServers(bp.getServers());
            }
            if (null != rd) {
                if (null != rd.getComponentStatus()) {
                    this.setRelayDispatcherComponentStatus(rd.getComponentStatus().getStatus());
                }
                if (null != rd.getDispatcherState()) {
                    this.setRelayDispatcherConnectionState(rd.getDispatcherState().getStateId());
                }
            }
            if (null != bd) {
                if (null != bd.getComponentStatus()) {
                    this.setBootstrapDispatcherComponentStatus(bd.getComponentStatus().getStatus());
                }
                if (null != bd.getDispatcherState()) {
                    this.setBootstrapDispatcherConnectionState(bd.getDispatcherState().getStateId());
                }
            }
        }
    }

    public RegistrationId getRegId() {
        return this.regId;
    }

    public void setRegId(RegistrationId regId) {
        this.regId = regId;
    }

    public RegistrationId getParentRegId() {
        return this.parentRegId;
    }

    public void setParentRegId(RegistrationId regId) {
        this.parentRegId = regId;
    }

    public Collection<DatabusSubscription> getSubscriptions() {
        return this.subscriptions;
    }

    public void setSubscriptions(Collection<DatabusSubscription> subscriptions) {
        this.subscriptions = subscriptions;
    }

    public ServerInfo getCurrentRelay() {
        return this.currentRelay;
    }

    public void setCurrentRelay(ServerInfo currentRelay) {
        this.currentRelay = currentRelay;
    }

    public ServerInfo getCurrentBootstrapServer() {
        return this.currentBootstrapServer;
    }

    public void setCurrentBootstrapServer(ServerInfo currentBootstrapServer) {
        this.currentBootstrapServer = currentBootstrapServer;
    }

    public Set<ServerInfo> getCandidateRelays() {
        return this.candidateRelays;
    }

    public void setCandidateRelays(Set<ServerInfo> candidateRelays) {
        this.candidateRelays = candidateRelays;
    }

    public Set<ServerInfo> getCandidateBootstrapServers() {
        return this.candidateBootstrapServers;
    }

    public void setCandidateBootstrapServers(Set<ServerInfo> candidateBootstrapServers) {
        this.candidateBootstrapServers = candidateBootstrapServers;
    }

    public DispatcherState.StateId getRelayDispatcherConnectionState() {
        return this.relayDispatcherConnectionState;
    }

    public void setRelayDispatcherConnectionState(DispatcherState.StateId relayDispatcherConnectionState) {
        this.relayDispatcherConnectionState = relayDispatcherConnectionState;
    }

    public DispatcherState.StateId getBootstrapDispatcherConnectionState() {
        return this.bootstrapDispatcherConnectionState;
    }

    public void setBootstrapDispatcherConnectionState(DispatcherState.StateId bootstrapDispatcherConnectionState) {
        this.bootstrapDispatcherConnectionState = bootstrapDispatcherConnectionState;
    }

    public ConnectionState.StateId getRelayPullerConnectionState() {
        return this.relayPullerConnectionState;
    }

    public void setRelayPullerConnectionState(ConnectionState.StateId relayPullerConnectionState) {
        this.relayPullerConnectionState = relayPullerConnectionState;
    }

    public ConnectionState.StateId getBootstrapPullerConnectionState() {
        return this.bootstrapPullerConnectionState;
    }

    public void setBootstrapPullerConnectionState(ConnectionState.StateId bootstrapPullerConnectionState) {
        this.bootstrapPullerConnectionState = bootstrapPullerConnectionState;
    }

    public DatabusComponentStatus.Status getRelayDispatcherComponentStatus() {
        return this.relayDispatcherComponentStatus;
    }

    public void setRelayDispatcherComponentStatus(DatabusComponentStatus.Status relayDispatcherComponentStatus) {
        this.relayDispatcherComponentStatus = relayDispatcherComponentStatus;
    }

    public DatabusComponentStatus.Status getBootstrapDispatcherComponentStatus() {
        return this.bootstrapDispatcherComponentStatus;
    }

    public void setBootstrapDispatcherComponentStatus(DatabusComponentStatus.Status bootstrapDispatcherComponentStatus) {
        this.bootstrapDispatcherComponentStatus = bootstrapDispatcherComponentStatus;
    }

    public DatabusComponentStatus.Status getRelayPullerComponentStatus() {
        return this.relayPullerComponentStatus;
    }

    public void setRelayPullerComponentStatus(DatabusComponentStatus.Status relayPullerComponentStatus) {
        this.relayPullerComponentStatus = relayPullerComponentStatus;
    }

    public DatabusComponentStatus.Status getBootstrapPullerComponentStatus() {
        return this.bootstrapPullerComponentStatus;
    }

    public void setBootstrapPullerComponentStatus(DatabusComponentStatus.Status bootstrapPullerComponentStatus) {
        this.bootstrapPullerComponentStatus = bootstrapPullerComponentStatus;
    }

    public boolean isMultiPartition() {
        return this._multiPartition;
    }

    public void setMultiPartition(boolean multiPartition) {
        this._multiPartition = multiPartition;
    }

    public List<RegistrationId> getChildrenRegistrations() {
        return this._childrenRegistrations;
    }

    public void setChildrenRegistrations(List<RegistrationId> childrenRegistrations) {
        this._childrenRegistrations = childrenRegistrations;
    }

    public SCN getHighWatermark() {
        return this._highWatermark;
    }

    public void setHighWatermark(SCN highWatermark) {
        this._highWatermark = highWatermark;
    }
}

