/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.client.generic;

import com.linkedin.databus.client.DatabusHttpClientImpl;
import com.linkedin.databus.client.generic.ConsumerPauseRequestProcessor;
import com.linkedin.databus.client.generic.DatabusFileLoggingConsumer;
import com.linkedin.databus.client.pub.DatabusCombinedConsumer;
import com.linkedin.databus.client.pub.DatabusRegistration;
import com.linkedin.databus.client.pub.ServerInfo;
import com.linkedin.databus.client.registration.DatabusV2RegistrationImpl;
import com.linkedin.databus.core.util.ConfigBuilder;
import com.linkedin.databus.core.util.ConfigLoader;
import com.linkedin.databus.core.util.InvalidConfigException;
import com.linkedin.databus2.core.container.netty.ServerContainer;
import com.linkedin.databus2.core.container.request.ContainerOperationProcessor;
import com.linkedin.databus2.core.container.request.ProcessorRegistrationConflictException;
import com.linkedin.databus2.core.container.request.RequestProcessor;
import com.linkedin.databus2.core.filter.DbusKeyCompositeFilterConfig;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.log4j.Logger;

public class SimpleFileLoggingConsumer {
    public static final String MODULE = SimpleFileLoggingConsumer.class.getName();
    public static final Logger LOG = Logger.getLogger((String)MODULE);
    public static final String RELAY_HOST_OPT_NAME = "relay_host";
    public static final String RELAY_PORT_OPT_NAME = "relay_port";
    public static final String EVENT_DUMP_FILE_OPT_NAME = "f";
    public static final String VALUE_DUMP_FILE_OPT_NAME = "value_file";
    public static final String HTTP_PORT_OPT_NAME = "http_port";
    public static final String JMX_SERVICE_PORT_OPT_NAME = "jmx_service_port";
    public static final String CHECKPOINT_DIR = "checkpoint_dir";
    public static final String BOOTSTRAP_HOST_OPT_NAME = "bootstrap_host";
    public static final String BOOTSTRAP_PORT_OPT_NAME = "bootstrap_port";
    public static final String EVENT_PATTERN_OPT_NAME = "event_pattern";
    public static final String FILTER_CONF_FILE_OPT_NAME = "filter_conf_file";
    public static final String SERVER_SIDE_FILTER_PREFIX = "serversidefilter.";
    public static final String SOURCES_OPT_NAME = "sources";
    private static String _eventDumpFile = null;
    private static String _valueDumpFile = null;
    private static String _relayHost = null;
    private static String _relayPort = null;
    private static String _bootstrapHost = null;
    private static String _bootstrapPort = null;
    private static String _httpPort = null;
    private static String _jmxServicePort = null;
    private static String _checkpointFileRootDir = null;
    private static String _eventPattern = null;
    private static boolean _enableBootStrap = false;
    private static String _filterConfFile = null;
    private static String[] _sources = null;

    protected static Options constructCommandLineOptions() {
        Options options = new Options();
        options.addOption(RELAY_HOST_OPT_NAME, true, "Relay Host Name");
        options.addOption(RELAY_PORT_OPT_NAME, true, "Relay Port");
        options.addOption(EVENT_DUMP_FILE_OPT_NAME, true, "File to dump event");
        options.addOption(VALUE_DUMP_FILE_OPT_NAME, true, "File to dump deserilized values");
        options.addOption(HTTP_PORT_OPT_NAME, true, "Consumer http port");
        options.addOption(JMX_SERVICE_PORT_OPT_NAME, true, "Consumer jmx service port");
        options.addOption(CHECKPOINT_DIR, true, "Checkpoint dir");
        options.addOption(BOOTSTRAP_HOST_OPT_NAME, true, "Bootstrap server Name");
        options.addOption(BOOTSTRAP_PORT_OPT_NAME, true, "Bootstrap server Port");
        options.addOption(EVENT_PATTERN_OPT_NAME, true, "Event Pattern Name to Check");
        options.addOption(FILTER_CONF_FILE_OPT_NAME, true, "Server Side Filter Config");
        options.addOption(SOURCES_OPT_NAME, true, "Comma seperated source names");
        return options;
    }

    protected static String[] processLocalArgs(String[] cliArgs) throws IOException, ParseException {
        GnuParser cliParser = new GnuParser();
        Options cliOptions = SimpleFileLoggingConsumer.constructCommandLineOptions();
        CommandLine cmd = cliParser.parse(cliOptions, cliArgs, true);
        if (cmd.hasOption(RELAY_HOST_OPT_NAME)) {
            _relayHost = cmd.getOptionValue(RELAY_HOST_OPT_NAME);
            LOG.info((Object)("Relay Host = " + _relayHost));
        }
        if (cmd.hasOption(RELAY_PORT_OPT_NAME)) {
            _relayPort = cmd.getOptionValue(RELAY_PORT_OPT_NAME);
            LOG.info((Object)("Relay Port = " + _relayPort));
        }
        if (cmd.hasOption(EVENT_DUMP_FILE_OPT_NAME)) {
            _eventDumpFile = cmd.getOptionValue(EVENT_DUMP_FILE_OPT_NAME);
            LOG.info((Object)("Saving event dump to file: " + _eventDumpFile));
        }
        if (cmd.hasOption(VALUE_DUMP_FILE_OPT_NAME)) {
            _valueDumpFile = cmd.getOptionValue(VALUE_DUMP_FILE_OPT_NAME);
            LOG.info((Object)("Saving event value dump to file: " + _valueDumpFile));
        }
        if (cmd.hasOption(HTTP_PORT_OPT_NAME)) {
            _httpPort = cmd.getOptionValue(HTTP_PORT_OPT_NAME);
            LOG.info((Object)("Consumer http port =  " + _httpPort));
        }
        if (cmd.hasOption(JMX_SERVICE_PORT_OPT_NAME)) {
            _jmxServicePort = cmd.getOptionValue(JMX_SERVICE_PORT_OPT_NAME);
            LOG.info((Object)("Consumer JMX Service port =  " + _jmxServicePort));
        }
        if (cmd.hasOption(CHECKPOINT_DIR)) {
            _checkpointFileRootDir = cmd.getOptionValue(CHECKPOINT_DIR);
            LOG.info((Object)("Checkpoint dir =  " + _checkpointFileRootDir));
        }
        if (cmd.hasOption(BOOTSTRAP_HOST_OPT_NAME)) {
            _bootstrapHost = cmd.getOptionValue(BOOTSTRAP_HOST_OPT_NAME);
            LOG.info((Object)("Bootstrap Server = " + _bootstrapHost));
        }
        if (cmd.hasOption(BOOTSTRAP_PORT_OPT_NAME)) {
            _bootstrapPort = cmd.getOptionValue(BOOTSTRAP_PORT_OPT_NAME);
            LOG.info((Object)("Bootstrap Server Port = " + _bootstrapPort));
        }
        if (cmd.hasOption(EVENT_PATTERN_OPT_NAME)) {
            _eventPattern = cmd.getOptionValue(EVENT_PATTERN_OPT_NAME);
            LOG.info((Object)("Event pattern = " + _eventPattern));
        }
        if (_bootstrapHost != null || _bootstrapPort != null) {
            _enableBootStrap = true;
        }
        if (cmd.hasOption(FILTER_CONF_FILE_OPT_NAME)) {
            _filterConfFile = cmd.getOptionValue(FILTER_CONF_FILE_OPT_NAME);
            LOG.info((Object)("Server Side Filtering Config File =" + _filterConfFile));
        }
        if (cmd.hasOption(SOURCES_OPT_NAME)) {
            _sources = cmd.getOptionValue(SOURCES_OPT_NAME).split(",");
            LOG.info((Object)("Sources to be subscribed are =" + Arrays.toString(_sources)));
        }
        return cmd.getArgs();
    }

    protected String[] addSources() {
        return _sources;
    }

    protected DatabusFileLoggingConsumer createTypedConsumer(String valueDumpFile) throws IOException {
        return this.createTypedConsumer(valueDumpFile, null);
    }

    protected DatabusFileLoggingConsumer createTypedConsumer(String valueDumpFile, String eventDumpFile) throws IOException {
        return new DatabusFileLoggingConsumer(valueDumpFile, null, eventDumpFile, false);
    }

    public void mainFunction(String[] args) throws Exception {
        DatabusRegistration reg;
        String[] leftOverArgs = SimpleFileLoggingConsumer.processLocalArgs(args);
        Properties startupProps = DatabusHttpClientImpl.processCommandLineArgs((String[])leftOverArgs);
        DatabusHttpClientImpl.Config clientConfigBuilder = new DatabusHttpClientImpl.Config();
        clientConfigBuilder.getContainer().setIdFromName(MODULE + ".localhost");
        if (_enableBootStrap) {
            clientConfigBuilder.getRuntime().getBootstrap().setEnabled(true);
        }
        ConfigLoader configLoader = new ConfigLoader("databus.client.", (ConfigBuilder)clientConfigBuilder);
        String[] sources = this.addSources();
        StringBuilder sourcesString = new StringBuilder();
        boolean firstSrc = true;
        for (String source : sources) {
            if (!firstSrc) {
                sourcesString.append(",");
            }
            firstSrc = false;
            sourcesString.append(source);
        }
        if (_httpPort != null) {
            startupProps.put("databus.client.container.httpPort", _httpPort);
        }
        if (_jmxServicePort != null) {
            startupProps.put("databus.client.container.jmx.jmxServicePort", _jmxServicePort);
        }
        if (_checkpointFileRootDir != null) {
            startupProps.put("databus.client.checkpointPersistence.fileSystem.rootDirectory", _checkpointFileRootDir);
        }
        DatabusHttpClientImpl.StaticConfig clientConfig = (DatabusHttpClientImpl.StaticConfig)configLoader.loadConfig((Map)startupProps);
        ServerInfo.ServerInfoBuilder relayBuilder = clientConfig.getRuntime().getRelay("1");
        relayBuilder.setName("DefaultRelay");
        if (_relayHost != null) {
            relayBuilder.setHost(_relayHost);
        }
        if (_relayPort != null) {
            relayBuilder.setPort(Integer.parseInt(_relayPort));
        }
        relayBuilder.setSources(sourcesString.toString());
        if (_enableBootStrap) {
            ServerInfo.ServerInfoBuilder bootstrapBuilder = clientConfig.getRuntime().getBootstrap().getService("2");
            bootstrapBuilder.setName("DefaultBootstrapServices");
            if (_bootstrapHost != null) {
                bootstrapBuilder.setHost(_bootstrapHost);
            }
            if (_bootstrapPort != null) {
                bootstrapBuilder.setPort(Integer.parseInt(_bootstrapPort));
            }
            bootstrapBuilder.setSources(sourcesString.toString());
        }
        DbusKeyCompositeFilterConfig filterConfig = this.createServerSideFilterConfig(_filterConfFile, startupProps);
        DatabusHttpClientImpl client = new DatabusHttpClientImpl(clientConfig);
        DatabusFileLoggingConsumer consumer = this.createTypedConsumer(_valueDumpFile, _eventDumpFile);
        if (_eventPattern != null) {
            consumer.setEventPattern(_eventPattern);
        }
        if (!((reg = client.register((DatabusCombinedConsumer)consumer, sources)) instanceof DatabusV2RegistrationImpl)) {
            throw new RuntimeException("Unexpected type for registration Object !!");
        }
        if (null != filterConfig) {
            reg.withServerSideFilter(filterConfig);
        }
        try {
            client.getProcessorRegistry().register("pauseConsumer", (RequestProcessor)new ConsumerPauseRequestProcessor(null, consumer));
            client.getProcessorRegistry().register("operation", (RequestProcessor)new ContainerOperationProcessor(null, (ServerContainer)client));
        }
        catch (ProcessorRegistrationConflictException e) {
            LOG.error((Object)"Failed to register pauseConsumer");
        }
        DatabusClientShutdownThread shutdownThread = new DatabusClientShutdownThread(client);
        Runtime.getRuntime().addShutdownHook(shutdownThread);
        client.startAndBlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DbusKeyCompositeFilterConfig createServerSideFilterConfig(String filterConfFile, Properties startupProps) throws IOException, InvalidConfigException {
        Boolean cmdLineHasFilterConfig = this.hasServerSideFilterConfig(startupProps);
        if (filterConfFile != null || cmdLineHasFilterConfig.booleanValue()) {
            Properties props;
            if (cmdLineHasFilterConfig.booleanValue()) {
                props = startupProps;
            } else {
                LOG.info((Object)("filterConfFile = " + filterConfFile));
                props = new Properties();
                FileInputStream filterConfStream = new FileInputStream(filterConfFile);
                try {
                    props.load(filterConfStream);
                }
                finally {
                    filterConfStream.close();
                }
            }
            DbusKeyCompositeFilterConfig.Config conf = new DbusKeyCompositeFilterConfig.Config();
            ConfigLoader filterConfigLoader = new ConfigLoader(SERVER_SIDE_FILTER_PREFIX, (ConfigBuilder)conf);
            DbusKeyCompositeFilterConfig.StaticConfig sConf = (DbusKeyCompositeFilterConfig.StaticConfig)filterConfigLoader.loadConfig((Map)props);
            return new DbusKeyCompositeFilterConfig(sConf);
        }
        return null;
    }

    private Boolean hasServerSideFilterConfig(Properties startupProps) {
        Enumeration<Object> propKeys = startupProps.keys();
        while (propKeys.hasMoreElements()) {
            String key = (String)propKeys.nextElement();
            if (!key.contains(SERVER_SIDE_FILTER_PREFIX)) continue;
            return true;
        }
        return false;
    }

    static class DatabusClientShutdownThread
    extends Thread {
        public static final String MODULE = DatabusClientShutdownThread.class.getName();
        public static final Logger LOG = Logger.getLogger((String)MODULE);
        private final ServerContainer _serverContainer;

        public DatabusClientShutdownThread(ServerContainer serverContainer) {
            super("ServerContainer Shutdown Thread");
            this._serverContainer = serverContainer;
        }

        @Override
        public void run() {
            LOG.info((Object)"Starting shutdown procedure for server container...");
            try {
                if (null != this._serverContainer && this._serverContainer.isRunningStatus()) {
                    this._serverContainer.shutdownUninteruptibly();
                }
                LOG.info((Object)"Server Container shutdown.");
            }
            catch (Exception e) {
                LOG.error((Object)"Error shutting down Server Container", (Throwable)e);
            }
        }
    }
}

