/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.client.generic;

import com.linkedin.databus.client.ClientFileBasedEventTrackingCallback;
import com.linkedin.databus.client.ClientFileBasedMetadataTrackingCallback;
import com.linkedin.databus.client.DbusEventAvroDecoder;
import com.linkedin.databus.client.consumer.AbstractDatabusCombinedConsumer;
import com.linkedin.databus.client.generic.DatabusConsumerPauseInterface;
import com.linkedin.databus.client.pub.ConsumerCallbackResult;
import com.linkedin.databus.client.pub.DbusEventDecoder;
import com.linkedin.databus.client.pub.SCN;
import com.linkedin.databus.core.DbusEvent;
import com.linkedin.databus.core.FileBasedEventTrackingCallback;
import com.linkedin.databus.core.util.ConfigBuilder;
import com.linkedin.databus.core.util.InvalidConfigException;
import java.io.IOException;
import org.apache.avro.Schema;
import org.apache.log4j.Logger;

public class DatabusFileLoggingConsumer
extends AbstractDatabusCombinedConsumer
implements DatabusConsumerPauseInterface {
    public static final String MODULE = DatabusFileLoggingConsumer.class.getName();
    public static final Logger LOG = Logger.getLogger((String)MODULE);
    private ClientFileBasedEventTrackingCallback _fileBasedDecodedValueCallback = null;
    private ClientFileBasedMetadataTrackingCallback _fileBasedMetadataCallback = null;
    private FileBasedEventTrackingCallback _fileBasedRawEventCallback = null;
    private boolean _isPaused;
    private String _EventPattern = null;

    public DatabusFileLoggingConsumer(StaticConfig config) throws IOException {
        this(config.getValueDumpFile(), config.getMetadataDumpFile(), config.getEventDumpFile(), config.isAppendOnly());
    }

    public DatabusFileLoggingConsumer(String valueDumpFile, boolean appendOnly) throws IOException {
        this(valueDumpFile, null, null, appendOnly);
    }

    public DatabusFileLoggingConsumer(String valueDumpFile, String metadataDumpFile, String eventDumpFile, boolean appendOnly) throws IOException {
        LOG.info((Object)("DatabusFileLoggingConsumer instantiated with payload-value dump file: " + valueDumpFile + ", metadata dump file: " + metadataDumpFile + ", raw-event dump file: " + eventDumpFile + ", appendOnly: " + appendOnly));
        if (valueDumpFile != null) {
            this._fileBasedDecodedValueCallback = new ClientFileBasedEventTrackingCallback(valueDumpFile, appendOnly);
            this._fileBasedDecodedValueCallback.init();
        }
        if (metadataDumpFile != null) {
            this._fileBasedMetadataCallback = new ClientFileBasedMetadataTrackingCallback(metadataDumpFile, appendOnly);
            this._fileBasedMetadataCallback.init();
        }
        if (eventDumpFile != null) {
            this._fileBasedRawEventCallback = new FileBasedEventTrackingCallback(eventDumpFile, appendOnly);
            this._fileBasedRawEventCallback.init();
        }
    }

    public ConsumerCallbackResult onCheckpoint(SCN checkpointScn) {
        this.waitIfPaused();
        LOG.info((Object)("startEvents:" + checkpointScn.toString()));
        return ConsumerCallbackResult.SUCCESS;
    }

    protected void LogTypedValue(DbusEvent e, DbusEventDecoder eventDecoder) {
        LOG.info((Object)"Log Typed Value");
    }

    public ConsumerCallbackResult onDataEvent(DbusEvent e, DbusEventDecoder eventDecoder) {
        this.waitIfPaused();
        if (!e.isValid()) {
            throw new RuntimeException("Got invalid event!!!");
        }
        if (this._fileBasedDecodedValueCallback != null) {
            this._fileBasedDecodedValueCallback.dumpEventValue(e, eventDecoder);
        }
        if (this._fileBasedMetadataCallback != null && eventDecoder instanceof DbusEventAvroDecoder) {
            this._fileBasedMetadataCallback.dumpEventMetadata(e, (DbusEventAvroDecoder)eventDecoder);
        }
        if (this._fileBasedRawEventCallback != null) {
            this._fileBasedRawEventCallback.onEvent(e);
        }
        this.LogTypedValue(e, eventDecoder);
        return ConsumerCallbackResult.SUCCESS;
    }

    public ConsumerCallbackResult onEndDataEventSequence(SCN endScn) {
        this.waitIfPaused();
        LOG.info((Object)("endEvents:" + endScn));
        return ConsumerCallbackResult.SUCCESS;
    }

    public ConsumerCallbackResult onEndSource(String source, Schema sourceSchema) {
        this.waitIfPaused();
        LOG.info((Object)("endSource:" + source));
        return ConsumerCallbackResult.SUCCESS;
    }

    public ConsumerCallbackResult onRollback(SCN startScn) {
        this.waitIfPaused();
        LOG.info((Object)("rollback:" + startScn));
        return ConsumerCallbackResult.SUCCESS;
    }

    public ConsumerCallbackResult onStartDataEventSequence(SCN startScn) {
        this.waitIfPaused();
        LOG.info((Object)("startDataEventSequence:" + startScn));
        return ConsumerCallbackResult.SUCCESS;
    }

    public ConsumerCallbackResult onStartSource(String source, Schema sourceSchema) {
        this.waitIfPaused();
        LOG.info((Object)("startSource:" + source));
        return ConsumerCallbackResult.SUCCESS;
    }

    public ConsumerCallbackResult onBootstrapEvent(DbusEvent e, DbusEventDecoder eventDecoder) {
        this.waitIfPaused();
        if (!e.isValid()) {
            throw new RuntimeException("Got invalid event!!!");
        }
        if (this._fileBasedDecodedValueCallback != null) {
            this._fileBasedDecodedValueCallback.dumpEventValue(e, eventDecoder);
        }
        if (this._fileBasedRawEventCallback != null) {
            this._fileBasedRawEventCallback.onEvent(e);
        }
        this.LogTypedValue(e, eventDecoder);
        this.printBootstrapEventInfo(BootstrapStage.OnBootstrapEvent, e.toString());
        return ConsumerCallbackResult.SUCCESS;
    }

    @Override
    public synchronized void pause() {
        this._isPaused = true;
        LOG.info((Object)"Consumer is set to pause!");
    }

    @Override
    public synchronized void resume() {
        this._isPaused = false;
        this.notifyAll();
        LOG.info((Object)"Consumer is set to resume!");
    }

    @Override
    public synchronized void waitIfPaused() {
        while (this._isPaused) {
            LOG.info((Object)"Consumer is paused!");
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public ConsumerCallbackResult onStartBootstrapSequence(SCN startScn) {
        this.waitIfPaused();
        this.printBootstrapEventInfo(BootstrapStage.StartBootstrapSequence, startScn.toString());
        return ConsumerCallbackResult.SUCCESS;
    }

    public ConsumerCallbackResult onEndBootstrapSequence(SCN endScn) {
        this.waitIfPaused();
        this.printBootstrapEventInfo(BootstrapStage.EndBootstrapSequence, endScn.toString());
        return ConsumerCallbackResult.SUCCESS;
    }

    public ConsumerCallbackResult onStartBootstrapSource(String name, Schema sourceSchema) {
        this.waitIfPaused();
        this.printBootstrapEventInfo(BootstrapStage.StartBootstrapSource, name);
        return ConsumerCallbackResult.SUCCESS;
    }

    public ConsumerCallbackResult onEndBootstrapSource(String name, Schema sourceSchema) {
        this.waitIfPaused();
        this.printBootstrapEventInfo(BootstrapStage.EndBootstrapSource, name);
        return ConsumerCallbackResult.SUCCESS;
    }

    public ConsumerCallbackResult onBootstrapCheckpoint(SCN batchCheckpointScn) {
        this.waitIfPaused();
        this.printBootstrapEventInfo(BootstrapStage.OnCheckpointEvent, batchCheckpointScn.toString());
        return ConsumerCallbackResult.SUCCESS;
    }

    public ConsumerCallbackResult onError(Throwable err) {
        return ConsumerCallbackResult.SUCCESS;
    }

    public ConsumerCallbackResult onBootstrapError(Throwable err) {
        return ConsumerCallbackResult.SUCCESS;
    }

    protected void printBootstrapEventInfo(BootstrapStage stage, String info) {
        LOG.info((Object)((Object)((Object)stage) + ": " + info));
    }

    public ConsumerCallbackResult onStartBootstrap() {
        this.waitIfPaused();
        LOG.info((Object)"startBootstrap");
        return ConsumerCallbackResult.SUCCESS;
    }

    public ConsumerCallbackResult onStopBootstrap() {
        this.waitIfPaused();
        LOG.info((Object)"stopBootstrap");
        return ConsumerCallbackResult.SUCCESS;
    }

    public ConsumerCallbackResult onBootstrapRollback(SCN batchCheckpointScn) {
        this.waitIfPaused();
        LOG.info((Object)("startBootstrapRollback:" + batchCheckpointScn.toString()));
        return ConsumerCallbackResult.SUCCESS;
    }

    public ConsumerCallbackResult onStartConsumption() {
        this.waitIfPaused();
        LOG.info((Object)"startConsumption");
        return ConsumerCallbackResult.SUCCESS;
    }

    public ConsumerCallbackResult onStopConsumption() {
        this.waitIfPaused();
        LOG.info((Object)"stopConsumption");
        return ConsumerCallbackResult.SUCCESS;
    }

    public String getEventPattern() {
        return this._EventPattern;
    }

    public Boolean isCheckingEventPattern() {
        return this._EventPattern != null;
    }

    public void setEventPattern(String checkEventPattern) {
        this._EventPattern = checkEventPattern;
    }

    static enum BootstrapStage {
        StartBootstrapSequence,
        EndBootstrapSequence,
        OnBootstrapEvent,
        OnCheckpointEvent,
        StartBootstrapSource,
        EndBootstrapSource;

    }

    static enum StreamStage {
        StartDataEventSequence,
        EndDataEventSequence,
        OnStreamEvent,
        OnCheckpointEvent,
        StartStreamSource,
        EndStreamSource,
        InvalidStage;

    }

    public static class StaticConfigBuilder
    implements ConfigBuilder<StaticConfig> {
        private String _valueDumpFile;
        private String _metadataDumpFile;
        private String _eventDumpFile;
        private boolean _appendOnly = false;

        public String getValueDumpFile() {
            return this._valueDumpFile;
        }

        public String getMetadataDumpFile() {
            return this._metadataDumpFile;
        }

        public String getEventDumpFile() {
            return this._eventDumpFile;
        }

        public void setValueDumpFile(String valueDumpFile) {
            this._valueDumpFile = valueDumpFile;
        }

        public void setMetadataDumpFile(String metadataDumpFile) {
            this._metadataDumpFile = metadataDumpFile;
        }

        public void setEventDumpFile(String eventDumpFile) {
            this._eventDumpFile = eventDumpFile;
        }

        public boolean getAppendOnly() {
            return this._appendOnly;
        }

        public void setAppendOnly(boolean appendOnly) {
            this._appendOnly = appendOnly;
        }

        public StaticConfig build() throws InvalidConfigException {
            return new StaticConfig(this._valueDumpFile, this._metadataDumpFile, this._eventDumpFile, this._appendOnly);
        }
    }

    public static class StaticConfig {
        private final String _valueDumpFile;
        private final String _metadataDumpFile;
        private final String _eventDumpFile;
        private boolean _append;

        public String getValueDumpFile() {
            return this._valueDumpFile;
        }

        public String getMetadataDumpFile() {
            return this._metadataDumpFile;
        }

        public String getEventDumpFile() {
            return this._eventDumpFile;
        }

        public boolean isAppendOnly() {
            return this._append;
        }

        public StaticConfig(String valueDumpFile, String metadataDumpFile, String eventDumpFile, boolean append) {
            this._valueDumpFile = valueDumpFile;
            this._metadataDumpFile = metadataDumpFile;
            this._eventDumpFile = eventDumpFile;
            this._append = append;
        }
    }
}

