/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.client.generic;

import com.linkedin.databus.client.generic.DatabusConsumerPauseInterface;
import com.linkedin.databus2.core.container.request.DatabusRequest;
import com.linkedin.databus2.core.container.request.InvalidRequestParamValueException;
import com.linkedin.databus2.core.container.request.RequestProcessingException;
import com.linkedin.databus2.core.container.request.RequestProcessor;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.concurrent.ExecutorService;
import org.apache.log4j.Logger;

public class ConsumerPauseRequestProcessor
implements RequestProcessor {
    public static final String MODULE = ConsumerPauseRequestProcessor.class.getName();
    public static final Logger LOG = Logger.getLogger((String)MODULE);
    public static final String COMMAND_NAME = "pauseConsumer";
    private final ExecutorService _executorService;
    private final DatabusConsumerPauseInterface _pauseConsumer;

    public ConsumerPauseRequestProcessor(ExecutorService executorService, DatabusConsumerPauseInterface pauseConsumer) {
        this._executorService = executorService;
        this._pauseConsumer = pauseConsumer;
    }

    public ExecutorService getExecutorService() {
        return this._executorService;
    }

    public DatabusRequest process(DatabusRequest request) throws IOException, RequestProcessingException {
        String action = request.getParams().getProperty("reqpath", "");
        if (action.equals("pause")) {
            this._pauseConsumer.pause();
            request.getResponseContent().write(ByteBuffer.wrap("{\"pauseConsumer\":\"set-pause\"}".getBytes(Charset.defaultCharset())));
        } else if (action.equals("resume")) {
            this._pauseConsumer.resume();
            request.getResponseContent().write(ByteBuffer.wrap("{\"pauseConsumer\":\"set-resume\"}".getBytes(Charset.defaultCharset())));
        } else {
            throw new InvalidRequestParamValueException(COMMAND_NAME, "request path", action);
        }
        return request;
    }
}

