/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.client;

import com.linkedin.databus.core.util.IdNamePair;
import com.linkedin.databus2.core.container.request.RegisterResponseEntry;
import com.linkedin.databus2.core.container.request.RegisterResponseMetadataEntry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class SourcesMessage {
    private TypeId _typeId;
    private List<IdNamePair> _sources;
    private String _sourcesIdListString;
    private Map<Long, List<RegisterResponseEntry>> _sourcesSchemas;
    private final List<RegisterResponseMetadataEntry> _metadataSchemas;

    private SourcesMessage(TypeId typeId, List<IdNamePair> sources, String sourcesIdListString, Map<Long, List<RegisterResponseEntry>> sourcesSchemas) {
        this(typeId, sources, sourcesIdListString, sourcesSchemas, null);
    }

    private SourcesMessage(TypeId typeId, List<IdNamePair> sources, String sourcesIdListString, Map<Long, List<RegisterResponseEntry>> sourcesSchemas, List<RegisterResponseMetadataEntry> metadataSchemas) {
        this._typeId = typeId;
        this._sources = sources;
        this._sourcesIdListString = sourcesIdListString;
        this._sourcesSchemas = sourcesSchemas;
        this._metadataSchemas = metadataSchemas;
    }

    public static SourcesMessage createSetSourcesIdsMessage(List<IdNamePair> sources, String sourcesIdListString) {
        return new SourcesMessage(TypeId.SET_SOURCES_IDS, sources, sourcesIdListString, null);
    }

    public static SourcesMessage createSetSourcesSchemasMessage(Map<Long, List<RegisterResponseEntry>> sourcesSchemas, List<RegisterResponseMetadataEntry> metadataSchemas) {
        return new SourcesMessage(TypeId.SET_SOURCES_SCHEMAS, null, null, sourcesSchemas, metadataSchemas);
    }

    public static SourcesMessage createSetSourcesSchemasMessage(Map<Long, List<RegisterResponseEntry>> sourcesSchemas) {
        return new SourcesMessage(TypeId.SET_SOURCES_SCHEMAS, null, null, sourcesSchemas, null);
    }

    public SourcesMessage switchToSetSourcesIds(List<IdNamePair> sources, String sourcesIdListString) {
        this._typeId = TypeId.SET_SOURCES_IDS;
        this._sources = sources;
        this._sourcesIdListString = sourcesIdListString;
        this._sourcesSchemas = null;
        return this;
    }

    public static SourcesMessage createSetSourcesIdsMessage(Collection<IdNamePair> sources) {
        return new SourcesMessage(TypeId.SET_SOURCES_IDS, new ArrayList<IdNamePair>(sources), SourcesMessage.calcSourcesIdListString(sources), null);
    }

    private static String calcSourcesIdListString(Collection<IdNamePair> sources) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (IdNamePair pair : sources) {
            if (!first) {
                sb.append(",");
            }
            sb.append(pair.getId());
            first = false;
        }
        return sb.toString();
    }

    public SourcesMessage switchToSetSourcesSchemas(Map<Long, List<RegisterResponseEntry>> sourcesSchemas) {
        this._typeId = TypeId.SET_SOURCES_IDS;
        this._sources = null;
        this._sourcesSchemas = sourcesSchemas;
        return this;
    }

    public TypeId getTypeId() {
        return this._typeId;
    }

    public List<IdNamePair> getSources() {
        return this._sources;
    }

    public String getSourcesIdListString() {
        return this._sourcesIdListString;
    }

    public Map<Long, List<RegisterResponseEntry>> getSourcesSchemas() {
        return this._sourcesSchemas;
    }

    public List<RegisterResponseMetadataEntry> getMetadataSchemas() {
        return this._metadataSchemas;
    }

    public String toString() {
        return this._typeId.toString();
    }

    public static enum TypeId {
        SET_SOURCES_IDS,
        SET_SOURCES_SCHEMAS;

    }
}

