/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.client;

import com.linkedin.databus.client.pub.ServerInfo;
import java.util.Set;

public class ServerSetChangeMessage {
    private TypeId _typeId;
    private ServerInfo _server;
    private Set<ServerInfo> _serverSet;

    private ServerSetChangeMessage(TypeId typeId, ServerInfo server, Set<ServerInfo> serverSet) {
        this._typeId = typeId;
        this._server = server;
        this._serverSet = serverSet;
    }

    public static ServerSetChangeMessage createSetServersMessage(Set<ServerInfo> serverSet) {
        return new ServerSetChangeMessage(TypeId.SET_SERVERS, null, serverSet);
    }

    public static ServerSetChangeMessage createAddServerMessage(ServerInfo server) {
        return new ServerSetChangeMessage(TypeId.ADD_SERVER, server, null);
    }

    public static ServerSetChangeMessage createRemoveServerMessage(ServerInfo server) {
        return new ServerSetChangeMessage(TypeId.REMOVE_SERVER, server, null);
    }

    public ServerSetChangeMessage switchToSetServers(Set<ServerInfo> serverSet) {
        this._typeId = TypeId.SET_SERVERS;
        this._server = null;
        this._serverSet = serverSet;
        return this;
    }

    public ServerSetChangeMessage switchToAddServer(ServerInfo server) {
        this._typeId = TypeId.ADD_SERVER;
        this._server = server;
        this._serverSet = null;
        return this;
    }

    public ServerSetChangeMessage switchToRemoveServer(ServerInfo server) {
        this._typeId = TypeId.REMOVE_SERVER;
        this._server = server;
        this._serverSet = null;
        return this;
    }

    public TypeId getTypeId() {
        return this._typeId;
    }

    public ServerInfo getServer() {
        return this._server;
    }

    public Set<ServerInfo> getServerSet() {
        return this._serverSet;
    }

    public String toString() {
        return "" + (Object)((Object)this._typeId);
    }

    public static enum TypeId {
        SET_SERVERS,
        ADD_SERVER,
        REMOVE_SERVER;

    }
}

