/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.client;

import com.linkedin.databus.client.BootstrapPullThread;
import com.linkedin.databus.client.DatabusHttpClientImpl;
import com.linkedin.databus.client.DatabusSourcesConnection;
import com.linkedin.databus.client.DispatcherState;
import com.linkedin.databus.client.GenericDispatcher;
import com.linkedin.databus.client.consumer.MultiConsumerCallback;
import com.linkedin.databus.client.pub.CheckpointPersistenceProvider;
import com.linkedin.databus.client.pub.DatabusCombinedConsumer;
import com.linkedin.databus.client.pub.RegistrationId;
import com.linkedin.databus.core.Checkpoint;
import com.linkedin.databus.core.DbusClientMode;
import com.linkedin.databus.core.DbusEvent;
import com.linkedin.databus.core.DbusEventBuffer;
import com.linkedin.databus.core.DbusEventUtils;
import com.linkedin.databus.core.DbusPrettyLogUtils;
import com.linkedin.databus.core.SCNRegressMessage;
import com.linkedin.databus.core.async.LifecycleMessage;
import com.linkedin.databus.core.data_model.DatabusSubscription;
import java.util.List;
import javax.management.MBeanServer;
import org.apache.log4j.Logger;

public class RelayDispatcher
extends GenericDispatcher<DatabusCombinedConsumer> {
    private final BootstrapPullThread _bootstrapPuller;

    public RelayDispatcher(String name, DatabusSourcesConnection.StaticConfig connConfig, List<DatabusSubscription> subsList, CheckpointPersistenceProvider checkpointPersistor, DbusEventBuffer dataEventsBuffer, MultiConsumerCallback asyncCallback, BootstrapPullThread bootstrapPuller, MBeanServer mbeanServer, DatabusHttpClientImpl serverHandle, RegistrationId registrationId, Logger log) {
        super(name, connConfig, subsList, checkpointPersistor, dataEventsBuffer, asyncCallback, mbeanServer, serverHandle, registrationId, connConfig.getDispatcherRetries(), log);
        this._bootstrapPuller = bootstrapPuller;
    }

    @Override
    protected Checkpoint createCheckpoint(DispatcherState curState, DbusEvent event) {
        return RelayDispatcher.createOnlineConsumptionCheckpoint(this._lastWindowScn, this._lastEowTsNsecs, curState, event);
    }

    @Override
    protected boolean processSysEvent(DispatcherState curState, DbusEvent event) {
        boolean success;
        block9: {
            success = true;
            if (event.isCheckpointMessage()) {
                Checkpoint ckpt = null;
                try {
                    ckpt = DbusEventUtils.getCheckpointFromEvent((DbusEvent)event);
                    DbusClientMode bootstrapMode = ckpt.getConsumptionMode();
                    if (bootstrapMode != DbusClientMode.ONLINE_CONSUMPTION) {
                        if (this._bootstrapPuller == null) {
                            this._log.error((Object)"Checkpoint specifies that the consumer is bootstrapping, but bootstrapPuller is not present (Is bootstrap disabled ?)");
                            return false;
                        }
                        ckpt.setConsumptionMode(DbusClientMode.BOOTSTRAP_SNAPSHOT);
                        if (curState.getStateId() != DispatcherState.StateId.EXPECT_EVENT_WINDOW) {
                            this._log.warn((Object)("The current state of the dispatcher is NOT as expected (" + DispatcherState.StateId.EXPECT_EVENT_WINDOW.name() + "). State prior to this: " + curState.getStateId().name()));
                        }
                        curState.getEventsIterator().getEventBuffer().clear();
                        curState.resetIterators();
                        curState.switchToExpectEventWindow();
                        this._bootstrapPuller.enqueueMessage(LifecycleMessage.createStartMessage());
                        this._log.info((Object)"Switching to bootstrap mode");
                        break block9;
                    }
                    success = super.processSysEvent(curState, event);
                }
                catch (Exception e) {
                    DbusPrettyLogUtils.logExceptionAtError((String)"Internal error processing a system event", (Throwable)e, (Logger)this._log);
                    success = false;
                }
            } else if (event.isSCNRegressMessage()) {
                SCNRegressMessage message = DbusEventUtils.getSCNRegressFromEvent((DbusEvent)event);
                this._log.info((Object)("Switching relays, some of the events maybe replayed. The Checkpoint to which the client with regress: " + message));
                curState.setSCNRegress(true);
                curState.switchToExpectEventWindow();
            } else {
                success = super.processSysEvent(curState, event);
            }
        }
        return success;
    }
}

