/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.client;

import com.linkedin.databus.client.DbusEventAvroDecoder;
import com.linkedin.databus.client.pub.SCN;
import com.linkedin.databus.core.Checkpoint;
import com.linkedin.databus.core.DbusEventBuffer;
import com.linkedin.databus.core.DbusLogAccumulator;
import com.linkedin.databus.core.util.IdNamePair;
import com.linkedin.databus2.core.container.request.RegisterResponseEntry;
import com.linkedin.databus2.core.container.request.RegisterResponseMetadataEntry;
import com.linkedin.databus2.schemas.SchemaId;
import com.linkedin.databus2.schemas.VersionedSchemaSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.log4j.Logger;

public class DispatcherState {
    public static final String MODULE = DispatcherState.class.getName();
    public static final Logger LOG = Logger.getLogger((String)MODULE);
    private StateId _stateId;
    private final Map<Long, IdNamePair> _sources = new HashMap<Long, IdNamePair>();
    private static final VersionedSchemaSet _schemaSet = new VersionedSchemaSet(true);
    private static final VersionedSchemaSet _metadataSchemasSet = new VersionedSchemaSet();
    private DbusEventBuffer.DbusEventIterator _eventsIterator;
    private DbusEventBuffer.DbusEventIterator _lastSuccessfulIterator;
    private final Map<Long, List<RegisterResponseEntry>> _payloadSchemaMap = new HashMap<Long, List<RegisterResponseEntry>>();
    private DbusEventBuffer _buffer;
    private volatile SCN _startWinScn;
    private boolean _eventsSeen;
    private IdNamePair _currentSource;
    private Schema _currentSourceSchema;
    private volatile SCN _endWinScn;
    private Checkpoint _lastSuccessfulCheckpoint;
    private SCN _lastSuccessfulScn;
    private DbusEventAvroDecoder _eventDecoder;
    private boolean _scnRegress = false;

    private DispatcherState() {
        this._stateId = StateId.INITIAL;
    }

    private DispatcherState(DbusEventBuffer buffer) {
        this._stateId = StateId.INITIAL;
        this._buffer = buffer;
    }

    public static DispatcherState create() {
        return new DispatcherState();
    }

    public static DispatcherState create(DbusEventBuffer eventBuffer, String iteratorName) {
        DispatcherState result = new DispatcherState(eventBuffer);
        result.createEventsIterator(iteratorName);
        return result;
    }

    private void setLastSuccessfulIterator(DbusEventBuffer.DbusEventIterator newValue) {
        boolean isDebugEnabled = LOG.isDebugEnabled();
        if (isDebugEnabled) {
            DbusLogAccumulator.addLog((String)("Changing _lastSuccessfulIterator from: " + this._lastSuccessfulIterator), (Logger)LOG);
        }
        if (null != this._lastSuccessfulIterator) {
            this._lastSuccessfulIterator.close();
        }
        this._lastSuccessfulIterator = null == newValue ? null : newValue.copy(this._lastSuccessfulIterator, newValue.getIdentifier() + ".save");
        if (isDebugEnabled) {
            DbusLogAccumulator.addLog((String)("Changing _lastSuccessfulIterator to: " + this._lastSuccessfulIterator), (Logger)LOG);
        }
    }

    public DispatcherState switchToStartDispatchEvents() {
        this._stateId = StateId.START_DISPATCH_EVENTS;
        return this;
    }

    private void createEventsIterator(String iteratorName) {
        if (null == this._eventsIterator) {
            this._stateId = StateId.START_DISPATCH_EVENTS;
            this._lastSuccessfulCheckpoint = null;
            this._lastSuccessfulScn = null;
            this.resetSourceInfo();
            this._eventsIterator = this._buffer.acquireIterator(iteratorName);
            LOG.info((Object)("start dispatch from: " + this._eventsIterator));
            this.setLastSuccessfulIterator(this._eventsIterator);
        }
    }

    private void refreshSchemas(List<RegisterResponseMetadataEntry> metadataSchemaList) {
        boolean isDebugEnabled = LOG.isDebugEnabled();
        try {
            for (Map.Entry<Long, List<RegisterResponseEntry>> entry : this._payloadSchemaMap.entrySet()) {
                for (RegisterResponseEntry r : entry.getValue()) {
                    String msg;
                    long id = r.getId();
                    String schemaName = null;
                    if (!this._sources.containsKey(id)) {
                        LOG.error((Object)("Obtained a RegisterResponseEntry with schema that has no sourceId set. id = " + id));
                        continue;
                    }
                    schemaName = this._sources.get(r.getId()).getName();
                    String schema = r.getSchema();
                    if (_schemaSet.add(schemaName, r.getVersion(), schema)) {
                        LOG.info((Object)("Registering schema name=" + schemaName + " id=" + entry.getKey().toString() + " version=" + r.getVersion()));
                        if (!isDebugEnabled) continue;
                        msg = "Registering schema name=" + schemaName + " id=" + entry.getKey().toString() + " version=" + r.getVersion() + ": " + schema;
                        DbusLogAccumulator.addLog((String)msg, (Logger)LOG);
                        continue;
                    }
                    if (!isDebugEnabled) continue;
                    msg = "Schema already known: " + schemaName + " version " + r.getId();
                    DbusLogAccumulator.addLog((String)msg, (Logger)LOG);
                }
            }
            if (metadataSchemaList != null && !metadataSchemaList.isEmpty()) {
                for (RegisterResponseMetadataEntry registerResponseMetadataEntry : metadataSchemaList) {
                    SchemaId id = new SchemaId(registerResponseMetadataEntry.getCrc32());
                    if (_metadataSchemasSet.add("metadata-source", registerResponseMetadataEntry.getVersion(), id, registerResponseMetadataEntry.getSchema())) {
                        LOG.info((Object)("Added metadata schema version " + registerResponseMetadataEntry.getVersion() + ",schemaID=0x" + id));
                        continue;
                    }
                    if (!isDebugEnabled) continue;
                    String msg = "Metadata schema version " + registerResponseMetadataEntry.getVersion() + ",schemaId=0x" + id + " already exists";
                    DbusLogAccumulator.addLog((String)msg, (Logger)LOG);
                }
            } else if (isDebugEnabled) {
                String msg = "Metadata schema is empty";
                DbusLogAccumulator.addLog((String)msg, (Logger)LOG);
            }
            this._eventDecoder = new DbusEventAvroDecoder(_schemaSet, _metadataSchemasSet);
        }
        catch (Exception e) {
            LOG.error((Object)"Error adding schema", (Throwable)e);
        }
    }

    public void resetIterators() {
        if (null != this._lastSuccessfulIterator) {
            this.setLastSuccessfulIterator(null);
            this._lastSuccessfulScn = null;
            this._lastSuccessfulCheckpoint = null;
        }
        if (null != this._eventsIterator) {
            DbusEventBuffer eventBuffer = this._eventsIterator.getEventBuffer();
            String iteratorName = this._eventsIterator.getIdentifier();
            this._eventsIterator.close();
            this._eventsIterator = eventBuffer.acquireIterator(iteratorName);
            if (LOG.isDebugEnabled()) {
                String msg = "Reset event iterator to: " + this._eventsIterator;
                DbusLogAccumulator.addLog((String)msg, (Logger)LOG);
            }
            this.resetSourceInfo();
        }
    }

    public void switchToExpectEventWindow() {
        this._stateId = StateId.EXPECT_EVENT_WINDOW;
    }

    public DispatcherState switchToStopDispatch() {
        this._stateId = StateId.STOP_DISPATCH_EVENTS;
        this.setEventsIterator(null);
        return this;
    }

    public DispatcherState switchToClosed() {
        this._stateId = StateId.CLOSED;
        this.setLastSuccessfulIterator(null);
        this.setEventsIterator(null);
        return this;
    }

    public synchronized void switchToStartStreamEventWindow(SCN startWinScn) {
        this._stateId = StateId.START_STREAM_EVENT_WINDOW;
        this._startWinScn = startWinScn;
        this._eventsSeen = true;
        this.resetSourceInfo();
    }

    public synchronized void switchToEndStreamEventWindow(SCN endWinScn) {
        this._stateId = StateId.END_STREAM_EVENT_WINDOW;
        this._endWinScn = endWinScn;
        this._eventsSeen = false;
    }

    public void switchToStartStreamSource(IdNamePair source, Schema sourceSchema) {
        this._stateId = StateId.START_STREAM_SOURCE;
        this._currentSource = source;
        this._currentSourceSchema = sourceSchema;
    }

    public void switchToEndStreamSource() {
        this._stateId = StateId.END_STREAM_SOURCE;
    }

    public void switchToExpectStreamDataEvents() {
        this._stateId = StateId.EXPECT_STREAM_DATA_EVENTS;
    }

    public void storeCheckpoint(Checkpoint cp, SCN scn) {
        this._lastSuccessfulCheckpoint = cp;
        this._lastSuccessfulScn = scn;
        this.setLastSuccessfulIterator(this._eventsIterator);
    }

    public void switchToRollback() {
        this._stateId = StateId.ROLLBACK;
        this._eventsSeen = false;
    }

    private void setEventsIterator(DbusEventBuffer.DbusEventIterator newValue) {
        String msg;
        String iterName;
        String string = iterName = null == newValue ? "dispatcher iterator" : newValue.getIdentifier();
        if (null != this._eventsIterator) {
            iterName = this._eventsIterator.getIdentifier();
            if (LOG.isDebugEnabled()) {
                msg = "Closing dispatcher iterator: " + this._eventsIterator;
                DbusLogAccumulator.addLog((String)msg, (Logger)LOG);
            }
            this._eventsIterator.close();
        }
        if (null == newValue) {
            this._eventsIterator = null;
            if (LOG.isDebugEnabled()) {
                msg = "Dispatcher iterator set to null";
                DbusLogAccumulator.addLog((String)msg, (Logger)LOG);
            }
        } else {
            this._eventsIterator = newValue.copy(this._eventsIterator, iterName);
            if (LOG.isDebugEnabled()) {
                msg = "New dispatcher iterator: " + this._eventsIterator;
                DbusLogAccumulator.addLog((String)msg, (Logger)LOG);
            }
        }
    }

    public void switchToReplayDataEvents() {
        this._stateId = StateId.REPLAY_DATA_EVENTS;
        this.resetSourceInfo();
        this.setEventsIterator(this._lastSuccessfulIterator);
    }

    public void resetSourceInfo() {
        this._currentSource = null;
        this._currentSourceSchema = null;
    }

    public StateId getStateId() {
        return this._stateId;
    }

    public DbusEventBuffer.DbusEventIterator getEventsIterator() {
        return this._eventsIterator;
    }

    public Map<Long, IdNamePair> getSources() {
        return this._sources;
    }

    public DbusEventAvroDecoder getEventDecoder() {
        return this._eventDecoder;
    }

    public synchronized SCN getStartWinScn() {
        return this._startWinScn;
    }

    public IdNamePair getCurrentSource() {
        return this._currentSource;
    }

    public Schema getCurrentSourceSchema() {
        return this._currentSourceSchema;
    }

    public synchronized SCN getEndWinScn() {
        return this._endWinScn;
    }

    public Checkpoint getLastSuccessfulCheckpoint() {
        return this._lastSuccessfulCheckpoint;
    }

    public VersionedSchemaSet getSchemaSet() {
        return _schemaSet;
    }

    public SCN getLastSuccessfulScn() {
        return this._lastSuccessfulScn;
    }

    public DbusEventBuffer.DbusEventIterator getLastSuccessfulIterator() {
        return this._lastSuccessfulIterator;
    }

    public String toString() {
        return "DispatcherState:" + this._stateId.toString();
    }

    public Map<Long, List<RegisterResponseEntry>> getSchemaMap() {
        return this._payloadSchemaMap;
    }

    public void removeEvents() {
        DbusEventBuffer.DbusEventIterator iter = this.getEventsIterator();
        if (!iter.equivalent(this._lastSuccessfulIterator)) {
            if (this._lastSuccessfulIterator == null) {
                LOG.warn((Object)"Last Successful Iterator was null. Rollback will not be possible!");
            } else {
                LOG.info((Object)("Invalidating last successful iterator last = " + this._lastSuccessfulIterator + " this iterator= " + iter));
                this.setLastSuccessfulIterator(null);
            }
        }
        iter.remove();
    }

    public boolean isSCNRegress() {
        return this._scnRegress;
    }

    public void setSCNRegress(boolean scnRegress) {
        this._scnRegress = scnRegress;
    }

    public boolean isEventsSeen() {
        return this._eventsSeen;
    }

    public void setEventsSeen(boolean hasSeenDataEvents) {
        this._eventsSeen = hasSeenDataEvents;
    }

    protected DispatcherState addSources(Collection<IdNamePair> sources) {
        for (IdNamePair source : sources) {
            this._sources.put(source.getId(), source);
        }
        return this;
    }

    protected DispatcherState addSchemas(Map<Long, List<RegisterResponseEntry>> schemaMap) {
        return this.addSchemas(schemaMap, null);
    }

    protected DispatcherState addSchemas(Map<Long, List<RegisterResponseEntry>> schemaMap, List<RegisterResponseMetadataEntry> metadataSchemaList) {
        this._payloadSchemaMap.putAll(schemaMap);
        this.refreshSchemas(metadataSchemaList);
        return this;
    }

    public static enum StateId {
        INITIAL,
        START_DISPATCH_EVENTS,
        EXPECT_EVENT_WINDOW,
        START_STREAM_EVENT_WINDOW,
        START_STREAM_SOURCE,
        EXPECT_STREAM_DATA_EVENTS,
        END_STREAM_SOURCE,
        END_STREAM_EVENT_WINDOW,
        ROLLBACK,
        REPLAY_DATA_EVENTS,
        STOP_DISPATCH_EVENTS,
        CLOSED;

    }
}

