/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.client;

import com.linkedin.databus.client.ConnectionStateFactory;
import com.linkedin.databus.client.DatabusBootstrapConnectionFactory;
import com.linkedin.databus.client.DatabusClientDSCUpdater;
import com.linkedin.databus.client.DatabusRelayConnectionFactory;
import com.linkedin.databus.client.DatabusSourcesConnection;
import com.linkedin.databus.client.LastWriteTimeTrackerImpl;
import com.linkedin.databus.client.consumer.DatabusV2ConsumerRegistration;
import com.linkedin.databus.client.consumer.LoggingConsumer;
import com.linkedin.databus.client.consumer.SelectingDatabusCombinedConsumer;
import com.linkedin.databus.client.consumer.SelectingDatabusCombinedConsumerFactory;
import com.linkedin.databus.client.netty.NettyHttpConnectionFactory;
import com.linkedin.databus.client.pub.CheckpointPersistenceProvider;
import com.linkedin.databus.client.pub.ClusterCheckpointPersistenceProvider;
import com.linkedin.databus.client.pub.DatabusBootstrapConsumer;
import com.linkedin.databus.client.pub.DatabusClient;
import com.linkedin.databus.client.pub.DatabusClientException;
import com.linkedin.databus.client.pub.DatabusClientGroupMember;
import com.linkedin.databus.client.pub.DatabusClientNode;
import com.linkedin.databus.client.pub.DatabusCombinedConsumer;
import com.linkedin.databus.client.pub.DatabusRegistration;
import com.linkedin.databus.client.pub.DatabusStreamConsumer;
import com.linkedin.databus.client.pub.DatabusV3Registration;
import com.linkedin.databus.client.pub.DbusClusterConsumerFactory;
import com.linkedin.databus.client.pub.DbusClusterInfo;
import com.linkedin.databus.client.pub.DbusPartitionListener;
import com.linkedin.databus.client.pub.DbusServerSideFilterFactory;
import com.linkedin.databus.client.pub.FileSystemCheckpointPersistenceProvider;
import com.linkedin.databus.client.pub.RegistrationId;
import com.linkedin.databus.client.pub.ServerInfo;
import com.linkedin.databus.client.pub.SharedCheckpointPersistenceProvider;
import com.linkedin.databus.client.pub.mbean.ConsumerCallbackStats;
import com.linkedin.databus.client.pub.mbean.UnifiedClientStats;
import com.linkedin.databus.client.registration.ClusterRegistrationConfig;
import com.linkedin.databus.client.registration.ClusterRegistrationStaticConfig;
import com.linkedin.databus.client.registration.DatabusMultiPartitionRegistration;
import com.linkedin.databus.client.registration.DatabusV2ClusterRegistrationImpl;
import com.linkedin.databus.client.registration.DatabusV2RegistrationImpl;
import com.linkedin.databus.client.registration.RegistrationIdGenerator;
import com.linkedin.databus.client.request.ClientStateRequestProcessor;
import com.linkedin.databus.client.request.ClientStatsRequestProcessor;
import com.linkedin.databus.core.DatabusComponentStatus;
import com.linkedin.databus.core.DbusEventBuffer;
import com.linkedin.databus.core.DbusEventFactory;
import com.linkedin.databus.core.DbusEventV2Factory;
import com.linkedin.databus.core.data_model.DatabusSubscription;
import com.linkedin.databus.core.monitoring.mbean.AggregatedDbusEventsStatisticsCollector;
import com.linkedin.databus.core.monitoring.mbean.DbusEventsStatisticsCollector;
import com.linkedin.databus.core.monitoring.mbean.StatsCollectorMergeable;
import com.linkedin.databus.core.monitoring.mbean.StatsCollectors;
import com.linkedin.databus.core.util.ConfigApplier;
import com.linkedin.databus.core.util.ConfigBuilder;
import com.linkedin.databus.core.util.ConfigLoader;
import com.linkedin.databus.core.util.ConfigManager;
import com.linkedin.databus.core.util.InvalidConfigException;
import com.linkedin.databus2.core.DatabusException;
import com.linkedin.databus2.core.container.monitoring.mbean.DatabusComponentAdmin;
import com.linkedin.databus2.core.container.monitoring.mbean.HttpStatisticsCollector;
import com.linkedin.databus2.core.container.netty.ServerContainer;
import com.linkedin.databus2.core.container.request.RequestProcessor;
import com.linkedin.databus2.core.filter.DbusKeyCompositeFilterConfig;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.log4j.Logger;

public class DatabusHttpClientImpl
extends ServerContainer
implements DatabusClient {
    public static final String MODULE = DatabusHttpClientImpl.class.getName();
    public static final Logger LOG = Logger.getLogger((String)MODULE);
    public static final int GLOBAL_STATS_MERGE_INTERVAL_MS = 500;
    protected Map<List<DatabusSubscription>, Set<ServerInfo>> _relayGroups;
    protected Map<List<DatabusSubscription>, Set<ServerInfo>> _bootstrapGroups;
    protected final List<DatabusSourcesConnection> _relayConnections;
    protected final StaticConfig _clientStaticConfig;
    protected final ConfigManager<RuntimeConfig> _configManager;
    protected final CheckpointPersistenceProvider _checkpointPersistenceProvider;
    protected final HttpStatisticsCollector _httpStatsCollector;
    protected final LoggingConsumer _loggingConsumer;
    protected final DatabusRelayConnectionFactory _relayConnFactory;
    protected final DatabusBootstrapConnectionFactory _bootstrapConnFactory;
    protected final DbusEventsStatisticsCollector _bootstrapEventsStatsCollector;
    protected final StatsCollectors<DbusEventsStatisticsCollector> _bootstrapEventsStats;
    protected final StatsCollectors<ConsumerCallbackStats> _consumerStatsCollectors;
    protected final StatsCollectors<ConsumerCallbackStats> _bsConsumerStatsCollectors;
    protected final StatsCollectors<UnifiedClientStats> _unifiedClientStatsCollectors;
    protected DatabusHttpClientStatus _clientStatus;
    protected final DatabusClientNode _clientNode;
    protected final DatabusClientGroupMember _groupMember;
    protected LastWriteTimeTrackerImpl _writeTimeTracker = null;
    protected DatabusClientDSCUpdater _dscUpdater = null;
    protected final DbusEventFactory _eventFactory;
    private static final int DEFAULT_PROTOCOL_VERSION = 2;
    private static final int DEFAULT_MAX_EVENT_VERSION = 2;
    private final Map<List<DatabusSubscription>, List<DatabusV2ConsumerRegistration>> _relayGroupStreamConsumers;
    private final Map<List<DatabusSubscription>, List<DatabusV2ConsumerRegistration>> _relayGroupBootstrapConsumers;
    protected boolean _cmEnabled = false;
    private final List<DatabusRegistration> _regList = new CopyOnWriteArrayList<DatabusRegistration>();
    private final Set<String> _activeClusters = new HashSet<String>();

    protected int getProtocolVersion() {
        return 2;
    }

    protected int getMaxEventVersion() {
        return 2;
    }

    public boolean isCMEnabled() {
        return this._cmEnabled;
    }

    public Map<String, String> printClientInfo() throws InvalidConfigException {
        throw new UnsupportedOperationException("Not supported in this version of client");
    }

    public void resetRelayConnections() {
        for (DatabusSourcesConnection conn : this._relayConnections) {
            conn.getRelayPullThread().killConnection();
        }
    }

    public DatabusHttpClientImpl(String propertyPrefix, Properties props) throws InvalidConfigException, IOException, DatabusException {
        this(DatabusHttpClientImpl.createConfigBuilder(propertyPrefix, props).build());
    }

    public DatabusHttpClientImpl() throws InvalidConfigException, IOException, DatabusException {
        this(new Config());
    }

    public DatabusHttpClientImpl(Config config) throws InvalidConfigException, IOException, DatabusException {
        this(config.build());
    }

    public DatabusHttpClientImpl(StaticConfig config) throws InvalidConfigException, IOException, DatabusException {
        this(config, ByteOrder.BIG_ENDIAN);
    }

    public DatabusHttpClientImpl(StaticConfig config, ByteOrder byteOrder) throws IOException, InvalidConfigException, DatabusException {
        super(config.getContainer(), byteOrder);
        this._eventFactory = new DbusEventV2Factory(byteOrder);
        this._clientStaticConfig = config;
        this._bootstrapEventsStatsCollector = new AggregatedDbusEventsStatisticsCollector(this.getContainerStaticConfig().getId(), "eventsBootstrap", true, true, this.getMbeanServer());
        this._bootstrapEventsStats = new StatsCollectors((StatsCollectorMergeable)this._bootstrapEventsStatsCollector);
        this._consumerStatsCollectors = new StatsCollectors();
        this._bsConsumerStatsCollectors = new StatsCollectors();
        this._unifiedClientStatsCollectors = new StatsCollectors();
        this._relayGroups = new HashMap<List<DatabusSubscription>, Set<ServerInfo>>(100);
        this._bootstrapGroups = new HashMap<List<DatabusSubscription>, Set<ServerInfo>>(100);
        this._relayGroupStreamConsumers = new HashMap<List<DatabusSubscription>, List<DatabusV2ConsumerRegistration>>(100);
        this._relayGroupBootstrapConsumers = new HashMap<List<DatabusSubscription>, List<DatabusV2ConsumerRegistration>>(100);
        this._relayConnections = new ArrayList<DatabusSourcesConnection>(20);
        if (config.getCluster().isEnabled()) {
            this._clientNode = new DatabusClientNode(config.getCluster());
            this._groupMember = this._clientNode.isEnabled() ? this._clientNode.getMember(this._clientStaticConfig.getCluster().getDomain(), this._clientStaticConfig.getCluster().getGroup(), this._clientStaticConfig.getCluster().getName()) : null;
        } else {
            this._clientNode = null;
            this._groupMember = null;
        }
        this._checkpointPersistenceProvider = this._clientStaticConfig.getCheckpointPersistence().getOrCreateCheckpointPersistenceProvider(this._groupMember);
        HttpStatisticsCollector httpStatsColl = this._clientStaticConfig.getHttpStatsCollector().getExistingStatsCollector();
        if (null == httpStatsColl) {
            httpStatsColl = new HttpStatisticsCollector(this.getContainerStaticConfig().getId(), "httpOutbound", this._clientStaticConfig.getRuntime().getHttpStatsCollector().isEnabled(), true, this.getMbeanServer());
        }
        this._httpStatsCollector = httpStatsColl;
        this._loggingConsumer = new LoggingConsumer(this._clientStaticConfig.getLoggingListener());
        this._clientStaticConfig.getRuntime().setManagedInstance(this);
        this._configManager = new ConfigManager(this._clientStaticConfig.getRuntimeConfigPrefix(), (ConfigBuilder)this._clientStaticConfig.getRuntime());
        NettyHttpConnectionFactory defaultConnFactory = new NettyHttpConnectionFactory(this.getBossExecutorService(), this.getIoExecutorService(), this.getContainerStatsCollector(), this.getNetworkTimeoutTimer(), this._clientStaticConfig.getContainer().getWriteTimeoutMs(), this._clientStaticConfig.getContainer().getReadTimeoutMs(), this._clientStaticConfig.getContainer().getBstReadTimeoutMs(), this.getProtocolVersion(), this.getMaxEventVersion(), this.getHttpChannelGroup());
        this._relayConnFactory = defaultConnFactory;
        this._bootstrapConnFactory = defaultConnFactory;
        this.initializeClientCommandProcessors();
        this.getGlobalStatsMerger().registerStatsCollector(this._bootstrapEventsStats);
    }

    public static Config createConfigBuilder(String propertyPrefix, Properties props) throws InvalidConfigException {
        Config configBuilder = new Config();
        ConfigLoader confLoader = new ConfigLoader(propertyPrefix, (ConfigBuilder)configBuilder);
        confLoader.loadConfig((Map)props);
        return configBuilder;
    }

    public StaticConfig getClientStaticConfig() {
        return this._clientStaticConfig;
    }

    public void registerDatabusStreamListener(DatabusStreamConsumer listener, DbusKeyCompositeFilterConfig filterConfig, String ... sources) throws DatabusClientException {
        this.registerDatabusStreamListener(listener, Arrays.asList(sources), filterConfig);
    }

    public void registerDatabusStreamListener(DatabusStreamConsumer[] listeners, DbusKeyCompositeFilterConfig filterConfig, String ... sources) throws DatabusClientException {
        this.registerDatabusStreamListener(listeners, Arrays.asList(sources), filterConfig);
    }

    public void registerDatabusBootstrapListener(DatabusBootstrapConsumer listener, DbusKeyCompositeFilterConfig filterConfig, String ... sources) throws DatabusClientException {
        this.registerDatabusBootstrapListener(listener, Arrays.asList(sources), filterConfig);
    }

    public void registerDatabusBootstrapListener(DatabusBootstrapConsumer[] listeners, DbusKeyCompositeFilterConfig filterConfig, String ... sources) throws DatabusClientException {
        this.registerDatabusBootstrapListener(listeners, Arrays.asList(sources), filterConfig);
    }

    public void registerDatabusStreamListener(DatabusStreamConsumer listener, List<String> sources, DbusKeyCompositeFilterConfig filterConfig) throws DatabusClientException {
        DatabusStreamConsumer[] listeners = new DatabusStreamConsumer[]{listener};
        this.registerDatabusStreamListener(listeners, sources, filterConfig);
    }

    public synchronized void registerDatabusStreamListener(DatabusStreamConsumer[] listeners, List<String> sources, DbusKeyCompositeFilterConfig filterConfig) throws DatabusClientException {
        List<DatabusStreamConsumer> listenersList = Arrays.asList(listeners);
        List sdccListenersList = SelectingDatabusCombinedConsumerFactory.convertListOfStreamConsumers(listenersList);
        ArrayList<SelectingDatabusCombinedConsumer> dccListenersList = new ArrayList<SelectingDatabusCombinedConsumer>();
        for (SelectingDatabusCombinedConsumer sdcc : sdccListenersList) {
            dccListenersList.add(sdcc);
        }
        DatabusV2ConsumerRegistration consumerReg = new DatabusV2ConsumerRegistration(dccListenersList, sources, filterConfig);
        this.registerDatabusListener(consumerReg, this._relayGroups, this.getRelayGroupStreamConsumers(), DatabusSubscription.createSubscriptionList(sources));
    }

    public void registerDatabusBootstrapListener(DatabusBootstrapConsumer listener, List<String> sources, DbusKeyCompositeFilterConfig filterConfig) throws DatabusClientException {
        DatabusBootstrapConsumer[] listeners = new DatabusBootstrapConsumer[]{listener};
        this.registerDatabusBootstrapListener(listeners, sources, filterConfig);
    }

    public synchronized void registerDatabusBootstrapListener(DatabusBootstrapConsumer[] listeners, List<String> sources, DbusKeyCompositeFilterConfig filter) throws DatabusClientException {
        List<DatabusBootstrapConsumer> listenersList = Arrays.asList(listeners);
        List sdccListenersList = SelectingDatabusCombinedConsumerFactory.convertListOfBootstrapConsumers(listenersList);
        ArrayList<SelectingDatabusCombinedConsumer> dccListenersList = new ArrayList<SelectingDatabusCombinedConsumer>();
        for (SelectingDatabusCombinedConsumer sdcc : sdccListenersList) {
            dccListenersList.add(sdcc);
        }
        DatabusV2ConsumerRegistration consumerReg = new DatabusV2ConsumerRegistration(dccListenersList, sources, filter);
        this.registerDatabusListener(consumerReg, this._relayGroups, this.getRelayGroupBootstrapConsumers(), DatabusSubscription.createSubscriptionList(sources));
    }

    public synchronized void unregisterDatabusStreamListener(DatabusStreamConsumer listener) throws DatabusClientException {
        for (List<DatabusSubscription> relayGroup : this.getRelayGroupStreamConsumers().keySet()) {
            while (this.getRelayGroupStreamConsumers().get(relayGroup).remove(listener)) {
            }
        }
    }

    public synchronized void unregisterDatabusBootstrapListener(DatabusBootstrapConsumer listener) throws DatabusClientException {
        for (List<DatabusSubscription> relayGroup : this.getRelayGroupBootstrapConsumers().keySet()) {
            while (this.getRelayGroupBootstrapConsumers().get(relayGroup).remove(listener)) {
            }
        }
    }

    public synchronized void doRegisterBootstrapService(ServerInfo serverInfo) {
        LOG.info((Object)("Registering bootstrap: " + serverInfo.toString()));
        List subList = DatabusSubscription.createSubscriptionList((List)serverInfo.getSources());
        Set<ServerInfo> sourceBootstrapServers = this._bootstrapGroups.get(subList);
        if (null == sourceBootstrapServers) {
            sourceBootstrapServers = new HashSet<ServerInfo>();
            this._bootstrapGroups.put(subList, sourceBootstrapServers);
        }
        sourceBootstrapServers.add(serverInfo);
    }

    public synchronized void doUnregisterBootstrapService(ServerInfo serverInfo) {
        Set<ServerInfo> sourceBootstrapServers = this._bootstrapGroups.get(DatabusSubscription.createSubscriptionList((List)serverInfo.getSources()));
        if (null != sourceBootstrapServers) {
            LOG.info((Object)("Unregistering bootstrap: " + serverInfo.toString()));
            sourceBootstrapServers.remove(serverInfo);
        }
    }

    public Map<List<DatabusSubscription>, Set<ServerInfo>> getRelayGroups() {
        return this._relayGroups;
    }

    public List<ServerInfo> getRelays() {
        RuntimeConfig runtimeConfig = (RuntimeConfig)this.getClientConfigManager().getReadOnlyConfig();
        return runtimeConfig.getRelays();
    }

    public synchronized List<DatabusSourcesConnection> getRelayConnections() {
        return this._relayConnections;
    }

    public synchronized List<ServerInfo> getBootstrapServices() {
        RuntimeConfig runtimeConfig = (RuntimeConfig)this.getClientConfigManager().getReadOnlyConfig();
        return runtimeConfig.getBootstrap().getServices();
    }

    public synchronized Map<List<DatabusSubscription>, List<DatabusV2ConsumerRegistration>> getRelayGroupStreamConsumers() {
        return this._relayGroupStreamConsumers;
    }

    public synchronized Map<List<DatabusSubscription>, List<DatabusV2ConsumerRegistration>> getRelayGroupBootstrapConsumers() {
        return this._relayGroupBootstrapConsumers;
    }

    public ConfigManager<RuntimeConfig> getClientConfigManager() {
        return this._configManager;
    }

    public CheckpointPersistenceProvider getCheckpointPersistenceProvider() {
        return this._checkpointPersistenceProvider;
    }

    public HttpStatisticsCollector getHttpStatsCollector() {
        return this._httpStatsCollector;
    }

    public LoggingConsumer getLoggingListener() {
        return this._loggingConsumer;
    }

    public DatabusRelayConnectionFactory getRelayConnFactory() {
        return this._relayConnFactory;
    }

    public DatabusBootstrapConnectionFactory getBootstrapConnFactory() {
        return this._bootstrapConnFactory;
    }

    public StatsCollectors<DbusEventsStatisticsCollector> getBootstrapEventsStats() {
        return this._bootstrapEventsStats;
    }

    public StatsCollectors<ConsumerCallbackStats> getRelayConsumerStatsCollectors() {
        return this._consumerStatsCollectors;
    }

    public StatsCollectors<ConsumerCallbackStats> getBootstrapConsumerStatsCollectors() {
        return this._bsConsumerStatsCollectors;
    }

    public StatsCollectors<UnifiedClientStats> getUnifiedClientStatsCollectors() {
        return this._unifiedClientStatsCollectors;
    }

    public DbusEventsStatisticsCollector getBootstrapEventsStatsCollector() {
        return (DbusEventsStatisticsCollector)this._bootstrapEventsStats.getStatsCollector();
    }

    public void setWriteTimeTracker(LastWriteTimeTrackerImpl writeTimeTracker) {
        this._writeTimeTracker = writeTimeTracker;
    }

    public LastWriteTimeTrackerImpl getWriteTimeTracker() {
        return this._writeTimeTracker;
    }

    public DatabusClientDSCUpdater getDSCUpdater() {
        return this._dscUpdater;
    }

    public Set<String> getActiveClientClusters() {
        return this._activeClusters;
    }

    public DatabusRegistration register(DatabusCombinedConsumer consumer, String ... sources) throws DatabusClientException {
        if (null == consumer) {
            throw new DatabusClientException("No consumer callback has been specified.");
        }
        if (null == sources || sources.length == 0) {
            throw new DatabusClientException("Please specify Databus sources to be consumed: register(consumer, source1, source2, ...");
        }
        RegistrationId regId = RegistrationIdGenerator.generateNewId(consumer.getClass().getSimpleName(), DatabusSubscription.createSubscriptionList(Arrays.asList(sources)));
        DatabusV2RegistrationImpl reg = new DatabusV2RegistrationImpl(regId, this, this.getCheckpointPersistenceProvider());
        ArrayList<DatabusCombinedConsumer> consumers = new ArrayList<DatabusCombinedConsumer>();
        consumers.add(consumer);
        reg.addDatabusConsumers(consumers);
        reg.addSubscriptions(sources);
        this._regList.add(reg);
        reg.onRegister();
        return reg;
    }

    public DatabusRegistration register(Collection<DatabusCombinedConsumer> consumers, String ... sources) throws DatabusClientException {
        if (null == consumers || consumers.isEmpty()) {
            throw new DatabusClientException("No consumer callbacks have been specified.");
        }
        if (null == sources || sources.length == 0) {
            throw new DatabusClientException("Please specify Databus sources to be consumed: register(consumer, source1, source2, ...");
        }
        RegistrationId regId = RegistrationIdGenerator.generateNewId(consumers.iterator().next().getClass().getSimpleName(), DatabusSubscription.createSubscriptionList(Arrays.asList(sources)));
        DatabusV2RegistrationImpl reg = new DatabusV2RegistrationImpl(regId, this, this.getCheckpointPersistenceProvider());
        reg.addDatabusConsumers(consumers);
        reg.addSubscriptions(sources);
        this._regList.add(reg);
        reg.onRegister();
        return reg;
    }

    public DatabusRegistration registerCluster(String cluster, DbusClusterConsumerFactory consumerFactory, DbusServerSideFilterFactory filterFactory, DbusPartitionListener partitionListener, String ... sources) throws DatabusClientException {
        if (null == sources || sources.length == 0) {
            throw new DatabusClientException("Sources is empty !!");
        }
        if (this._activeClusters.contains(cluster)) {
            throw new DatabusClientException("Cluster :" + cluster + " has already been registed to this client instance." + " Only one registration per cluster is allowed for a databus client instance !!");
        }
        ClusterRegistrationStaticConfig c = this._clientStaticConfig.getClientCluster(cluster);
        if (null == c) {
            throw new DatabusClientException("Cluster Configuration for cluster (" + cluster + ") not provided !!");
        }
        if (null == consumerFactory) {
            throw new DatabusClientException("Consumer Factory is null !!");
        }
        ClusterCheckpointPersistenceProvider.StaticConfig ckptPersistenceProviderConfig = new ClusterCheckpointPersistenceProvider.StaticConfig(c.getZkAddr(), c.getClusterName(), c.getMaxCkptWritesSkipped(), c.getCheckpointIntervalMs());
        DbusClusterInfo clusterInfo = new DbusClusterInfo(c.getClusterName(), c.getNumPartitions(), c.getQuorum());
        RegistrationId regId = RegistrationIdGenerator.generateNewId(c.getClusterName());
        DatabusV2ClusterRegistrationImpl reg = new DatabusV2ClusterRegistrationImpl(regId, this, ckptPersistenceProviderConfig, clusterInfo, consumerFactory, filterFactory, partitionListener, sources);
        this._regList.add(reg);
        reg.onRegister();
        this._activeClusters.add(cluster);
        return reg;
    }

    public boolean deregister(DatabusRegistration reg) {
        return this._regList.remove(reg);
    }

    public Collection<DatabusMultiPartitionRegistration> getAllClientClusterRegistrations() {
        ArrayList<DatabusMultiPartitionRegistration> regs = new ArrayList<DatabusMultiPartitionRegistration>();
        for (DatabusRegistration reg : this._regList) {
            if (!(reg instanceof DatabusV2ClusterRegistrationImpl)) continue;
            regs.add((DatabusV2ClusterRegistrationImpl)reg);
        }
        return regs;
    }

    public Collection<DatabusRegistration> getAllRegistrations() {
        return Collections.unmodifiableCollection(this._regList);
    }

    public boolean isClusterEnabled() {
        return this._clientNode != null && this._clientNode.isEnabled();
    }

    public void pause() {
        this._clientStatus.pause();
    }

    public void resume() {
        this._clientStatus.resume();
    }

    public void suspendOnError(Throwable cause) {
        this._clientStatus.suspendOnError(cause);
    }

    public static void main(String[] args) throws Exception {
        Config staticConfigBuilder = new Config();
        DatabusHttpClientImpl client = DatabusHttpClientImpl.createFromCli(args, staticConfigBuilder);
        client.startAndBlock();
    }

    public static DatabusHttpClientImpl createFromCli(String[] args, Config defaultConfigBuilder) throws Exception {
        Properties startupProps = ServerContainer.processCommandLineArgs((String[])args);
        if (null == defaultConfigBuilder) {
            defaultConfigBuilder = new Config();
        }
        ConfigLoader staticConfigLoader = new ConfigLoader("databus.client.", (ConfigBuilder)defaultConfigBuilder);
        StaticConfig staticConfig = (StaticConfig)staticConfigLoader.loadConfig((Map)startupProps);
        DatabusHttpClientImpl dbusHttpClient = new DatabusHttpClientImpl(staticConfig);
        return dbusHttpClient;
    }

    public void start() {
        super.start();
    }

    protected void doStart() {
        super.doStart();
        LOG.info((Object)("relay consumers: " + this.getRelayGroupStreamConsumers().size()));
        LOG.info((Object)("bootstrap consumers: " + this.getRelayGroupBootstrapConsumers().size()));
        if (this._clientNode != null && this._clientNode.isEnabled() && !this.waitForLeadership()) {
            LOG.error((Object)"Error acquiring leadership! Not starting client");
            return;
        }
        this._httpStatsCollector.registerMastershipStatus(1);
        if (!this.getClientStaticConfig().usesDynamicRelayConfiguration()) {
            this.initializeRelayConnections();
            for (DatabusRegistration r : this._regList) {
                if (r.getState().isRunning()) continue;
                try {
                    LOG.info((Object)("Registration (" + r.getRegistrationId() + ") has not been started yet !! Starting !!"));
                    r.start();
                }
                catch (DatabusClientException e) {
                    LOG.error((Object)"Got exception while starting registration !!", (Throwable)e);
                    throw new RuntimeException(e);
                }
            }
        } else {
            LOG.info((Object)"Client with dynamically configured relays: relay connections will be initialized during register call");
        }
        if (this._dscUpdater != null && this._dscUpdater.isRunning()) {
            this._dscUpdater.stop();
        }
    }

    protected void doShutdown() {
        LOG.info((Object)(((Object)((Object)this)).getClass().getSimpleName() + ": shutting down..."));
        this.unregisterMbeans();
        for (DatabusSourcesConnection relayConn : this._relayConnections) {
            relayConn.stop();
        }
        for (DatabusRegistration reg : this._regList) {
            LOG.info((Object)("Shutting down registration: " + reg.getRegistrationId()));
            try {
                if (reg.getState() == DatabusRegistration.RegistrationState.SHUTDOWN) continue;
                reg.shutdown();
            }
            catch (Exception ex) {
                LOG.error((Object)("Unable to shut down registration: " + reg.getRegistrationId()), (Throwable)ex);
            }
        }
        if (this._dscUpdater != null && this._dscUpdater.isRunning()) {
            this._dscUpdater.stop();
            this._dscUpdater.awaitShutdown();
        }
        if (this._groupMember != null) {
            this._groupMember.leave();
        }
        if (this._clientNode != null) {
            this._clientNode.close();
        }
        this._httpStatsCollector.registerMastershipStatus(0);
        super.doShutdown();
        LOG.info((Object)(((Object)((Object)this)).getClass().getSimpleName() + ": shutdown complete."));
    }

    protected void initializeClientCommandProcessors() throws DatabusException {
        this._processorRegistry.register("clientStats", (RequestProcessor)new ClientStatsRequestProcessor(null, this));
        this._processorRegistry.register("clientState", (RequestProcessor)new ClientStateRequestProcessor(null, this));
    }

    protected boolean waitForLeadership() {
        DatabusClientGroupMember member = this._groupMember;
        if (member != null && member.join()) {
            LOG.info((Object)("Waiting for leadership: " + member.toString()));
            if (this._dscUpdater != null) {
                Thread t = new Thread((Runnable)this._dscUpdater, "DscUpdater");
                t.setDaemon(true);
                t.start();
            }
            boolean acquiredLeadership = member.waitForLeaderShip();
            LOG.info((Object)("Acquired leadership=  " + acquiredLeadership + " member=" + member.toString()));
            return acquiredLeadership;
        }
        LOG.info((Object)("Started Failed! Non availability of group/cluster handler! http relay connection for sources:" + this.getRelayGroupStreamConsumers()));
        return false;
    }

    protected void unregisterMbeans() {
        this.getHttpStatsCollector().unregisterMBeans();
        this.getBootstrapEventsStatsCollector().unregisterMBeans();
        for (DbusEventsStatisticsCollector b : this._bootstrapEventsStats.getStatsCollectors()) {
            b.unregisterMBeans();
        }
        for (DatabusSourcesConnection conn : this._relayConnections) {
            conn.unregisterMbeans();
        }
    }

    protected ServerInfo getRandomRelay(Map<List<DatabusSubscription>, Set<ServerInfo>> groupsServers, List<DatabusSubscription> sources) throws DatabusClientException {
        List<ServerInfo> candidateServers = DatabusHttpClientImpl.findServers(groupsServers, sources);
        if (0 == candidateServers.size()) {
            throw new DatabusClientException("Unable to find servers to support sources: " + sources);
        }
        Random rng = new Random();
        ServerInfo randomRelay = candidateServers.get(rng.nextInt(candidateServers.size()));
        return randomRelay;
    }

    protected List<DatabusV2ConsumerRegistration> registerDatabusListener(DatabusV2ConsumerRegistration listener, Map<List<DatabusSubscription>, Set<ServerInfo>> groupsServers, Map<List<DatabusSubscription>, List<DatabusV2ConsumerRegistration>> groupsListeners, List<DatabusSubscription> sources) throws DatabusClientException {
        List subsSources = null;
        ServerInfo randomRelay = this.getRandomRelay(groupsServers, sources);
        if (null == randomRelay) {
            assert (this.getClientStaticConfig().usesDynamicRelayConfiguration()) : "Client relay(s) configured statically but no relays available at listener registration";
            subsSources = sources;
        } else {
            try {
                subsSources = DatabusSubscription.createFromUriList((Collection)randomRelay.getSources());
            }
            catch (DatabusException e) {
                throw new DatabusClientException("source list decode error:" + e.getMessage(), (Throwable)e);
            }
            catch (URISyntaxException e) {
                throw new DatabusClientException("source list decode error:" + e.getMessage(), (Throwable)e);
            }
        }
        List<DatabusV2ConsumerRegistration> consumers = DatabusHttpClientImpl.getListOfConsumerRegsFromSubList(groupsListeners, subsSources);
        if (null == consumers) {
            consumers = new CopyOnWriteArrayList<DatabusV2ConsumerRegistration>();
            groupsListeners.put(subsSources, consumers);
        }
        consumers.add(listener);
        return consumers;
    }

    protected static List<DatabusV2ConsumerRegistration> getListOfConsumerRegsFromSubList(Map<List<DatabusSubscription>, List<DatabusV2ConsumerRegistration>> groupsListeners, List<DatabusSubscription> subsSources) {
        return groupsListeners.get(subsSources);
    }

    protected DatabusComponentAdmin createComponentAdmin() {
        return new DatabusComponentAdmin((ServerContainer)this, this.getMbeanServer(), DatabusHttpClientImpl.class.getSimpleName());
    }

    protected DatabusComponentStatus createComponentStatus() {
        this._clientStatus = new DatabusHttpClientStatus();
        return this._clientStatus;
    }

    protected synchronized void doRegisterRelay(ServerInfo serverInfo) {
        LOG.info((Object)("Registering relay: " + serverInfo.toString()));
        List subList = DatabusSubscription.createSubscriptionList((List)serverInfo.getSources());
        Set<ServerInfo> sourceRelays = this._relayGroups.get(subList);
        if (null == sourceRelays) {
            sourceRelays = new HashSet<ServerInfo>(5);
            this._relayGroups.put(subList, sourceRelays);
        }
        sourceRelays.add(serverInfo);
    }

    public void setCMEnabled(boolean enabled) {
        this._cmEnabled = enabled;
    }

    protected synchronized void doUnregisterRelay(ServerInfo serverInfo) {
        Set<ServerInfo> sourceRelays = this._relayGroups.get(DatabusSubscription.createSubscriptionList((List)serverInfo.getSources()));
        if (null != sourceRelays) {
            LOG.info((Object)("Unregistering relay: " + serverInfo.toString()));
            sourceRelays.remove(serverInfo);
        }
    }

    String generateSubsStatsName(List<String> sourcesStrList) {
        int subsListSize = sourcesStrList.size();
        String lastSubs = subsListSize != 0 ? sourcesStrList.get(subsListSize - 1) : "null";
        String[] cmpt = lastSubs.split("\\.");
        String name = cmpt.length >= 4 ? cmpt[3] : lastSubs;
        LOG.info((Object)("sourcename= " + name));
        return name;
    }

    private synchronized void initializeRelayConnections() {
        for (List<DatabusSubscription> subsList : this._relayGroups.keySet()) {
            List sourcesStrList = DatabusSubscription.getStrList(subsList);
            List<DatabusV2ConsumerRegistration> relayConsumers = this.getRelayGroupStreamConsumers().get(subsList);
            if (null == relayConsumers || 0 == relayConsumers.size()) continue;
            try {
                DatabusSourcesConnection.StaticConfig connConfig = this.getClientStaticConfig().getConnection(sourcesStrList);
                if (null == connConfig) {
                    connConfig = this.getClientStaticConfig().getConnectionDefaults();
                }
                if (!connConfig.getEventBuffer().isEnableScnIndex() && connConfig.getEventBuffer().getQueuePolicy() != DbusEventBuffer.QueuePolicy.BLOCK_ON_WRITE) {
                    throw new InvalidConfigException("If SCN index is disabled, queue policy must be BLOCK_ON_WRITE");
                }
                CheckpointPersistenceProvider cpPersistenceProvder = this.getCheckpointPersistenceProvider();
                if (null != cpPersistenceProvder && this.getClientStaticConfig().getCheckpointPersistence().isClearBeforeUse()) {
                    cpPersistenceProvder.removeCheckpoint(sourcesStrList);
                }
                ServerInfo server0 = this._relayGroups.get(subsList).iterator().next();
                ArrayList<DatabusV2ConsumerRegistration> bstConsumersRegs = new ArrayList<DatabusV2ConsumerRegistration>();
                for (List<DatabusSubscription> bstSubSourcesList : this.getRelayGroupBootstrapConsumers().keySet()) {
                    List<DatabusV2ConsumerRegistration> bstRegsistrations = this.getRelayGroupBootstrapConsumers().get(bstSubSourcesList);
                    for (DatabusV2ConsumerRegistration bstConsumerReg : bstRegsistrations) {
                        if (!server0.supportsSources(bstConsumerReg.getSources())) continue;
                        bstConsumersRegs.add(bstConsumerReg);
                    }
                }
                DbusEventBuffer eventBuffer = connConfig.getEventBuffer().getOrCreateEventBuffer(this._eventFactory);
                eventBuffer.setDropOldEvents(true);
                eventBuffer.start(0L);
                DbusEventBuffer bootstrapBuffer = null;
                if (this._clientStaticConfig.getRuntime().getBootstrap().isEnabled()) {
                    bootstrapBuffer = new DbusEventBuffer(connConfig.getEventBuffer());
                    bootstrapBuffer.setDropOldEvents(false);
                    bootstrapBuffer.start(0L);
                }
                LOG.info((Object)("The sourcesList is " + sourcesStrList));
                LOG.info((Object)("The relayGroupStreamConsumers is " + this.getRelayGroupStreamConsumers().get(subsList)));
                Set<ServerInfo> relays = this._relayGroups.get(subsList);
                Set<ServerInfo> bootstrapServices = this._bootstrapGroups.get(subsList);
                String statsCollectorName = this.generateSubsStatsName(sourcesStrList);
                int ownerId = this.getContainerStaticConfig().getId();
                this._bootstrapEventsStats.addStatsCollector(statsCollectorName, (StatsCollectorMergeable)new DbusEventsStatisticsCollector(ownerId, statsCollectorName + ".inbound.bs", true, false, this.getMbeanServer()));
                this._inBoundStatsCollectors.addStatsCollector(statsCollectorName, (StatsCollectorMergeable)new DbusEventsStatisticsCollector(ownerId, statsCollectorName + ".inbound", true, false, this.getMbeanServer()));
                this._outBoundStatsCollectors.addStatsCollector(statsCollectorName, (StatsCollectorMergeable)new DbusEventsStatisticsCollector(ownerId, statsCollectorName + ".outbound", true, false, this.getMbeanServer()));
                this._consumerStatsCollectors.addStatsCollector(statsCollectorName, (StatsCollectorMergeable)new ConsumerCallbackStats(ownerId, statsCollectorName + ".inbound.cons", statsCollectorName + ".inbound.cons", true, false, null, this.getMbeanServer()));
                this._bsConsumerStatsCollectors.addStatsCollector(statsCollectorName, (StatsCollectorMergeable)new ConsumerCallbackStats(ownerId, statsCollectorName + ".inbound.bs.cons", statsCollectorName + ".inbound.bs.cons", true, false, null, this.getMbeanServer()));
                this._unifiedClientStatsCollectors.addStatsCollector(statsCollectorName, (StatsCollectorMergeable)new UnifiedClientStats(ownerId, statsCollectorName + ".inbound.unified.cons", statsCollectorName + ".inbound.unified.cons", true, false, this._clientStaticConfig.getPullerThreadDeadnessThresholdMs(), null, this.getMbeanServer()));
                ConnectionStateFactory connStateFactory = new ConnectionStateFactory(DatabusSubscription.getStrList(subsList));
                DatabusSourcesConnection newConn = new DatabusSourcesConnection(connConfig, subsList, relays, bootstrapServices, relayConsumers, bstConsumersRegs, eventBuffer, bootstrapBuffer, this.getDefaultExecutorService(), this.getContainerStatsCollector(), (DbusEventsStatisticsCollector)this._inBoundStatsCollectors.getStatsCollector(statsCollectorName), (DbusEventsStatisticsCollector)this._bootstrapEventsStats.getStatsCollector(statsCollectorName), (ConsumerCallbackStats)this._consumerStatsCollectors.getStatsCollector(statsCollectorName), (ConsumerCallbackStats)this._bsConsumerStatsCollectors.getStatsCollector(statsCollectorName), (UnifiedClientStats)this._unifiedClientStatsCollectors.getStatsCollector(statsCollectorName), this.getCheckpointPersistenceProvider(), this.getRelayConnFactory(), this.getBootstrapConnFactory(), this.getHttpStatsCollector(), null, this, this._eventFactory, connStateFactory);
                newConn.start();
                this._relayConnections.add(newConn);
            }
            catch (Exception e) {
                LOG.error((Object)("connection initialization issue for source(s):" + subsList + "; please check your configuration"), (Throwable)e);
            }
        }
        if (0 == this._relayConnections.size()) {
            LOG.warn((Object)"No connections specified");
        }
    }

    protected static List<ServerInfo> findServers(Map<List<DatabusSubscription>, Set<ServerInfo>> groups, List<DatabusSubscription> subs) {
        boolean debugEnabled = LOG.isDebugEnabled();
        ArrayList<ServerInfo> result = new ArrayList<ServerInfo>(10);
        for (Map.Entry<List<DatabusSubscription>, Set<ServerInfo>> entry : groups.entrySet()) {
            List<DatabusSubscription> serverSubs = entry.getKey();
            if (ServerInfo.checkSubsequenceSubsV3(subs, serverSubs)) {
                result.addAll((Collection<ServerInfo>)entry.getValue());
            }
            if (!debugEnabled) continue;
            LOG.debug((Object)("Log an individual entry in group " + entry));
        }
        return result;
    }

    private static List<ServerInfo> parseServerInfosMap(Map<String, ServerInfo.ServerInfoBuilder> map) throws InvalidConfigException {
        ArrayList<ServerInfo> infos = new ArrayList<ServerInfo>((int)((double)map.size() * 1.3));
        for (Map.Entry<String, ServerInfo.ServerInfoBuilder> entry : map.entrySet()) {
            LOG.info((Object)("parseServerInfo: " + entry.toString()));
            ServerInfo.ServerInfoBuilder builder = entry.getValue();
            boolean added = infos.add(builder.build());
            LOG.info((Object)("added=" + added));
        }
        LOG.info((Object)("info size=" + infos.size()));
        return infos;
    }

    public Map<RegistrationId, DatabusV3Registration> getRegistrationIdMap() {
        return null;
    }

    public DatabusSourcesConnection getDatabusSourcesConnection(String regIdStr) {
        return null;
    }

    public DatabusV3Registration getRegistration(RegistrationId rid) {
        throw new UnsupportedOperationException();
    }

    public DbusEventFactory getEventFactory() {
        return this._eventFactory;
    }

    public Map<RegistrationId, DbusClusterInfo> getAllClientClusters() {
        HashMap<RegistrationId, DbusClusterInfo> clusters = new HashMap<RegistrationId, DbusClusterInfo>();
        Collection<DatabusMultiPartitionRegistration> regs = this.getAllClientClusterRegistrations();
        for (DatabusMultiPartitionRegistration reg : regs) {
            if (!(reg instanceof DatabusV2ClusterRegistrationImpl)) continue;
            DatabusV2ClusterRegistrationImpl r = (DatabusV2ClusterRegistrationImpl)reg;
            clusters.put(new RegistrationId(r.getRegistrationId().getId()), r.getClusterInfo());
        }
        return clusters;
    }

    protected class DatabusHttpClientStatus
    extends DatabusComponentStatus {
        public DatabusHttpClientStatus() {
            super("DatabusHttpClientImpl");
        }

        public DatabusComponentStatus.Status getStatus() {
            if (!DatabusHttpClientImpl.this._relayConnections.isEmpty()) {
                return DatabusHttpClientImpl.this._relayConnections.get(0).getConnectionStatus().getStatus();
            }
            if (!DatabusHttpClientImpl.this._regList.isEmpty()) {
                return ((DatabusRegistration)DatabusHttpClientImpl.this._regList.get(0)).getStatus().getStatus();
            }
            return null;
        }

        public String getMessage() {
            if (!DatabusHttpClientImpl.this._relayConnections.isEmpty()) {
                return DatabusHttpClientImpl.this._relayConnections.get(0).getConnectionStatus().getMessage();
            }
            if (!DatabusHttpClientImpl.this._regList.isEmpty()) {
                return ((DatabusRegistration)DatabusHttpClientImpl.this._regList.get(0)).getStatus().getMessage();
            }
            return null;
        }

        public void pause() {
            super.pause();
            for (DatabusSourcesConnection relayConn : DatabusHttpClientImpl.this._relayConnections) {
                relayConn.getConnectionStatus().pause();
            }
            for (DatabusRegistration reg : DatabusHttpClientImpl.this._regList) {
                LOG.info((Object)("Pausing registration :" + reg.getRegistrationId()));
                try {
                    if (!reg.getState().isRunning()) continue;
                    reg.pause();
                }
                catch (Exception ex) {
                    LOG.error((Object)("Unable to pause registration :" + reg.getRegistrationId()), (Throwable)ex);
                }
            }
        }

        public void resume() {
            for (DatabusSourcesConnection relayConn : DatabusHttpClientImpl.this._relayConnections) {
                relayConn.getConnectionStatus().resume();
            }
            for (DatabusRegistration reg : DatabusHttpClientImpl.this._regList) {
                LOG.info((Object)("Resuming registration :" + reg.getRegistrationId()));
                try {
                    if (reg.getState() != DatabusRegistration.RegistrationState.PAUSED) continue;
                    reg.resume();
                }
                catch (Exception ex) {
                    LOG.error((Object)("Unable to resume registration :" + reg.getRegistrationId()), (Throwable)ex);
                }
            }
            super.resume();
        }

        public void suspendOnError(Throwable cause) {
            super.suspendOnError(cause);
            for (DatabusSourcesConnection relayConn : DatabusHttpClientImpl.this._relayConnections) {
                relayConn.getConnectionStatus().suspendOnError(cause);
            }
            for (DatabusRegistration reg : DatabusHttpClientImpl.this._regList) {
                LOG.info((Object)("Suspending registration :" + reg.getRegistrationId()));
                try {
                    if (!reg.getState().isRunning()) continue;
                    reg.suspendOnError(cause);
                }
                catch (Exception ex) {
                    LOG.error((Object)("Unable to suspend registration :" + reg.getRegistrationId()), (Throwable)ex);
                }
            }
        }

        public void shutdown() {
            for (DatabusSourcesConnection relayConn : DatabusHttpClientImpl.this._relayConnections) {
                relayConn.getConnectionStatus().shutdown();
            }
            for (DatabusRegistration reg : DatabusHttpClientImpl.this._regList) {
                LOG.info((Object)("Shutting down registration :" + reg.getRegistrationId()));
                try {
                    if (reg.getState() == DatabusRegistration.RegistrationState.SHUTDOWN) continue;
                    reg.shutdown();
                }
                catch (Exception ex) {
                    LOG.error((Object)("Unable to shutdown registration :" + reg.getRegistrationId()), (Throwable)ex);
                }
            }
            super.shutdown();
        }

        public Map<List<DatabusSubscription>, Set<ServerInfo>> getRelayGroups() {
            return DatabusHttpClientImpl.this._relayGroups;
        }
    }

    public static class Config
    extends StaticConfigBuilderBase
    implements ConfigBuilder<StaticConfig> {
        public StaticConfig build() throws InvalidConfigException {
            this.verifyConfig();
            this.getConnectionDefaults().setConsumeCurrent(!this.getRuntime().getBootstrap().isEnabled());
            this.getConnectionDefaults().setPullerBufferUtilizationPct(this._pullerBufferUtilizationPct);
            this.getConnectionDefaults().setReadLatestScnOnError(this._enableReadLatestOnRelayFallOff);
            ServerContainer.StaticConfig sconfig = this.getContainer().build();
            this.getConnectionDefaults().setId(sconfig.getId());
            this._connConfigs = new HashMap((int)((double)this._connections.size() * 1.3));
            for (String connKey : this._connections.keySet()) {
                String[] keySources = connKey.split("[,]");
                for (int i = 0; i < keySources.length; ++i) {
                    keySources[i] = keySources[i].trim();
                }
                DatabusSourcesConnection.Config confBuilder = (DatabusSourcesConnection.Config)this._connections.get(connKey);
                confBuilder.setId(sconfig.getId());
                this._connConfigs.put(Arrays.asList(keySources), confBuilder.build());
            }
            HashMap<String, ClusterRegistrationStaticConfig> clientClusterStaticConfigs = new HashMap<String, ClusterRegistrationStaticConfig>();
            for (Map.Entry e : this._clientClusters.entrySet()) {
                String clusterName = ((ClusterRegistrationConfig)e.getValue()).getClusterName();
                if (clientClusterStaticConfigs.containsKey(clusterName)) {
                    throw new InvalidConfigException("Duplicate configuration for client cluster :" + clusterName);
                }
                ClusterRegistrationStaticConfig c = ((ClusterRegistrationConfig)e.getValue()).build();
                clientClusterStaticConfigs.put(clusterName, c);
            }
            return new StaticConfig(this.getCheckpointPersistence().build(), sconfig, this.getRuntime(), this.getRuntimeConfigPrefix(), this.getConnectionDefaults().build(), this._connConfigs, this.getHttpStatsCollector().build(), this.getLoggingListener().build(), this.getCluster().build(), this._dscUpdateIntervalMs, this._pullerThreadDeadnessThresholdMs, this._pullerBufferUtilizationPct, this._enableReadLatestOnRelayFallOff, this._enablePerConnectionStats, this.usesDynamicRelayConfiguration(), clientClusterStaticConfigs);
        }
    }

    public static class StaticConfigBuilderBase {
        protected CheckpointPersistenceStaticConfigBuilder _checkpointPersistence;
        protected ServerContainer.Config _container;
        protected RuntimeConfigBuilder _runtime = new RuntimeConfigBuilder();
        protected String _runtimeConfigPrefix = "databus.client.";
        protected DatabusSourcesConnection.Config _connectionDefaults;
        protected Map<String, DatabusSourcesConnection.Config> _connections;
        protected HttpStatisticsCollector.Config _httpStatsCollector;
        protected LoggingConsumer.Config _loggingListener;
        protected DatabusClientNode.Config _cluster;
        protected long _dscUpdateIntervalMs = 5000L;
        protected long _pullerThreadDeadnessThresholdMs = 300000L;
        protected int _pullerBufferUtilizationPct = 100;
        protected boolean _enablePerConnectionStats = false;
        protected Map<String, ClusterRegistrationConfig> _clientClusters;
        protected boolean _enableReadLatestOnRelayFallOff = false;
        protected HashMap<List<String>, DatabusSourcesConnection.StaticConfig> _connConfigs;

        public StaticConfigBuilderBase() {
            this.setCheckpointPersistence(new CheckpointPersistenceStaticConfigBuilder());
            ServerContainer.Config containerCfg = new ServerContainer.Config();
            containerCfg.setHttpPort(containerCfg.getHttpPort() + 1);
            containerCfg.getJmx().setJmxServicePort(containerCfg.getJmx().getJmxServicePort() + 1);
            this.setContainer(containerCfg);
            this._connectionDefaults = new DatabusSourcesConnection.Config();
            this._connections = new HashMap<String, DatabusSourcesConnection.Config>(5);
            this._clientClusters = new HashMap<String, ClusterRegistrationConfig>();
            this._httpStatsCollector = new HttpStatisticsCollector.Config();
            this._loggingListener = new LoggingConsumer.Config();
            this._cluster = new DatabusClientNode.Config();
        }

        protected void verifyConfig() throws InvalidConfigException {
            if (this._pullerBufferUtilizationPct <= 0 || this._pullerBufferUtilizationPct > 100) {
                throw new InvalidConfigException("invalid puller buffer utilization percentage:" + this._pullerBufferUtilizationPct);
            }
        }

        public CheckpointPersistenceStaticConfigBuilder getCheckpointPersistence() {
            return this._checkpointPersistence;
        }

        public void setCheckpointPersistence(CheckpointPersistenceStaticConfigBuilder checkpointPersistence) {
            this._checkpointPersistence = checkpointPersistence;
            this._checkpointPersistence.setRuntimeConfigPrefix(this._runtimeConfigPrefix + "checkpoint.");
            this._runtime.setCheckpointPersistence(checkpointPersistence.getRuntime());
        }

        public ServerContainer.Config getContainer() {
            return this._container;
        }

        public void setContainer(ServerContainer.Config container) {
            this._container = container;
            this._container.setRuntimeConfigPropertyPrefix(this._runtimeConfigPrefix + "runtime.");
            this._runtime.setContainer(container.getRuntime());
        }

        public RuntimeConfigBuilder getRuntime() {
            return this._runtime;
        }

        public void setRuntime(RuntimeConfigBuilder runtime) {
            this._runtime = runtime;
        }

        public String getRuntimeConfigPrefix() {
            return this._runtimeConfigPrefix;
        }

        public void setRuntimeConfigPrefix(String runtimeConfigPrefix) {
            this._runtimeConfigPrefix = runtimeConfigPrefix;
            this._container.setRuntimeConfigPropertyPrefix(this._runtimeConfigPrefix + "runtime.");
            this._checkpointPersistence.setRuntimeConfigPrefix(this._runtimeConfigPrefix + "checkpoint.");
        }

        public int getPullerBufferUtilizationPct() {
            return this._pullerBufferUtilizationPct;
        }

        public void setPullerBufferUtilizationPct(int pullerBufferUtilizationPct) {
            this._pullerBufferUtilizationPct = pullerBufferUtilizationPct;
        }

        public boolean isEnableReadLatestOnRelayFallOff() {
            return this._enableReadLatestOnRelayFallOff;
        }

        public void setEnableReadLatestOnRelayFallOff(boolean enableReadLatestOnRelayFallOff) {
            this._enableReadLatestOnRelayFallOff = enableReadLatestOnRelayFallOff;
        }

        public DatabusSourcesConnection.Config getConnection(String id) {
            DatabusSourcesConnection.Config conn = this._connections.get(id);
            if (null == conn) {
                conn = new DatabusSourcesConnection.Config(this._connectionDefaults);
                this._connections.put(id, conn);
            }
            return conn;
        }

        public void setConnection(String id, DatabusSourcesConnection.Config conn) {
            this._connections.put(id, conn);
        }

        public ClusterRegistrationConfig getClientCluster(String id) {
            ClusterRegistrationConfig cluster = this._clientClusters.get(id);
            if (null == cluster) {
                cluster = new ClusterRegistrationConfig();
                this._clientClusters.put(id, cluster);
            }
            return cluster;
        }

        public void setClientCluster(String id, ClusterRegistrationConfig cluster) {
            this._clientClusters.put(id, cluster);
        }

        public HttpStatisticsCollector.Config getHttpStatsCollector() {
            return this._httpStatsCollector;
        }

        public void setHttpStatsCollector(HttpStatisticsCollector.Config httpStatsCollector) {
            this._httpStatsCollector = httpStatsCollector;
        }

        public LoggingConsumer.Config getLoggingListener() {
            return this._loggingListener;
        }

        public void setLoggingListener(LoggingConsumer.Config loggingListener) {
            this._loggingListener = loggingListener;
        }

        public long getDscUpdateIntervalMs() {
            return this._dscUpdateIntervalMs;
        }

        public void setDscUpdateIntervalMs(long dscUpdateIntervalMs) {
            this._dscUpdateIntervalMs = dscUpdateIntervalMs;
        }

        public long getPullerThreadDeadnessThresholdMs() {
            return this._pullerThreadDeadnessThresholdMs;
        }

        public void setPullerThreadDeadnessThresholdMs(long pullerThreadDeadnessThresholdMs) {
            this._pullerThreadDeadnessThresholdMs = pullerThreadDeadnessThresholdMs;
        }

        public DatabusClientNode.Config getCluster() {
            return this._cluster;
        }

        public void setCluster(DatabusClientNode.Config cluster) {
            this._cluster = cluster;
        }

        public DatabusSourcesConnection.Config getConnectionDefaults() {
            return this._connectionDefaults;
        }

        public void setConnectionDefaults(DatabusSourcesConnection.Config connectionDefaults) {
            this._connectionDefaults = connectionDefaults;
        }

        public boolean isEnablePerConnectionStats() {
            return this._enablePerConnectionStats;
        }

        public void setEnablePerConnectionStats(boolean enablePerConnectionStats) {
            this._enablePerConnectionStats = enablePerConnectionStats;
        }

        public boolean usesDynamicRelayConfiguration() {
            return false;
        }
    }

    public static class StaticConfig {
        private final CheckpointPersistenceStaticConfig _checkpointPersistence;
        private final ServerContainer.StaticConfig _container;
        private final RuntimeConfigBuilder _runtime;
        private final String _runtimeConfigPrefix;
        private final DatabusSourcesConnection.StaticConfig _connectionDefaults;
        private final Map<List<String>, DatabusSourcesConnection.StaticConfig> _connections;
        private final HttpStatisticsCollector.StaticConfig _httpStatsCollector;
        private final LoggingConsumer.StaticConfig _loggingListener;
        private final DatabusClientNode.StaticConfig _cluster;
        private final long _dscUpdateIntervalMs;
        private final long _pullerThreadDeadnessThresholdMs;
        private final int _pullerBufferUtilizationPct;
        private final boolean _enableReadLatestOnRelayFallOff;
        private final boolean _enablePerConnectionStats;
        private final boolean _usesDynamicRelayConfiguration;
        private final Map<String, ClusterRegistrationStaticConfig> _clientClusters;

        public StaticConfig(CheckpointPersistenceStaticConfig checkpointPersistence, ServerContainer.StaticConfig container, RuntimeConfigBuilder runtime, String runtimeConfigPrefix, DatabusSourcesConnection.StaticConfig connectionDefaults, Map<List<String>, DatabusSourcesConnection.StaticConfig> connections, HttpStatisticsCollector.StaticConfig httpStatsCollector, LoggingConsumer.StaticConfig loggingListener, DatabusClientNode.StaticConfig cluster, long dscUpdateIntervalMs, long pullerThreadDeadnessThresholdMs, int pullerBufferUtilizationPct, boolean enableReadLatestOnRelayFallOff, boolean enablePerConnectionStats, boolean usesDynamicRelayConfiguration, Map<String, ClusterRegistrationStaticConfig> clientClusters) {
            this._checkpointPersistence = checkpointPersistence;
            this._container = container;
            this._runtime = runtime;
            this._runtimeConfigPrefix = runtimeConfigPrefix;
            this._connections = connections;
            this._connectionDefaults = connectionDefaults;
            this._httpStatsCollector = httpStatsCollector;
            this._loggingListener = loggingListener;
            this._cluster = cluster;
            this._dscUpdateIntervalMs = dscUpdateIntervalMs;
            this._pullerThreadDeadnessThresholdMs = pullerThreadDeadnessThresholdMs;
            this._pullerBufferUtilizationPct = pullerBufferUtilizationPct;
            this._enableReadLatestOnRelayFallOff = enableReadLatestOnRelayFallOff;
            this._enablePerConnectionStats = enablePerConnectionStats;
            this._usesDynamicRelayConfiguration = usesDynamicRelayConfiguration;
            this._clientClusters = clientClusters;
        }

        public long getDSCUpdateIntervalMs() {
            return this._dscUpdateIntervalMs;
        }

        public long getPullerThreadDeadnessThresholdMs() {
            return this._pullerThreadDeadnessThresholdMs;
        }

        public CheckpointPersistenceStaticConfig getCheckpointPersistence() {
            return this._checkpointPersistence;
        }

        public ServerContainer.StaticConfig getContainer() {
            return this._container;
        }

        public RuntimeConfigBuilder getRuntime() {
            return this._runtime;
        }

        public DatabusClientNode.StaticConfig getCluster() {
            return this._cluster;
        }

        public String getRuntimeConfigPrefix() {
            return this._runtimeConfigPrefix;
        }

        public Map<List<String>, DatabusSourcesConnection.StaticConfig> getConnections() {
            return this._connections;
        }

        public DatabusSourcesConnection.StaticConfig getConnection(List<String> id) {
            return this._connections.get(id);
        }

        public ClusterRegistrationStaticConfig getClientCluster(String clusterName) {
            return this._clientClusters.get(clusterName);
        }

        public DatabusSourcesConnection.StaticConfig getConnectionDefaults() {
            return this._connectionDefaults;
        }

        public HttpStatisticsCollector.StaticConfig getHttpStatsCollector() {
            return this._httpStatsCollector;
        }

        public LoggingConsumer.StaticConfig getLoggingListener() {
            return this._loggingListener;
        }

        public int getPullerBufferUtilizationPct() {
            return this._pullerBufferUtilizationPct;
        }

        public boolean isReadLatestScnOnErrorEnabled() {
            return this._enableReadLatestOnRelayFallOff;
        }

        public boolean isEnablePerConnectionStats() {
            return this._enablePerConnectionStats;
        }

        public boolean usesDynamicRelayConfiguration() {
            return this._usesDynamicRelayConfiguration;
        }

        public String toString() {
            return "StaticConfig [_checkpointPersistence=" + this._checkpointPersistence + ", _container=" + this._container + ", _runtime=" + this._runtime + ", _runtimeConfigPrefix=" + this._runtimeConfigPrefix + ", _connectionDefaults=" + this._connectionDefaults + ", _connections=" + this._connections + ", _httpStatsCollector=" + this._httpStatsCollector + ", _loggingListener=" + this._loggingListener + ", _cluster=" + this._cluster + ", _dscUpdateIntervalMs=" + this._dscUpdateIntervalMs + ", _pullerThreadDeadnessThresholdMs=" + this._pullerThreadDeadnessThresholdMs + ", _pullerBufferUtilizationPct=" + this._pullerBufferUtilizationPct + ", _enableReadLatestOnRelayFallOff=" + this._enableReadLatestOnRelayFallOff + ", _enablePerConnectionStats=" + this._enablePerConnectionStats + ", _usesDynamicRelayConfiguration=" + this._usesDynamicRelayConfiguration + ", _clientClusters=" + this._clientClusters + "]";
        }
    }

    public static class RuntimeConfigBuilder
    implements ConfigBuilder<RuntimeConfig> {
        private ServerContainer.RuntimeConfigBuilder _container = new ServerContainer.RuntimeConfigBuilder();
        private CheckpointPersistenceRuntimeConfigBuilder _checkpointPersistence = new CheckpointPersistenceRuntimeConfigBuilder();
        private DatabusHttpClientImpl _managedInstance = null;
        private final Map<String, ServerInfo.ServerInfoBuilder> _relays = new HashMap<String, ServerInfo.ServerInfoBuilder>();
        private HttpStatisticsCollector.RuntimeConfigBuilder _httpStatsCollector = new HttpStatisticsCollector.RuntimeConfigBuilder();
        private LoggingConsumer.RuntimeConfigBuilder _loggingListener = new LoggingConsumer.RuntimeConfigBuilder();
        private BootstrapClientRuntimeConfigBuilder _bootstrap = new BootstrapClientRuntimeConfigBuilder();
        private String _relaysList = "";

        public ServerContainer.RuntimeConfigBuilder getContainer() {
            return this._container;
        }

        public void setContainer(ServerContainer.RuntimeConfigBuilder container) {
            this._container = container;
        }

        public CheckpointPersistenceRuntimeConfigBuilder getCheckpointPersistence() {
            return this._checkpointPersistence;
        }

        public void setCheckpointPersistence(CheckpointPersistenceRuntimeConfigBuilder checkpointPersistence) {
            this._checkpointPersistence = checkpointPersistence;
        }

        public DatabusHttpClientImpl getManagedInstance() {
            return this._managedInstance;
        }

        public void setManagedInstance(DatabusHttpClientImpl managedInstance) {
            this._managedInstance = managedInstance;
            if (null != this._managedInstance) {
                this._container.setManagedInstance((ServerContainer)this._managedInstance);
                this._checkpointPersistence.setManagedInstance(this._managedInstance);
                this._httpStatsCollector.setManagedInstance(this._managedInstance.getHttpStatsCollector());
                this._loggingListener.managedInstance(this._managedInstance.getLoggingListener());
                this._bootstrap.setManagedInstance(this._managedInstance);
            }
        }

        public ServerInfo.ServerInfoBuilder getRelay(String id) {
            ServerInfo.ServerInfoBuilder relay = this.getRelays().get(id);
            if (null == relay) {
                relay = new ServerInfo.ServerInfoBuilder();
                this.setRelay(id, relay);
            }
            return relay;
        }

        public void setRelay(String id, ServerInfo.ServerInfoBuilder serverInfo) {
            this._relays.put(id, serverInfo);
        }

        public Map<String, ServerInfo.ServerInfoBuilder> getRelays() {
            return this._relays;
        }

        public RuntimeConfig build() throws InvalidConfigException {
            if (null == this._managedInstance) {
                throw new InvalidConfigException("No associated http client for runtime config");
            }
            List<ServerInfo> relays = DatabusHttpClientImpl.parseServerInfosMap(this.getRelays());
            LOG.info((Object)("Relays size=" + relays.size()));
            if (null != this._relaysList && this._relaysList.length() > 0) {
                relays = RuntimeConfigBuilder.parseServerInfoList(this._relaysList, relays);
            }
            LOG.info((Object)("Relays size=" + relays.size()));
            DatabusHttpClientImpl databusHttpClientImpl = this._managedInstance;
            ((Object)((Object)databusHttpClientImpl)).getClass();
            return databusHttpClientImpl.new RuntimeConfig(this.getContainer().build(), this.getCheckpointPersistence().build(), relays, this.getHttpStatsCollector().build(), this.getLoggingListener().build(), this.getBootstrap().build());
        }

        static List<ServerInfo> parseServerInfoList(String serversList, List<ServerInfo> servers) throws InvalidConfigException {
            if (null == servers) {
                servers = new ArrayList<ServerInfo>(10);
            }
            ServerInfo.ServerInfoSetBuilder builder = new ServerInfo.ServerInfoSetBuilder();
            builder.setServers(serversList);
            servers.addAll(builder.build());
            return servers;
        }

        public HttpStatisticsCollector.RuntimeConfigBuilder getHttpStatsCollector() {
            return this._httpStatsCollector;
        }

        public void setHttpStatsCollector(HttpStatisticsCollector.RuntimeConfigBuilder httpStatsCollector) {
            this._httpStatsCollector = httpStatsCollector;
        }

        public LoggingConsumer.RuntimeConfigBuilder getLoggingListener() {
            return this._loggingListener;
        }

        public void setLoggingListener(LoggingConsumer.RuntimeConfigBuilder loggingListener) {
            this._loggingListener = loggingListener;
        }

        public BootstrapClientRuntimeConfigBuilder getBootstrap() {
            return this._bootstrap;
        }

        public void setBootstrap(BootstrapClientRuntimeConfigBuilder bootstrap) {
            this._bootstrap = bootstrap;
        }

        public String getRelaysList() {
            return this._relaysList;
        }

        public void setRelaysList(String relaysList) {
            this._relaysList = relaysList;
        }
    }

    public class RuntimeConfig
    implements ConfigApplier<RuntimeConfig> {
        private final ServerContainer.RuntimeConfig _container;
        private final CheckpointPersistenceRuntimeConfig _checkpointPersistence;
        private final List<ServerInfo> _relays;
        private final HttpStatisticsCollector.RuntimeConfig _httpStatsCollector;
        private final LoggingConsumer.RuntimeConfig _loggingListener;
        private final BootstrapClientRuntimeConfig _bootstrap;

        public RuntimeConfig(ServerContainer.RuntimeConfig container, CheckpointPersistenceRuntimeConfig checkpoint, List<ServerInfo> relays, HttpStatisticsCollector.RuntimeConfig httpStatsCollector, LoggingConsumer.RuntimeConfig loggingListener, BootstrapClientRuntimeConfig bootstrap) {
            this._container = container;
            this._checkpointPersistence = checkpoint;
            this._relays = relays;
            this._httpStatsCollector = httpStatsCollector;
            this._loggingListener = loggingListener;
            this._bootstrap = bootstrap;
        }

        public ServerContainer.RuntimeConfig getContainer() {
            return this._container;
        }

        public CheckpointPersistenceRuntimeConfig getCheckpointPersistence() {
            return this._checkpointPersistence;
        }

        public List<ServerInfo> getRelays() {
            return this._relays;
        }

        public Set<ServerInfo> getRelaysSet() {
            return new HashSet<ServerInfo>(this._relays);
        }

        public void addRelay(ServerInfo si) {
            if (!DatabusHttpClientImpl.this._cmEnabled) {
                LOG.error((Object)"Supported only when Helix Integration is enabled (i.e., V3 client + CM enabled");
            }
            LOG.info((Object)("Adding relay with name " + si.getName() + " " + si.getAddress().getHostName() + " " + si.getAddress().getPort()));
            this._relays.add(si);
        }

        public void removeRelay(ServerInfo si) {
            if (!DatabusHttpClientImpl.this._cmEnabled) {
                LOG.error((Object)"Supported only when Helix Integration is enabled (i.e., V3 client + CM enabled");
            }
            LOG.info((Object)("Removing relay with name " + si.getName() + " " + si.getAddress().getHostName() + " " + si.getAddress().getPort()));
            this._relays.remove(si);
        }

        public void updateRelaySet(Set<ServerInfo> ssi) {
            if (!DatabusHttpClientImpl.this._cmEnabled) {
                LOG.error((Object)"Supported only when Helix Integration is enabled (i.e., V3 client + CM enabled");
            }
            LOG.info((Object)"Updating relay set ");
            for (ServerInfo si : ssi) {
                LOG.info((Object)(si.getName() + " " + si.getAddress().getHostName() + " " + si.getAddress().getPort()));
            }
            this._relays.addAll(ssi);
        }

        public BootstrapClientRuntimeConfig getBootstrap() {
            return this._bootstrap;
        }

        public HttpStatisticsCollector.RuntimeConfig getHttpStatsCollector() {
            return this._httpStatsCollector;
        }

        public LoggingConsumer.RuntimeConfig getLoggingListener() {
            return this._loggingListener;
        }

        public void applyNewConfig(RuntimeConfig oldConfig) {
            LOG.info((Object)"Applying runtime client config");
            if (null == oldConfig || !this.getContainer().equals((Object)oldConfig.getContainer())) {
                this.getContainer().applyNewConfig(null != oldConfig ? oldConfig.getContainer() : null);
            }
            if (!(this.getCheckpointPersistence() == null || null != oldConfig && this.getCheckpointPersistence().equals(oldConfig.getCheckpointPersistence()))) {
                this.getCheckpointPersistence().applyNewConfig(null != oldConfig ? oldConfig.getCheckpointPersistence() : null);
            }
            if (null == oldConfig || !((Object)this.getRelays()).equals(oldConfig.getRelays())) {
                if (null != oldConfig) {
                    for (ServerInfo serverInfo : oldConfig.getRelays()) {
                        if (this.getRelays().contains(serverInfo)) continue;
                        DatabusHttpClientImpl.this.doUnregisterRelay(serverInfo);
                    }
                }
                for (ServerInfo serverInfo : this.getRelays()) {
                    if (null != oldConfig && oldConfig.getRelays().contains(serverInfo)) continue;
                    DatabusHttpClientImpl.this.doRegisterRelay(serverInfo);
                }
            }
            if (null == oldConfig || !((Object)DatabusHttpClientImpl.this.getBootstrapServices()).equals(oldConfig.getBootstrap().getServices())) {
                if (null != oldConfig) {
                    for (ServerInfo serverInfo : oldConfig.getBootstrap().getServices()) {
                        if (DatabusHttpClientImpl.this.getBootstrapServices().contains(serverInfo)) continue;
                        DatabusHttpClientImpl.this.doUnregisterBootstrapService(serverInfo);
                    }
                }
                for (ServerInfo serverInfo : this.getBootstrap().getServices()) {
                    if (null != oldConfig && oldConfig.getBootstrap().getServices().contains(serverInfo)) continue;
                    DatabusHttpClientImpl.this.doRegisterBootstrapService(serverInfo);
                }
            }
        }

        public boolean equals(Object otherConfig) {
            if (null == otherConfig || !(otherConfig instanceof RuntimeConfig)) {
                return false;
            }
            return this.equalsConfig((RuntimeConfig)otherConfig);
        }

        public boolean equalsConfig(RuntimeConfig otherConfig) {
            if (null == otherConfig) {
                return false;
            }
            return this.getContainer().equals((Object)otherConfig.getContainer()) && this.getCheckpointPersistence().equals(otherConfig.getCheckpointPersistence());
        }

        public int hashCode() {
            return this._container.hashCode() ^ this._checkpointPersistence.hashCode();
        }
    }

    public static class CheckpointPersistenceStaticConfigBuilder
    implements ConfigBuilder<CheckpointPersistenceStaticConfig> {
        private String _type = CheckpointPersistenceStaticConfig.ProviderType.FILE_SYSTEM.toString();
        private FileSystemCheckpointPersistenceProvider.Config _fileSystem = new FileSystemCheckpointPersistenceProvider.Config();
        private SharedCheckpointPersistenceProvider.Config _sharedState;
        private CheckpointPersistenceProvider _existing = null;
        private CheckpointPersistenceRuntimeConfigBuilder _runtime = new CheckpointPersistenceRuntimeConfigBuilder();
        private String _runtimeConfigPrefix;
        private boolean _clearBeforeUse;
        private int _protocolVersion;

        public CheckpointPersistenceStaticConfigBuilder() {
            this._runtime.setFileSystem(this._fileSystem.getRuntime());
            this.setRuntimeConfigPrefix("databus.checkpointPersistence.");
            this._sharedState = new SharedCheckpointPersistenceProvider.Config();
            this._clearBeforeUse = false;
            this._protocolVersion = 2;
        }

        public void setProtocolVersion(int protocolVersion) {
            this._protocolVersion = protocolVersion;
        }

        public String getType() {
            return this._type;
        }

        public void setType(String type) {
            this._type = type;
        }

        public FileSystemCheckpointPersistenceProvider.Config getFileSystem() {
            return this._fileSystem;
        }

        public void setFileSystem(FileSystemCheckpointPersistenceProvider.Config fileSystem) {
            this._fileSystem = fileSystem;
        }

        public CheckpointPersistenceProvider getExisting() {
            return this._existing;
        }

        public void setExisting(CheckpointPersistenceProvider existing) {
            this._existing = existing;
        }

        public String getRuntimeConfigPrefix() {
            return this._runtimeConfigPrefix;
        }

        public void setRuntimeConfigPrefix(String runtimeConfigPrefix) {
            this._runtimeConfigPrefix = runtimeConfigPrefix;
            this._fileSystem.setRuntimeConfigPrefix(this._runtimeConfigPrefix + ".fileSystem");
        }

        public CheckpointPersistenceRuntimeConfigBuilder getRuntime() {
            return this._runtime;
        }

        public void setRuntime(CheckpointPersistenceRuntimeConfigBuilder runtime) {
            this._runtime = runtime;
        }

        public CheckpointPersistenceStaticConfig build() throws InvalidConfigException {
            CheckpointPersistenceStaticConfig.ProviderType providerType = null;
            try {
                providerType = CheckpointPersistenceStaticConfig.ProviderType.valueOf(this._type.toUpperCase());
            }
            catch (Exception e) {
                throw new InvalidConfigException("invalid cp3 type:" + this._type, (Throwable)e);
            }
            if (CheckpointPersistenceStaticConfig.ProviderType.EXISTING == providerType && null == this.getExisting()) {
                throw new InvalidConfigException("no existing checkpoint persistence provider specified");
            }
            LOG.info((Object)("checkpoint persistence type: " + this._type));
            LOG.info((Object)("clear before use: " + this._clearBeforeUse));
            LOG.info((Object)("client-relay protocol version: " + this._protocolVersion));
            return new CheckpointPersistenceStaticConfig(providerType, this.getFileSystem().build(), this.getSharedState().build(), this.getExisting(), this.getRuntime(), this.getRuntimeConfigPrefix(), this.isClearBeforeUse(), this._protocolVersion);
        }

        public boolean isClearBeforeUse() {
            return this._clearBeforeUse;
        }

        public void setClearBeforeUse(boolean clearBeforeUse) {
            this._clearBeforeUse = clearBeforeUse;
        }

        public SharedCheckpointPersistenceProvider.Config getSharedState() {
            return this._sharedState;
        }

        public void setSharedState(SharedCheckpointPersistenceProvider.Config sharedState) {
            this._sharedState = sharedState;
        }
    }

    public static class CheckpointPersistenceStaticConfig {
        private final ProviderType _type;
        private final FileSystemCheckpointPersistenceProvider.StaticConfig _fileSystem;
        private final SharedCheckpointPersistenceProvider.StaticConfig _sharedState;
        private final CheckpointPersistenceProvider _existing;
        private final CheckpointPersistenceRuntimeConfigBuilder _runtime;
        private final String _runtimeConfigPrefix;
        private final boolean _clearBeforeUse;
        private final int _protocolVersion;

        public String toString() {
            return "CheckpointPersistenceStaticConfig [_type=" + (Object)((Object)this._type) + ", _fileSystem=" + this._fileSystem + ", _sharedState=" + this._sharedState + ", _existing=" + this._existing + ", _runtime=" + this._runtime + ", _runtimeConfigPrefix=" + this._runtimeConfigPrefix + ", _clearBeforeUse=" + this._clearBeforeUse + "]";
        }

        public CheckpointPersistenceStaticConfig(ProviderType type, FileSystemCheckpointPersistenceProvider.StaticConfig fileSystem, SharedCheckpointPersistenceProvider.StaticConfig sharedState, CheckpointPersistenceProvider existing, CheckpointPersistenceRuntimeConfigBuilder runtime, String runtimeConfigPrefix, boolean clearBeforeUse, int protocolVersion) {
            this._type = type;
            this._fileSystem = fileSystem;
            this._sharedState = sharedState;
            this._existing = existing;
            this._runtime = runtime;
            this._runtimeConfigPrefix = runtimeConfigPrefix;
            this._clearBeforeUse = clearBeforeUse;
            this._protocolVersion = protocolVersion;
        }

        public ProviderType getType() {
            return this._type;
        }

        public FileSystemCheckpointPersistenceProvider.StaticConfig getFileSystem() {
            return this._fileSystem;
        }

        public SharedCheckpointPersistenceProvider.StaticConfig getSharedState() {
            return this._sharedState;
        }

        public CheckpointPersistenceProvider existing() {
            return ProviderType.EXISTING == this._type ? this._existing : null;
        }

        public String getRuntimeConfigPrefix() {
            return this._runtimeConfigPrefix;
        }

        public CheckpointPersistenceRuntimeConfigBuilder getRuntime() {
            return this._runtime;
        }

        public boolean isClearBeforeUse() {
            return this._clearBeforeUse;
        }

        public CheckpointPersistenceProvider getOrCreateCheckpointPersistenceProvider() throws InvalidConfigException {
            return this.getOrCreateCheckpointPersistenceProvider(null);
        }

        public CheckpointPersistenceProvider getOrCreateCheckpointPersistenceProvider(DatabusClientGroupMember groupMember) throws InvalidConfigException {
            CheckpointPersistenceProvider cpPersistenceProvider = null;
            switch (this.getType()) {
                case FILE_SYSTEM: {
                    LOG.info((Object)"Creating file-system checkpoint persistence provider");
                    cpPersistenceProvider = new FileSystemCheckpointPersistenceProvider(this.getFileSystem(), this._protocolVersion);
                    break;
                }
                case SHARED: {
                    LOG.info((Object)"Creating shared ZooKeeper-based checkpoint persistence provider");
                    cpPersistenceProvider = new SharedCheckpointPersistenceProvider(groupMember, this.getSharedState());
                    break;
                }
                case EXISTING: {
                    cpPersistenceProvider = this._existing;
                    break;
                }
                case NONE: {
                    cpPersistenceProvider = null;
                    break;
                }
                default: {
                    throw new InvalidConfigException("Unable to create persistence provider of type: " + (Object)((Object)this.getType()));
                }
            }
            return cpPersistenceProvider;
        }

        public static enum ProviderType {
            FILE_SYSTEM,
            EXISTING,
            NONE,
            SHARED;

        }
    }

    public static class CheckpointPersistenceRuntimeConfigBuilder
    implements ConfigBuilder<CheckpointPersistenceRuntimeConfig> {
        private FileSystemCheckpointPersistenceProvider.RuntimeConfigBuilder _fileSystem = new FileSystemCheckpointPersistenceProvider.RuntimeConfigBuilder();
        private SharedCheckpointPersistenceProvider.RuntimeConfigBuilder _shared = new SharedCheckpointPersistenceProvider.RuntimeConfigBuilder();
        private DatabusHttpClientImpl _managedInstance = null;

        public FileSystemCheckpointPersistenceProvider.RuntimeConfigBuilder getFileSystem() {
            return this._fileSystem;
        }

        public void setFileSystem(FileSystemCheckpointPersistenceProvider.RuntimeConfigBuilder fileSystem) {
            this._fileSystem = fileSystem;
        }

        public DatabusHttpClientImpl getManagedInstance() {
            return this._managedInstance;
        }

        public void setManagedInstance(DatabusHttpClientImpl managedInstance) {
            this._managedInstance = managedInstance;
            if (null != this._managedInstance) {
                CheckpointPersistenceProvider persistenceProvider = this._managedInstance.getCheckpointPersistenceProvider();
                if (persistenceProvider instanceof FileSystemCheckpointPersistenceProvider) {
                    this._fileSystem.setManagedInstance((FileSystemCheckpointPersistenceProvider)persistenceProvider);
                } else if (persistenceProvider instanceof SharedCheckpointPersistenceProvider) {
                    this._shared.setManagedInstance((SharedCheckpointPersistenceProvider)persistenceProvider);
                }
            }
        }

        public CheckpointPersistenceRuntimeConfig build() throws InvalidConfigException {
            if (null == this._managedInstance) {
                throw new InvalidConfigException("No associated client for runtime config");
            }
            if (this._fileSystem.getManagedInstance() != null) {
                return new CheckpointPersistenceRuntimeConfig(this._fileSystem.build());
            }
            if (this._shared.getManagedInstance() != null) {
                return new CheckpointPersistenceRuntimeConfig(this._shared.build());
            }
            return null;
        }

        public SharedCheckpointPersistenceProvider.RuntimeConfigBuilder getShared() {
            return this._shared;
        }

        public void setShared(SharedCheckpointPersistenceProvider.RuntimeConfigBuilder sharedState) {
            this._shared = sharedState;
        }
    }

    public static class CheckpointPersistenceRuntimeConfig
    implements ConfigApplier<CheckpointPersistenceRuntimeConfig> {
        private final FileSystemCheckpointPersistenceProvider.RuntimeConfig _fileSystem;
        private final SharedCheckpointPersistenceProvider.RuntimeConfig _shared;

        public CheckpointPersistenceRuntimeConfig(FileSystemCheckpointPersistenceProvider.RuntimeConfig fileSystem) {
            this._fileSystem = fileSystem;
            this._shared = null;
        }

        public CheckpointPersistenceRuntimeConfig(SharedCheckpointPersistenceProvider.RuntimeConfig shared) {
            this._shared = shared;
            this._fileSystem = null;
        }

        public FileSystemCheckpointPersistenceProvider.RuntimeConfig getFileSystem() {
            return this._fileSystem;
        }

        public SharedCheckpointPersistenceProvider.RuntimeConfig getShared() {
            return this._shared;
        }

        public void applyNewConfig(CheckpointPersistenceRuntimeConfig oldConfig) {
            if (this._fileSystem != null) {
                if (null == oldConfig || !this.getFileSystem().equals((Object)oldConfig.getFileSystem())) {
                    this.getFileSystem().applyNewConfig(null != oldConfig ? oldConfig.getFileSystem() : null);
                }
            } else if (!(this._shared == null || null != oldConfig && this.getShared().equals(oldConfig.getShared()))) {
                this.getShared().applyNewConfig(null != oldConfig ? oldConfig.getShared() : null);
            }
        }

        public boolean equals(Object otherConfig) {
            if (null == otherConfig || !(otherConfig instanceof CheckpointPersistenceRuntimeConfig)) {
                return false;
            }
            return this.equalsConfig((CheckpointPersistenceRuntimeConfig)otherConfig);
        }

        public boolean equalsConfig(CheckpointPersistenceRuntimeConfig otherConfig) {
            if (null == otherConfig) {
                return false;
            }
            if (this._fileSystem != null) {
                return this.getFileSystem().equals((Object)otherConfig.getFileSystem());
            }
            if (this._shared != null) {
                return this.getShared().equals(otherConfig.getShared());
            }
            return false;
        }

        public int hashCode() {
            return this._fileSystem != null ? this._fileSystem.hashCode() : this._shared.hashCode();
        }
    }

    public static class BootstrapClientRuntimeConfigBuilder
    implements ConfigBuilder<BootstrapClientRuntimeConfig> {
        private boolean _enabled = false;
        private final Map<String, ServerInfo.ServerInfoBuilder> _services = new HashMap<String, ServerInfo.ServerInfoBuilder>();
        private DatabusHttpClientImpl _managedInstance;
        private String _servicesList = "";

        public boolean isEnabled() {
            return this._enabled;
        }

        public void setEnabled(boolean enabled) {
            this._enabled = enabled;
        }

        public void setService(String id, ServerInfo.ServerInfoBuilder serverInfo) {
            this._services.put(id, serverInfo);
        }

        public ServerInfo.ServerInfoBuilder getService(String id) {
            ServerInfo.ServerInfoBuilder bootstrapService = this._services.get(id);
            if (null == bootstrapService) {
                bootstrapService = new ServerInfo.ServerInfoBuilder();
                this._services.put(id, bootstrapService);
            }
            return bootstrapService;
        }

        public BootstrapClientRuntimeConfig build() throws InvalidConfigException {
            if (null == this._managedInstance) {
                throw new InvalidConfigException("No managed databus client");
            }
            List<ServerInfo> bootstrapServices = DatabusHttpClientImpl.parseServerInfosMap(this._services);
            if (null != this._servicesList && this._servicesList.length() > 0) {
                bootstrapServices = RuntimeConfigBuilder.parseServerInfoList(this._servicesList, bootstrapServices);
            }
            return new BootstrapClientRuntimeConfig(this.isEnabled(), bootstrapServices);
        }

        public DatabusHttpClientImpl getManagedInstance() {
            return this._managedInstance;
        }

        public void setManagedInstance(DatabusHttpClientImpl managedInstance) {
            this._managedInstance = managedInstance;
        }

        public String getServicesList() {
            return this._servicesList;
        }

        public void setServicesList(String servicesList) {
            this._servicesList = servicesList;
        }
    }

    public static class BootstrapClientRuntimeConfig
    implements ConfigApplier<BootstrapClientRuntimeConfig> {
        private final boolean _enabled;
        private final List<ServerInfo> _services;

        public BootstrapClientRuntimeConfig(boolean enabled, List<ServerInfo> bootstrapServices) {
            this._enabled = enabled;
            this._services = bootstrapServices;
        }

        public boolean isEnabled() {
            return this._enabled;
        }

        public List<ServerInfo> getServices() {
            return this._services;
        }

        public Set<ServerInfo> getServicesSet() {
            return new HashSet<ServerInfo>(this._services);
        }

        public void applyNewConfig(BootstrapClientRuntimeConfig oldConfig) {
        }

        public boolean equals(Object otherConfig) {
            if (null == otherConfig || !(otherConfig instanceof BootstrapClientRuntimeConfig)) {
                return false;
            }
            return this.equalsConfig((BootstrapClientRuntimeConfig)otherConfig);
        }

        public boolean equalsConfig(BootstrapClientRuntimeConfig otherConfig) {
            if (null == otherConfig) {
                return false;
            }
            return this.isEnabled() == otherConfig.isEnabled() && ((Object)this.getServices()).equals(otherConfig.getServices());
        }

        public int hashCode() {
            return (this._enabled ? -1 : 0) ^ ((Object)this._services).hashCode();
        }
    }
}

