/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.client;

import com.linkedin.databus.client.LastWriteTimeTrackerImpl;
import com.linkedin.databus.client.pub.DatabusClientGroupMember;
import org.apache.log4j.Logger;

public class DatabusClientDSCUpdater
implements Runnable {
    public static final String MODULE = DatabusClientDSCUpdater.class.getName();
    public static final Logger LOG = Logger.getLogger((String)MODULE);
    public static final String DSCKEY = "dscLastWriteTimestamp";
    private final DatabusClientGroupMember _groupMember;
    private final LastWriteTimeTrackerImpl _writeTimeTracker;
    private final long _dscUpdateDelayInMs;
    private boolean _shutdownRequested = false;
    private State _state = State.INIT;

    public DatabusClientDSCUpdater(DatabusClientGroupMember groupMember, LastWriteTimeTrackerImpl writeTimeTracker, long dscUpdateDelayInMs) {
        this._groupMember = groupMember;
        this._writeTimeTracker = writeTimeTracker;
        this._dscUpdateDelayInMs = dscUpdateDelayInMs;
    }

    public void init() {
        this._state = State.INIT;
        this._shutdownRequested = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            if (this._writeTimeTracker != null) {
                LOG.info((Object)("Started! DSC Updater thread started with clientNode=" + this._groupMember));
                this._state = State.RUNNING;
                while (!this._shutdownRequested) {
                    long lastWriteTimeMillis = this.getTimestamp();
                    if (lastWriteTimeMillis > 0L) {
                        if (lastWriteTimeMillis > this._writeTimeTracker.getLastWriteTimeMillis()) {
                            this._writeTimeTracker.setLastWriteTimeMillis(lastWriteTimeMillis);
                        } else {
                            LOG.info((Object)("DSCUpdater: Skipping update of lastWriteEventTimestamp: current= " + this._writeTimeTracker.getLastWriteTimeMillis() + " new=" + lastWriteTimeMillis));
                        }
                    }
                    Thread.sleep(this._dscUpdateDelayInMs);
                }
            }
        }
        catch (InterruptedException e) {
            LOG.info((Object)"DSC Updater thread interrupted!");
        }
        DatabusClientDSCUpdater databusClientDSCUpdater = this;
        synchronized (databusClientDSCUpdater) {
            this._state = State.STOPPED;
            this.notify();
        }
        LOG.info((Object)"DSC Updater thread stopped!");
    }

    public long getTimestamp() {
        if (this._groupMember != null) {
            Long ts = (Long)this._groupMember.readSharedData(DSCKEY);
            if (ts != null) {
                return ts;
            }
        } else {
            return this.getLocalTimestamp();
        }
        LOG.info((Object)("DSCUpdater: error reading dscLastWriteTimestamp from " + this._groupMember));
        return 0L;
    }

    public long getLocalTimestamp() {
        if (this._writeTimeTracker != null) {
            return this._writeTimeTracker.getLastWriteTimeMillis();
        }
        return 0L;
    }

    public boolean isStopped() {
        return this._state == State.STOPPED;
    }

    public boolean isRunning() {
        return this._state == State.RUNNING;
    }

    public synchronized void stop() {
        this._shutdownRequested = true;
    }

    public synchronized boolean awaitShutdown() {
        try {
            while (this._state != State.STOPPED) {
                this.wait();
            }
        }
        catch (InterruptedException e) {
            LOG.info((Object)"DSC Thread interrupted while awaiting shutdown! ");
        }
        return this._state == State.STOPPED;
    }

    public void writeLocalTimestamp(long timestampInMillis) {
        if (this._writeTimeTracker != null) {
            this._writeTimeTracker.setLastWriteTimeMillis(timestampInMillis);
        }
    }

    public void writeTimestamp(long timestampInMillis) {
        this.writeLocalTimestamp(timestampInMillis);
        if (this._groupMember != null) {
            this._groupMember.writeSharedData(DSCKEY, (Object)timestampInMillis);
        }
    }

    private static enum State {
        INIT,
        RUNNING,
        STOPPED;

    }
}

