/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.client;

import com.linkedin.databus.client.ChunkedBodyReadableByteChannel;
import com.linkedin.databus.client.DatabusBootstrapConnection;
import com.linkedin.databus.client.DatabusBootstrapConnectionStateMessage;
import com.linkedin.databus.client.DatabusHttpClientImpl;
import com.linkedin.databus.client.DatabusRelayConnection;
import com.linkedin.databus.client.DatabusRelayConnectionStateMessage;
import com.linkedin.databus.client.pub.ServerInfo;
import com.linkedin.databus.core.BootstrapCheckpointHandler;
import com.linkedin.databus.core.Checkpoint;
import com.linkedin.databus.core.DbusEventBuffer;
import com.linkedin.databus.core.DbusEventFactory;
import com.linkedin.databus.core.DbusEventInternalReadable;
import com.linkedin.databus.core.InternalDatabusEventsListener;
import com.linkedin.databus.core.data_model.DatabusSubscription;
import com.linkedin.databus.core.util.IdNamePair;
import com.linkedin.databus2.core.DatabusException;
import com.linkedin.databus2.core.container.request.RegisterResponseEntry;
import com.linkedin.databus2.core.container.request.RegisterResponseMetadataEntry;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.netty.channel.Channel;

public class ConnectionState
implements DatabusRelayConnectionStateMessage,
DatabusBootstrapConnectionStateMessage {
    private StateId _stateId;
    private final DbusEventBuffer _dataEventsBuffer;
    private DatabusHttpClientImpl.StaticConfig _clientConfig;
    protected final List<DatabusSubscription> _subscriptions;
    private final List<String> _sourcesNames;
    protected BootstrapCheckpointHandler _bstCheckpointHandler = null;
    private final String _sourcesNameList;
    private boolean _isRelayFellOff = false;
    private InetSocketAddress _serverInetAddress;
    private ServerInfo _currentServerInfo;
    private DatabusRelayConnection _relayConnection;
    private DatabusBootstrapConnection _bootstrapConnection;
    private List<IdNamePair> _sources;
    protected Map<Long, IdNamePair> _sourcesIdMap = new HashMap<Long, IdNamePair>(20);
    protected Map<String, IdNamePair> _sourcesNameMap = new HashMap<String, IdNamePair>(20);
    private String _sourcesIdListString;
    private String _subsListString;
    private Map<Long, List<RegisterResponseEntry>> _sourcesSchemas;
    private Map<Long, List<RegisterResponseEntry>> _keysSchemas;
    private List<RegisterResponseMetadataEntry> _metadataSchemas;
    private Checkpoint _checkpoint;
    private boolean _scnRegress = false;
    private boolean _flexibleCheckpointRequest = false;
    private final List<InternalDatabusEventsListener> _readEventListeners;
    private ChunkedBodyReadableByteChannel _readChannel;
    private Channel _startScnChannel;
    private ServerInfo _currentBSServerInfo;
    private String _hostName;
    private String _svcName;

    protected ConnectionState(DbusEventBuffer dataEventsBuffer, List<String> sourcesNames, List<DatabusSubscription> subs) {
        this._stateId = StateId.INITIAL;
        this._dataEventsBuffer = dataEventsBuffer;
        this._readEventListeners = new ArrayList<InternalDatabusEventsListener>();
        if (subs != null) {
            this._subscriptions = new ArrayList<DatabusSubscription>(subs);
            this._sourcesNames = DatabusSubscription.getStrList(this._subscriptions);
        } else if (sourcesNames != null) {
            this._subscriptions = DatabusSubscription.createSubscriptionList(sourcesNames);
            this._sourcesNames = new ArrayList<String>(sourcesNames);
        } else {
            throw new IllegalArgumentException("both sources and subscriptions are null");
        }
        StringBuilder sb = new StringBuilder();
        boolean firstSource = true;
        for (String sourceName : this._sourcesNames) {
            if (!firstSource) {
                sb.append(',');
            }
            sb.append(sourceName);
            firstSource = false;
        }
        this._sourcesNameList = sb.toString();
        this._hostName = "";
        this._svcName = "";
    }

    public void createBootstrapCheckpointHandler() {
        assert (this._bstCheckpointHandler == null) : "BootstrapCheckpointHandler already initialized " + this._bstCheckpointHandler.toString();
        this._bstCheckpointHandler = new BootstrapCheckpointHandler(this._sourcesNames);
    }

    public void expandSubscriptions() {
    }

    public StateId getStateId() {
        return this._stateId;
    }

    public ConnectionState switchToPickServer() {
        this._stateId = StateId.PICK_SERVER;
        return this;
    }

    public ConnectionState switchToRequestSources(ServerInfo relayInfo, InetSocketAddress relayInetAddr, DatabusRelayConnection relayConnection) {
        this._stateId = StateId.REQUEST_SOURCES;
        this._serverInetAddress = relayInetAddr;
        this._currentServerInfo = relayInfo;
        this._relayConnection = relayConnection;
        return this;
    }

    @Override
    public void switchToSourcesRequestError() {
        this._stateId = StateId.SOURCES_REQUEST_ERROR;
    }

    @Override
    public void switchToSourcesResponseError() {
        this._stateId = StateId.SOURCES_RESPONSE_ERROR;
    }

    @Override
    public void switchToSourcesSuccess(List<IdNamePair> sources, String hostName, String svcName) {
        this._stateId = StateId.SOURCES_RESPONSE_SUCCESS;
        this.setSourcesIds(sources);
        this.setTrackingInfo(hostName, svcName);
    }

    public void setSourcesIds(List<IdNamePair> sources) {
        this._sources = sources;
        this._sourcesIdMap.clear();
        this._sourcesNameMap.clear();
        for (IdNamePair source : this._sources) {
            this._sourcesIdMap.put(source.getId(), source);
            this._sourcesNameMap.put(source.getName(), source);
        }
        this.expandSubscriptions();
    }

    public void setTrackingInfo(String hostName, String svcName) {
        this._hostName = hostName;
        this._svcName = svcName;
    }

    public String getHostName() {
        return this._hostName;
    }

    public String getSvcName() {
        return this._svcName;
    }

    public DbusEventInternalReadable createEopEvent(Checkpoint cp, DbusEventFactory eventFactory) throws DatabusException {
        return eventFactory.createLongKeyEOPEvent(cp.getWindowScn(), (short)0);
    }

    public ConnectionState switchToRequestSourcesSchemas(String sourcesIdListString, String subsListString) {
        this._stateId = StateId.REQUEST_REGISTER;
        this.setSourcesIdListString(sourcesIdListString);
        this.setSubsListString(subsListString);
        return this;
    }

    public void setSourcesIdListString(String sourcesIdListString) {
        this._sourcesIdListString = sourcesIdListString;
    }

    public void setSubsListString(String subsListString) {
        this._subsListString = subsListString;
    }

    @Override
    public void switchToRegisterSuccess(Map<Long, List<RegisterResponseEntry>> sourcesSchemas, Map<Long, List<RegisterResponseEntry>> keysSchemas, List<RegisterResponseMetadataEntry> metadataSchemas) {
        this._stateId = StateId.REGISTER_RESPONSE_SUCCESS;
        this.setSourcesSchemas(sourcesSchemas);
        this.setKeysSchemas(keysSchemas);
        this.setMetadataSchemas(metadataSchemas);
    }

    public void setSourcesSchemas(Map<Long, List<RegisterResponseEntry>> sourcesSchemas) {
        this._sourcesSchemas = sourcesSchemas;
    }

    public void setKeysSchemas(Map<Long, List<RegisterResponseEntry>> keysSchemas) {
        this._keysSchemas = keysSchemas;
    }

    public void setMetadataSchemas(List<RegisterResponseMetadataEntry> metadataSchemas) {
        this._metadataSchemas = metadataSchemas;
    }

    public ConnectionState switchToRequestStream(Checkpoint checkpoint) {
        this._stateId = StateId.REQUEST_STREAM;
        if (this._checkpoint != checkpoint || this._readEventListeners.isEmpty()) {
            this._checkpoint = checkpoint;
            this._readEventListeners.clear();
            this._readEventListeners.add((InternalDatabusEventsListener)this._checkpoint);
        }
        return this;
    }

    @Override
    public void switchToStreamSuccess(ChunkedBodyReadableByteChannel readChannel) {
        this._stateId = StateId.STREAM_REQUEST_SUCCESS;
        this._readChannel = readChannel;
    }

    public void switchToStreamResponseDone() {
        this._stateId = StateId.STREAM_RESPONSE_DONE;
    }

    public ConnectionState switchToClosed() {
        this._stateId = StateId.CLOSED;
        return this;
    }

    @Override
    public void switchToRegisterRequestError() {
        this._stateId = StateId.REGISTER_REQUEST_ERROR;
    }

    @Override
    public void switchToRegisterResponseError() {
        this._stateId = StateId.REGISTER_RESPONSE_ERROR;
    }

    public DatabusRelayConnection getRelayConnection() {
        return this._relayConnection;
    }

    @Override
    public void switchToStreamRequestError() {
        this._stateId = StateId.STREAM_REQUEST_ERROR;
    }

    @Override
    public void switchToStreamResponseError() {
        this._stateId = StateId.STREAM_RESPONSE_ERROR;
    }

    public ConnectionState switchToRequestTargetScn(Checkpoint ckpt) {
        this._stateId = StateId.REQUEST_TARGET_SCN;
        this.setCheckpoint(ckpt);
        return this;
    }

    @Override
    public void switchToTargetScnRequestError() {
        this._stateId = StateId.TARGET_SCN_REQUEST_ERROR;
    }

    @Override
    public void switchToTargetScnResponseError() {
        this._stateId = StateId.TARGET_SCN_RESPONSE_ERROR;
    }

    @Override
    public void switchToTargetScnSuccess() {
        this._stateId = StateId.TARGET_SCN_RESPONSE_SUCCESS;
    }

    public ConnectionState bootstrapServerSelected(InetSocketAddress serviceInetAddr, DatabusBootstrapConnection bootstrapConnection, ServerInfo currentBSServerInfo) {
        this._serverInetAddress = serviceInetAddr;
        this._bootstrapConnection = bootstrapConnection;
        this._currentBSServerInfo = currentBSServerInfo;
        return this;
    }

    public ConnectionState switchToRequestStartScn(Checkpoint ckpt) {
        this._stateId = StateId.REQUEST_START_SCN;
        this.setCheckpoint(ckpt);
        return this;
    }

    @Override
    public void switchToStartScnRequestError() {
        this._stateId = StateId.START_SCN_REQUEST_ERROR;
    }

    @Override
    public void switchToStartScnResponseError() {
        this._stateId = StateId.START_SCN_RESPONSE_ERROR;
    }

    @Override
    public void switchToStartScnSuccess(Checkpoint ckpt, DatabusBootstrapConnection bootstrapConnection, ServerInfo bsServerInfo) {
        this._stateId = StateId.START_SCN_RESPONSE_SUCCESS;
        this._currentBSServerInfo = bsServerInfo;
        if (ckpt != this._checkpoint) {
            this._checkpoint = ckpt;
            this._readEventListeners.clear();
            this._readEventListeners.add((InternalDatabusEventsListener)this._checkpoint);
        }
        if (null != bootstrapConnection) {
            this._bootstrapConnection = bootstrapConnection;
        }
    }

    public void switchToBootstrap(Checkpoint cp) {
        this._stateId = StateId.BOOTSTRAP;
        this._checkpoint = cp;
    }

    public Channel getStartScnChannel() {
        return this._startScnChannel;
    }

    public List<String> getSourcesNames() {
        return this._sourcesNames;
    }

    public List<DatabusSubscription> getSubscriptions() {
        return this._subscriptions;
    }

    public String getSourcesNameList() {
        return this._sourcesNameList;
    }

    public InetSocketAddress getServerInetAddress() {
        return this._serverInetAddress;
    }

    public List<IdNamePair> getSources() {
        return this._sources;
    }

    public String getSourcesIdListString() {
        return this._sourcesIdListString;
    }

    public String getSubsListString() {
        return this._subsListString;
    }

    public Map<Long, IdNamePair> getSourceIdMap() {
        return this._sourcesIdMap;
    }

    public Map<String, IdNamePair> getSourcesNameMap() {
        return this._sourcesNameMap;
    }

    public Map<Long, List<RegisterResponseEntry>> getSourcesSchemas() {
        return this._sourcesSchemas;
    }

    public Map<Long, List<RegisterResponseEntry>> getKeysSchemas() {
        return this._keysSchemas;
    }

    public List<RegisterResponseMetadataEntry> getMetadataSchemas() {
        return this._metadataSchemas;
    }

    public DbusEventBuffer getDataEventsBuffer() {
        return this._dataEventsBuffer;
    }

    public ChunkedBodyReadableByteChannel getReadChannel() {
        return this._readChannel;
    }

    public void setCheckpoint(Checkpoint cp) {
        if (cp == this._checkpoint) {
            return;
        }
        if (null != this._checkpoint) {
            this._readEventListeners.remove(this._checkpoint);
        }
        this._checkpoint = cp;
        this._readEventListeners.add((InternalDatabusEventsListener)this._checkpoint);
    }

    public Checkpoint getCheckpoint() {
        return this._checkpoint;
    }

    public List<InternalDatabusEventsListener> getListeners() {
        return this._readEventListeners;
    }

    public DatabusHttpClientImpl.StaticConfig getClientConfig() {
        return this._clientConfig;
    }

    public String toString() {
        return this._stateId.toString();
    }

    public ServerInfo getCurrentServerInfo() {
        return this._currentServerInfo;
    }

    public DatabusBootstrapConnection getBootstrapConnection() {
        return this._bootstrapConnection;
    }

    public void clearBootstrapState() {
        this._readEventListeners.clear();
    }

    public void setRelayConnection(DatabusRelayConnection conn) {
        this._relayConnection = conn;
    }

    public void setBootstrapConnection(DatabusBootstrapConnection conn) {
        this._bootstrapConnection = conn;
    }

    @Override
    public void switchToSourcesRequestSent() {
        this._stateId = StateId.SOURCES_REQUEST_SENT;
    }

    @Override
    public void swichToRegisterRequestSent() {
        this._stateId = StateId.REGISTER_REQUEST_SENT;
    }

    @Override
    public void switchToStreamRequestSent() {
        this._stateId = StateId.STREAM_REQUEST_SENT;
    }

    @Override
    public void switchToBootstrapRequested() {
        this._stateId = StateId.BOOTSTRAP_REQUESTED;
    }

    @Override
    public void switchToBootstrapDone() {
        this._stateId = StateId.BOOTSTRAP_DONE;
    }

    @Override
    public void switchToStartScnRequestSent() {
        this._stateId = StateId.START_SCN_REQUEST_SENT;
    }

    @Override
    public void switchToTargetScnRequestSent() {
        this._stateId = StateId.TARGET_SCN_REQUEST_SENT;
    }

    public ServerInfo getCurrentBSServerInfo() {
        return this._currentBSServerInfo;
    }

    public void setCurrentBSServerInfo(ServerInfo serverInfo) {
        this._currentBSServerInfo = serverInfo;
    }

    public boolean isRelayFellOff() {
        return this._isRelayFellOff;
    }

    public void setRelayFellOff(boolean retryOnFellOff) {
        this._isRelayFellOff = retryOnFellOff;
    }

    public boolean isSCNRegress() {
        return this._scnRegress;
    }

    public void setSCNRegress(boolean regress) {
        this._scnRegress = regress;
    }

    public boolean isFlexibleCheckpointRequest() {
        return this._flexibleCheckpointRequest;
    }

    public void setFlexibleCheckpointRequest(boolean flexibleCheckpointRequest) {
        this._flexibleCheckpointRequest = flexibleCheckpointRequest;
    }

    protected BootstrapCheckpointHandler getBstCheckpointHandler() {
        return this._bstCheckpointHandler;
    }

    public static enum StateId {
        INITIAL,
        PICK_SERVER,
        REQUEST_SOURCES,
        SOURCES_REQUEST_SENT,
        SOURCES_RESPONSE_SUCCESS,
        SOURCES_REQUEST_ERROR,
        SOURCES_RESPONSE_ERROR,
        REQUEST_REGISTER,
        REGISTER_REQUEST_SENT,
        REGISTER_RESPONSE_SUCCESS,
        REGISTER_REQUEST_ERROR,
        REGISTER_RESPONSE_ERROR,
        REQUEST_STREAM,
        STREAM_REQUEST_SENT,
        STREAM_REQUEST_SUCCESS,
        STREAM_REQUEST_ERROR,
        STREAM_RESPONSE_ERROR,
        STREAM_RESPONSE_DONE,
        CLOSED,
        BOOTSTRAP_REQUESTED,
        BOOTSTRAP,
        REQUEST_START_SCN,
        START_SCN_REQUEST_SENT,
        START_SCN_RESPONSE_SUCCESS,
        START_SCN_REQUEST_ERROR,
        START_SCN_RESPONSE_ERROR,
        REQUEST_TARGET_SCN,
        TARGET_SCN_REQUEST_SENT,
        TARGET_SCN_RESPONSE_SUCCESS,
        TARGET_SCN_REQUEST_ERROR,
        TARGET_SCN_RESPONSE_ERROR,
        START_SNAPSHOT_PHASE,
        START_CATCHUP_PHASE,
        BOOTSTRAP_DONE;

    }
}

