/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.client;

import com.linkedin.databus.core.Checkpoint;

public class BootstrapResultMessage {
    private TypeId _typeId;
    private Checkpoint _bootstrapCheckpoint;
    private Throwable _failureReason;

    private BootstrapResultMessage(TypeId typeId, Checkpoint bootstrapCheckpoint, Throwable failureReason) {
        this._typeId = typeId;
        this._bootstrapCheckpoint = bootstrapCheckpoint;
        this._failureReason = failureReason;
    }

    public static BootstrapResultMessage createBootstrapCompleteMessage(Checkpoint bootstrapCheckpoint) {
        return new BootstrapResultMessage(TypeId.BOOTSTRAP_COMPLETE, bootstrapCheckpoint, null);
    }

    public static BootstrapResultMessage createBootstrapFailedMessage(Throwable failureReason) {
        return new BootstrapResultMessage(TypeId.BOOTSTRAP_FAILED, null, failureReason);
    }

    public BootstrapResultMessage switchToBootstrapComplete(Checkpoint bootstrapCheckpoint) {
        this._typeId = TypeId.BOOTSTRAP_COMPLETE;
        this._bootstrapCheckpoint = bootstrapCheckpoint;
        this._failureReason = null;
        return this;
    }

    public BootstrapResultMessage switchToBootstrapFailed(Throwable failureReason) {
        this._typeId = TypeId.BOOTSTRAP_COMPLETE;
        this._bootstrapCheckpoint = null;
        this._failureReason = failureReason;
        return this;
    }

    public TypeId getTypeId() {
        return this._typeId;
    }

    public Checkpoint getBootstrapCheckpoint() {
        return this._bootstrapCheckpoint;
    }

    public Throwable getFailureReason() {
        return this._failureReason;
    }

    public String toString() {
        return this._typeId.toString();
    }

    public static enum TypeId {
        BOOTSTRAP_COMPLETE,
        BOOTSTRAP_FAILED;

    }
}

