/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.client.test;

import com.linkedin.databus.client.consumer.DelegatingDatabusCombinedConsumer;
import com.linkedin.databus.client.pub.ConsumerCallbackResult;
import com.linkedin.databus.client.pub.DatabusCombinedConsumer;
import com.linkedin.databus.client.pub.DbusEventDecoder;
import com.linkedin.databus.client.pub.SCN;
import com.linkedin.databus.core.DbusEvent;
import java.util.ArrayList;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.log4j.Logger;

public class CallbackTrackingDatabusConsumer
extends DelegatingDatabusCombinedConsumer {
    final List<String> _callbacks = new ArrayList<String>();
    String _lastCallback;

    public CallbackTrackingDatabusConsumer(DatabusCombinedConsumer delegate, Logger log) {
        super(delegate, log);
    }

    public List<String> getCallbacks() {
        return this._callbacks;
    }

    public String getLastCallback() {
        return this._lastCallback;
    }

    public void resetCallbacks() {
        this._callbacks.clear();
        this._lastCallback = null;
    }

    void registerCallback(String cb) {
        this._lastCallback = cb;
        this._callbacks.add(cb);
    }

    @Override
    public ConsumerCallbackResult onStartConsumption() {
        this.registerCallback("onStartConsumption()");
        return super.onStartConsumption();
    }

    @Override
    public ConsumerCallbackResult onStopConsumption() {
        this.registerCallback("onStopConsumption()");
        return super.onStopConsumption();
    }

    @Override
    public ConsumerCallbackResult onStartDataEventSequence(SCN startScn) {
        this.registerCallback("onStartDataEventSequence(" + startScn + ")");
        return super.onStartDataEventSequence(startScn);
    }

    @Override
    public ConsumerCallbackResult onEndDataEventSequence(SCN endScn) {
        this.registerCallback("onEndDataEventSequence(" + endScn + ")");
        return super.onEndDataEventSequence(endScn);
    }

    @Override
    public ConsumerCallbackResult onRollback(SCN rollbackScn) {
        this.registerCallback("onRollback(" + rollbackScn + ")");
        return super.onRollback(rollbackScn);
    }

    @Override
    public ConsumerCallbackResult onStartSource(String source, Schema sourceSchema) {
        this.registerCallback("onStartSource(" + source + ")");
        return super.onStartSource(source, sourceSchema);
    }

    @Override
    public ConsumerCallbackResult onEndSource(String source, Schema sourceSchema) {
        this.registerCallback("onEndSource(" + source + ")");
        return super.onEndSource(source, sourceSchema);
    }

    @Override
    public ConsumerCallbackResult onDataEvent(DbusEvent e, DbusEventDecoder eventDecoder) {
        this.registerCallback("onDataEvent(" + e + ")");
        return super.onDataEvent(e, eventDecoder);
    }

    @Override
    public ConsumerCallbackResult onCheckpoint(SCN checkpointScn) {
        this.registerCallback("onCheckpoint(" + checkpointScn + ")");
        return super.onCheckpoint(checkpointScn);
    }

    @Override
    public ConsumerCallbackResult onError(Throwable err) {
        this.registerCallback("onError(" + err.getClass().getName() + ":" + err.getMessage() + ")");
        return super.onError(err);
    }

    @Override
    public ConsumerCallbackResult onStartBootstrap() {
        this.registerCallback("onStartBootstrap()");
        return super.onStartBootstrap();
    }

    @Override
    public ConsumerCallbackResult onStopBootstrap() {
        this.registerCallback("onStopBootstrap()");
        return super.onStopBootstrap();
    }

    @Override
    public ConsumerCallbackResult onStartBootstrapSequence(SCN startScn) {
        this.registerCallback("onStartBootstrapSequence(" + startScn + ")");
        return super.onStartBootstrapSequence(startScn);
    }

    @Override
    public ConsumerCallbackResult onEndBootstrapSequence(SCN endScn) {
        this.registerCallback("onEndBootstrapSequence(" + endScn + ")");
        return super.onEndBootstrapSequence(endScn);
    }

    @Override
    public ConsumerCallbackResult onStartBootstrapSource(String source, Schema sourceSchema) {
        this.registerCallback("onStartBootstrapSource(" + source + ")");
        return super.onStartBootstrapSource(source, sourceSchema);
    }

    @Override
    public ConsumerCallbackResult onEndBootstrapSource(String source, Schema sourceSchema) {
        this.registerCallback("onEndBootstrapSource(" + source + ")");
        return super.onEndBootstrapSource(source, sourceSchema);
    }

    @Override
    public ConsumerCallbackResult onBootstrapEvent(DbusEvent e, DbusEventDecoder eventDecoder) {
        this.registerCallback("onBootstrapEvent(" + e + ")");
        return super.onBootstrapEvent(e, eventDecoder);
    }

    @Override
    public ConsumerCallbackResult onBootstrapRollback(SCN rollbackScn) {
        this.registerCallback("onBootstrapRollback(" + rollbackScn + ")");
        return super.onBootstrapRollback(rollbackScn);
    }

    @Override
    public ConsumerCallbackResult onBootstrapCheckpoint(SCN checkpointScn) {
        this.registerCallback("onBootstrapCheckpoint(" + checkpointScn + ")");
        return super.onBootstrapCheckpoint(checkpointScn);
    }

    @Override
    public ConsumerCallbackResult onBootstrapError(Throwable err) {
        this.registerCallback("onBootstrapError(" + err.getClass().getName() + ":" + err.getMessage() + ")");
        return super.onBootstrapError(err);
    }
}

