/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.client.data_model;

import com.linkedin.databus.client.pub.SCN;
import java.util.Arrays;

public class MultiPartitionSCN
implements SCN {
    private static final long serialVersionUID = 1L;
    private long[] _seq;

    public MultiPartitionSCN(int numPartitions) {
        this._seq = new long[numPartitions];
    }

    public MultiPartitionSCN(MultiPartitionSCN other) {
        this._seq = other.getSequences();
    }

    public MultiPartitionSCN(MultiPartitionSCN other, int partitionIdx, long seq) {
        this._seq = other.getSequences(partitionIdx < other._seq.length ? null : new long[partitionIdx + 1]);
        this._seq[partitionIdx] = seq;
    }

    public boolean isComparable(SCN otherSCN) {
        if (null == otherSCN || !(otherSCN instanceof MultiPartitionSCN)) {
            return false;
        }
        MultiPartitionSCN other = (MultiPartitionSCN)otherSCN;
        return this._seq.length == other._seq.length;
    }

    public int compareTo(SCN otherSCN) {
        int i;
        if (null == otherSCN) {
            throw new NullPointerException("can't compare to a null SCN");
        }
        if (!(otherSCN instanceof MultiPartitionSCN)) {
            return 0;
        }
        MultiPartitionSCN other = (MultiPartitionSCN)otherSCN;
        if (this._seq.length != other._seq.length) {
            return 0;
        }
        for (i = 0; i < this._seq.length && this._seq[i] == other._seq[i]; ++i) {
        }
        if (i == this._seq.length) {
            return 0;
        }
        return this._seq[i] < other._seq[i] ? -1 : 1;
    }

    public boolean equals(Object other) {
        if (null == other || !(other instanceof SCN)) {
            return false;
        }
        SCN otherSCN = (SCN)other;
        return this.isComparable(otherSCN) && 0 == this.compareTo(otherSCN);
    }

    public int hashCode() {
        return null == this._seq ? 0 : Arrays.hashCode(this._seq);
    }

    public long[] getSequences() {
        return this.getSequences(null);
    }

    public long[] getSequences(long[] reuse) {
        if (null == reuse || reuse.length < this._seq.length) {
            reuse = new long[this._seq.length];
        }
        System.arraycopy(this._seq, 0, reuse, 0, this._seq.length);
        return reuse;
    }

    public int size() {
        return this._seq.length;
    }

    public long partitionSeq(int partitionIdx) {
        return this._seq[partitionIdx];
    }

    public void partitionSeq(int partitionIdx, long seq) {
        if (partitionIdx >= this._seq.length) {
            this._seq = this.getSequences(new long[partitionIdx + 1]);
        }
        this._seq[partitionIdx] = seq;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this._seq.length * 50);
        sb.append('[');
        boolean first = true;
        for (long i : this._seq) {
            if (first) {
                first = false;
            } else {
                sb.append(',');
            }
            sb.append(i);
        }
        sb.append(']');
        return sb.toString();
    }
}

