/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.client.consumer;

import com.linkedin.databus.client.DbusEventAvroDecoder;
import com.linkedin.databus.client.consumer.DelegatingDatabusCombinedConsumer;
import com.linkedin.databus.client.pub.ConsumerCallbackResult;
import com.linkedin.databus.client.pub.DatabusCombinedConsumer;
import com.linkedin.databus.client.pub.DatabusV3Consumer;
import com.linkedin.databus.client.pub.DbusEventDecoder;
import com.linkedin.databus.client.pub.SCN;
import com.linkedin.databus.core.DbusEvent;
import com.linkedin.databus.core.DbusEventPart;
import com.linkedin.databus.core.FileBasedEventTrackingCallback;
import com.linkedin.databus.core.util.ConfigApplier;
import com.linkedin.databus.core.util.ConfigBuilder;
import com.linkedin.databus.core.util.InvalidConfigException;
import com.linkedin.databus2.schemas.VersionedSchema;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Formatter;
import org.apache.avro.Schema;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;

public class LoggingConsumer
extends DelegatingDatabusCombinedConsumer
implements DatabusV3Consumer {
    public static final String MODULE = LoggingConsumer.class.getName();
    private static final Logger CLASS_LOG = Logger.getLogger((String)MODULE);
    private static final double NANOS_PER_MS = 1000000.0;
    private static final long BOOTSTRAP_EVENT_LOG_FREQUENCY = 100L;
    private static final String BOOTSTRAP_EVENT_LOG_FORMAT = "bootstrap => #events: %d, last scn: %d, last key: %s, source: %s";
    private final StaticConfig _staticConfig;
    private RuntimeConfig _runtimeConfig;
    private long _currentWindowScn;
    private long _lastWindowSeq;
    private long _lastWindowStartTs;
    private long _lastWindowEndTs;
    private long _curSourceStartTs;
    private int _curSourceEvents;
    private int _curWindowEvents;
    private long _bstEventsNum;
    private StringBuffer _perSourceMsgBuilder;
    private FileBasedEventTrackingCallback _fileBasedCallback = null;

    public LoggingConsumer() throws InvalidConfigException {
        this(new Config());
    }

    public LoggingConsumer(Config configBuilder) throws InvalidConfigException {
        this(configBuilder.build());
    }

    public LoggingConsumer(StaticConfig staticConfig, String regId) throws InvalidConfigException {
        this(staticConfig, regId, null);
    }

    public LoggingConsumer(StaticConfig staticConfig) throws InvalidConfigException {
        this(staticConfig, null, (DatabusCombinedConsumer)null);
    }

    public LoggingConsumer(StaticConfig staticConfig, String regId, DatabusCombinedConsumer delegate) throws InvalidConfigException {
        super(delegate, regId == null ? null : Logger.getLogger((String)(MODULE + ":" + regId)));
        this._staticConfig = staticConfig;
        this._log.info((Object)("logging listener config: " + staticConfig.toString()));
        staticConfig.getRuntime().managedInstance(this);
        this._runtimeConfig = staticConfig.getRuntime().build();
        this._currentWindowScn = -1L;
        this._lastWindowEndTs = this._lastWindowStartTs = System.nanoTime();
        this._curSourceEvents = 0;
        this._curWindowEvents = 0;
        this._lastWindowSeq = -1L;
    }

    public void enableEventFileTrace(String outputFileName) throws IOException {
        if (outputFileName != null) {
            this.enableEventFileTrace(outputFileName, false);
        }
    }

    public void enableEventFileTrace(String outputFileName, boolean append) throws IOException {
        if (outputFileName != null) {
            this._fileBasedCallback = new FileBasedEventTrackingCallback(outputFileName, append);
            this._fileBasedCallback.init();
        }
    }

    public boolean isEnabled() {
        return this._runtimeConfig.isEnabled();
    }

    public Level getLogLevel() {
        return this._runtimeConfig.getLogLevel();
    }

    public Verbosity getVerbosity() {
        return this._runtimeConfig.getVerbosity();
    }

    public boolean isValidityCheckEnabled() {
        return this._runtimeConfig.isValidityCheckEnabled();
    }

    public RuntimeConfig getRuntimeConfig() {
        return this._runtimeConfig;
    }

    private void setNewConfig(RuntimeConfig runtimeConfig) {
        this._runtimeConfig = runtimeConfig;
    }

    @Override
    public ConsumerCallbackResult onEndDataEventSequence(SCN endScn) {
        ConsumerCallbackResult result = super.onEndDataEventSequence(endScn);
        return this.doEndDataEventSequence(endScn, result, false);
    }

    @Override
    public ConsumerCallbackResult onDataEvent(DbusEvent e, DbusEventDecoder eventDecoder) {
        ConsumerCallbackResult result = super.onDataEvent(e, eventDecoder);
        return this.doDataEvent(e, eventDecoder, result, false);
    }

    @Override
    public ConsumerCallbackResult onCheckpoint(SCN checkpointScn) {
        ConsumerCallbackResult result = super.onCheckpoint(checkpointScn);
        return this.doCheckpoint(checkpointScn, result, false);
    }

    @Override
    public ConsumerCallbackResult onEndSource(String source, Schema sourceSchema) {
        ConsumerCallbackResult result = super.onEndSource(source, sourceSchema);
        return this.doEndSource(source, sourceSchema, result, false);
    }

    @Override
    public ConsumerCallbackResult onRollback(SCN rollbackScn) {
        ConsumerCallbackResult result = super.onRollback(rollbackScn);
        return this.doRollback(rollbackScn, result, false);
    }

    @Override
    public ConsumerCallbackResult onStartDataEventSequence(SCN startScn) {
        this.startDataEventSequenceStats();
        ConsumerCallbackResult result = super.onStartDataEventSequence(startScn);
        return this.doStartDataEventSequence(startScn, result, false);
    }

    @Override
    public ConsumerCallbackResult onStartSource(String source, Schema sourceSchema) {
        this.startSourceStats(sourceSchema);
        ConsumerCallbackResult result = super.onStartSource(source, sourceSchema);
        return this.doStartSource(source, sourceSchema, result, false);
    }

    @Override
    public ConsumerCallbackResult onEndBootstrapSequence(SCN endScn) {
        ConsumerCallbackResult result = super.onEndBootstrapSequence(endScn);
        return this.doEndDataEventSequence(endScn, result, true);
    }

    @Override
    public ConsumerCallbackResult onEndBootstrapSource(String source, Schema sourceSchema) {
        ConsumerCallbackResult result = super.onEndBootstrapSource(source, sourceSchema);
        return this.doEndSource(source, sourceSchema, result, true);
    }

    @Override
    public ConsumerCallbackResult onBootstrapEvent(DbusEvent e, DbusEventDecoder eventDecoder) {
        ConsumerCallbackResult result = super.onBootstrapEvent(e, eventDecoder);
        return this.doDataEvent(e, eventDecoder, result, true);
    }

    @Override
    public ConsumerCallbackResult onBootstrapCheckpoint(SCN batchCheckpointScn) {
        ConsumerCallbackResult result = super.onBootstrapCheckpoint(batchCheckpointScn);
        return this.doCheckpoint(batchCheckpointScn, result, true);
    }

    @Override
    public ConsumerCallbackResult onStartBootstrapSequence(SCN startScn) {
        this.startDataEventSequenceStats();
        ConsumerCallbackResult result = super.onStartBootstrapSequence(startScn);
        return this.doStartDataEventSequence(startScn, result, true);
    }

    @Override
    public ConsumerCallbackResult onStartBootstrapSource(String source, Schema sourceSchema) {
        this.startSourceStats(sourceSchema);
        ConsumerCallbackResult result = super.onStartBootstrapSource(source, sourceSchema);
        return this.doStartSource(source, sourceSchema, result, true);
    }

    @Override
    public ConsumerCallbackResult onStartConsumption() {
        ConsumerCallbackResult result = super.onStartConsumption();
        return this.doStartConsumption(result, false);
    }

    @Override
    public ConsumerCallbackResult onStopConsumption() {
        ConsumerCallbackResult result = super.onStopConsumption();
        return this.doStopConsumption(result, false);
    }

    @Override
    public ConsumerCallbackResult onBootstrapRollback(SCN rollbackScn) {
        ConsumerCallbackResult result = super.onBootstrapRollback(rollbackScn);
        return this.doRollback(rollbackScn, result, true);
    }

    @Override
    public ConsumerCallbackResult onStartBootstrap() {
        ConsumerCallbackResult result = super.onStartBootstrap();
        return this.doStartConsumption(result, true);
    }

    @Override
    public ConsumerCallbackResult onStopBootstrap() {
        ConsumerCallbackResult result = super.onStopBootstrap();
        return this.doStopConsumption(result, true);
    }

    @Override
    public ConsumerCallbackResult onError(Throwable err) {
        ConsumerCallbackResult result = super.onError(err);
        return this.doError(err, result, false);
    }

    @Override
    public ConsumerCallbackResult onBootstrapError(Throwable err) {
        ConsumerCallbackResult result = super.onBootstrapError(err);
        return this.doError(err, result, true);
    }

    @Override
    public boolean canBootstrap() {
        return false;
    }

    private ConsumerCallbackResult doStartConsumption(ConsumerCallbackResult result, boolean bootstrapOn) {
        RuntimeConfig rtConfig = this.getRuntimeConfig();
        if (!rtConfig.isEnabled() || !Verbosity.ALL.equals((Object)rtConfig.getVerbosity())) {
            return result;
        }
        this._log.log((Priority)rtConfig.getLogLevel(), (Object)(bootstrapOn ? "startBootstrap" : "startConsumption"));
        if (bootstrapOn) {
            this._bstEventsNum = 0L;
        }
        return result;
    }

    private ConsumerCallbackResult doStartDataEventSequence(SCN startScn, ConsumerCallbackResult result, boolean bootstrapOn) {
        RuntimeConfig rtConfig = this.getRuntimeConfig();
        if (!rtConfig.isEnabled() || Verbosity.EVENTS_ONLY.equals((Object)rtConfig.getVerbosity())) {
            return result;
        }
        this._log.log((Priority)rtConfig.getLogLevel(), (Object)((bootstrapOn ? "startBootstrapSequence:" : "startDataEventSequence:") + startScn.toString()));
        return result;
    }

    private ConsumerCallbackResult doStartSource(String source, Schema sourceSchema, ConsumerCallbackResult result, boolean bootstrapOn) {
        RuntimeConfig rtConfig = this.getRuntimeConfig();
        if (!rtConfig.isEnabled() || !Verbosity.ALL.equals((Object)rtConfig.getVerbosity())) {
            return result;
        }
        this._log.log((Priority)rtConfig.getLogLevel(), (Object)((bootstrapOn ? "startBootstrapSource:" : "startSource:") + source));
        return result;
    }

    private ConsumerCallbackResult doDataEvent(DbusEvent e, DbusEventDecoder eventDecoder, ConsumerCallbackResult result, boolean bootstrapOn) {
        RuntimeConfig rtConfig = this.getRuntimeConfig();
        if (!rtConfig.isEnabled()) {
            return result;
        }
        if (rtConfig.isValidityCheckEnabled() && !e.isValid()) {
            this._log.error((Object)"invalid event received:");
            this._log.error((Object)e.toString());
        }
        if (bootstrapOn) {
            ++this._bstEventsNum;
            if (this._bstEventsNum % 100L == 1L) {
                VersionedSchema payloadSchema = eventDecoder.getPayloadSchema(e);
                String schemaName = null == payloadSchema ? "unknown source: " + e.getSourceId() : payloadSchema.getSchema().getName();
                String keyStr = null;
                try {
                    if (e.isKeyString()) {
                        keyStr = new String(e.keyBytes(), "UTF-8");
                    } else if (e.isKeyNumber()) {
                        keyStr = Long.toString(e.key());
                    } else if (e.isKeySchema()) {
                        DbusEventPart keyPart = e.getKeyPart();
                        keyStr = keyPart.toString();
                    }
                }
                catch (UnsupportedEncodingException e1) {
                    keyStr = "unsupported key encoding";
                }
                catch (RuntimeException ex) {
                    keyStr = "key decoding error: " + ex;
                }
                String msg = String.format(BOOTSTRAP_EVENT_LOG_FORMAT, this._bstEventsNum, e.sequence(), keyStr, schemaName);
                this._log.log((Priority)rtConfig.getLogLevel(), (Object)msg);
            }
        }
        this._currentWindowScn = e.sequence();
        if (this._fileBasedCallback != null) {
            this._fileBasedCallback.onEvent(e);
        }
        if (this._staticConfig.isLogTypedValue()) {
            this.logTypedValue(e, eventDecoder, rtConfig, bootstrapOn ? "b:" : "s:");
        }
        this.updateEventStats(e);
        return result;
    }

    private ConsumerCallbackResult doEndSource(String source, Schema sourceSchema, ConsumerCallbackResult result, boolean bootstrapOn) {
        this.endSourceStats(sourceSchema);
        RuntimeConfig rtConfig = this.getRuntimeConfig();
        if (!rtConfig.isEnabled() || !Verbosity.ALL.equals((Object)rtConfig.getVerbosity())) {
            return result;
        }
        this._log.log((Priority)rtConfig.getLogLevel(), (Object)((bootstrapOn ? "endBootstrapSource" : "endSource:") + source));
        return result;
    }

    private ConsumerCallbackResult doCheckpoint(SCN checkpointScn, ConsumerCallbackResult result, boolean bootstrapOn) {
        RuntimeConfig rtConfig = this.getRuntimeConfig();
        if (!rtConfig.isEnabled() || Verbosity.EVENTS_ONLY.equals((Object)rtConfig.getVerbosity())) {
            return result;
        }
        this._log.log((Priority)rtConfig.getLogLevel(), (Object)((bootstrapOn ? "bootstrapCheckpoint:" : "Checkpoint:") + checkpointScn));
        return result;
    }

    private ConsumerCallbackResult doRollback(SCN rollbackScn, ConsumerCallbackResult result, boolean bootstrapOn) {
        RuntimeConfig rtConfig = this.getRuntimeConfig();
        if (!rtConfig.isEnabled() || !Verbosity.ALL.equals((Object)rtConfig.getVerbosity())) {
            return result;
        }
        this._log.log((Priority)rtConfig.getLogLevel(), (Object)((bootstrapOn ? "bootstrapRollback" : "rollback") + rollbackScn));
        return result;
    }

    private ConsumerCallbackResult doError(Throwable err, ConsumerCallbackResult result, boolean bootstrapOn) {
        RuntimeConfig rtConfig = this.getRuntimeConfig();
        this._log.log((Priority)rtConfig.getLogLevel(), (Object)(bootstrapOn ? "onBootstrapError" : "onError"), err);
        return result;
    }

    private ConsumerCallbackResult doEndDataEventSequence(SCN endScn, ConsumerCallbackResult result, boolean bootstrapOn) {
        RuntimeConfig rtConfig = this.getRuntimeConfig();
        if (!rtConfig.isEnabled() || Verbosity.EVENTS_ONLY.equals((Object)rtConfig.getVerbosity())) {
            return result;
        }
        this.endDataEventSequenceStats(rtConfig, bootstrapOn);
        return result;
    }

    private void startDataEventSequenceStats() {
        this._lastWindowStartTs = System.nanoTime();
        this._curWindowEvents = 0;
        this._perSourceMsgBuilder = new StringBuffer(200);
    }

    private void endDataEventSequenceStats(RuntimeConfig rtConfig, boolean bootstrapOn) {
        long endTs = System.nanoTime();
        StringBuilder sb = new StringBuilder(500);
        Formatter fmt = new Formatter(sb);
        long curWindowSeq = this._currentWindowScn;
        fmt.format("%s: %d updates => wt:%.3f;cb:%.3f%nevents => bop=%d eop=%d %s", bootstrapOn ? "bst" : "str", this._curWindowEvents, (double)(this._lastWindowStartTs - this._lastWindowEndTs) / 1000000.0, (double)(endTs - this._lastWindowStartTs) / 1000000.0, this._lastWindowSeq, curWindowSeq, this._perSourceMsgBuilder);
        fmt.flush();
        this._log.log((Priority)rtConfig.getLogLevel(), (Object)fmt.toString());
        fmt.close();
        this._lastWindowEndTs = endTs;
        this._lastWindowSeq = curWindowSeq;
        this._perSourceMsgBuilder = null;
    }

    private ConsumerCallbackResult doStopConsumption(ConsumerCallbackResult result, boolean bootstrapOn) {
        RuntimeConfig rtConfig = this.getRuntimeConfig();
        if (!rtConfig.isEnabled() || !Verbosity.ALL.equals((Object)rtConfig.getVerbosity())) {
            return result;
        }
        this._log.log((Priority)rtConfig.getLogLevel(), (Object)(bootstrapOn ? "stopBootstrap" : "stopConsumption"));
        return result;
    }

    private void startSourceStats(Schema sourceSchema) {
        this._curSourceStartTs = System.nanoTime();
        this._curSourceEvents = 0;
    }

    private void endSourceStats(Schema sourceSchema) {
        Formatter fmt = new Formatter(this._perSourceMsgBuilder);
        fmt.format("%s=%d (%.3f ms) ", sourceSchema.getName(), this._curSourceEvents, (double)(System.nanoTime() - this._curSourceStartTs) / 1000000.0);
        fmt.flush();
        fmt.close();
    }

    private void updateEventStats(DbusEvent e) {
        ++this._curWindowEvents;
        ++this._curSourceEvents;
    }

    protected void logTypedValue(DbusEvent e, DbusEventDecoder eventDecoder, RuntimeConfig rtConfig, String phase) {
        if (eventDecoder instanceof DbusEventAvroDecoder) {
            try {
                DbusEventAvroDecoder avroDecoder = (DbusEventAvroDecoder)eventDecoder;
                ByteArrayOutputStream stringOut = new ByteArrayOutputStream();
                stringOut.write(phase.getBytes("UTF-8"));
                avroDecoder.dumpEventValueInJSON(e, stringOut);
                stringOut.flush();
                this._log.log((Priority)rtConfig.getLogLevel(), (Object)stringOut.toString("UTF-8"));
            }
            catch (IOException ex) {
                this._log.warn((Object)("typed value serialization error:" + ex.getMessage()), (Throwable)ex);
            }
            catch (RuntimeException ex) {
                this._log.warn((Object)("typed value serialization error:" + ex.getMessage()), (Throwable)ex);
            }
        }
    }

    public static class Config
    implements ConfigBuilder<StaticConfig> {
        private RuntimeConfigBuilder _runtime = new RuntimeConfigBuilder();
        private boolean _logTypedValue = false;

        public RuntimeConfigBuilder getRuntime() {
            return this._runtime;
        }

        public void setRuntime(RuntimeConfigBuilder runtime) {
            this._runtime = runtime;
        }

        public boolean isLogTypedValue() {
            return this._logTypedValue;
        }

        public void setLogTypedValue(boolean logTypedValue) {
            this._logTypedValue = logTypedValue;
        }

        public StaticConfig build() throws InvalidConfigException {
            return new StaticConfig(this.getRuntime(), this._logTypedValue);
        }
    }

    public static class StaticConfig {
        private final RuntimeConfigBuilder _runtime;
        private final boolean _logTypedValue;

        public StaticConfig(RuntimeConfigBuilder runtime, boolean logTypedValue) {
            this._runtime = runtime;
            this._logTypedValue = logTypedValue;
        }

        public RuntimeConfigBuilder getRuntime() {
            return this._runtime;
        }

        public boolean isLogTypedValue() {
            return this._logTypedValue;
        }

        public String toString() {
            return this.toJsonString();
        }

        public String toJsonString() {
            ObjectMapper mapper = new ObjectMapper();
            StringWriter writer = new StringWriter(100);
            try {
                mapper.writeValue((Writer)writer, (Object)this);
                writer.flush();
                return writer.toString();
            }
            catch (JsonGenerationException e) {
                CLASS_LOG.error((Object)("json error: " + e.getMessage()), (Throwable)e);
            }
            catch (JsonMappingException e) {
                CLASS_LOG.error((Object)("json error: " + e.getMessage()), (Throwable)e);
            }
            catch (IOException e) {
                CLASS_LOG.error((Object)("json i/o error: " + e.getMessage()), (Throwable)e);
            }
            return "";
        }
    }

    public static class RuntimeConfigBuilder
    implements ConfigBuilder<RuntimeConfig> {
        private boolean _enabled = true;
        private String _logLevel = "INFO";
        private LoggingConsumer _managedInstance = null;
        private String _verbosity = "EVENT_WINDOWS";
        private boolean _validityCheckEnabled = true;

        public boolean isValidityCheckEnabled() {
            return this._validityCheckEnabled;
        }

        public void setValidityCheckEnabled(boolean validityCheckEnabled) {
            this._validityCheckEnabled = validityCheckEnabled;
        }

        public boolean isEnabled() {
            return this._enabled;
        }

        public void setEnabled(boolean enabled) {
            this._enabled = enabled;
        }

        public String getLogLevel() {
            return this._logLevel;
        }

        public void setLogLevel(String logLevel) {
            this._logLevel = logLevel;
        }

        public LoggingConsumer managedInstance() {
            return this._managedInstance;
        }

        public void managedInstance(LoggingConsumer managedInstance) {
            this._managedInstance = managedInstance;
        }

        public RuntimeConfig build() throws InvalidConfigException {
            if (null == this._managedInstance) {
                throw new InvalidConfigException("Managed logging listener not set");
            }
            Level logLevel = null;
            try {
                logLevel = Level.toLevel((String)this.getLogLevel());
            }
            catch (Exception e) {
                throw new InvalidConfigException("Invalid log level:", (Throwable)e);
            }
            Verbosity verbosity = null;
            try {
                verbosity = Verbosity.valueOf(this.getVerbosity());
            }
            catch (Exception e) {
                throw new InvalidConfigException("Invalid verbosiry:", (Throwable)e);
            }
            LoggingConsumer loggingConsumer = this._managedInstance;
            loggingConsumer.getClass();
            return loggingConsumer.new RuntimeConfig(this.isEnabled(), verbosity, logLevel, this.isValidityCheckEnabled());
        }

        public String getVerbosity() {
            return this._verbosity;
        }

        public void setVerbosity(String verbosity) {
            this._verbosity = verbosity;
        }

        public String toString() {
            return this.toJsonString();
        }

        public String toJsonString() {
            ObjectMapper mapper = new ObjectMapper();
            StringWriter writer = new StringWriter(100);
            try {
                mapper.writeValue((Writer)writer, (Object)this);
                writer.flush();
                return writer.toString();
            }
            catch (JsonGenerationException e) {
                CLASS_LOG.error((Object)("json error: " + e.getMessage()), (Throwable)e);
            }
            catch (JsonMappingException e) {
                CLASS_LOG.error((Object)("json error: " + e.getMessage()), (Throwable)e);
            }
            catch (IOException e) {
                CLASS_LOG.error((Object)("json i/o error: " + e.getMessage()), (Throwable)e);
            }
            return "";
        }
    }

    public class RuntimeConfig
    implements ConfigApplier<RuntimeConfig> {
        private final boolean _enabled;
        private final Level _logLevel;
        private final Verbosity _verbosity;
        private final boolean _validityCheckEnabled;

        public RuntimeConfig(boolean enabled, Verbosity verbosity, Level logLevel, boolean validityCheckEnabled) {
            this._enabled = enabled;
            this._logLevel = logLevel;
            this._verbosity = verbosity;
            this._validityCheckEnabled = validityCheckEnabled;
        }

        public boolean isEnabled() {
            return this._enabled;
        }

        public Level getLogLevel() {
            return this._logLevel;
        }

        public boolean isValidityCheckEnabled() {
            return this._validityCheckEnabled;
        }

        public Verbosity getVerbosity() {
            return this._verbosity;
        }

        public void applyNewConfig(RuntimeConfig oldConfig) {
            if (null == oldConfig || !this.equals(oldConfig)) {
                LoggingConsumer.this.setNewConfig(this);
            }
        }

        public boolean equals(Object otherConfig) {
            if (null == otherConfig || !(otherConfig instanceof RuntimeConfig)) {
                return false;
            }
            return this.equalsConfig((RuntimeConfig)otherConfig);
        }

        public boolean equalsConfig(RuntimeConfig otherConfig) {
            if (null == otherConfig) {
                return false;
            }
            return this.isEnabled() == otherConfig.isEnabled() && this.getLogLevel().equals((Object)otherConfig.getLogLevel()) && this.isValidityCheckEnabled() == otherConfig.isValidityCheckEnabled();
        }

        public int hashCode() {
            return (this._enabled ? -1 : 0) ^ this._logLevel.hashCode() ^ (this._validityCheckEnabled ? -1 : 0);
        }
    }

    public static enum Verbosity {
        EVENTS_ONLY,
        EVENT_WINDOWS,
        ALL;

    }
}

