/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.client.consumer;

import com.linkedin.databus.client.consumer.ConsumerCallable;
import com.linkedin.databus.client.pub.ConsumerCallbackResult;
import com.linkedin.databus.client.pub.DatabusCombinedConsumer;
import com.linkedin.databus.client.pub.SCN;
import com.linkedin.databus.client.pub.mbean.ConsumerCallbackStats;
import com.linkedin.databus.client.pub.mbean.UnifiedClientStats;

class EndDataEventSequenceCallable
extends ConsumerCallable<ConsumerCallbackResult> {
    private final SCN _scn;
    private final DatabusCombinedConsumer _consumer;
    private final ConsumerCallbackStats _consumerStats;
    private final UnifiedClientStats _unifiedClientStats;

    public EndDataEventSequenceCallable(long currentNanos, SCN scn, DatabusCombinedConsumer consumer, ConsumerCallbackStats consumerStats, UnifiedClientStats unifiedClientStats) {
        super(currentNanos);
        this._scn = scn;
        this._consumer = consumer;
        this._consumerStats = consumerStats;
        this._unifiedClientStats = unifiedClientStats;
    }

    @Override
    protected ConsumerCallbackResult doCall() throws Exception {
        return this._consumer.onEndDataEventSequence(this._scn);
    }

    @Override
    protected void doEndCall(ConsumerCallbackResult result) {
        if (result == ConsumerCallbackResult.ERROR || result == ConsumerCallbackResult.ERROR_FATAL) {
            if (this._consumerStats != null) {
                this._consumerStats.registerSysErrorsProcessed();
            }
            if (this._unifiedClientStats != null) {
                this._unifiedClientStats.registerCallbackError();
            }
        } else {
            long nanoRunTime = this.getNanoRunTime();
            if (this._consumerStats != null) {
                long totalTime = (nanoRunTime + this.getNanoTimeInQueue()) / 1000000L;
                this._consumerStats.registerSystemEventProcessed(totalTime);
            }
            if (this._unifiedClientStats != null) {
                this._unifiedClientStats.registerCallbacksProcessed(nanoRunTime);
            }
        }
    }
}

