/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.client.consumer;

import com.linkedin.databus.client.consumer.AbstractDatabusCombinedConsumer;
import com.linkedin.databus.client.pub.ConsumerCallbackResult;
import com.linkedin.databus.client.pub.DatabusBootstrapConsumer;
import com.linkedin.databus.client.pub.DatabusCombinedConsumer;
import com.linkedin.databus.client.pub.DatabusStreamConsumer;
import com.linkedin.databus.client.pub.DbusEventDecoder;
import com.linkedin.databus.client.pub.SCN;
import com.linkedin.databus.core.DbusEvent;
import org.apache.avro.Schema;
import org.apache.log4j.Logger;

public abstract class DelegatingDatabusCombinedConsumer
extends AbstractDatabusCombinedConsumer {
    protected final DatabusStreamConsumer _streamDelegate;
    protected final DatabusBootstrapConsumer _bootstrapDelegate;
    protected Logger _log;

    public DelegatingDatabusCombinedConsumer(DatabusStreamConsumer streamDelegate, DatabusBootstrapConsumer bootstrapDelegate) {
        this(streamDelegate, bootstrapDelegate, null);
    }

    public DelegatingDatabusCombinedConsumer(DatabusStreamConsumer streamDelegate, DatabusBootstrapConsumer bootstrapDelegate, Logger log) {
        this._streamDelegate = streamDelegate;
        this._bootstrapDelegate = bootstrapDelegate;
        this._log = null != log ? log : Logger.getLogger(this.getClass());
    }

    public DelegatingDatabusCombinedConsumer(DatabusCombinedConsumer delegate) {
        this((DatabusStreamConsumer)delegate, (DatabusBootstrapConsumer)delegate, null);
    }

    public DelegatingDatabusCombinedConsumer(DatabusCombinedConsumer delegate, Logger log) {
        this((DatabusStreamConsumer)delegate, (DatabusBootstrapConsumer)delegate, log);
    }

    @Override
    public ConsumerCallbackResult onStartConsumption() {
        try {
            return null != this._streamDelegate ? this._streamDelegate.onStartConsumption() : ConsumerCallbackResult.SUCCESS;
        }
        catch (RuntimeException re) {
            this._log.error((Object)("onStartConsumption error: " + re.getMessage()), (Throwable)re);
            return ConsumerCallbackResult.ERROR;
        }
    }

    @Override
    public ConsumerCallbackResult onStopConsumption() {
        try {
            return null != this._streamDelegate ? this._streamDelegate.onStopConsumption() : ConsumerCallbackResult.SUCCESS;
        }
        catch (RuntimeException re) {
            this._log.error((Object)("onStopConsumption error: " + re.getMessage()), (Throwable)re);
            return ConsumerCallbackResult.ERROR;
        }
    }

    @Override
    public ConsumerCallbackResult onStartDataEventSequence(SCN startScn) {
        try {
            return null != this._streamDelegate ? this._streamDelegate.onStartDataEventSequence(startScn) : ConsumerCallbackResult.SUCCESS;
        }
        catch (RuntimeException re) {
            this._log.error((Object)("onStartDataEventSequence error: " + re.getMessage()), (Throwable)re);
            return ConsumerCallbackResult.ERROR;
        }
    }

    @Override
    public ConsumerCallbackResult onEndDataEventSequence(SCN endScn) {
        try {
            return null != this._streamDelegate ? this._streamDelegate.onEndDataEventSequence(endScn) : ConsumerCallbackResult.SUCCESS;
        }
        catch (RuntimeException re) {
            this._log.error((Object)("onEndDataEventSequence error: " + re.getMessage()), (Throwable)re);
            return ConsumerCallbackResult.ERROR;
        }
    }

    @Override
    public ConsumerCallbackResult onRollback(SCN rollbackScn) {
        try {
            return null != this._streamDelegate ? this._streamDelegate.onRollback(rollbackScn) : ConsumerCallbackResult.SUCCESS;
        }
        catch (RuntimeException re) {
            this._log.error((Object)("onRollback error: " + re.getMessage()), (Throwable)re);
            return ConsumerCallbackResult.ERROR;
        }
    }

    @Override
    public ConsumerCallbackResult onStartSource(String source, Schema sourceSchema) {
        try {
            return null != this._streamDelegate ? this._streamDelegate.onStartSource(source, sourceSchema) : ConsumerCallbackResult.SUCCESS;
        }
        catch (RuntimeException re) {
            this._log.error((Object)("onStartSource error: " + re.getMessage()), (Throwable)re);
            return ConsumerCallbackResult.ERROR;
        }
    }

    @Override
    public ConsumerCallbackResult onEndSource(String source, Schema sourceSchema) {
        try {
            return null != this._streamDelegate ? this._streamDelegate.onEndSource(source, sourceSchema) : ConsumerCallbackResult.SUCCESS;
        }
        catch (RuntimeException re) {
            this._log.error((Object)("onEndSource error: " + re.getMessage()), (Throwable)re);
            return ConsumerCallbackResult.ERROR;
        }
    }

    @Override
    public ConsumerCallbackResult onDataEvent(DbusEvent e, DbusEventDecoder eventDecoder) {
        try {
            return null != this._streamDelegate ? this._streamDelegate.onDataEvent(e, eventDecoder) : ConsumerCallbackResult.SUCCESS;
        }
        catch (RuntimeException re) {
            this._log.error((Object)("onDataEvent error: " + re.getMessage()), (Throwable)re);
            return ConsumerCallbackResult.ERROR;
        }
    }

    @Override
    public ConsumerCallbackResult onCheckpoint(SCN checkpointScn) {
        try {
            return null != this._streamDelegate ? this._streamDelegate.onCheckpoint(checkpointScn) : ConsumerCallbackResult.SUCCESS;
        }
        catch (RuntimeException re) {
            this._log.error((Object)("onCheckpoint error: " + re.getMessage()), (Throwable)re);
            return ConsumerCallbackResult.ERROR;
        }
    }

    @Override
    public ConsumerCallbackResult onError(Throwable err) {
        try {
            return null != this._streamDelegate ? this._streamDelegate.onError(err) : ConsumerCallbackResult.SUCCESS;
        }
        catch (RuntimeException re) {
            this._log.error((Object)("onError error: " + re.getMessage()), (Throwable)re);
            return ConsumerCallbackResult.ERROR;
        }
    }

    @Override
    public ConsumerCallbackResult onStartBootstrap() {
        try {
            return null != this._bootstrapDelegate ? this._bootstrapDelegate.onStartBootstrap() : ConsumerCallbackResult.SUCCESS;
        }
        catch (RuntimeException re) {
            this._log.error((Object)("onStartBootstrap error: " + re.getMessage()), (Throwable)re);
            return ConsumerCallbackResult.ERROR;
        }
    }

    @Override
    public ConsumerCallbackResult onStopBootstrap() {
        try {
            return null != this._bootstrapDelegate ? this._bootstrapDelegate.onStopBootstrap() : ConsumerCallbackResult.SUCCESS;
        }
        catch (RuntimeException re) {
            this._log.error((Object)("onStopBootstrap error: " + re.getMessage()), (Throwable)re);
            return ConsumerCallbackResult.ERROR;
        }
    }

    @Override
    public ConsumerCallbackResult onStartBootstrapSequence(SCN startScn) {
        try {
            return null != this._bootstrapDelegate ? this._bootstrapDelegate.onStartBootstrapSequence(startScn) : ConsumerCallbackResult.SUCCESS;
        }
        catch (RuntimeException re) {
            this._log.error((Object)("onStartBootstrapSequence error: " + re.getMessage()), (Throwable)re);
            return ConsumerCallbackResult.ERROR;
        }
    }

    @Override
    public ConsumerCallbackResult onEndBootstrapSequence(SCN endScn) {
        try {
            return null != this._bootstrapDelegate ? this._bootstrapDelegate.onEndBootstrapSequence(endScn) : ConsumerCallbackResult.SUCCESS;
        }
        catch (RuntimeException re) {
            this._log.error((Object)("onEndBootstrapSequence error: " + re.getMessage()), (Throwable)re);
            return ConsumerCallbackResult.ERROR;
        }
    }

    @Override
    public ConsumerCallbackResult onStartBootstrapSource(String name, Schema sourceSchema) {
        try {
            return null != this._bootstrapDelegate ? this._bootstrapDelegate.onStartBootstrapSource(name, sourceSchema) : ConsumerCallbackResult.SUCCESS;
        }
        catch (RuntimeException re) {
            this._log.error((Object)("onStartBootstrapSource error: " + re.getMessage()), (Throwable)re);
            return ConsumerCallbackResult.ERROR;
        }
    }

    @Override
    public ConsumerCallbackResult onEndBootstrapSource(String name, Schema sourceSchema) {
        try {
            return null != this._bootstrapDelegate ? this._bootstrapDelegate.onEndBootstrapSource(name, sourceSchema) : ConsumerCallbackResult.SUCCESS;
        }
        catch (RuntimeException re) {
            this._log.error((Object)("onEndBootstrapSource error: " + re.getMessage()), (Throwable)re);
            return ConsumerCallbackResult.ERROR;
        }
    }

    @Override
    public ConsumerCallbackResult onBootstrapEvent(DbusEvent e, DbusEventDecoder eventDecoder) {
        try {
            return null != this._bootstrapDelegate ? this._bootstrapDelegate.onBootstrapEvent(e, eventDecoder) : ConsumerCallbackResult.SUCCESS;
        }
        catch (RuntimeException re) {
            this._log.error((Object)("onBootstrapEvent error: " + re.getMessage()), (Throwable)re);
            return ConsumerCallbackResult.ERROR;
        }
    }

    @Override
    public ConsumerCallbackResult onBootstrapRollback(SCN batchCheckpointScn) {
        try {
            return null != this._bootstrapDelegate ? this._bootstrapDelegate.onBootstrapRollback(batchCheckpointScn) : ConsumerCallbackResult.SUCCESS;
        }
        catch (RuntimeException re) {
            this._log.error((Object)("onBootstrapRollback error: " + re.getMessage()), (Throwable)re);
            return ConsumerCallbackResult.ERROR;
        }
    }

    @Override
    public ConsumerCallbackResult onBootstrapCheckpoint(SCN batchCheckpointScn) {
        try {
            return null != this._bootstrapDelegate ? this._bootstrapDelegate.onBootstrapCheckpoint(batchCheckpointScn) : ConsumerCallbackResult.SUCCESS;
        }
        catch (RuntimeException re) {
            this._log.error((Object)("onBootstrapCheckpoint error: " + re.getMessage()), (Throwable)re);
            return ConsumerCallbackResult.ERROR;
        }
    }

    @Override
    public ConsumerCallbackResult onBootstrapError(Throwable err) {
        try {
            return null != this._bootstrapDelegate ? this._bootstrapDelegate.onBootstrapError(err) : ConsumerCallbackResult.SUCCESS;
        }
        catch (RuntimeException re) {
            this._log.error((Object)("onBootstrapError error: " + re.getMessage()), (Throwable)re);
            return ConsumerCallbackResult.ERROR;
        }
    }

    public DatabusStreamConsumer getStreamDelegate() {
        return this._streamDelegate;
    }

    public DatabusBootstrapConsumer getBootstrapDelegate() {
        return this._bootstrapDelegate;
    }

    public Logger getLog() {
        return this._log;
    }

    public void setLog(Logger log) {
        this._log = log;
    }

    @Override
    public boolean canBootstrap() {
        return true;
    }
}

