/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.client.consumer;

import com.linkedin.databus.client.pub.DatabusCombinedConsumer;
import com.linkedin.databus.core.data_model.DatabusSubscription;
import com.linkedin.databus2.core.filter.DbusKeyCompositeFilterConfig;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class ConsumerRegistration {
    protected final List<DatabusCombinedConsumer> _consumers;
    protected final List<DatabusSubscription> _subs;
    protected final Random _rng;
    protected final DbusKeyCompositeFilterConfig _filterConfig;

    public ConsumerRegistration(DatabusCombinedConsumer consumer, List<String> sources, DbusKeyCompositeFilterConfig filterConfig) {
        this(consumer, null, DatabusSubscription.createSubscriptionList(sources), filterConfig);
    }

    public ConsumerRegistration(List<DatabusCombinedConsumer> consumers, List<String> sources, DbusKeyCompositeFilterConfig filterConfig) {
        this(null, consumers, DatabusSubscription.createSubscriptionList(sources), filterConfig);
    }

    public DatabusCombinedConsumer getConsumer() {
        int index = this._rng.nextInt(this._consumers.size());
        return this._consumers.get(index);
    }

    public List<DatabusCombinedConsumer> getConsumers() {
        return this._consumers;
    }

    public List<String> getSources() {
        return DatabusSubscription.getStrList(this._subs);
    }

    public List<DatabusSubscription> getSubscriptions() {
        return this._subs;
    }

    public boolean checkSourceSubscription(DatabusSubscription sub) {
        for (DatabusSubscription dSub : this._subs) {
            if (!dSub.equals((Object)sub)) continue;
            return true;
        }
        return false;
    }

    public DbusKeyCompositeFilterConfig getFilterConfig() {
        return this._filterConfig;
    }

    protected ConsumerRegistration(DatabusCombinedConsumer consumer, List<DatabusCombinedConsumer> consumers, List<DatabusSubscription> subs, DbusKeyCompositeFilterConfig filterConfig) {
        boolean neitherConsumerParamsNull;
        boolean bothConsumerParamsNull = consumer == null && (consumers == null || consumers.size() == 0);
        boolean bl = neitherConsumerParamsNull = consumer != null && consumers != null;
        if (bothConsumerParamsNull || neitherConsumerParamsNull) {
            throw new InvalidParameterException("Only one of consumer / consumers should be null");
        }
        if (null == consumers) {
            this._consumers = new ArrayList<DatabusCombinedConsumer>();
            this._consumers.add(consumer);
        } else {
            this._consumers = consumers;
        }
        this._subs = new ArrayList<DatabusSubscription>(subs);
        this._filterConfig = filterConfig;
        this._rng = new Random();
    }

    public static List<String> createStringFromAllSubscriptionFromRegistration(ConsumerRegistration reg) {
        List<DatabusSubscription> subscriptions = reg.getSubscriptions();
        return DatabusSubscription.getStrList(subscriptions);
    }
}

