/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.client.consumer;

import java.util.concurrent.Callable;

public abstract class ConsumerCallable<C>
implements Callable<C> {
    private final long _creationTime;
    private volatile long _startTime;
    private volatile long _endTime;

    protected ConsumerCallable(long currentNanos) {
        this._creationTime = -1L == currentNanos ? System.nanoTime() : currentNanos;
        this._startTime = -1L;
        this._endTime = -1L;
    }

    public boolean isStarted() {
        return -1L != this._startTime;
    }

    public boolean isDone() {
        return -1L != this._endTime;
    }

    public long getNanoTimeInQueue() {
        return -1L != this._startTime ? this._startTime - this._creationTime : System.nanoTime() - this._startTime;
    }

    public long getNanoRunTime() {
        return -1L == this._startTime ? 0L : (-1L == this._endTime ? System.nanoTime() - this._startTime : this._endTime - this._startTime);
    }

    public long getCreationTime() {
        return this._creationTime;
    }

    public long getStartTime() {
        return this._startTime;
    }

    public long getEndTime() {
        return this._endTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public C call() throws Exception {
        this._startTime = System.nanoTime();
        try {
            C c = this.doCall();
            return c;
        }
        finally {
            this._endTime = System.nanoTime();
        }
    }

    public final void endCall(C result) {
        this.doEndCall(result);
    }

    protected abstract C doCall() throws Exception;

    protected void doEndCall(C result) {
    }
}

