/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.client.pub.mbean;

import com.codahale.metrics.MergeableExponentiallyDecayingReservoir;
import com.linkedin.databus.client.pub.mbean.UnifiedClientStatsMBean;
import com.linkedin.databus.client.pub.monitoring.events.UnifiedClientStatsEvent;
import com.linkedin.databus.core.DbusEvent;
import com.linkedin.databus.core.monitoring.mbean.AbstractMonitoringMBean;
import com.linkedin.databus.core.monitoring.mbean.DatabusMonitoringMBean;
import com.linkedin.databus.core.monitoring.mbean.StatsCollectorMergeable;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.List;
import java.util.concurrent.locks.Lock;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.avro.io.JsonEncoder;
import org.apache.avro.specific.SpecificDatumWriter;
import org.apache.commons.math3.stat.StatUtils;

public class UnifiedClientStats
extends AbstractMonitoringMBean<UnifiedClientStatsEvent>
implements UnifiedClientStatsMBean,
StatsCollectorMergeable<UnifiedClientStats> {
    public static final int DEFAULT_DEADNESS_THRESHOLD_MS = 300000;
    private final String _name;
    private final String _dimension;
    private final MBeanServer _mbeanServer;
    private final MergeableExponentiallyDecayingReservoir _reservoirTimeLagConsumerCallbacksMs;
    private MergeableExponentiallyDecayingReservoir _reservoirTimeLagSourceToReceiptMs;
    private long _deadnessThresholdMs;
    private boolean _isBootstrapping = false;

    public UnifiedClientStats(int ownerId, String name, String dimension) {
        this(ownerId, name, dimension, true, false, 300000L, null, null);
    }

    public UnifiedClientStats(int ownerId, String name, String dimension, boolean enabled, boolean threadSafe, long deadnessThresholdMs, UnifiedClientStatsEvent initData) {
        this(ownerId, name, dimension, enabled, threadSafe, deadnessThresholdMs, initData, null);
    }

    public UnifiedClientStats(int ownerId, String name, String dimension, boolean enabled, boolean threadSafe, long deadnessThresholdMs, UnifiedClientStatsEvent initData, MBeanServer server) {
        super(enabled, threadSafe, (Object)initData);
        ((UnifiedClientStatsEvent)((Object)this._event)).ownerId = ownerId;
        this._name = name;
        this._dimension = dimension;
        this._deadnessThresholdMs = deadnessThresholdMs;
        this._mbeanServer = server;
        this._reservoirTimeLagSourceToReceiptMs = new MergeableExponentiallyDecayingReservoir();
        this._reservoirTimeLagConsumerCallbacksMs = new MergeableExponentiallyDecayingReservoir();
        this.resetData();
        this.registerAsMbean();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBootstrappingState(boolean isBootstrapping) {
        if (!this._enabled.get()) {
            return;
        }
        Lock writeLock = this.acquireWriteLock();
        try {
            if (!this._isBootstrapping && isBootstrapping) {
                this._reservoirTimeLagSourceToReceiptMs = null;
            } else if (this._isBootstrapping && !isBootstrapping) {
                this._reservoirTimeLagSourceToReceiptMs = new MergeableExponentiallyDecayingReservoir();
            }
            this._isBootstrapping = isBootstrapping;
            ((UnifiedClientStatsEvent)((Object)this._event)).curBootstrappingPartitions = isBootstrapping ? 1 : 0;
        }
        finally {
            this.releaseLock(writeLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHeartbeatTimestamp(long heartbeatTimestamp) {
        if (!this._enabled.get()) {
            return;
        }
        Lock writeLock = this.acquireWriteLock();
        try {
            ((UnifiedClientStatsEvent)((Object)this._event)).timestampOfLastHeartbeatMs = heartbeatTimestamp;
        }
        finally {
            this.releaseLock(writeLock);
        }
    }

    public void setDeadnessThresholdMs(long deadnessThresholdMs) {
        this._deadnessThresholdMs = deadnessThresholdMs;
    }

    public String getDimension() {
        return this._dimension;
    }

    public String getName() {
        return this._name;
    }

    public MergeableExponentiallyDecayingReservoir getReservoirTimeLagSourceToReceiptMs() {
        return this._reservoirTimeLagSourceToReceiptMs;
    }

    public MergeableExponentiallyDecayingReservoir getReservoirTimeLagConsumerCallbacksMs() {
        return this._reservoirTimeLagConsumerCallbacksMs;
    }

    public void registerAsMbean() {
        super.registerAsMbean(this._mbeanServer);
    }

    public void unregisterAsMbean() {
        super.unregisterMbean(this._mbeanServer);
    }

    public JsonEncoder createJsonEncoder(OutputStream out) throws IOException {
        return new JsonEncoder(((UnifiedClientStatsEvent)((Object)this._event)).getSchema(), out);
    }

    public ObjectName generateObjectName() throws MalformedObjectNameException {
        Hashtable mbeanProps = this.generateBaseMBeanProps();
        mbeanProps.put("ownerId", Integer.toString(((UnifiedClientStatsEvent)((Object)this._event)).ownerId));
        mbeanProps.put("dimension", this._dimension);
        return new ObjectName("com.linkedin.databus2", mbeanProps);
    }

    protected void resetData() {
        long now;
        ((UnifiedClientStatsEvent)((Object)this._event)).timestampLastResetMs = now = System.currentTimeMillis();
        ((UnifiedClientStatsEvent)((Object)this._event)).aggregated = false;
        ((UnifiedClientStatsEvent)((Object)this._event)).curBootstrappingPartitions = 0;
        ((UnifiedClientStatsEvent)((Object)this._event)).curDeadConnections = 0;
        ((UnifiedClientStatsEvent)((Object)this._event)).numConsumerErrors = 0L;
        ((UnifiedClientStatsEvent)((Object)this._event)).numDataEvents = 0L;
        ((UnifiedClientStatsEvent)((Object)this._event)).timestampOfLastHeartbeatMs = now;
        ((UnifiedClientStatsEvent)((Object)this._event)).timestampLastDataEventWasReceivedMs = 0L;
    }

    protected void cloneData(UnifiedClientStatsEvent event) {
        event.aggregated = ((UnifiedClientStatsEvent)((Object)this._event)).aggregated;
        event.curBootstrappingPartitions = ((UnifiedClientStatsEvent)((Object)this._event)).curBootstrappingPartitions;
        event.curDeadConnections = ((UnifiedClientStatsEvent)((Object)this._event)).curDeadConnections;
        event.numConsumerErrors = ((UnifiedClientStatsEvent)((Object)this._event)).numConsumerErrors;
        event.numDataEvents = ((UnifiedClientStatsEvent)((Object)this._event)).numDataEvents;
        event.timestampOfLastHeartbeatMs = ((UnifiedClientStatsEvent)((Object)this._event)).timestampOfLastHeartbeatMs;
        event.timestampLastDataEventWasReceivedMs = ((UnifiedClientStatsEvent)((Object)this._event)).timestampLastDataEventWasReceivedMs;
    }

    protected UnifiedClientStatsEvent newDataEvent() {
        return new UnifiedClientStatsEvent();
    }

    protected SpecificDatumWriter<UnifiedClientStatsEvent> getAvroWriter() {
        return new SpecificDatumWriter(UnifiedClientStatsEvent.class);
    }

    protected void doMergeStats(Object eventData) {
        if (!(eventData instanceof UnifiedClientStats)) {
            LOG.warn((Object)("Attempt to merge stats from unknown event class: " + eventData.getClass().getName()));
            return;
        }
        UnifiedClientStats otherEvent = (UnifiedClientStats)eventData;
        UnifiedClientStatsEvent e = (UnifiedClientStatsEvent)((Object)otherEvent._event);
        ((UnifiedClientStatsEvent)((Object)this._event)).aggregated = true;
        ((UnifiedClientStatsEvent)((Object)this._event)).curBootstrappingPartitions += e.curBootstrappingPartitions;
        ((UnifiedClientStatsEvent)((Object)this._event)).numConsumerErrors += e.numConsumerErrors;
        ((UnifiedClientStatsEvent)((Object)this._event)).numDataEvents += e.numDataEvents;
        if (e.aggregated) {
            ((UnifiedClientStatsEvent)((Object)this._event)).curDeadConnections += e.curDeadConnections;
        } else if (System.currentTimeMillis() - e.timestampOfLastHeartbeatMs > this._deadnessThresholdMs) {
            ++((UnifiedClientStatsEvent)((Object)this._event)).curDeadConnections;
        }
        if (((UnifiedClientStatsEvent)((Object)this._event)).timestampLastDataEventWasReceivedMs == 0L) {
            ((UnifiedClientStatsEvent)((Object)this._event)).timestampLastDataEventWasReceivedMs = e.timestampLastDataEventWasReceivedMs;
        } else if (e.timestampLastDataEventWasReceivedMs > 0L) {
            ((UnifiedClientStatsEvent)((Object)this._event)).timestampLastDataEventWasReceivedMs = Math.min(((UnifiedClientStatsEvent)((Object)this._event)).timestampLastDataEventWasReceivedMs, e.timestampLastDataEventWasReceivedMs);
        }
        if (e.timestampLastDataEventWasReceivedMs > 0L) {
            this._reservoirTimeLagSourceToReceiptMs.merge(otherEvent.getReservoirTimeLagSourceToReceiptMs());
        }
        this._reservoirTimeLagConsumerCallbacksMs.merge(otherEvent.getReservoirTimeLagConsumerCallbacksMs());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void merge(UnifiedClientStats obj) {
        if (!this._enabled.get()) {
            return;
        }
        Lock writeLock = this.acquireWriteLock();
        try {
            this.doMergeStats(obj);
        }
        finally {
            this.releaseLock(writeLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetAndMerge(List<UnifiedClientStats> objList) {
        Lock writeLock = this.acquireWriteLock();
        try {
            this.reset();
            for (UnifiedClientStats t : objList) {
                this.merge(t);
            }
        }
        finally {
            this.releaseLock(writeLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mergeStats(DatabusMonitoringMBean<UnifiedClientStatsEvent> other) {
        if (!(other instanceof UnifiedClientStats)) {
            return;
        }
        UnifiedClientStats otherObj = (UnifiedClientStats)other;
        Lock otherReadLock = otherObj.acquireReadLock();
        Lock thisWriteLock = null;
        try {
            thisWriteLock = this.acquireWriteLock(otherReadLock);
            this.doMergeStats(otherObj);
        }
        finally {
            this.releaseLock(thisWriteLock);
            this.releaseLock(otherReadLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getCurBootstrappingPartitions() {
        int result = 0;
        Lock readLock = this.acquireReadLock();
        try {
            result = ((UnifiedClientStatsEvent)((Object)this._event)).curBootstrappingPartitions;
        }
        finally {
            this.releaseLock(readLock);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getCurDeadConnections() {
        int result = 0;
        Lock readLock = this.acquireReadLock();
        try {
            if (!((UnifiedClientStatsEvent)((Object)this._event)).aggregated) {
                long timeIntervalSinceHeartbeatMs = System.currentTimeMillis() - ((UnifiedClientStatsEvent)((Object)this._event)).timestampOfLastHeartbeatMs;
                ((UnifiedClientStatsEvent)((Object)this._event)).curDeadConnections = timeIntervalSinceHeartbeatMs > this._deadnessThresholdMs ? 1 : 0;
            }
            result = ((UnifiedClientStatsEvent)((Object)this._event)).curDeadConnections;
        }
        finally {
            this.releaseLock(readLock);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getNumConsumerErrors() {
        long result = 0L;
        Lock readLock = this.acquireReadLock();
        try {
            result = ((UnifiedClientStatsEvent)((Object)this._event)).numConsumerErrors;
        }
        finally {
            this.releaseLock(readLock);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getNumDataEvents() {
        long result = 0L;
        Lock readLock = this.acquireReadLock();
        try {
            result = ((UnifiedClientStatsEvent)((Object)this._event)).numDataEvents;
        }
        finally {
            this.releaseLock(readLock);
        }
        return result;
    }

    @Override
    public double getTimeLagSourceToReceiptMs_HistPct_50() {
        return this.getTimeLagSourceToReceiptMs_HistPct(50.0);
    }

    @Override
    public double getTimeLagSourceToReceiptMs_HistPct_90() {
        return this.getTimeLagSourceToReceiptMs_HistPct(90.0);
    }

    @Override
    public double getTimeLagSourceToReceiptMs_HistPct_95() {
        return this.getTimeLagSourceToReceiptMs_HistPct(95.0);
    }

    @Override
    public double getTimeLagSourceToReceiptMs_HistPct_99() {
        return this.getTimeLagSourceToReceiptMs_HistPct(99.0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private double getTimeLagSourceToReceiptMs_HistPct(double percentile) {
        double result = -1.0;
        Lock readLock = this.acquireReadLock();
        try {
            double[] dataValues;
            if (!this._isBootstrapping && ((UnifiedClientStatsEvent)((Object)this._event)).timestampLastDataEventWasReceivedMs > 0L && this._reservoirTimeLagSourceToReceiptMs != null && this._reservoirTimeLagSourceToReceiptMs.size() > 0 && (dataValues = this._reservoirTimeLagSourceToReceiptMs.getUnsortedValues()).length > 0) {
                result = StatUtils.percentile((double[])dataValues, (double)percentile);
            }
        }
        finally {
            this.releaseLock(readLock);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getTimeLagLastReceivedToNowMs() {
        long result = 0L;
        Lock readLock = this.acquireReadLock();
        try {
            result = ((UnifiedClientStatsEvent)((Object)this._event)).timestampLastDataEventWasReceivedMs != 0L ? System.currentTimeMillis() - ((UnifiedClientStatsEvent)((Object)this._event)).timestampLastDataEventWasReceivedMs : -1L;
        }
        finally {
            this.releaseLock(readLock);
        }
        return result;
    }

    @Override
    public double getTimeLagConsumerCallbacksMs_HistPct_50() {
        return this.getTimeLagConsumerCallbacksMs_HistPct(50.0);
    }

    @Override
    public double getTimeLagConsumerCallbacksMs_HistPct_90() {
        return this.getTimeLagConsumerCallbacksMs_HistPct(90.0);
    }

    @Override
    public double getTimeLagConsumerCallbacksMs_HistPct_95() {
        return this.getTimeLagConsumerCallbacksMs_HistPct(95.0);
    }

    @Override
    public double getTimeLagConsumerCallbacksMs_HistPct_99() {
        return this.getTimeLagConsumerCallbacksMs_HistPct(99.0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private double getTimeLagConsumerCallbacksMs_HistPct(double percentile) {
        double result = -1.0;
        Lock readLock = this.acquireReadLock();
        try {
            if (this._reservoirTimeLagConsumerCallbacksMs.size() > 0) {
                double[] dataValues = this._reservoirTimeLagConsumerCallbacksMs.getUnsortedValues();
                result = StatUtils.percentile((double[])dataValues, (double)percentile);
            }
        }
        finally {
            this.releaseLock(readLock);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getTimeLagConsumerCallbacksMs_Max() {
        double result = -1.0;
        Lock readLock = this.acquireReadLock();
        try {
            if (this._reservoirTimeLagConsumerCallbacksMs.size() > 0) {
                double[] dataValues = this._reservoirTimeLagConsumerCallbacksMs.getUnsortedValues();
                result = StatUtils.max((double[])dataValues);
            }
        }
        finally {
            this.releaseLock(readLock);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getTimeSinceLastResetMs() {
        long result = 0L;
        Lock readLock = this.acquireReadLock();
        try {
            result = System.currentTimeMillis() - ((UnifiedClientStatsEvent)((Object)this._event)).timestampLastResetMs;
        }
        finally {
            this.releaseLock(readLock);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getTimestampLastResetMs() {
        long result = 0L;
        Lock readLock = this.acquireReadLock();
        try {
            result = ((UnifiedClientStatsEvent)((Object)this._event)).timestampLastResetMs;
        }
        finally {
            this.releaseLock(readLock);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerDataEventReceived(DbusEvent e) {
        if (!this._enabled.get()) {
            return;
        }
        Lock writeLock = this.acquireWriteLock();
        try {
            ++((UnifiedClientStatsEvent)((Object)this._event)).numDataEvents;
            ((UnifiedClientStatsEvent)((Object)this._event)).timestampLastDataEventWasReceivedMs = System.currentTimeMillis();
            if (!this._isBootstrapping) {
                long sourceTimestampOfLastEventReceivedMs = e.timestampInNanos() / 1000000L;
                this._reservoirTimeLagSourceToReceiptMs.update((double)(((UnifiedClientStatsEvent)((Object)this._event)).timestampLastDataEventWasReceivedMs - sourceTimestampOfLastEventReceivedMs), ((UnifiedClientStatsEvent)((Object)this._event)).timestampLastDataEventWasReceivedMs / 1000L);
            }
        }
        finally {
            this.releaseLock(writeLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerCallbacksProcessed(long timeElapsedNs) {
        if (!this._enabled.get()) {
            return;
        }
        Lock writeLock = this.acquireWriteLock();
        try {
            this._reservoirTimeLagConsumerCallbacksMs.update((double)timeElapsedNs / 1000000.0);
        }
        finally {
            this.releaseLock(writeLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerCallbackError() {
        if (!this._enabled.get()) {
            return;
        }
        Lock writeLock = this.acquireWriteLock();
        try {
            ++((UnifiedClientStatsEvent)((Object)this._event)).numConsumerErrors;
        }
        finally {
            this.releaseLock(writeLock);
        }
    }
}

