/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.client.pub.mbean;

import com.linkedin.databus.client.pub.mbean.ConsumerCallbackStatsMBean;
import com.linkedin.databus.client.pub.monitoring.events.ConsumerCallbackStatsEvent;
import com.linkedin.databus.core.DbusEvent;
import com.linkedin.databus.core.monitoring.mbean.AbstractMonitoringMBean;
import com.linkedin.databus.core.monitoring.mbean.StatsCollectorMergeable;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.List;
import java.util.concurrent.locks.Lock;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.avro.io.JsonEncoder;
import org.apache.avro.specific.SpecificDatumWriter;

public class ConsumerCallbackStats
extends AbstractMonitoringMBean<ConsumerCallbackStatsEvent>
implements ConsumerCallbackStatsMBean,
StatsCollectorMergeable<ConsumerCallbackStats> {
    private final String _name;
    private final String _dimension;
    private final MBeanServer _mbeanServer;

    public ConsumerCallbackStats(int ownerId, String name, String dimension, boolean enabled, boolean threadSafe, ConsumerCallbackStatsEvent initData) {
        this(ownerId, name, dimension, enabled, threadSafe, initData, null);
    }

    public ConsumerCallbackStats(int ownerId, String name, String dimension, boolean enabled, boolean threadSafe, ConsumerCallbackStatsEvent initData, MBeanServer server) {
        super(enabled, threadSafe, (Object)initData);
        ((ConsumerCallbackStatsEvent)((Object)this._event)).ownerId = ownerId;
        this._name = name;
        this._dimension = dimension;
        ((ConsumerCallbackStatsEvent)((Object)this._event)).dimension = dimension;
        ((ConsumerCallbackStatsEvent)((Object)this._event)).timestampLastMergeMs = ((ConsumerCallbackStatsEvent)((Object)this._event)).timestampCreationMs = System.currentTimeMillis();
        this._mbeanServer = server;
        this.resetData();
        this.registerAsMbean();
    }

    public String getDimension() {
        return this._dimension;
    }

    public String getName() {
        return this._name;
    }

    public void registerAsMbean() {
        super.registerAsMbean(this._mbeanServer);
    }

    public void unregisterAsMbean() {
        super.unregisterMbean(this._mbeanServer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getTimestampLastResetMs() {
        Lock readLock = this.acquireReadLock();
        long result = 0L;
        try {
            result = ((ConsumerCallbackStatsEvent)((Object)this._event)).timestampLastResetMs;
        }
        finally {
            this.releaseLock(readLock);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getTimeSinceLastResetMs() {
        Lock readLock = this.acquireReadLock();
        long result = 0L;
        try {
            result = System.currentTimeMillis() - ((ConsumerCallbackStatsEvent)((Object)this._event)).timestampLastResetMs;
        }
        finally {
            this.releaseLock(readLock);
        }
        return result;
    }

    public JsonEncoder createJsonEncoder(OutputStream out) throws IOException {
        return new JsonEncoder(((ConsumerCallbackStatsEvent)((Object)this._event)).getSchema(), out);
    }

    public ObjectName generateObjectName() throws MalformedObjectNameException {
        Hashtable mbeanProps = this.generateBaseMBeanProps();
        mbeanProps.put("ownerId", Integer.toString(((ConsumerCallbackStatsEvent)((Object)this._event)).ownerId));
        mbeanProps.put("dimension", this._dimension);
        return new ObjectName("com.linkedin.databus2", mbeanProps);
    }

    protected void resetData() {
        ((ConsumerCallbackStatsEvent)((Object)this._event)).maxSeenWinScn = 0L;
        ((ConsumerCallbackStatsEvent)((Object)this._event)).minSeenWinScn = 0L;
        ((ConsumerCallbackStatsEvent)((Object)this._event)).latencyEventsProcessed = 0L;
        ((ConsumerCallbackStatsEvent)((Object)this._event)).numDataEventsProcessed = 0L;
        ((ConsumerCallbackStatsEvent)((Object)this._event)).numDataEventsReceived = 0L;
        ((ConsumerCallbackStatsEvent)((Object)this._event)).numErrorsReceived = 0L;
        ((ConsumerCallbackStatsEvent)((Object)this._event)).numErrorsProcessed = 0L;
        ((ConsumerCallbackStatsEvent)((Object)this._event)).numSysEventsReceived = 0L;
        ((ConsumerCallbackStatsEvent)((Object)this._event)).numSysEventsProcessed = 0L;
        ((ConsumerCallbackStatsEvent)((Object)this._event)).numSysErrorsProcessed = 0L;
        ((ConsumerCallbackStatsEvent)((Object)this._event)).numDataErrorsProcessed = 0L;
        ((ConsumerCallbackStatsEvent)((Object)this._event)).numEventsProcessed = 0L;
        ((ConsumerCallbackStatsEvent)((Object)this._event)).numEventsReceived = 0L;
        ((ConsumerCallbackStatsEvent)((Object)this._event)).timestampLastResetMs = System.currentTimeMillis();
        ((ConsumerCallbackStatsEvent)((Object)this._event)).timestampLastEventProcessed = 0L;
        ((ConsumerCallbackStatsEvent)((Object)this._event)).timestampLastEventReceived = 0L;
        ((ConsumerCallbackStatsEvent)((Object)this._event)).timestampOfLastEventReceived = 0L;
        ((ConsumerCallbackStatsEvent)((Object)this._event)).timestampOfLastEventProcessed = 0L;
        ((ConsumerCallbackStatsEvent)((Object)this._event)).scnOfLastEventProcessed = 0L;
        ((ConsumerCallbackStatsEvent)((Object)this._event)).maxSeenWinTimestamp = 0L;
    }

    protected void cloneData(ConsumerCallbackStatsEvent event) {
        event.maxSeenWinScn = ((ConsumerCallbackStatsEvent)((Object)this._event)).maxSeenWinScn;
        event.minSeenWinScn = ((ConsumerCallbackStatsEvent)((Object)this._event)).minSeenWinScn;
        event.latencyEventsProcessed = ((ConsumerCallbackStatsEvent)((Object)this._event)).latencyEventsProcessed;
        event.numDataEventsReceived = ((ConsumerCallbackStatsEvent)((Object)this._event)).numDataEventsReceived;
        event.numDataEventsProcessed = ((ConsumerCallbackStatsEvent)((Object)this._event)).numDataEventsProcessed;
        event.numDataErrorsProcessed = ((ConsumerCallbackStatsEvent)((Object)this._event)).numDataErrorsProcessed;
        event.numErrorsReceived = ((ConsumerCallbackStatsEvent)((Object)this._event)).numErrorsReceived;
        event.numErrorsProcessed = ((ConsumerCallbackStatsEvent)((Object)this._event)).numErrorsProcessed;
        event.numSysEventsReceived = ((ConsumerCallbackStatsEvent)((Object)this._event)).numSysEventsReceived;
        event.numSysEventsProcessed = ((ConsumerCallbackStatsEvent)((Object)this._event)).numSysEventsProcessed;
        event.numSysErrorsProcessed = ((ConsumerCallbackStatsEvent)((Object)this._event)).numSysErrorsProcessed;
        event.numEventsProcessed = ((ConsumerCallbackStatsEvent)((Object)this._event)).numEventsProcessed;
        event.numEventsReceived = ((ConsumerCallbackStatsEvent)((Object)this._event)).numEventsReceived;
        event.scnOfLastEventProcessed = ((ConsumerCallbackStatsEvent)((Object)this._event)).scnOfLastEventProcessed;
        event.maxSeenWinTimestamp = ((ConsumerCallbackStatsEvent)((Object)this._event)).maxSeenWinTimestamp;
    }

    protected ConsumerCallbackStatsEvent newDataEvent() {
        return new ConsumerCallbackStatsEvent();
    }

    protected SpecificDatumWriter<ConsumerCallbackStatsEvent> getAvroWriter() {
        return new SpecificDatumWriter(ConsumerCallbackStatsEvent.class);
    }

    protected void doMergeStats(Object eventData) {
        if (!(eventData instanceof ConsumerCallbackStatsEvent)) {
            if (!(eventData instanceof ConsumerCallbackStats)) {
                LOG.warn((Object)("Attempt to merge unknown event class" + eventData.getClass().getName()));
                return;
            }
            eventData = ((ConsumerCallbackStats)eventData)._event;
        }
        ConsumerCallbackStatsEvent e = (ConsumerCallbackStatsEvent)((Object)eventData);
        ((ConsumerCallbackStatsEvent)((Object)this._event)).numDataEventsReceived += e.numDataEventsReceived;
        ((ConsumerCallbackStatsEvent)((Object)this._event)).numDataEventsProcessed += e.numDataEventsProcessed;
        ((ConsumerCallbackStatsEvent)((Object)this._event)).numDataErrorsProcessed += e.numDataErrorsProcessed;
        ((ConsumerCallbackStatsEvent)((Object)this._event)).numEventsReceived += e.numEventsReceived;
        ((ConsumerCallbackStatsEvent)((Object)this._event)).numEventsProcessed += e.numEventsProcessed;
        ((ConsumerCallbackStatsEvent)((Object)this._event)).numErrorsReceived += e.numErrorsReceived;
        ((ConsumerCallbackStatsEvent)((Object)this._event)).numErrorsProcessed += e.numErrorsProcessed;
        ((ConsumerCallbackStatsEvent)((Object)this._event)).numSysEventsProcessed += e.numSysEventsProcessed;
        ((ConsumerCallbackStatsEvent)((Object)this._event)).numSysEventsReceived += e.numSysEventsReceived;
        ((ConsumerCallbackStatsEvent)((Object)this._event)).numSysErrorsProcessed += e.numSysErrorsProcessed;
        ((ConsumerCallbackStatsEvent)((Object)this._event)).latencyEventsProcessed += e.latencyEventsProcessed;
        ((ConsumerCallbackStatsEvent)((Object)this._event)).minSeenWinScn = ((ConsumerCallbackStatsEvent)((Object)this._event)).minSeenWinScn != 0L ? Math.min(((ConsumerCallbackStatsEvent)((Object)this._event)).minSeenWinScn, e.minSeenWinScn) : e.minSeenWinScn;
        ((ConsumerCallbackStatsEvent)((Object)this._event)).maxSeenWinScn = ((ConsumerCallbackStatsEvent)((Object)this._event)).maxSeenWinScn != 0L ? Math.max(((ConsumerCallbackStatsEvent)((Object)this._event)).maxSeenWinScn, e.maxSeenWinScn) : e.maxSeenWinScn;
        ((ConsumerCallbackStatsEvent)((Object)this._event)).timestampLastMergeMs = System.currentTimeMillis();
        ((ConsumerCallbackStatsEvent)((Object)this._event)).timestampLastEventProcessed = ((ConsumerCallbackStatsEvent)((Object)this._event)).timestampLastEventProcessed != 0L ? Math.max(((ConsumerCallbackStatsEvent)((Object)this._event)).timestampLastEventProcessed, e.timestampLastEventProcessed) : e.timestampLastEventProcessed;
        ((ConsumerCallbackStatsEvent)((Object)this._event)).timestampLastEventReceived = ((ConsumerCallbackStatsEvent)((Object)this._event)).timestampLastEventReceived != 0L ? Math.max(((ConsumerCallbackStatsEvent)((Object)this._event)).timestampLastEventReceived, e.timestampLastEventReceived) : e.timestampLastEventReceived;
        ((ConsumerCallbackStatsEvent)((Object)this._event)).timestampOfLastEventProcessed = ((ConsumerCallbackStatsEvent)((Object)this._event)).timestampOfLastEventProcessed != 0L ? Math.max(((ConsumerCallbackStatsEvent)((Object)this._event)).timestampOfLastEventProcessed, e.timestampOfLastEventProcessed) : e.timestampOfLastEventProcessed;
        ((ConsumerCallbackStatsEvent)((Object)this._event)).timestampOfLastEventReceived = ((ConsumerCallbackStatsEvent)((Object)this._event)).timestampOfLastEventReceived != 0L ? Math.max(((ConsumerCallbackStatsEvent)((Object)this._event)).timestampOfLastEventReceived, e.timestampOfLastEventReceived) : e.timestampOfLastEventReceived;
        ((ConsumerCallbackStatsEvent)((Object)this._event)).scnOfLastEventProcessed = 0L != ((ConsumerCallbackStatsEvent)((Object)this._event)).scnOfLastEventProcessed ? Math.max(((ConsumerCallbackStatsEvent)((Object)this._event)).scnOfLastEventProcessed, e.scnOfLastEventProcessed) : e.scnOfLastEventProcessed;
        ((ConsumerCallbackStatsEvent)((Object)this._event)).maxSeenWinTimestamp = 0L != ((ConsumerCallbackStatsEvent)((Object)this._event)).maxSeenWinTimestamp ? Math.max(((ConsumerCallbackStatsEvent)((Object)this._event)).maxSeenWinTimestamp, e.maxSeenWinTimestamp) : e.maxSeenWinTimestamp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetAndMerge(List<ConsumerCallbackStats> objList) {
        Lock writeLock = this.acquireWriteLock();
        try {
            this.reset();
            for (ConsumerCallbackStats t : objList) {
                this.merge(t);
            }
        }
        finally {
            this.releaseLock(writeLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getNumDataEventsReceived() {
        Lock readLock = this.acquireReadLock();
        long result = 0L;
        try {
            result = ((ConsumerCallbackStatsEvent)((Object)this._event)).numDataEventsReceived;
        }
        finally {
            this.releaseLock(readLock);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getNumDataEventsProcessed() {
        Lock readLock = this.acquireReadLock();
        long result = 0L;
        try {
            result = ((ConsumerCallbackStatsEvent)((Object)this._event)).numDataEventsProcessed;
        }
        finally {
            this.releaseLock(readLock);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getNumDataErrorsProcessed() {
        Lock readLock = this.acquireReadLock();
        long result = 0L;
        try {
            result = ((ConsumerCallbackStatsEvent)((Object)this._event)).numDataErrorsProcessed;
        }
        finally {
            this.releaseLock(readLock);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getNumSysEventsReceived() {
        Lock readLock = this.acquireReadLock();
        long result = 0L;
        try {
            result = ((ConsumerCallbackStatsEvent)((Object)this._event)).numSysEventsReceived;
        }
        finally {
            this.releaseLock(readLock);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getMinSeenWinScn() {
        Lock readLock = this.acquireReadLock();
        long result = 0L;
        try {
            result = ((ConsumerCallbackStatsEvent)((Object)this._event)).minSeenWinScn;
        }
        finally {
            this.releaseLock(readLock);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getMaxSeenWinScn() {
        Lock readLock = this.acquireReadLock();
        long result = 0L;
        try {
            result = ((ConsumerCallbackStatsEvent)((Object)this._event)).maxSeenWinScn;
        }
        finally {
            this.releaseLock(readLock);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getNumErrorsReceived() {
        Lock readLock = this.acquireReadLock();
        long result = 0L;
        try {
            result = ((ConsumerCallbackStatsEvent)((Object)this._event)).numErrorsReceived;
        }
        finally {
            this.releaseLock(readLock);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getNumErrorsProcessed() {
        Lock readLock = this.acquireReadLock();
        long result = 0L;
        try {
            result = ((ConsumerCallbackStatsEvent)((Object)this._event)).numErrorsProcessed;
        }
        finally {
            this.releaseLock(readLock);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getTimeSinceCreation() {
        Lock readLock = this.acquireReadLock();
        long result = 0L;
        try {
            result = System.currentTimeMillis() - ((ConsumerCallbackStatsEvent)((Object)this._event)).timestampCreationMs;
        }
        finally {
            this.releaseLock(readLock);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getLatencyEventsProcessed() {
        Lock readLock = this.acquireReadLock();
        long result = 0L;
        try {
            result = ((ConsumerCallbackStatsEvent)((Object)this._event)).latencyEventsProcessed;
        }
        finally {
            this.releaseLock(readLock);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getNumEventsProcessed() {
        Lock readLock = this.acquireReadLock();
        long result = 0L;
        try {
            result = ((ConsumerCallbackStatsEvent)((Object)this._event)).numEventsProcessed;
        }
        finally {
            this.releaseLock(readLock);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getAveLatencyEventsProcessed() {
        Lock readLock = this.acquireReadLock();
        double result = 0.0;
        try {
            result = ((ConsumerCallbackStatsEvent)((Object)this._event)).numEventsProcessed != 0L ? (double)((ConsumerCallbackStatsEvent)((Object)this._event)).latencyEventsProcessed / (double)((ConsumerCallbackStatsEvent)((Object)this._event)).numEventsProcessed : 0.0;
        }
        finally {
            this.releaseLock(readLock);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerDataEventReceived(DbusEvent e) {
        if (!this._enabled.get()) {
            return;
        }
        Lock writeLock = this.acquireWriteLock();
        try {
            ++((ConsumerCallbackStatsEvent)((Object)this._event)).numEventsReceived;
            ++((ConsumerCallbackStatsEvent)((Object)this._event)).numDataEventsReceived;
            ((ConsumerCallbackStatsEvent)((Object)this._event)).timestampLastEventReceived = System.currentTimeMillis();
            ((ConsumerCallbackStatsEvent)((Object)this._event)).timestampOfLastEventReceived = e.timestampInNanos() / 1000000L;
        }
        finally {
            this.releaseLock(writeLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerSystemEventReceived() {
        if (!this._enabled.get()) {
            return;
        }
        Lock writeLock = this.acquireWriteLock();
        try {
            ++((ConsumerCallbackStatsEvent)((Object)this._event)).numEventsReceived;
            ++((ConsumerCallbackStatsEvent)((Object)this._event)).numSysEventsReceived;
            ((ConsumerCallbackStatsEvent)((Object)this._event)).timestampLastEventReceived = System.currentTimeMillis();
        }
        finally {
            this.releaseLock(writeLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerSystemEventProcessed(long timeElapsed) {
        if (!this._enabled.get()) {
            return;
        }
        Lock writeLock = this.acquireWriteLock();
        try {
            ++((ConsumerCallbackStatsEvent)((Object)this._event)).numEventsProcessed;
            ++((ConsumerCallbackStatsEvent)((Object)this._event)).numSysEventsProcessed;
            ((ConsumerCallbackStatsEvent)((Object)this._event)).timestampLastEventProcessed = System.currentTimeMillis();
            ((ConsumerCallbackStatsEvent)((Object)this._event)).latencyEventsProcessed += timeElapsed;
        }
        finally {
            this.releaseLock(writeLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerEventsReceived(int size) {
        if (!this._enabled.get()) {
            return;
        }
        Lock writeLock = this.acquireWriteLock();
        try {
            ((ConsumerCallbackStatsEvent)((Object)this._event)).numEventsReceived += (long)size;
            ((ConsumerCallbackStatsEvent)((Object)this._event)).timestampLastEventReceived = System.currentTimeMillis();
        }
        finally {
            this.releaseLock(writeLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerEventsProcessed(int size, long timeElapsed) {
        if (!this._enabled.get()) {
            return;
        }
        Lock writeLock = this.acquireWriteLock();
        try {
            ((ConsumerCallbackStatsEvent)((Object)this._event)).numEventsProcessed += (long)size;
            ((ConsumerCallbackStatsEvent)((Object)this._event)).timestampLastEventProcessed = System.currentTimeMillis();
            ((ConsumerCallbackStatsEvent)((Object)this._event)).latencyEventsProcessed += timeElapsed;
        }
        finally {
            this.releaseLock(writeLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerDataEventsProcessed(int size, long timeElapsed, DbusEvent e) {
        if (!this._enabled.get()) {
            return;
        }
        Lock writeLock = this.acquireWriteLock();
        try {
            ((ConsumerCallbackStatsEvent)((Object)this._event)).numEventsProcessed += (long)size;
            ((ConsumerCallbackStatsEvent)((Object)this._event)).numDataEventsProcessed += (long)size;
            ((ConsumerCallbackStatsEvent)((Object)this._event)).latencyEventsProcessed += timeElapsed;
            ((ConsumerCallbackStatsEvent)((Object)this._event)).timestampLastEventProcessed = System.currentTimeMillis();
            ((ConsumerCallbackStatsEvent)((Object)this._event)).timestampOfLastEventProcessed = e.timestampInNanos() / 1000000L;
            ((ConsumerCallbackStatsEvent)((Object)this._event)).scnOfLastEventProcessed = e.sequence();
        }
        finally {
            this.releaseLock(writeLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerErrorEventsProcessed(int size) {
        if (!this._enabled.get()) {
            return;
        }
        Lock writeLock = this.acquireWriteLock();
        try {
            ((ConsumerCallbackStatsEvent)((Object)this._event)).numErrorsProcessed += (long)size;
        }
        finally {
            this.releaseLock(writeLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerSysErrorsProcessed() {
        if (!this._enabled.get()) {
            return;
        }
        Lock writeLock = this.acquireWriteLock();
        try {
            ++((ConsumerCallbackStatsEvent)((Object)this._event)).numErrorsProcessed;
            ++((ConsumerCallbackStatsEvent)((Object)this._event)).numSysErrorsProcessed;
        }
        finally {
            this.releaseLock(writeLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerDataErrorsProcessed() {
        if (!this._enabled.get()) {
            return;
        }
        Lock writeLock = this.acquireWriteLock();
        try {
            ++((ConsumerCallbackStatsEvent)((Object)this._event)).numErrorsProcessed;
            ++((ConsumerCallbackStatsEvent)((Object)this._event)).numDataErrorsProcessed;
        }
        finally {
            this.releaseLock(writeLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerSrcErrors() {
        if (!this._enabled.get()) {
            return;
        }
        Lock writeLock = this.acquireWriteLock();
        try {
            ++((ConsumerCallbackStatsEvent)((Object)this._event)).numErrorsReceived;
        }
        finally {
            this.releaseLock(writeLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerWindowSeen(long timestamp, long scn) {
        Lock writeLock = this.acquireWriteLock();
        try {
            ((ConsumerCallbackStatsEvent)((Object)this._event)).maxSeenWinScn = ((ConsumerCallbackStatsEvent)((Object)this._event)).maxSeenWinScn == 0L ? scn : Math.max(((ConsumerCallbackStatsEvent)((Object)this._event)).maxSeenWinScn, scn);
            ((ConsumerCallbackStatsEvent)((Object)this._event)).minSeenWinScn = ((ConsumerCallbackStatsEvent)((Object)this._event)).minSeenWinScn == 0L ? scn : Math.min(((ConsumerCallbackStatsEvent)((Object)this._event)).minSeenWinScn, scn);
            ((ConsumerCallbackStatsEvent)((Object)this._event)).maxSeenWinTimestamp = 0L == ((ConsumerCallbackStatsEvent)((Object)this._event)).maxSeenWinTimestamp ? timestamp / 1000000L : Math.max(((ConsumerCallbackStatsEvent)((Object)this._event)).maxSeenWinTimestamp, timestamp / 1000000L);
        }
        finally {
            this.releaseLock(writeLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getTimeSinceLastMergeMs() {
        Lock readLock = this.acquireReadLock();
        long result = 0L;
        try {
            result = System.currentTimeMillis() - ((ConsumerCallbackStatsEvent)((Object)this._event)).timestampLastMergeMs;
        }
        finally {
            this.releaseLock(readLock);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getTimeSinceLastEventReceived() {
        Lock readLock = this.acquireReadLock();
        long result = 0L;
        try {
            result = System.currentTimeMillis() - ((ConsumerCallbackStatsEvent)((Object)this._event)).timestampLastEventReceived;
        }
        finally {
            this.releaseLock(readLock);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getTimeSinceLastEventProcessed() {
        Lock readLock = this.acquireReadLock();
        long result = 0L;
        try {
            result = System.currentTimeMillis() - ((ConsumerCallbackStatsEvent)((Object)this._event)).timestampLastEventProcessed;
        }
        finally {
            this.releaseLock(readLock);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getTimeDiffLastEventReceived() {
        Lock readLock = this.acquireReadLock();
        long result = 0L;
        try {
            result = System.currentTimeMillis() - ((ConsumerCallbackStatsEvent)((Object)this._event)).timestampOfLastEventReceived;
        }
        finally {
            this.releaseLock(readLock);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getTimeDiffLastEventProcessed() {
        Lock readLock = this.acquireReadLock();
        long result = 0L;
        try {
            result = System.currentTimeMillis() - ((ConsumerCallbackStatsEvent)((Object)this._event)).timestampOfLastEventProcessed;
        }
        finally {
            this.releaseLock(readLock);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getNumSysErrorsProcessed() {
        Lock readLock = this.acquireReadLock();
        long result = 0L;
        try {
            result = ((ConsumerCallbackStatsEvent)((Object)this._event)).numSysErrorsProcessed;
        }
        finally {
            this.releaseLock(readLock);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getNumEventsReceived() {
        Lock readLock = this.acquireReadLock();
        long result = 0L;
        try {
            result = ((ConsumerCallbackStatsEvent)((Object)this._event)).numEventsReceived;
        }
        finally {
            this.releaseLock(readLock);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getNumSysEventsProcessed() {
        Lock readLock = this.acquireReadLock();
        long result = 0L;
        try {
            result = ((ConsumerCallbackStatsEvent)((Object)this._event)).numSysEventsProcessed;
        }
        finally {
            this.releaseLock(readLock);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void merge(ConsumerCallbackStats obj) {
        if (!this._enabled.get()) {
            return;
        }
        Lock writeLock = this.acquireWriteLock();
        try {
            this.doMergeStats(obj);
        }
        finally {
            this.releaseLock(writeLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getScnOfLastEventProcessed() {
        Lock readLock = this.acquireReadLock();
        long result = 0L;
        try {
            result = ((ConsumerCallbackStatsEvent)((Object)this._event)).scnOfLastEventProcessed;
        }
        finally {
            this.releaseLock(readLock);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getMaxSeenWinTimestamp() {
        Lock readLock = this.acquireReadLock();
        long result = 0L;
        try {
            result = ((ConsumerCallbackStatsEvent)((Object)this._event)).maxSeenWinTimestamp;
        }
        finally {
            this.releaseLock(readLock);
        }
        return result;
    }
}

