/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.client.pub;

import com.linkedin.databus.client.pub.CheckpointPersistenceProviderAbstract;
import com.linkedin.databus.client.pub.DatabusClientGroupMember;
import com.linkedin.databus.core.Checkpoint;
import com.linkedin.databus.core.util.ConfigApplier;
import com.linkedin.databus.core.util.ConfigBuilder;
import com.linkedin.databus.core.util.InvalidConfigException;
import java.io.IOException;
import java.util.List;
import org.apache.log4j.Logger;

public class SharedCheckpointPersistenceProvider
extends CheckpointPersistenceProviderAbstract {
    public static final String MODULE = SharedCheckpointPersistenceProvider.class.getName();
    public static final Logger LOG = Logger.getLogger((String)MODULE);
    private final StaticConfig _staticConfig;
    private final DatabusClientGroupMember _groupMember;
    private int _numWrites = 0;

    public SharedCheckpointPersistenceProvider(DatabusClientGroupMember node) throws InvalidConfigException {
        this(node, new Config());
    }

    public StaticConfig getStaticConfig() {
        return this._staticConfig;
    }

    public SharedCheckpointPersistenceProvider(DatabusClientGroupMember groupMember, Config config) throws InvalidConfigException {
        this(groupMember, config.build());
    }

    public SharedCheckpointPersistenceProvider(DatabusClientGroupMember node, StaticConfig config) throws InvalidConfigException {
        this._staticConfig = config;
        this._groupMember = node;
        if (this._groupMember == null) {
            throw new InvalidConfigException("Cannot initialize shared checkpoint with null cluster group member! Check if cluster node has been enabled");
        }
    }

    @Override
    public void storeCheckpoint(List<String> sourceNames, Checkpoint checkpoint) throws IOException {
        String key = this.makeKey(sourceNames);
        ++this._numWrites;
        if (this._numWrites > this._staticConfig.getMaxNumWritesSkipped()) {
            this._numWrites = 0;
            if (!this._groupMember.writeSharedData(key, checkpoint)) {
                LOG.info((Object)("Write failed in store checkpoint; Assuming no connection to zookeeper; throwing IO Exception: key=" + key));
                throw new IOException("Write failed in store checkpoint; Assuming no connection to zookeeper; throwing IO Exception: key=" + key);
            }
        }
    }

    protected String makeKey(List<String> srcs) {
        StringBuilder k = new StringBuilder();
        for (String s : srcs) {
            k.append("_");
            k.append(s);
        }
        return k.toString();
    }

    @Override
    public Checkpoint loadCheckpoint(List<String> sourceNames) {
        String key = this.makeKey(sourceNames);
        return (Checkpoint)this._groupMember.readSharedData(key);
    }

    @Override
    public void removeCheckpoint(List<String> sourceNames) {
        String key = this.makeKey(sourceNames);
        this._groupMember.removeSharedData(key);
    }

    public static class RuntimeConfigBuilder
    implements ConfigBuilder<RuntimeConfig> {
        private SharedCheckpointPersistenceProvider _managedInstance = null;

        public RuntimeConfig build() throws InvalidConfigException {
            if (null == this._managedInstance) {
                throw new InvalidConfigException("No associated managed instance for runtime config");
            }
            return new RuntimeConfig();
        }

        public void setManagedInstance(SharedCheckpointPersistenceProvider persistenceProvider) {
            this._managedInstance = persistenceProvider;
        }

        public Object getManagedInstance() {
            return this._managedInstance;
        }
    }

    public static class RuntimeConfig
    implements ConfigApplier<RuntimeConfig> {
        public void applyNewConfig(RuntimeConfig oldConfig) {
        }

        public boolean equalsConfig(RuntimeConfig otherConfig) {
            return null != otherConfig;
        }
    }

    public static class Config
    implements ConfigBuilder<StaticConfig> {
        private int _maxNumWritesSkipped = 0;

        public StaticConfig build() throws InvalidConfigException {
            return new StaticConfig(this._maxNumWritesSkipped);
        }

        public int getMaxNumWritesSkipped() {
            return this._maxNumWritesSkipped;
        }

        public void setMaxNumWritesSkipped(int frequencyOfWritesInEvents) {
            this._maxNumWritesSkipped = frequencyOfWritesInEvents;
        }
    }

    public static class StaticConfig {
        private final int _maxNumWritesSkipped;

        public StaticConfig(int maxNumWritesSkipped) {
            this._maxNumWritesSkipped = maxNumWritesSkipped;
        }

        public int getMaxNumWritesSkipped() {
            return this._maxNumWritesSkipped;
        }

        public String toString() {
            return "StaticConfig [_maxNumWritesSkipped=" + this._maxNumWritesSkipped + "]";
        }
    }
}

