/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.client.pub;

import com.linkedin.databus.client.pub.DbusClusterInfo;
import com.linkedin.databus.client.pub.DbusModPartitionedFilterFactory;
import com.linkedin.databus.client.pub.DbusPartitionInfo;
import com.linkedin.databus.client.pub.DbusServerSideFilterFactory;
import com.linkedin.databus.core.data_model.DatabusSubscription;
import com.linkedin.databus.core.data_model.LegacySubscriptionUriCodec;
import com.linkedin.databus.core.data_model.SubscriptionUriCodec;
import com.linkedin.databus.core.util.InvalidConfigException;
import com.linkedin.databus2.core.DatabusException;
import com.linkedin.databus2.core.filter.DbusKeyCompositeFilterConfig;
import com.linkedin.databus2.core.filter.KeyFilterConfigHolder;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class DbusRangePartitionedFilterFactory
implements DbusServerSideFilterFactory {
    public static final String MODULE = DbusModPartitionedFilterFactory.class.getName();
    public static final Logger LOG = Logger.getLogger((String)MODULE);
    private final List<DatabusSubscription> _subscriptions = new ArrayList<DatabusSubscription>();
    private final long _rangeWidth;

    public DbusRangePartitionedFilterFactory(long rangeWidth, String ... srcUris) throws DatabusException {
        this(rangeWidth, DbusRangePartitionedFilterFactory.toLegacyUris(srcUris));
    }

    public DbusRangePartitionedFilterFactory(long rangeWidth, URI ... srcUris) throws DatabusException {
        this(rangeWidth, (SubscriptionUriCodec)LegacySubscriptionUriCodec.getInstance(), srcUris);
    }

    public DbusRangePartitionedFilterFactory(long rangeWidth, SubscriptionUriCodec codec, URI ... srcUris) throws DatabusException {
        this._rangeWidth = rangeWidth;
        for (URI u : srcUris) {
            DatabusSubscription s1 = codec.decode(u);
            this._subscriptions.add(s1);
        }
    }

    @Override
    public DbusKeyCompositeFilterConfig createServerSideFilter(DbusClusterInfo cluster, DbusPartitionInfo partition) throws InvalidConfigException {
        DbusKeyCompositeFilterConfig.Config compositeConfig = new DbusKeyCompositeFilterConfig.Config();
        for (DatabusSubscription s : this._subscriptions) {
            KeyFilterConfigHolder.Config filterConfig = new KeyFilterConfigHolder.Config();
            filterConfig.setType(KeyFilterConfigHolder.PartitionType.RANGE.toString());
            filterConfig.getRange().setSize(this._rangeWidth);
            filterConfig.getRange().setPartitions("[" + partition.getPartitionId() + "]");
            compositeConfig.setFilter(s.getLogicalSource().getName(), filterConfig);
        }
        DbusKeyCompositeFilterConfig c = new DbusKeyCompositeFilterConfig(compositeConfig.build());
        LOG.info((Object)("Generated Mod Partitioned Config for partition (" + partition + ") of cluster (" + cluster + ") is :" + c));
        return c;
    }

    private static URI[] toLegacyUris(String ... srcUris) throws DatabusException {
        URI[] uris = new URI[srcUris.length];
        int i = 0;
        try {
            for (String s : srcUris) {
                uris[i++] = new URI(s);
            }
        }
        catch (URISyntaxException e) {
            throw new DatabusException((Throwable)e);
        }
        return uris;
    }
}

