/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.client.pub;

import java.net.InetSocketAddress;

public class DatabusServerCoordinates
implements Comparable<DatabusServerCoordinates> {
    private final String _name;
    private final InetSocketAddress _address;
    private StateId _state;

    public DatabusServerCoordinates(String name, InetSocketAddress address, String state) {
        this._name = name;
        this._address = address;
        try {
            this._state = StateId.valueOf(state);
        }
        catch (Exception ex) {
            this._state = StateId.UNKNOWN;
        }
    }

    public DatabusServerCoordinates(String name, InetSocketAddress address, StateId state) {
        this._name = name;
        this._address = address;
        this._state = state;
    }

    public DatabusServerCoordinates(String name, InetSocketAddress address) {
        this(name, address, "OFFLINE");
    }

    public DatabusServerCoordinates(InetSocketAddress address, String state) {
        this("default", address, state);
    }

    public String getName() {
        return this._name;
    }

    public InetSocketAddress getAddress() {
        return this._address;
    }

    public void setState(StateId state) {
        this._state = state;
    }

    public StateId getState() {
        return this._state;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        DatabusServerCoordinates castedObj = (DatabusServerCoordinates)o;
        return this._address.equals(castedObj.getAddress()) && this._state.equals((Object)castedObj.getState());
    }

    public int hashCode() {
        return (this.getAddress().hashCode() << 16) + this.getState().hashCode();
    }

    @Override
    public int compareTo(DatabusServerCoordinates o) {
        InetSocketAddress addr1 = this.getAddress();
        InetSocketAddress addr2 = o.getAddress();
        String addrStr1 = addr1 != null ? addr1.toString() + (Object)((Object)this.getState()) : "";
        String addrStr2 = addr2 != null ? addr2.toString() + (Object)((Object)this.getState()) : "";
        return addrStr1.compareTo(addrStr2);
    }

    public boolean isOnlineState() {
        return this._state == StateId.ONLINE;
    }

    public String toString() {
        return "DatabusServerCoordinates [_name=" + this._name + ", _address=" + this._address + ", _state=" + (Object)((Object)this._state) + "]";
    }

    public static enum StateId {
        UNKNOWN,
        ERROR,
        OFFLINE,
        ONLINE;

    }
}

