/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.client.pub;

import com.linkedin.databus.client.pub.DatabusClientException;
import com.linkedin.databus.client.pub.DbusPartitionInfo;
import com.linkedin.databus.client.pub.FetchMaxSCNRequest;
import com.linkedin.databus.client.pub.FlushRequest;
import com.linkedin.databus.client.pub.RegistrationId;
import com.linkedin.databus.client.pub.RelayFindMaxSCNResult;
import com.linkedin.databus.client.pub.RelayFlushMaxSCNResult;
import com.linkedin.databus.client.pub.mbean.ConsumerCallbackStatsMBean;
import com.linkedin.databus.client.pub.mbean.UnifiedClientStatsMBean;
import com.linkedin.databus.core.Checkpoint;
import com.linkedin.databus.core.DatabusComponentStatus;
import com.linkedin.databus.core.data_model.DatabusSubscription;
import com.linkedin.databus.core.monitoring.mbean.DbusEventsStatisticsCollectorMBean;
import com.linkedin.databus2.core.filter.DbusKeyCompositeFilterConfig;
import java.util.Collection;
import org.apache.log4j.Logger;

public interface DatabusRegistration {
    public boolean start() throws IllegalStateException, DatabusClientException;

    public void shutdown() throws IllegalStateException;

    public void pause() throws IllegalStateException;

    public void suspendOnError(Throwable var1) throws IllegalStateException;

    public void resume() throws IllegalStateException;

    public RegistrationState getState();

    public boolean deregister() throws IllegalStateException;

    public Collection<DatabusSubscription> getSubscriptions();

    public DatabusComponentStatus getStatus();

    public DbusKeyCompositeFilterConfig getFilterConfig();

    public Logger getLogger();

    public DatabusRegistration getParent();

    public DatabusRegistration withRegId(RegistrationId var1) throws DatabusClientException, IllegalStateException;

    public DatabusRegistration withServerSideFilter(DbusKeyCompositeFilterConfig var1) throws IllegalStateException;

    public Collection<DbusPartitionInfo> getPartitions();

    public Checkpoint getLastPersistedCheckpoint();

    public boolean storeCheckpoint(Checkpoint var1) throws IllegalStateException;

    public DbusEventsStatisticsCollectorMBean getRelayEventStats();

    public DbusEventsStatisticsCollectorMBean getBootstrapEventStats();

    public ConsumerCallbackStatsMBean getRelayCallbackStats();

    public ConsumerCallbackStatsMBean getBootstrapCallbackStats();

    public UnifiedClientStatsMBean getUnifiedClientStats();

    public RelayFindMaxSCNResult fetchMaxSCN(FetchMaxSCNRequest var1) throws InterruptedException;

    public RelayFlushMaxSCNResult flush(RelayFindMaxSCNResult var1, FlushRequest var2) throws InterruptedException;

    public RelayFlushMaxSCNResult flush(FetchMaxSCNRequest var1, FlushRequest var2) throws InterruptedException;

    public RegistrationId getRegistrationId();

    public static enum RegistrationState {
        INIT,
        REGISTERED,
        STARTED,
        PAUSED,
        RESUMED,
        SUSPENDED_ON_ERROR,
        SHUTDOWN,
        DEREGISTERED;


        public boolean isPreStartState() {
            switch (this) {
                case INIT: 
                case REGISTERED: {
                    return true;
                }
            }
            return false;
        }

        public boolean isPostRunState() {
            switch (this) {
                case SHUTDOWN: 
                case DEREGISTERED: {
                    return true;
                }
            }
            return false;
        }

        public boolean isRunning() {
            switch (this) {
                case STARTED: 
                case PAUSED: 
                case SUSPENDED_ON_ERROR: 
                case RESUMED: {
                    return true;
                }
            }
            return false;
        }

        public boolean isActiveRegistration() {
            switch (this) {
                case REGISTERED: 
                case SHUTDOWN: 
                case STARTED: 
                case PAUSED: 
                case SUSPENDED_ON_ERROR: 
                case RESUMED: {
                    return true;
                }
            }
            return false;
        }
    }
}

