/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.client.pub;

public enum ConsumerCallbackResult {
    SUCCESS(0),
    CHECKPOINT(100),
    SKIP_CHECKPOINT(150),
    ERROR(200),
    ERROR_FATAL(300);

    private final int _level;

    private ConsumerCallbackResult(int level) {
        this._level = level;
    }

    public int getLevel() {
        return this._level;
    }

    public static boolean isSuccess(ConsumerCallbackResult resultCode) {
        return SUCCESS == resultCode || CHECKPOINT == resultCode || SKIP_CHECKPOINT == resultCode;
    }

    public static boolean isFailure(ConsumerCallbackResult resultCode) {
        return ERROR == resultCode || ERROR_FATAL == resultCode;
    }

    public static boolean isSkipCheckpoint(ConsumerCallbackResult resultCode) {
        return SKIP_CHECKPOINT == resultCode;
    }

    public static ConsumerCallbackResult max(ConsumerCallbackResult r1, ConsumerCallbackResult r2) {
        return r1._level < r2._level ? r2 : r1;
    }
}

