/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.bootstrap.utils.bst_reader.filter;

import com.linkedin.databus.bootstrap.utils.bst_reader.filter.BootstrapReaderFilter;
import com.linkedin.databus.core.DbusEvent;
import org.apache.avro.generic.GenericRecord;

public class PayloadFieldEqFilter
implements BootstrapReaderFilter {
    final String _fieldName;
    final Object _constValue;

    public PayloadFieldEqFilter(String fieldName, Object constValue) {
        this._fieldName = fieldName;
        this._constValue = constValue;
    }

    @Override
    public boolean matches(DbusEvent event, GenericRecord payload) {
        Object val = payload.get(this._fieldName);
        if (null == val) {
            return false;
        }
        if (val instanceof Float) {
            return ((Float)val).floatValue() == ((Number)this._constValue).floatValue();
        }
        if (val instanceof Double) {
            return ((Double)val).doubleValue() == ((Number)this._constValue).doubleValue();
        }
        if (val instanceof Number) {
            return ((Number)val).longValue() == ((Number)this._constValue).longValue();
        }
        return val.toString().compareTo(this._constValue.toString()) == 0;
    }
}

